/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.view.AccountManagementView;
import com.parablu.epa.view.BackUpPreferencesView;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.LicenseExpiredView;
import com.parablu.epa.view.MediaManagementView;
import com.parablu.epa.view.NotificationView;
import com.parablu.epa.view.SyncPreferencesView;
import java.io.IOException;
import java.nio.channels.FileLock;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsolidatedView {
    private static Logger logger = LoggerFactory.getLogger(ConsolidatedView.class);
    FontsManager fontsManager;
    public Shell shell;
    private ToolBar toolBar;
    private ToolItem settingsToolItem;
    private ToolItem notificationToolItem;
    private ToolItem backupToolItem;
    private ToolItem accountToolItem;
    private ToolItem mediaToolItem;
    private SyncPreferencesView preferencesPage;
    private BackUpPreferencesView backUpFolderView;
    private AccountManagementView accountManagementPage;
    private NotificationView notificationPage;
    private LicenseExpiredView licenseExpiredViewPage;
    private FileLock uiFileLock;
    private MediaManagementView mediaManagementPage;
    protected Composite centerWizardPanel;
    private StackLayout centerWizardLayout;
    private static final int MENU_SETTINGS = 0;
    private static final int MENU_BACKUP = 1;
    private static final int MENU_ACCOUNT = 2;
    private static final int MENU_MEDIA = 3;
    private static final int MENU_LICENSE = 5;
    private static final int MENU_NOTIFICATION = 4;
    private static final int COLOR255 = 255;
    private static final int COLOR240 = 240;
    private static final int MENU_ABOUT = 6;
    private Color uiBackgroundColor;
    private Color whiteColor;
    private ImageData shellImageData;
    private Image shellImage;
    private ImageData notificationHotImageData;
    private ImageData accountImageData;
    private ImageData accountHotImageData;
    private static final int IMAGE_X_SCALE_SIZE = 72;
    private static final int IMAGE_Y_SCALE_SIZE = 72;
    public static final String RESOURCE = "resource";
    private static final String IMG = "img";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String BLUSYNC_SETTINGS_ICON_PATH = "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "settings.png";
    public static final String BLUSYNC_SYNC_NOW_ICON_PATH = "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "sync_folder.png";
    public static final String BLUSYNC_HELP_ICON_PATH = "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "help.png";
    public static final String BLUSYNC_ACTIVITY_HISTORY_ICON_PATH = "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "log.png";
    public static final String BLUSYNC_ACCOUNT_ICON_PATH = "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "account.png";
    public static final String BLUSYNC_MEDIA_ICON_PATH = "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "media.png";
    private ToolItem aboutToolItem;

    ConsolidatedView(FileLock fileLock) throws IOException {
        block2: {
            this.shell = null;
            this.toolBar = null;
            this.settingsToolItem = null;
            this.notificationToolItem = null;
            this.backupToolItem = null;
            this.accountToolItem = null;
            this.mediaToolItem = null;
            this.preferencesPage = null;
            this.backUpFolderView = null;
            this.accountManagementPage = null;
            this.notificationPage = null;
            this.licenseExpiredViewPage = null;
            this.uiFileLock = null;
            this.mediaManagementPage = null;
            this.centerWizardPanel = null;
            this.centerWizardLayout = null;
            this.uiBackgroundColor = new Color((Device)Display.getCurrent(), 240, 240, 240);
            this.whiteColor = new Color((Device)Display.getCurrent(), 255, 255, 255);
            this.shellImageData = null;
            this.shellImage = null;
            this.notificationHotImageData = null;
            this.accountImageData = null;
            this.accountHotImageData = null;
            this.aboutToolItem = null;
            try {
                this.uiFileLock = fileLock;
                this.shell = new Shell(192);
                int xAxisLocation = this.shell.getDisplay().getClientArea().width / 2 - 150;
                int yAxisLocation = this.shell.getDisplay().getClientArea().height / 2 - 170;
                this.shell.setLocation(xAxisLocation, yAxisLocation);
                this.shell.setBackground(this.whiteColor);
                this.shell.setMinimumSize(400, 400);
            }
            catch (Exception e) {
                logger.error("Exception in UIMain constructor: " + e.getMessage());
                logger.trace("" + e);
                if (this.uiFileLock == null) break block2;
                this.uiFileLock.release();
            }
        }
    }

    public void openShell() throws IOException {
        block2: {
            try {
                GridLayout shellGridLayout = new GridLayout();
                shellGridLayout.marginWidth = 0;
                shellGridLayout.marginHeight = 0;
                shellGridLayout.marginBottom = 0;
                shellGridLayout.verticalSpacing = 0;
                shellGridLayout.horizontalSpacing = 0;
                shellGridLayout.numColumns = 1;
                shellGridLayout.marginRight = 0;
                this.shell.setLayout((Layout)shellGridLayout);
                this.fontsManager = new FontsManager(this.shell.getDisplay());
                this.shell.setText(PropertyHelper.REGVIEW_APPNAME);
                this.shell.setFont(this.fontsManager.getMediumNormalFont());
                this.shellImageData = new ImageData(SyncConstants.PARABLU_NAMED_IMAGE);
                this.shellImage = new Image((Device)this.shell.getDisplay(), this.shellImageData.scaledTo(72, 72));
                this.shell.setImage(this.shellImage);
                this.generateUI();
                Listener listener = event -> {
                    logger.debug("BluSync UI Close action called from UIMain");
                    this.close(true);
                };
                this.shell.addListener(21, listener);
                this.shell.pack();
                this.shell.open();
            }
            catch (Exception e) {
                logger.error("Exception in UIMain constructor: " + e.getMessage());
                logger.trace("" + e);
                if (this.uiFileLock == null) break block2;
                this.uiFileLock.release();
            }
        }
    }

    private void generateUI() {
        logger.debug("Structuring BluSync Settings/Preferences User Interface");
        int imageAccountHorizontalSize = 33;
        int imageAccountVerticalSize = 33;
        int imageNotificationHorizontalSize = 33;
        int imageNotificationVerticalSize = 33;
        this.toolBar = new ToolBar((Composite)this.shell, 0x1000000);
        GridLayout toolBarGridLayout = new GridLayout();
        toolBarGridLayout.marginLeft = 0;
        toolBarGridLayout.marginTop = 0;
        toolBarGridLayout.marginBottom = 0;
        toolBarGridLayout.marginWidth = 0;
        toolBarGridLayout.marginHeight = 0;
        this.toolBar.setLayout((Layout)toolBarGridLayout);
        GridData toolbarData = new GridData(768);
        toolbarData.horizontalAlignment = 16384;
        this.toolBar.setLayoutData((Object)toolbarData);
        this.toolBar.setBackground(this.whiteColor);
        this.toolBar.setFont(this.fontsManager.getMediumNormalFont());
        this.notificationToolItem = new ToolItem(this.toolBar, 16);
        this.notificationToolItem.setText("  Notifications  ");
        this.notificationToolItem.setToolTipText("Notifications");
        this.notificationHotImageData = new ImageData(BLUSYNC_SYNC_NOW_ICON_PATH);
        this.notificationToolItem.setImage(new Image((Device)Display.getCurrent(), this.notificationHotImageData.scaledTo(33, 33)));
        this.notificationToolItem.setSelection(true);
        this.notificationToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsolidatedView.this.setDataForCentralArea(4);
            }
        });
        this.accountToolItem = new ToolItem(this.toolBar, 16);
        this.accountToolItem.setText("  Account  ");
        this.accountToolItem.setToolTipText("Account");
        this.accountImageData = new ImageData(BLUSYNC_ACCOUNT_ICON_PATH);
        this.accountToolItem.setImage(new Image((Device)Display.getCurrent(), this.accountImageData.scaledTo(33, 33)));
        this.accountHotImageData = new ImageData(BLUSYNC_ACCOUNT_ICON_PATH);
        this.accountToolItem.setHotImage(new Image((Device)Display.getCurrent(), this.accountHotImageData.scaledTo(33, 33)));
        this.accountToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsolidatedView.this.setDataForCentralArea(2);
            }
        });
        if (SettingHelper.isLicenseActive()) {
            this.setDataForCentralArea(2);
            this.setDataForCentralArea(1);
            this.setDataForCentralArea(0);
            this.setDataForCentralArea(4);
        } else {
            this.setDataForCentralArea(5);
        }
    }

    public void setDataForCentralArea(int menuOption) {
        if (this.centerWizardPanel == null) {
            this.centerWizardLayout = new StackLayout();
            this.centerWizardLayout.marginWidth = 0;
            this.centerWizardLayout.marginHeight = 0;
            this.centerWizardPanel = new Composite((Composite)this.shell, 2052);
            GridData gridData = new GridData(1808);
            this.centerWizardPanel.setLayoutData((Object)gridData);
            this.centerWizardPanel.setLayout((Layout)this.centerWizardLayout);
        }
        switch (menuOption) {
            case 0: {
                this.menuSettings();
                break;
            }
            case 1: {
                this.menuBackup();
                break;
            }
            case 2: {
                this.menuAccount();
                break;
            }
            case 3: {
                this.menuMedia();
                break;
            }
            case 4: {
                this.menuNotification();
                break;
            }
            case 5: {
                this.menuLicensce();
                break;
            }
            case 6: {
                this.menuAbout();
            }
        }
    }

    private void menuSettings() {
        logger.debug("menu option is MENU_SYNC ");
        if (this.preferencesPage == null) {
            this.preferencesPage = new SyncPreferencesView(this.centerWizardPanel);
        }
        this.preferencesPage.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.preferencesPage.getBaseGroup();
        this.centerWizardPanel.layout();
    }

    private void menuBackup() {
        logger.debug("menu option is MENU_ACTIVITY_HISTORY ");
        if (this.backUpFolderView == null) {
            this.backUpFolderView = new BackUpPreferencesView(this.centerWizardPanel);
        }
        this.backUpFolderView.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.backUpFolderView.getBaseGroup();
        this.centerWizardPanel.layout();
        this.backUpFolderView.startBackupTimer();
    }

    private void menuAccount() {
        logger.debug("menu option is MENU_ACCOUNT ");
        if (this.accountManagementPage == null) {
            this.accountManagementPage = new AccountManagementView(this.centerWizardPanel);
            this.accountManagementPage.generateUI();
            this.accountManagementPage.generateUISupportdata();
        }
        this.accountManagementPage.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.accountManagementPage.getBaseGroup();
        this.centerWizardPanel.layout();
    }

    private void menuMedia() {
        logger.debug("menu option = MENU_MEDIA ");
        if (this.mediaManagementPage == null) {
            this.mediaManagementPage = new MediaManagementView(this.centerWizardPanel);
        }
        this.mediaManagementPage.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.mediaManagementPage.getBaseGroup();
        this.centerWizardPanel.layout();
    }

    private void menuLicensce() {
        logger.debug("menu option is MENU_LICENSE ");
        this.disposeAllStackedCompositePagesOnShell();
        if (this.licenseExpiredViewPage == null) {
            this.licenseExpiredViewPage = new LicenseExpiredView(this.centerWizardPanel);
        }
        this.licenseExpiredViewPage.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.licenseExpiredViewPage.getBaseGroup();
        this.centerWizardPanel.layout();
        this.toolBar.setEnabled(false);
        this.toolBar.layout();
        this.toolBar.getShell().layout();
    }

    private void menuNotification() {
        logger.debug("menu option = MENU_NOTIFICATION ");
        if (this.notificationPage == null) {
            this.notificationPage = new NotificationView(this.centerWizardPanel);
        }
        this.notificationPage.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.notificationPage.getBaseGroup();
        this.centerWizardPanel.layout();
        this.notificationPage.startNotificationTimerTask();
    }

    private void menuAbout() {
        logger.debug("menu option is MENU_ABOUT");
        if (this.accountManagementPage == null) {
            this.accountManagementPage = new AccountManagementView(this.centerWizardPanel);
            this.accountManagementPage.generateUIforAbout();
            this.accountManagementPage.generateUISupportdataforAbout();
        }
        this.accountManagementPage.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.accountManagementPage.getBaseGroup();
        this.centerWizardPanel.layout();
    }

    public void close(boolean showApplyMessageForSettings) {
        if (this.shell == null) {
            return;
        }
        if (showApplyMessageForSettings) {
            this.askWhetherSettingsChangesAreToBeApplied();
        }
        this.setImageDataObjectsToNull();
        try {
            this.uiFileLock.release();
        }
        catch (IOException e) {
            logger.error("Exception when trying to release ui File Lock" + e);
        }
        this.disposeAllToolBarWidgets();
        this.disposeAllStackedCompositePagesOnShell();
        if (this.shellImage != null && !this.shellImage.isDisposed()) {
            this.shellImage.dispose();
        }
        this.shell.setBackground(null);
        if (this.shell.getImage() != null && !this.shell.getImage().isDisposed()) {
            this.shell.getImage().dispose();
        }
        if (this.shell.getBackgroundImage() != null && !this.shell.getBackgroundImage().isDisposed()) {
            this.shell.getBackgroundImage().dispose();
        }
        this.shell.dispose();
        this.shell = null;
        if (this.uiBackgroundColor != null && !this.uiBackgroundColor.isDisposed()) {
            this.uiBackgroundColor.dispose();
        }
        if (this.whiteColor != null && !this.whiteColor.isDisposed()) {
            this.whiteColor.dispose();
        }
        logger.debug("Disposed all fields");
    }

    private void disposeAllStackedCompositePagesOnShell() {
        if (this.preferencesPage != null && this.preferencesPage.mainParentComposite != null) {
            this.preferencesPage.disposeAllSettings();
            this.preferencesPage = null;
        }
        if (this.backUpFolderView != null && this.backUpFolderView.mainParentComposite != null) {
            this.backUpFolderView.disoposeAllWidgets();
            this.backUpFolderView = null;
        }
        if (this.accountManagementPage != null && this.accountManagementPage.mainParentComposite != null) {
            this.accountManagementPage.disposeAllAccountWidgets();
            this.accountManagementPage = null;
        }
        if (this.mediaManagementPage != null && this.mediaManagementPage.mainParentComposite != null) {
            this.mediaManagementPage.disposeAllMediaWidgets();
            this.mediaManagementPage = null;
        }
        if (this.notificationPage != null && this.notificationPage.mainParentComposite != null) {
            this.notificationPage.disposeAllNotification();
            this.notificationPage = null;
        }
        if (this.licenseExpiredViewPage != null && this.licenseExpiredViewPage.mainParentComposite != null) {
            this.licenseExpiredViewPage.disposeAllLicenseViewFields();
            this.licenseExpiredViewPage = null;
        }
    }

    private void disposeAllToolBarWidgets() {
        this.fontsManager.disposeFonts();
        if (this.settingsToolItem != null) {
            if (this.settingsToolItem.getImage() != null) {
                this.settingsToolItem.getImage().dispose();
            }
            if (this.settingsToolItem.getHotImage() != null) {
                this.settingsToolItem.getHotImage().dispose();
            }
            this.settingsToolItem.dispose();
        }
        if (this.backupToolItem != null) {
            if (this.backupToolItem.getImage() != null) {
                this.backupToolItem.getImage().dispose();
            }
            if (this.backupToolItem.getHotImage() != null) {
                this.backupToolItem.getHotImage().dispose();
            }
            this.backupToolItem.dispose();
        }
        if (this.accountToolItem != null) {
            if (this.accountToolItem.getImage() != null) {
                this.accountToolItem.getImage().dispose();
            }
            if (this.accountToolItem.getHotImage() != null) {
                this.accountToolItem.getHotImage().dispose();
            }
            this.accountToolItem.dispose();
        }
        if (this.mediaToolItem != null) {
            if (this.mediaToolItem.getImage() != null) {
                this.mediaToolItem.getImage().dispose();
            }
            if (this.mediaToolItem.getHotImage() != null) {
                this.mediaToolItem.getHotImage().dispose();
            }
            this.mediaToolItem.dispose();
        }
        if (this.notificationToolItem != null) {
            if (this.notificationToolItem.getImage() != null) {
                this.notificationToolItem.getImage().dispose();
            }
            if (this.notificationToolItem.getHotImage() != null) {
                this.notificationToolItem.getHotImage().dispose();
            }
            this.notificationToolItem.dispose();
        }
        this.toolBar.dispose();
    }

    private void setImageDataObjectsToNull() {
        this.shellImageData = null;
        this.notificationHotImageData = null;
        this.accountImageData = null;
        this.accountHotImageData = null;
    }

    private void askWhetherSettingsChangesAreToBeApplied() {
        int backupFrequencyMinutes;
        int backupFrequencyHours;
        int backupFrequencyDays;
        int syncFrequencyMinutes;
        int syncFrequencyHours;
        int backupFrequency;
        boolean backupFreqeuncyChanged = false;
        boolean syncFreqeuncyChanged = false;
        int syncFrequency = SettingHelper.getCheckParacloudForUpdateTimerInMins();
        int newbackupFrequency = backupFrequency = SettingHelper.getBackUpIntervalInMins();
        int newSyncFrequency = syncFrequency;
        if (this.preferencesPage.syncFrequencyMinutesCombo != null && this.preferencesPage.syncFrequencyHoursCombo != null && this.preferencesPage.syncFrequencyMinutesCombo.isEnabled() && (newSyncFrequency = (syncFrequencyHours = Integer.parseInt(this.preferencesPage.syncFrequencyHoursCombo.getItem(this.preferencesPage.syncFrequencyHoursCombo.getSelectionIndex())) * 60) + (syncFrequencyMinutes = Integer.parseInt(this.preferencesPage.syncFrequencyMinutesCombo.getItem(this.preferencesPage.syncFrequencyMinutesCombo.getSelectionIndex())))) != syncFrequency && newSyncFrequency != 0) {
            syncFreqeuncyChanged = true;
        }
        if (this.backUpFolderView.backupFrequencyHoursCombo != null && this.backUpFolderView.backupFrequencyMinutesCombo != null && this.backUpFolderView.backupFrequencyDaysCombo != null && this.backUpFolderView.backupFrequencyHoursCombo.isEnabled() && backupFrequency != (newbackupFrequency = (backupFrequencyDays = Integer.parseInt(this.backUpFolderView.backupFrequencyDaysCombo.getItem(this.backUpFolderView.backupFrequencyDaysCombo.getSelectionIndex())) * 24 * 60) + (backupFrequencyHours = Integer.parseInt(this.backUpFolderView.backupFrequencyHoursCombo.getItem(this.backUpFolderView.backupFrequencyHoursCombo.getSelectionIndex())) * 60) + (backupFrequencyMinutes = Integer.parseInt(this.backUpFolderView.backupFrequencyMinutesCombo.getItem(this.backUpFolderView.backupFrequencyMinutesCombo.getSelectionIndex())))) && newbackupFrequency != 0) {
            backupFreqeuncyChanged = true;
        }
        if (backupFreqeuncyChanged || syncFreqeuncyChanged) {
            MessageBox msg = new MessageBox(this.shell, 196);
            msg.setMessage("Do you want to save your changes?");
            int confirmationValue = msg.open();
            if (confirmationValue == 64) {
                SettingHelper.setTempCheckParacloudForUpdateTimerInMins((int)newSyncFrequency);
                SettingHelper.setTempBackUpIntervalInMins((int)newbackupFrequency);
                SettingHelper.applyChangesToSharedPreferences((boolean)true);
                logger.debug("Settings applied");
            } else {
                SettingHelper.refresh();
            }
        }
    }

    public void openAboutShell() {
        GridLayout shellGridLayout = new GridLayout();
        shellGridLayout.marginWidth = 0;
        shellGridLayout.marginHeight = 0;
        shellGridLayout.marginBottom = 0;
        shellGridLayout.verticalSpacing = 0;
        shellGridLayout.horizontalSpacing = 0;
        shellGridLayout.numColumns = 1;
        shellGridLayout.marginRight = 0;
        this.shell.setLayout((Layout)shellGridLayout);
        this.fontsManager = new FontsManager(this.shell.getDisplay());
        this.shell.setText(PropertyHelper.REGVIEW_APPNAME);
        this.shell.setFont(this.fontsManager.getMediumNormalFont());
        this.shellImageData = new ImageData(SyncConstants.PARABLU_NAMED_IMAGE);
        this.shellImage = new Image((Device)this.shell.getDisplay(), this.shellImageData.scaledTo(72, 72));
        this.shell.setImage(this.shellImage);
        this.generateUIforAbout();
        Listener listener = event -> {
            logger.debug("BluSync UI Close action called from UIMain");
            this.closeAboutUi(true);
        };
        this.shell.addListener(21, listener);
        this.shell.pack();
        this.shell.open();
    }

    public void generateUIforAbout() {
        logger.debug("Structuring BluSync Settings/Preferences User Interface");
        this.toolBar = new ToolBar((Composite)this.shell, 0x1000000);
        GridLayout toolBarGridLayout = new GridLayout();
        toolBarGridLayout.marginLeft = 0;
        toolBarGridLayout.marginTop = 0;
        toolBarGridLayout.marginBottom = 0;
        toolBarGridLayout.marginWidth = 0;
        toolBarGridLayout.marginHeight = 0;
        this.toolBar.setLayout((Layout)toolBarGridLayout);
        GridData toolbarData = new GridData(768);
        toolbarData.horizontalAlignment = 16384;
        this.toolBar.setLayoutData((Object)toolbarData);
        this.toolBar.setBackground(this.whiteColor);
        this.toolBar.setFont(this.fontsManager.getMediumNormalFont());
        this.aboutToolItem = new ToolItem(this.toolBar, 16);
        this.aboutToolItem.setText("");
        this.aboutToolItem.setToolTipText("Account");
        logger.debug("licence" + SettingHelper.getBackupLicenced() + SettingHelper.isLicenseActive());
        if (SettingHelper.isLicenseActive()) {
            this.setDataForCentralArea(6);
        } else {
            logger.debug("################");
            this.setDataForCentralArea(5);
        }
    }

    public void closeAboutUi(boolean showApplyMessageForSettings) {
        if (this.shell == null) {
            return;
        }
        if (showApplyMessageForSettings) {
            // empty if block
        }
        this.setImageDataObjectsToNull();
        try {
            this.uiFileLock.release();
        }
        catch (IOException e) {
            logger.error("Exception when trying to release ui File Lock" + e);
        }
        this.disposeAboutToolBarWidgets();
        this.disposeAboutStackedCompositePagesOnShell();
        if (this.shellImage != null && !this.shellImage.isDisposed()) {
            this.shellImage.dispose();
        }
        this.shell.setBackground(null);
        if (this.shell.getImage() != null && !this.shell.getImage().isDisposed()) {
            this.shell.getImage().dispose();
        }
        if (this.shell.getBackgroundImage() != null && !this.shell.getBackgroundImage().isDisposed()) {
            this.shell.getBackgroundImage().dispose();
        }
        this.shell.dispose();
        this.shell = null;
        if (this.uiBackgroundColor != null && !this.uiBackgroundColor.isDisposed()) {
            this.uiBackgroundColor.dispose();
        }
        if (this.whiteColor != null && !this.whiteColor.isDisposed()) {
            this.whiteColor.dispose();
        }
        logger.debug("Disposed all fields");
    }

    private void disposeAboutStackedCompositePagesOnShell() {
        if (this.accountManagementPage != null && this.accountManagementPage.mainParentComposite != null) {
            this.accountManagementPage.disposeAllAccountWidgets();
            this.accountManagementPage = null;
        }
        if (this.licenseExpiredViewPage != null && this.licenseExpiredViewPage.mainParentComposite != null) {
            this.licenseExpiredViewPage.disposeAllLicenseViewFields();
            this.licenseExpiredViewPage = null;
        }
    }

    private void disposeAboutToolBarWidgets() {
        this.fontsManager.disposeFonts();
        if (this.aboutToolItem != null) {
            if (this.aboutToolItem.getImage() != null) {
                this.aboutToolItem.getImage().dispose();
            }
            if (this.aboutToolItem.getHotImage() != null) {
                this.aboutToolItem.getHotImage().dispose();
            }
            this.aboutToolItem.dispose();
        }
        this.toolBar.dispose();
    }
}

