/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.sync;

import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.sync.MultiThreadSyncUploadJob;
import com.parablu.epa.common.service.sync.SyncDownloadJob;
import com.parablu.epa.common.service.sync.SyncJob;
import com.parablu.epa.common.service.sync.SyncMediaUploadJob;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.MediaTO;
import com.parablu.epa.core.to.ResponseTO;
import com.parablu.epa.service.notifications.DirectoryRefreshHelper;
import com.parablu.epa.service.notifications.UIHelper;
import com.parablu.epa.service.settings.WindowsSettingsHelper;
import com.parablu.epa.service.sync.WindowsSyncDownloadJob;
import com.parablu.epa.service.sync.WindowsSyncMediaUploadJob;
import com.parablu.epa.service.sync.WindowsSyncUploadJob;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsSyncJob
extends SyncJob {
    private SyncDownloadJob dt;
    private MultiThreadSyncUploadJob ut;
    private SyncMediaUploadJob mt = null;
    private Logger logger = LoggerFactory.getLogger(WindowsSyncJob.class);

    public void startMediaUpload(List<MediaTO> mediaBackUpList) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.mt = new WindowsSyncMediaUploadJob(SettingHelper.getCurrentCloudIpAddress(), this.currentPort, SettingHelper.getCloudName(), SettingHelper.readTokenFromFile(), mediaBackUpList, SettingHelper.getMediaDbUrl());
        this.mt.setName("Media Upload");
        this.mt.start();
        this.mt.join();
    }

    public void startUploadDownload() throws InterruptedException {
        this.logger.debug("Starting Upload Download Threads");
        String cloudIP = SettingHelper.getCurrentCloudIpAddress();
        GatewayTO gatewayTo = SettingHelper.getSyncUploadIpAddress();
        this.logger.debug("IP:" + cloudIP + " Cloud name:" + SettingHelper.getCloudName());
        this.logger.debug("Regristration ID: " + SettingHelper.getRegristrationID());
        String currentImageTablePath = new StringBuffer().append(this.baseURlForImageTables).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(this.currentImageTableName).toString();
        this.dt = new WindowsSyncDownloadJob(cloudIP, this.currentPort, SettingHelper.getCloudName(), this.downloadTableURL, this.deviceUserPath, currentImageTablePath, this.crawlTimeStamp, this.baseURlForImageTables, this.currentImageTableName, this.token, gatewayTo.getGatewayName());
        this.ut = new WindowsSyncUploadJob(cloudIP, this.currentPort, SettingHelper.getCloudName(), this.uploadTableURL, this.deviceUserPath, currentImageTablePath, this.baseURlForImageTables, this.currentImageTableName, this.token, gatewayTo);
        this.ut.setName("Upload thread");
        this.dt.setName("Download thread");
        this.dt.start();
        this.ut.start();
        this.dt.join();
        this.ut.join();
    }

    protected void refreshExplorer() {
        if (this.totalFilestoDownloadCount > 0 || this.totalFilestoUploadCount > 0) {
            DirectoryRefreshHelper directoryRefreshHelper = new DirectoryRefreshHelper();
            directoryRefreshHelper.refreshDirectory();
        }
    }

    public void updateSystrayImageAccordingToStage(String syncingImage) {
        if (!NotificationHelper.isBackUpStarted()) {
            UIHelper.updateSystrayImageAccordingToStage(syncingImage);
        } else {
            UIHelper.displaySyncingGif();
        }
    }

    public void updateSystrayToolTipNotification(String string, String string2) {
        UIHelper.updateSystrayToolTipNotification(string, string2);
    }

    public void abortUploadAndDownloadProcess() {
        this.logger.debug("Aborting Upload And Download Process");
        if (this.dt != null) {
            this.dt.isTerminated = true;
            this.dt.abortDownloadProcesses();
            if (this.dt.isAlive()) {
                this.dt.interrupt();
            }
        }
        if (this.ut != null) {
            this.ut.isTerminated = true;
            this.ut.abortUploadProcesses();
            if (this.ut.isAlive()) {
                this.ut.interrupt();
            }
        }
        if (this.mt != null) {
            this.mt.isTerminated = true;
            this.mt.abortUploadProcesses();
            if (this.mt.isAlive()) {
                this.mt.interrupt();
            }
        }
    }

    protected void remapNetworkDrive(ResponseTO arg0, String arg1) {
        if (arg0 != null && SettingHelper.isMediaHubEnabled()) {
            WindowsSettingsHelper.dsconnectWebDAVasNetworkDrive();
            WindowsSettingsHelper.mapWebDAVasNetworkDrive(SettingHelper.getMediaUserName(), SettingHelper.getMediaPassword(), null);
        }
    }
}

