/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.settings;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.settings.InterfaceManagementService;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.settings.SharedPreferences;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.ProxyElement;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.service.settings.VersionHelper;
import com.parablu.epa.to.NetworkDriveTo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsSettingsHelper {
    private static final String MEDIAHUB_CONNECTION_ERROR_MESSAGE = "Connection to mediahub failed. Please check your connection status and try again.";
    private static final String MEDIA_HUB_UNAUTHORIZED_MESSAGE = "Username and/or password incorrect.";
    private static final String SYSTEM_ERROR_NETWORK_UNREACHABLE = "System error 67 has occurred";
    private static final String SYSTEM_ERROR_UNAUTHORIZED = "System error 1244 has occurred";
    private static final String HTTP_PROTOCOL = "http";
    private static final String MEDIA_HUB_URL_PARAM = "mediahub";
    private static final String WEBDEV_ERROR = "Error while connecting to WebDav";
    private static Logger logger = LoggerFactory.getLogger(WindowsSettingsHelper.class);

    private WindowsSettingsHelper() {
    }

    public static boolean initiateSettings() {
        boolean success = true;
        try {
            logger.debug("Initiating initial settings");
            VersionHelper.getRegistryValueForUserProfile();
            SettingHelper.setInstallationDir((String)VersionHelper.getRegistryValue("Path"));
            SettingHelper.setUserHome((String)VersionHelper.getUserProfile());
            ParabluFileSystemUtils.setUserProfile((String)SettingHelper.getUserHome());
            ParabluFileSystemUtils.setInstallationDir((String)SettingHelper.getInstallationDir());
            ParabluFileSystemUtils.setOldInstallationDir((String)VersionHelper.getRegistryValue("HKCU", "Software\\ParaBlu\\BluSync", "OldPath"));
            SettingHelper.setProgramFilesDir((String)System.getenv("ProgramFiles"));
            String appDataDir = SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + "AppData" + StringLiterals.FILE_SEPARATOR + "Roaming";
            StringBuilder sb = new StringBuilder();
            SettingHelper.setOsName((String)WindowsSettingsHelper.getOSType());
            SettingHelper.setOsVersion((String)WindowsSettingsHelper.getOSVersion());
            SettingHelper.setUserAppdataDir((String)appDataDir);
            sb.append(appDataDir).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ParaBlu").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("Blusync");
            SettingHelper.setParabluBaseAppDataFolderUrl((String)(appDataDir + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBlu"));
            SettingHelper.setParabluBlusyncAppDataFolderUrl((String)sb.toString());
            SettingHelper.setParabluTempUploadFolder((String)new StringBuffer().append(SettingHelper.getParabluBlusyncAppDataFolderUrl()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("TempUploadFolder").toString());
            SettingHelper.setParabluTempDownloadFolder((String)new StringBuffer().append(SettingHelper.getParabluBlusyncAppDataFolderUrl()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("tempDownloadFolder").toString());
            SettingHelper.setCrawlGzipFolder((String)new StringBuffer().append(SettingHelper.getParabluBlusyncAppDataFolderUrl()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("requestdata").toString());
            SettingHelper.setParabluScriptsFolder((String)(SettingHelper.getParabluBaseAppDataFolderUrl() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "Scripts"));
            SettingHelper.setParabluVshadowPath((String)(SettingHelper.getParabluBaseAppDataFolderUrl() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "vshadow"));
            SettingHelper.setSnapFolderPath((String)(SettingHelper.getParabluBaseAppDataFolderUrl() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "Snapshots"));
            SettingHelper.setBaseDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").toString());
            SettingHelper.setActivityDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ActivityTable").toString());
            SettingHelper.setFolderDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("FolderSync").toString());
            SettingHelper.setSyncedFilesDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("SyncedFiles").toString());
            SettingHelper.setImageTableHistoryDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ImageTableHistory").toString());
            SettingHelper.setDownloadTableDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("DownloadTable").toString());
            SettingHelper.setBackUpDbUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("BackupDB").toString());
            SettingHelper.setMediaDbUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("MediaDB").toString());
            SettingHelper.setUploadTableDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("UploadTable").toString());
            SettingHelper.setDodTableDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("DodTable").toString());
            SettingHelper.setSharedPreferencesUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("settings").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("usersettings").toString());
            SettingHelper.setIpSettingsUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("settings").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ipsettings").toString());
            SettingHelper.setTokenFileUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("settings").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("token.pbs").toString());
            SettingHelper.setUpdateDownloadURL((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("updates").toString());
            SettingHelper.setUiLockUrl((String)new StringBuffer().append(SettingHelper.getParabluBlusyncAppDataFolderUrl()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ParabluUI.lock").toString());
            SettingHelper.setMainLockUrl((String)new StringBuffer().append(SettingHelper.getParabluBlusyncAppDataFolderUrl()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ParabluMain.lock").toString());
            SettingHelper.setIconPath((String)(SettingHelper.getInstallationDir() + StringLiterals.FILE_SEPARATOR + SyncConstants.FOLDER_ICON_NAME));
            SettingHelper.setRestoreDbUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("RestoreDB").toString());
            SettingHelper.setKeystorePath((String)(SettingHelper.getInstallationDir() + StringLiterals.FILE_SEPARATOR + SyncConstants.CONSTANTS_KEYSTORE));
            SettingHelper.setBackUpCrawlDbUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("BackupCrawlDB").toString());
            SettingHelper.setBaseChunkFolderUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("Upload").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("Chunk").toString());
            SettingHelper.setSyncDbUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("SycnDB").toString());
            SettingHelper.setChunkDbUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ChunkDB").toString());
            SettingHelper.setProxyPreferencesUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("settings").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("proxysettings").toString());
            success = SettingHelper.createFolders();
            logger.debug("System info and paths initialisation : " + success);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception while geting user name,appdata name" + e);
            logger.error(e.getMessage());
            success = false;
        }
        if (success) {
            success = SettingHelper.readFromSharedPreferences();
            if (!success) {
                success = SettingHelper.resetSharedPreferences();
                logger.debug("Settings reset: " + success);
            }
            if (success) {
                if ("true".equalsIgnoreCase(SettingHelper.getBackupLicenced())) {
                    if (StringUtils.isNotEmpty((String)SettingHelper.getEndpointBackupUiDisabledDetails())) {
                        String[] disabledUiList = SettingHelper.getEndpointBackupUiDisabledDetails().split(",");
                        InterfaceManagementService.disableUISettings((String)"BACKUP", Arrays.asList(disabledUiList));
                    } else {
                        InterfaceManagementService.initialiseDefaultUISettings((String)"BACKUP", (boolean)true);
                    }
                }
                if ("true".equalsIgnoreCase(SettingHelper.getSyncLicenced())) {
                    if (StringUtils.isNotEmpty((String)SettingHelper.getEndpointSyncUiDisabledDetails())) {
                        String[] syncDisabledUiDetails = SettingHelper.getEndpointSyncUiDisabledDetails().split(",");
                        InterfaceManagementService.disableUISettings((String)"SYNC", Arrays.asList(syncDisabledUiDetails));
                    } else {
                        InterfaceManagementService.initialiseDefaultUISettings((String)"SYNC", (boolean)true);
                    }
                }
            }
            VersionHelper.getRegistryValueForVersion();
            SettingHelper.setProductVersion((String)VersionHelper.getProductVersion());
            SettingHelper.setIsVssEnabled((String)new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl()).getVssEnabled());
            ProxyElement.setIp((String)PropertyHelper.MAIN_EBMS_DOMAIN);
            logger.debug("Url" + ProxyElement.getIp());
            logger.debug("Settings initialisation : " + success);
        }
        return success;
    }

    public static boolean initiateSettingsForShellExtension() {
        boolean valid = true;
        VersionHelper.getRegistryValueForUserProfile();
        SettingHelper.setInstallationDir((String)VersionHelper.getRegistryValue("Path"));
        SettingHelper.setUserHome((String)VersionHelper.getUserProfile());
        ParabluFileSystemUtils.setUserProfile((String)SettingHelper.getUserHome());
        String appDataDir = SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + "AppData" + StringLiterals.FILE_SEPARATOR + "Roaming";
        StringBuilder sb = new StringBuilder();
        sb.append(appDataDir).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ParaBlu").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("Blusync");
        SettingHelper.setKeystorePath((String)(SettingHelper.getInstallationDir() + StringLiterals.FILE_SEPARATOR + SyncConstants.CONSTANTS_KEYSTORE));
        String userSettingsPath = new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("settings").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("usersettings").toString();
        String tokenFilePath = new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("settings").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("token.pbs").toString();
        SharedPreferences sp = new SharedPreferences(userSettingsPath);
        Map map = sp.readAllData();
        if (map == null || map.isEmpty() || map.get("cloud_name") == null) {
            valid = false;
            return valid;
        }
        SettingHelper.setCurrentCloudIpAddress((String)((String)map.get("working_cloud_ip")));
        ProxyElement.setIp((String)((String)map.get("working_cloud_ip")));
        SettingHelper.setCloudName((String)((String)map.get("cloud_name")));
        SettingHelper.setUserName((String)((String)map.get("user_name")));
        SettingHelper.setParabluSyncFolder((String)((String)map.get("parablu-folder")));
        SettingHelper.setTokenFileUrl((String)tokenFilePath);
        return valid;
    }

    static String getOSType() {
        String osType = System.getProperty("os.name");
        if (osType.toLowerCase().contains("win")) {
            return osType;
        }
        return osType + "(win)";
    }

    static String getOSVersion() {
        String architecture = "";
        try {
            String osVersion = System.getProperty("os.version");
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            architecture = arch != null && arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "(64 bit)" : "(32 bit)";
            return osVersion + architecture;
        }
        catch (Exception e) {
            logger.error("ERROR WHILE GETTING OS VERSION" + e.getMessage());
            logger.trace("" + e);
            return architecture;
        }
    }

    public static NetworkDriveTo mapWebDAVasNetworkDrive(String userName, String password, String webDrive) {
        String webDrv = webDrive;
        Integer port = null;
        if (webDrive == null) {
            webDrv = "*";
        }
        logger.debug("Trying to map network drive to media hub");
        if (SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && SettingHelper.getHttpPort() != null) {
            port = Integer.valueOf(SettingHelper.getHttpPort());
        }
        WindowsSettingsHelper.detectAndRemoveExistingNetworkDrives(port);
        return WindowsSettingsHelper.mapNetworkDrive(userName, password, webDrv, port);
    }

    private static NetworkDriveTo mapNetworkDrive(String userName, String password, String webDrive, Integer port) {
        String consoleMessage = "";
        try {
            String[] x = new String[]{"net", "use", webDrive, "http://" + SettingHelper.getCurrentCloudIpAddress() + "/" + SettingHelper.getCloudName() + "/" + MEDIA_HUB_URL_PARAM + "/", "/u:" + userName, password, "/p:yes"};
            Process process = Runtime.getRuntime().exec(x);
            if (process.waitFor() != 0 && port != null) {
                String[] x1 = new String[]{"net", "use", webDrive, "http://" + SettingHelper.getCurrentCloudIpAddress() + ":" + port + "/" + SettingHelper.getCloudName() + "/" + MEDIA_HUB_URL_PARAM + "/", "/u:" + userName, password, "/p:yes"};
                process = Runtime.getRuntime().exec(x1);
                process.waitFor();
            }
            WindowsSettingsHelper.readInputStreamAndDetermineDriveName(userName, password, process);
            consoleMessage = WindowsSettingsHelper.readErrorStream(process);
            SettingHelper.applyChangesToSharedPreferences((boolean)true);
        }
        catch (IOException e) {
            logger.error(WEBDEV_ERROR + e.getMessage());
            logger.trace("" + e);
        }
        catch (InterruptedException e) {
            logger.debug(WEBDEV_ERROR + e);
        }
        return new NetworkDriveTo(consoleMessage, SettingHelper.isMediaHubEnabled());
    }

    public static boolean checkIfDriveIsMounted() {
        boolean mounted = false;
        try {
            String[] x = new String[]{"net", "use"};
            Process process = Runtime.getRuntime().exec(x);
            int status = process.waitFor();
            if (status != 0) {
                return mounted;
            }
            try (InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String cmdLine;
                while ((cmdLine = bufferedReader.readLine()) != null) {
                    String[] driveName;
                    String driveToUnmap;
                    if (!cmdLine.contains(SettingHelper.getCloudName() + "\\" + MEDIA_HUB_URL_PARAM) || (driveToUnmap = (driveName = cmdLine.split(":"))[0].trim()).isEmpty()) continue;
                    mounted = true;
                    break;
                }
            }
        }
        catch (IOException e) {
            logger.error(WEBDEV_ERROR + e.getMessage());
            logger.trace("" + e);
        }
        catch (InterruptedException e) {
            logger.debug(WEBDEV_ERROR + e);
        }
        return mounted;
    }

    private static String readErrorStream(Process process) throws IOException {
        StringBuilder consoleMessage = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
             BufferedReader errorBufferedReader = new BufferedReader(inputStreamReader);){
            String errorStreamMessage;
            while ((errorStreamMessage = errorBufferedReader.readLine()) != null) {
                if (errorStreamMessage.isEmpty()) continue;
                if (errorStreamMessage.contains(SYSTEM_ERROR_UNAUTHORIZED)) {
                    consoleMessage = new StringBuilder().append(MEDIA_HUB_UNAUTHORIZED_MESSAGE);
                    break;
                }
                if (errorStreamMessage.contains(SYSTEM_ERROR_NETWORK_UNREACHABLE)) {
                    consoleMessage = new StringBuilder().append(MEDIAHUB_CONNECTION_ERROR_MESSAGE);
                    break;
                }
                consoleMessage.append(errorStreamMessage).append("\n");
            }
        }
        catch (Exception e) {
            logger.debug("Exception", (Throwable)e);
        }
        return consoleMessage.toString();
    }

    private static void readInputStreamAndDetermineDriveName(String userName, String password, Process process) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String cmdLine;
            while ((cmdLine = bufferedReader.readLine()) != null) {
                if (cmdLine.contains(":")) {
                    int position = cmdLine.indexOf(58);
                    SettingHelper.setWebdevDrive((String)cmdLine.substring(position - 1, position));
                    continue;
                }
                if (!cmdLine.contentEquals("The command completed successfully.")) continue;
                SettingHelper.setMediaHubEnabled((boolean)true);
                SettingHelper.setMediaUserName((String)userName);
                SettingHelper.setMediaPassword((String)password);
                logger.debug("Media Hub successfully Enabled");
            }
        }
        catch (Exception e) {
            logger.debug("Exception", (Throwable)e);
        }
    }

    private static void detectAndRemoveExistingNetworkDrives(Integer port) {
        try {
            String[] x = new String[]{"net", "use"};
            Process process = Runtime.getRuntime().exec(x);
            int status = process.waitFor();
            if (status != 0 && port != null) {
                String[] x1 = new String[]{"net", "use"};
                process = Runtime.getRuntime().exec(x1);
                status = process.waitFor();
            }
            if (status != 0) {
                return;
            }
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String cmdLine;
                while ((cmdLine = bufferedReader.readLine()) != null) {
                    String[] driveName;
                    String driveToUnmap;
                    if (!cmdLine.contains(SettingHelper.getCloudName() + "\\" + MEDIA_HUB_URL_PARAM) || (driveToUnmap = (driveName = cmdLine.split(":"))[0].trim()).isEmpty()) continue;
                    WindowsSettingsHelper.dsconnectManuallyMappedNetworkDrive(driveToUnmap);
                }
            }
        }
        catch (IOException e) {
            logger.error(WEBDEV_ERROR + e.getMessage());
            logger.trace("" + e);
        }
        catch (InterruptedException e) {
            logger.debug(WEBDEV_ERROR + e);
        }
    }

    public static void dsconnectWebDAVasNetworkDrive() {
        try {
            logger.debug("Trying to disconnect from network drive");
            String x = "net use " + SettingHelper.getWebdevDrive() + ": /delete /yes";
            Runtime.getRuntime().exec(x);
            logger.debug("MediaHub disconnect exec statement: " + x);
            SettingHelper.setWebdevDrive(null);
            SettingHelper.setMediaHubEnabled((boolean)false);
            SettingHelper.applyChangesToSharedPreferences((boolean)true);
        }
        catch (IOException e) {
            logger.debug(WEBDEV_ERROR + e);
        }
    }

    private static void dsconnectManuallyMappedNetworkDrive(String driveName) {
        try {
            logger.debug("Trying to disconnect from network drive");
            String x = "net use " + driveName + ": /delete /yes";
            Runtime.getRuntime().exec(x);
            logger.debug("MediaHub disconnect exec statement: " + x);
        }
        catch (IOException e) {
            logger.debug(WEBDEV_ERROR + e);
        }
    }

    public static String getProductVersion(boolean serviceVersion) {
        if (serviceVersion) {
            VersionHelper.getRegistryValueForServiceVersion();
        } else {
            VersionHelper.getRegistryValueForVersion();
        }
        return VersionHelper.getProductVersion();
    }
}

