/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.settings;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.StringLiterals;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionHelper {
    private static Logger logger = LoggerFactory.getLogger(VersionHelper.class);
    private static final String REG_COMMAND = "reg query ";
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String REG_KEY_32 = "\"HKCU\\Software\\ParaBlu\\BluSync\" /v Version";
    private static String productVersion = null;
    private static String userProfile = null;
    private static String serviceVersion = null;
    private static final String REG_KEY_64 = "\"HKCU64\\Software\\ParaBlu\\BluSync\" /v Version";
    private static final String SERVICE_REG_KEY_32 = "\"HKEY_LOCAL_MACHINE\\SOFTWARE\\ParabluSvc\" /v Version";
    private static final String SERVICE_REG_KEY_64 = "\"HKEY_LOCAL_MACHINE64\\SOFTWARE\\WOW6432Node\\ParabluSvc\" /v Version";
    private static final String REG_KEY_64_PATH = "\"HKCU64\\Software\\ParaBlu\\BluSync\" /v ";
    private static final String REG_KEY_32_PATH = "\"HKCU\\Software\\ParaBlu\\BluSync\" /v ";
    private static final String REG_KEY_PATH = "Software\\ParaBlu\\BluSync";
    private static final String SERVICE_REG_KEY_PATH = "Software\\WOW6432Node\\ParabluSvc";
    private static final String SERVICE_REG_KEY_PATH_32 = "Software\\ParabluSvc";
    private static final String EXCEPTION_READING_VERSION = "Exception while Reading Version Details: ";

    private VersionHelper() {
    }

    static void readVersionDetails1(boolean serviceVersion) {
        try {
            Process process = serviceVersion ? Runtime.getRuntime().exec("reg query \"HKEY_LOCAL_MACHINE\\SOFTWARE\\ParabluSvc\" /v Version") : Runtime.getRuntime().exec("reg query \"HKCU\\Software\\ParaBlu\\BluSync\" /v Version");
            VersionReader reader = new VersionReader(process.getInputStream());
            reader.startReading();
            process.waitFor();
            String result = reader.getResult();
            int p = result.indexOf(REGSTR_TOKEN);
            if (p == -1 && !VersionHelper.check64Bit(process, serviceVersion)) {
                productVersion = null;
                return;
            }
            productVersion = result.substring(p + REGSTR_TOKEN.length()).trim();
        }
        catch (Exception e) {
            logger.error(EXCEPTION_READING_VERSION, (Throwable)e);
        }
    }

    static void readUserProfile1(String key) {
        try {
            Process process = Runtime.getRuntime().exec("reg query \"HKCU\\Software\\ParaBlu\\BluSync\" /v " + key);
            VersionReader reader = new VersionReader(process.getInputStream());
            reader.startReading();
            process.waitFor();
            String result = reader.getResult();
            int p = result.indexOf(REGSTR_TOKEN);
            if (p == -1 && !VersionHelper.check64Bit(process, key)) {
                userProfile = null;
                return;
            }
            userProfile = result.substring(p + REGSTR_TOKEN.length()).trim();
        }
        catch (Exception e) {
            logger.error(EXCEPTION_READING_VERSION, (Throwable)e);
        }
    }

    static String searchRegistryAndGetValue1(String key) {
        String value;
        try {
            Process process = Runtime.getRuntime().exec("reg query \"HKCU\\Software\\ParaBlu\\BluSync\" /v " + key);
            VersionReader reader = new VersionReader(process.getInputStream());
            reader.startReading();
            process.waitFor();
            String result = reader.getResult();
            int p = result.indexOf(REGSTR_TOKEN);
            if (p == -1 && !VersionHelper.check64Bit(process, key)) {
                return null;
            }
            value = result.substring(p + REGSTR_TOKEN.length()).trim();
        }
        catch (Exception e) {
            value = null;
            logger.error(EXCEPTION_READING_VERSION, (Throwable)e);
        }
        return value;
    }

    public static String getProductVersion() {
        return productVersion;
    }

    static boolean check64Bit(Process process, boolean serviceVerion) throws IOException, InterruptedException {
        Process process1 = serviceVerion ? Runtime.getRuntime().exec("reg query \"HKEY_LOCAL_MACHINE64\\SOFTWARE\\WOW6432Node\\ParabluSvc\" /v Version") : Runtime.getRuntime().exec("reg query \"HKCU64\\Software\\ParaBlu\\BluSync\" /v Version");
        VersionReader reader1 = new VersionReader(process.getInputStream());
        reader1.startReading();
        process1.waitFor();
        String result1 = reader1.getResult();
        int p1 = result1.indexOf(REGSTR_TOKEN);
        return p1 != -1;
    }

    static boolean check64Bit(Process process, String key) throws IOException, InterruptedException {
        Process process1 = Runtime.getRuntime().exec("reg query \"HKCU64\\Software\\ParaBlu\\BluSync\" /v " + key);
        VersionReader reader1 = new VersionReader(process.getInputStream());
        reader1.startReading();
        process1.waitFor();
        String result1 = reader1.getResult();
        int p1 = result1.indexOf(REGSTR_TOKEN);
        return p1 != -1;
    }

    static String getRegistryValue(String key) {
        String value = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REG_KEY_PATH, (String)key);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        return SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + "AppData" + StringLiterals.FILE_SEPARATOR + "Roaming" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBlu";
    }

    static String getRegistryValueForUserProfile() {
        String value = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REG_KEY_PATH, (String)"UserProfile");
        if (!StringUtils.isEmpty((String)value)) {
            userProfile = value;
        }
        return value;
    }

    static String getRegistryValueForVersion() {
        String value = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REG_KEY_PATH, (String)"Version");
        if (!StringUtils.isEmpty((String)value)) {
            productVersion = value;
        }
        return value;
    }

    static String getRegistryValueForServiceVersion() {
        String arch = VersionHelper.getOsArch();
        String key = arch.contains("64") ? SERVICE_REG_KEY_PATH : SERVICE_REG_KEY_PATH_32;
        String value = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key, (String)"Version");
        if (!StringUtils.isEmpty((String)value)) {
            serviceVersion = value;
        }
        return value;
    }

    static String getOsArch() {
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        logger.debug(arch);
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        logger.debug("wowArch:" + wow64Arch);
        String realArch = arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "64" : "32";
        logger.debug("os architecture...:" + realArch);
        return realArch;
    }

    public static String getRegistryValue(String hKeyType, String regKeyPath, String key) {
        try {
            WinReg.HKEY hKey = null;
            if (StringUtils.isEmpty((String)hKeyType) || StringUtils.isEmpty((String)regKeyPath) || StringUtils.isEmpty((String)key)) {
                return null;
            }
            if ("HKLM".equalsIgnoreCase(hKeyType)) {
                hKey = WinReg.HKEY_LOCAL_MACHINE;
            } else if ("HKCU".equalsIgnoreCase(hKeyType)) {
                hKey = WinReg.HKEY_CURRENT_USER;
            } else if ("HKU".equalsIgnoreCase(hKeyType)) {
                hKey = WinReg.HKEY_USERS;
            }
            String value = Advapi32Util.registryGetStringValue((WinReg.HKEY)hKey, (String)regKeyPath, (String)key);
            if (StringUtils.isNotEmpty((String)value)) {
                return value;
            }
            return "null";
        }
        catch (Exception e) {
            logger.error("Error in registry look up", (Throwable)e);
            return "null";
        }
    }

    public static void setRegistryValue(String hKeyType, String regKeyPath, String key) {
        WinReg.HKEY hKey = null;
        if (StringUtils.isEmpty((String)hKeyType) || StringUtils.isEmpty((String)regKeyPath) || StringUtils.isEmpty((String)key)) {
            return;
        }
        if ("HKLM".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_LOCAL_MACHINE;
        } else if ("HKCU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_CURRENT_USER;
        } else if ("HKU".equalsIgnoreCase(hKeyType)) {
            hKey = WinReg.HKEY_USERS;
        }
        Advapi32Util.registrySetStringValue((WinReg.HKEY)hKey, (String)regKeyPath, (String)key);
    }

    public static void setProductVersion(String productVersion) {
        VersionHelper.productVersion = productVersion;
    }

    public static String getUserProfile() {
        return userProfile;
    }

    public static void setUserProfile(String userProfile) {
        VersionHelper.userProfile = userProfile;
    }

    public static String getServiceVersion() {
        return serviceVersion;
    }

    public static void setServiceVersion(String serviceVersion) {
        VersionHelper.serviceVersion = serviceVersion;
    }

    static class VersionReader {
        private InputStream is;
        private StringWriter sw;

        VersionReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        public void startReading() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException e) {
                logger.error("IOException while start to read: " + e);
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

