/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.notifications;

import com.parablu.epa.service.notifications.PowerStateListener;
import com.parablu.epa.service.notifications.Windows;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.awt.Window;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import javax.swing.JWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Listener {
    private JWindow broadcastTarget;
    private ExecutorService service = ForkJoinPool.commonPool();
    private WinDef.HWND broadcastWindow;
    private Pointer notificationHandle;
    private Windows.WNDPROC proc;
    private static int s_uTaskbarRestart;
    private static Logger logger;
    private final ConcurrentLinkedQueue<PowerStateListener> listeners = new ConcurrentLinkedQueue();

    public Listener() {
        final Windows user32 = Windows.INSTANCE;
        Runnable edtTask = new Runnable(){

            @Override
            public void run() {
                Listener.this.broadcastTarget = new JWindow();
                Listener.this.broadcastTarget.setSize(0, 0);
                Listener.this.broadcastTarget.setLocation(-9999, 0);
                Listener.this.broadcastTarget.setFocusable(false);
                Listener.this.broadcastTarget.setVisible(true);
                Listener.this.broadcastWindow = new WinDef.HWND(Native.getWindowPointer((Window)Listener.this.broadcastTarget));
                Listener.this.notificationHandle = user32.RegisterPowerSettingNotification((WinNT.HANDLE)Listener.this.broadcastWindow, Windows.GUID_SYSTEM_AWAYMODE, 0);
                if (Listener.this.notificationHandle == null) {
                    logger.debug("Failed to register for PowerSettingNotification");
                    return;
                }
                Listener.this.proc = new Windows.WNDPROC(){

                    @Override
                    public int WndProc(WinDef.HWND hWnd, int uMsg, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
                        logger.debug(uMsg + "Mesaage from listner..." + wParam);
                        logger.debug("s_uTaskbarRestart.........." + s_uTaskbarRestart);
                        if (uMsg == 536) {
                            if (Windows.PBT_APMSUSPEND.equals((Object)wParam)) {
                                for (PowerStateListener l : Listener.this.listeners) {
                                    l.suspend();
                                }
                                return 0;
                            }
                            if (Windows.PBT_APMRESUMESUSPEND.equals((Object)wParam)) {
                                for (PowerStateListener l : Listener.this.listeners) {
                                    l.resume();
                                }
                                return 0;
                            }
                        }
                        if (uMsg == s_uTaskbarRestart) {
                            for (PowerStateListener l : Listener.this.listeners) {
                                l.taskbarCreated();
                            }
                            return 0;
                        }
                        return user32.DefWindowProc(hWnd, uMsg, wParam, lParam);
                    }
                };
                BaseTSD.LONG_PTR ptr = user32.SetWindowLong(Listener.this.broadcastWindow, -4, Listener.this.proc);
                if (ptr.longValue() == 0L) {
                    logger.debug("Failed to set new address of window procedure");
                }
            }
        };
        this.service.submit(edtTask);
    }

    public void addPowerStateListener(PowerStateListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removePowerStateListener(PowerStateListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void destroy() {
        Windows user32 = Windows.INSTANCE;
        this.listeners.clear();
        if (user32.UnregisterPowerSettingNotification(this.notificationHandle)) {
            this.notificationHandle = null;
            this.broadcastTarget.dispose();
        }
    }

    public static final int registerWindowMessage(String lpString) {
        int messageId = User32.INSTANCE.RegisterWindowMessage(lpString);
        if (messageId == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return messageId;
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public static int getS_uTaskbarRestart() {
        return s_uTaskbarRestart;
    }

    public static void setS_uTaskbarRestart(int s_uTaskbarRestart) {
        Listener.s_uTaskbarRestart = s_uTaskbarRestart;
    }

    static {
        logger = LoggerFactory.getLogger(Listener.class);
    }
}

