/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.backup;

import com.parablu.epa.common.dao.BackUpImageDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.alarm.StatisticsCollectorHelper;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.BluVaultIPHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.element.GroupPolicyElement;
import com.parablu.epa.core.element.GroupPolicyElementList;
import com.parablu.epa.core.element.ProxyElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BluVaultTO;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.service.alarm.WindowsPolicyRefreshHelper;
import com.parablu.epa.view.SystemTrayUI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsCheckBackupPolicy {
    private static String cloudName = SettingHelper.getCloudName();
    private static String keyStorePath = SettingHelper.getKeystorePath();
    public static BackupAdapter backUpAdapter = new BackupAdapter(cloudName, keyStorePath);
    private static BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
    private static Logger logger = LoggerFactory.getLogger(WindowsCheckBackupPolicy.class);
    static int policyRefreshIntervalInHrs = -1;
    static int statisticsRefreshIntervalInHrs = -1;

    private WindowsCheckBackupPolicy() {
    }

    public static void checkGroupPolicy() {
        if (NotificationHelper.policyRefreshStarted) {
            logger.debug("policy refresh finished:" + NotificationHelper.policyRefreshStarted);
            WindowsCheckBackupPolicy.resetTimers();
            return;
        }
        NotificationHelper.policyRefreshStarted = true;
        BackupPolicyTO currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
        if (currentPolicy != null) {
            BackupPolicyTO backupPolicyTo = new BackupPolicyTO();
            GroupPolicyElementList groupPolicyElementList = null;
            try {
                logger.debug("Getting GROUP POLICY ELEMENT#######################");
                backUpAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                groupPolicyElementList = backUpAdapter.getGroupPolicyElement(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceName(), SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
                if (groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
                    logger.debug("groupPolicyElementList is nulll.....");
                    groupPolicyElementList = WindowsCheckBackupPolicy.retryUsingUpdatedIp();
                }
            }
            catch (CrawlAdapterException protocolException) {
                logger.error("Client protocol exception...." + (Object)((Object)protocolException));
                groupPolicyElementList = WindowsCheckBackupPolicy.retryUsingUpdatedIp();
            }
            catch (Exception e) {
                logger.error("Error in get latest policy:" + e);
            }
            if (groupPolicyElementList != null && !groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
                try {
                    for (GroupPolicyElement groupPolicyElement : groupPolicyElementList.getGroupPolicyElement()) {
                        if (groupPolicyElement.getStatus() == 416) {
                            SettingHelper.setLicenseActive((boolean)false);
                            continue;
                        }
                        SettingHelper.setLicenseActive((boolean)true);
                        PolicyManagementServerHelper.createGroupPolicyAndChildDetails((BackupPolicyDAOImpl)backupPolicyDAOImpl, (BackupPolicyTO)backupPolicyTo, (GroupPolicyElementList)groupPolicyElementList);
                    }
                }
                catch (Exception e) {
                    logger.error("Error in create group  policy:" + e);
                }
            }
            WindowsCheckBackupPolicy.checkPolicyNameAndDeleteBackupDb();
        } else {
            logger.debug("Due to some connection error previous policy may null so get latest policy");
            PolicyManagementServerHelper.loadBackupPolicyElement((String)SettingHelper.getDeviceName());
            WindowsCheckBackupPolicy.checkPolicyNameAndDeleteBackupDb();
        }
        if (NotificationHelper.isRestartAgentIcon()) {
            logger.debug("....ui list changed so relaunch agent..");
            SystemTrayUI.getSystemtrayInstance().relaunchSystemTray();
            NotificationHelper.setRestartAgentIcon((boolean)false);
        }
        WindowsCheckBackupPolicy.resetTimers();
        NotificationHelper.policyRefreshStarted = false;
    }

    public static void resetTimers() {
        BackupPolicyTO currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
        policyRefreshIntervalInHrs = WindowsCheckBackupPolicy.getCurrentPolicyRefereshInterval(currentPolicy);
        logger.debug("Backup policy interval :" + policyRefreshIntervalInHrs);
        statisticsRefreshIntervalInHrs = WindowsCheckBackupPolicy.getCurrentStatisticsRefereshInterval(currentPolicy);
        if (policyRefreshIntervalInHrs != -1 && policyRefreshIntervalInHrs != 0) {
            SettingHelper.setTempPolicyRefreshIntervalInMins((int)policyRefreshIntervalInHrs);
            WindowsPolicyRefreshHelper.resetBackupPolicyTimer();
        } else {
            SettingHelper.setTempPolicyRefreshIntervalInMins((int)60);
            WindowsPolicyRefreshHelper.resetBackupPolicyTimer();
        }
        if (statisticsRefreshIntervalInHrs != -1 && statisticsRefreshIntervalInHrs != 0) {
            SettingHelper.setStatisticsRefreshIntervalInMins((int)statisticsRefreshIntervalInHrs);
            StatisticsCollectorHelper.resetStatisticsTimer();
        } else {
            SettingHelper.setStatisticsRefreshIntervalInMins((int)120);
            StatisticsCollectorHelper.resetStatisticsTimer();
        }
    }

    public static void loadBackupPolicyElement(String deviceName) {
        GroupPolicyElementList groupPolicyElementList = null;
        BackupPolicyTO backupPolicyTo = new BackupPolicyTO();
        try {
            groupPolicyElementList = backUpAdapter.getGroupPolicyElement(SettingHelper.getCurrentCloudIpAddress(), deviceName, SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
            if (groupPolicyElementList.getGroupPolicyElement() == null) {
                groupPolicyElementList = WindowsCheckBackupPolicy.retryUsingUpdatedIp();
            }
        }
        catch (CrawlAdapterException protocolException) {
            logger.error("Client protocol exception." + (Object)((Object)protocolException));
            groupPolicyElementList = WindowsCheckBackupPolicy.retryUsingUpdatedIp();
        }
        catch (Exception e) {
            logger.debug("Exception in load backup policy so retrying it" + e);
            groupPolicyElementList = WindowsCheckBackupPolicy.retryUsingUpdatedIp();
        }
        if (!groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
            try {
                PolicyManagementServerHelper.createGroupPolicyAndChildDetails((BackupPolicyDAOImpl)backupPolicyDAOImpl, (BackupPolicyTO)backupPolicyTo, (GroupPolicyElementList)groupPolicyElementList);
            }
            catch (Exception e) {
                logger.error("Error in adding policy details....." + e);
            }
        }
    }

    private static int getCurrentPolicyRefereshInterval(BackupPolicyTO currentPolicy) {
        int policyInterval = -1;
        if (currentPolicy != null) {
            policyInterval = currentPolicy.getPolicyRefreshInterval();
        }
        return policyInterval;
    }

    private static int getCurrentStatisticsRefereshInterval(BackupPolicyTO currentPolicy) {
        int statisticsInterval = -1;
        if (currentPolicy != null) {
            statisticsInterval = currentPolicy.getStatisticsRefreshInterval();
        }
        logger.info("Current statistics interval from policy:" + statisticsInterval);
        return statisticsInterval;
    }

    private static GroupPolicyElementList retryUsingUpdatedIp() {
        boolean retry = false;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 60000L * (long)sleepMultiplier;
        String currentIP = SettingHelper.getPublicIpAddress();
        BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
        List ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
        do {
            logger.debug("Retrying to get policy information.");
            ebmsList = WindowsCheckBackupPolicy.removeCurrentIp(ebmsList, currentIP);
            logger.debug("ebms list size after removing the current ip:" + ebmsList.size());
            if (ebmsList.isEmpty()) {
                logger.debug("inside ebms list empty cycle finished so sleep and reset");
                sleepTime = ParabluFileSystemUtils.sleepForGivenTime((long)sleepTime);
                ++retryCount;
                ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
            }
            if (!ebmsList.isEmpty()) {
                currentIP = ebmsList.get(0).getBluVaultName();
            }
            logger.debug("The current IP to get policy is:" + currentIP);
            GroupPolicyElementList groupPolicyElementList = null;
            try {
                backUpAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                logger.debug("Getting GROUP POLICY ELEMENT#######################");
                groupPolicyElementList = backUpAdapter.getGroupPolicyElement(currentIP, SettingHelper.getDeviceName(), SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
            }
            catch (CrawlAdapterException protocolException) {
                logger.error("client protocol exception...." + (Object)((Object)protocolException));
            }
            catch (Exception e) {
                logger.error("Error in retrying  to get policy:" + e);
            }
            if (groupPolicyElementList != null && !groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
                for (GroupPolicyElement groupPolicyElement : groupPolicyElementList.getGroupPolicyElement()) {
                    if (groupPolicyElement.getStatus() == 416) {
                        SettingHelper.setLicenseActive((boolean)false);
                        retry = false;
                        continue;
                    }
                    SettingHelper.setLicenseActive((boolean)true);
                    SettingHelper.setCurrentCloudIpAddress((String)currentIP);
                    ProxyElement.setIp((String)currentIP);
                    SettingHelper.applyChangesToSharedPreferences((boolean)false);
                    return groupPolicyElementList;
                }
            } else {
                retry = true;
            }
        } while (retry && retryCount < 4);
        return null;
    }

    private static List<BluVaultTO> removeCurrentIp(List<BluVaultTO> ebmsList, String currentIP) {
        List<Object> ebmsList1 = new ArrayList();
        if (ebmsList == null) {
            ArrayList<BluVaultTO> ebsList = new ArrayList<BluVaultTO>();
            return ebsList;
        }
        if (StringUtils.isEmpty((String)currentIP)) {
            return ebmsList;
        }
        try {
            ebmsList1 = ebmsList.stream().filter(p -> !p.getBluVaultName().equalsIgnoreCase(currentIP)).collect(Collectors.toList());
            logger.debug("After removing the ip size:" + ebmsList1.size() + "  current Ip:" + currentIP);
        }
        catch (Exception e) {
            logger.error("error happened while removing current ip..", (Throwable)e);
        }
        logger.debug("After removing the ip size:" + ebmsList1.size() + "  current Ip:" + currentIP);
        return ebmsList1;
    }

    private static void checkPolicyNameAndDeleteBackupDb() {
        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
            BackupPolicyTO currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
            String policyName = "";
            if (currentPolicy != null) {
                policyName = currentPolicy.getPolicyGroupName();
            }
            logger.debug("Policy Name: " + policyName);
            if (!StringUtils.isEmpty((String)policyName) && policyName.contentEquals("RESTART")) {
                BackUpImageDAOImpl backUpImageDAOImpl = new BackUpImageDAOImpl(SettingHelper.getBackUpDbUrl());
                backUpImageDAOImpl.deleteEntireTable();
            }
        }
    }
}

