/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.alarm;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.backup.WindowsCheckBackupPolicy;
import com.parablu.epa.service.backup.WindowsCheckSyncPolicy;
import com.parablu.epa.service.notifications.WindowsEventsManagement;
import java.io.RandomAccessFile;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowsPolicyRefreshHelper {
    private static Logger logger = LoggerFactory.getLogger(WindowsPolicyRefreshHelper.class);
    private static Timer backupPolicyRefreshTimer = null;
    private static Timer syncPolicyRefreshTimer = null;
    private static long timeInMillisecondsConvertionFactorFromMinutes = 60000L;
    private static WindowsEventsManagement windowsEventsManagement = new WindowsEventsManagement();

    private WindowsPolicyRefreshHelper() {
    }

    public static synchronized void initiateBackupPolicyTimer() {
        WindowsCheckBackupPolicy.resetTimers();
        logger.debug("Initiating backup policy refresh timer STARTED" + SettingHelper.getTempPolicyRefreshIntervalInMins());
        backupPolicyRefreshTimer = new Timer();
        try {
            backupPolicyRefreshTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    windowsEventsManagement.refreshPolicyTask();
                }
            }, 600000L, (long)SettingHelper.getTempPolicyRefreshIntervalInMins() * timeInMillisecondsConvertionFactorFromMinutes);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Error in initiating backup timer...." + e.getMessage());
        }
        logger.debug("Initiating backup policy refresh timer COMPLETED");
    }

    public static synchronized void initiateBackupPolicyTimerAfterDelay() {
        backupPolicyRefreshTimer = new Timer();
        try {
            backupPolicyRefreshTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    windowsEventsManagement.refreshPolicyTask();
                    WindowsPolicyRefreshHelper.openNamedPipeNClose();
                }
            }, (long)SettingHelper.getTempPolicyRefreshIntervalInMins() * timeInMillisecondsConvertionFactorFromMinutes, (long)SettingHelper.getTempPolicyRefreshIntervalInMins() * timeInMillisecondsConvertionFactorFromMinutes);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Error in initiating timer......" + e.getMessage());
        }
        logger.debug("Initiating policy refresh timer after delay ");
    }

    public static synchronized void resetBackupPolicyTimer() {
        if (backupPolicyRefreshTimer != null) {
            backupPolicyRefreshTimer.cancel();
        }
        WindowsPolicyRefreshHelper.initiateBackupPolicyTimerAfterDelay();
    }

    public static void cancelBackupPolicyTimer() {
        backupPolicyRefreshTimer.cancel();
    }

    public static synchronized void refreshPolicyAndResetTimer() {
        WindowsCheckSyncPolicy.pullSyncPolicy();
        BlusyncThreadHelper.resetSyncTimer();
        windowsEventsManagement.refreshPolicyTask();
    }

    public static synchronized void initiateSyncPolicyTimerAfterDelay(int syncPolicyRefreshInterval) {
        syncPolicyRefreshTimer = new Timer();
        try {
            syncPolicyRefreshTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    WindowsCheckSyncPolicy.pullSyncPolicy();
                    BlusyncThreadHelper.resetSyncTimer();
                }
            }, (long)syncPolicyRefreshInterval * timeInMillisecondsConvertionFactorFromMinutes, (long)syncPolicyRefreshInterval * timeInMillisecondsConvertionFactorFromMinutes);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Error in initiating timer......" + e.getMessage());
        }
        logger.debug("Initiating policy refresh timer after delay ");
    }

    public static synchronized void resetSyncPolicyTimer(int syncPolicyRefreshInterval) {
        if (syncPolicyRefreshTimer != null) {
            syncPolicyRefreshTimer.cancel();
        }
        WindowsPolicyRefreshHelper.initiateSyncPolicyTimerAfterDelay(syncPolicyRefreshInterval);
    }

    public static void cancelBSyncPolicyTimer() {
        syncPolicyRefreshTimer.cancel();
    }

    private static void openNamedPipeNClose() {
        try {
            logger.debug("opening the named pipe...");
            RandomAccessFile pipe = new RandomAccessFile("\\\\.\\pipe\\ParabluSvcNAmedPipe", "rw");
            logger.debug("wait for one sec and close...");
            Thread.sleep(1000L);
            pipe.close();
        }
        catch (Exception e) {
            logger.error("Exception in open named pipe.." + e.getMessage());
        }
    }
}

