/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.alarm;

import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.RestoreActivityHistoryDAOImpl;
import com.parablu.epa.common.service.backup.NewBackUpJob;
import com.parablu.epa.common.service.backup.ReSendFilesJob;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.ActivityManagementHelper;
import com.parablu.epa.common.service.settings.HashChecker;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.sync.SyncJob;
import com.parablu.epa.core.adapter.tcp.ListnerAdapter;
import com.parablu.epa.core.service.sync.BaseJob;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.ScheduleTO;
import com.parablu.epa.helper.windows.VolumeShadowService;
import com.parablu.epa.service.alarm.WindowsPolicyRefreshHelper;
import com.parablu.epa.service.backup.WindowsBackupJob;
import com.parablu.epa.service.backup.WindowsCheckBackupPolicy;
import com.parablu.epa.service.backup.WindowsResendFilesJob;
import com.parablu.epa.service.notifications.UIHelper;
import com.parablu.epa.service.notifications.WindowsPowerStateListnerHelper;
import com.parablu.epa.service.sync.WindowsSyncJob;
import com.parablu.epa.view.RestoreBackup;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlusyncThreadHelper {
    private static NewBackUpJob backUpJob = null;
    private static SyncJob syncJob = null;
    private static Logger logger = LoggerFactory.getLogger(BlusyncThreadHelper.class);
    private static Timer syncTimer = null;
    private static Timer backUpTimer = null;
    private static Timer backUpWatchTimer = null;
    private static long timeInMillisecondsConvertionFactorFromMinutes = 60000L;
    private static Map<Date, ScheduleTO> scheduledBackupTypeMap = new HashMap<Date, ScheduleTO>();
    private static boolean isAdhocBackup = false;
    private static final String ILLEGAL_THREAD_STATE_EXCEPTION = "IllegalThreadStateException";
    private static ReSendFilesJob reSendFilesJob = null;
    private static boolean isFiveMinutesRetry;
    private static RestoreBackup restoreBackup;
    private static Timer restoreUpdateTimer;
    private static RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl;

    private BlusyncThreadHelper() {
    }

    public static synchronized void startBackUp(boolean isManual, boolean isFullBackup) {
        if (backUpJob != null && backUpJob.isAlive() || !SettingHelper.isLicenseActive() || SettingHelper.isDeviceBlocked()) {
            logger.debug("backup job is not null and is alive");
            BlusyncThreadHelper.resetBackupTimer();
            return;
        }
        if (!SettingHelper.isEnableAutomaticBackUp() && !isManual) {
            logger.debug("isEnableAutomaticBackUp: " + SettingHelper.isEnableAutomaticBackUp());
            return;
        }
        if (NotificationHelper.isRestoreStarted()) {
            logger.debug("Restore is runningg......");
            if (NotificationHelper.isSuspendBackup) {
                logger.debug("Restore is running and suspendbackup is enabled so return");
                return;
            }
        }
        backUpJob = new WindowsBackupJob(isManual, isFullBackup);
        backUpJob.setDaemon(true);
        backUpJob.start();
        logger.debug("The boolean manual is:" + isManual);
        BlusyncThreadHelper.startReSendFilesJob(isManual);
        Runnable runnable = () -> {
            try {
                backUpJob.join();
                BlusyncThreadHelper.resetBackupTimer();
                if (BlusyncThreadHelper.backUpJob.jobSucceded) {
                    logger.debug("Inside backUpJob.jobSucceded....");
                    return;
                }
                BlusyncThreadHelper.inspectError((BaseJob)backUpJob);
            }
            catch (IllegalThreadStateException e) {
                logger.trace("" + e);
                logger.error(ILLEGAL_THREAD_STATE_EXCEPTION, (Object)e.getMessage());
                logger.debug(ILLEGAL_THREAD_STATE_EXCEPTION, (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.trace("" + e);
                logger.error("Interrupted exception", (Object)e.getMessage());
                logger.debug("InterruptedException", (Throwable)e);
            }
        };
        new Thread(runnable).start();
        BlusyncThreadHelper.resetBackupTimer();
        if (!SettingHelper.isInitiateBackupInterfaceEnabled()) {
            UIHelper.displaySyncingGif();
        }
    }

    private static void startReSendFilesJob(boolean isManual) {
        try {
            if (reSendFilesJob != null && reSendFilesJob.isAlive()) {
                logger.debug("resend files job is alive so return");
                return;
            }
            logger.debug("Starting resend files job...");
            reSendFilesJob = new WindowsResendFilesJob(isManual);
            reSendFilesJob.setDaemon(true);
            reSendFilesJob.start();
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Resend files job thread interrupted.....");
        }
    }

    public static synchronized void initiateSyncTimer() {
        syncTimer = new Timer();
        logger.debug("NEXT SYNC SCHEDULED MINUTES :" + SettingHelper.getPolicySyncInterval());
        syncTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                WindowsPolicyRefreshHelper.refreshPolicyAndResetTimer();
                BlusyncThreadHelper.startSync(false);
            }
        }, 5000L, (long)SettingHelper.getPolicySyncInterval() * timeInMillisecondsConvertionFactorFromMinutes);
    }

    public static synchronized void initiateBackUpTimer() {
        backUpTimer = new Timer();
        isAdhocBackup = ActivityManagementHelper.isPreviousBackupInturupted();
        WindowsPowerStateListnerHelper.startPowerEventListner();
        backUpTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                BlusyncThreadHelper.startBackUp(false, NotificationHelper.isFullBackupOnly);
            }
        }, BlusyncThreadHelper.getNextScheduledMinute() * timeInMillisecondsConvertionFactorFromMinutes);
        BlusyncThreadHelper.initiateBackupWatchTimer();
    }

    private static void initiateBackupWatchTimer() {
        try {
            backUpWatchTimer = new Timer();
            backUpWatchTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    logger.debug("Reseting the timer after delay of 27 mins..");
                    BlusyncThreadHelper.resetBackupTimer();
                }
            }, 27L * timeInMillisecondsConvertionFactorFromMinutes, 27L * timeInMillisecondsConvertionFactorFromMinutes);
        }
        catch (Exception e) {
            logger.error("Error in initiate backup watch timer:", (Throwable)e);
        }
    }

    public static void initiateBackup() {
        block2: while (true) {
            try {
                while (true) {
                    long nextScheduledMinute = BlusyncThreadHelper.getNextScheduledMinute();
                    long nextBackupTimeStamp = nextScheduledMinute * timeInMillisecondsConvertionFactorFromMinutes;
                    SettingHelper.setNextBackupTimeStamp((long)nextBackupTimeStamp);
                    NotificationHelper.setChangeNextBackuplabel((boolean)true);
                    logger.debug("NEXT SCHEDULE TIME IN MINUTES:" + nextScheduledMinute);
                    if (nextScheduledMinute == 0L) break block2;
                    Thread.sleep(nextScheduledMinute * timeInMillisecondsConvertionFactorFromMinutes);
                    logger.debug("After thread sleep GOING TO START BACKUP:" + nextBackupTimeStamp);
                    if (SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) {
                        BlusyncThreadHelper.startServerBackup(false);
                        continue;
                    }
                    BlusyncThreadHelper.startBackUp(false, NotificationHelper.isFullBackupOnly);
                }
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception" + e.getMessage());
                continue;
            }
            break;
        }
    }

    public static synchronized void initiateSyncTimerAfterDelay() {
        syncTimer = new Timer();
        syncTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                BlusyncThreadHelper.startSync(false);
            }
        }, (long)SettingHelper.getPolicySyncInterval() * timeInMillisecondsConvertionFactorFromMinutes, (long)SettingHelper.getPolicySyncInterval() * timeInMillisecondsConvertionFactorFromMinutes);
    }

    public static void waitForBackupJob() {
        if (backUpJob != null) {
            while (backUpJob.isAlive()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    logger.error("InterruptedException while thread sleep" + e);
                }
            }
        }
    }

    public static synchronized void initiateBackUpTimerAfterDelay() {
        backUpTimer = new Timer();
        backUpTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                BlusyncThreadHelper.startBackUp(false, NotificationHelper.isFullBackupOnly);
            }
        }, BlusyncThreadHelper.getNextScheduledMinute() * timeInMillisecondsConvertionFactorFromMinutes);
    }

    public static synchronized void resetSyncTimer() {
        if (syncTimer != null) {
            syncTimer.cancel();
        }
        BlusyncThreadHelper.initiateSyncTimerAfterDelay();
    }

    public static synchronized void resetBackupTimer() {
        if (isFiveMinutesRetry) {
            NotificationHelper.policyRefreshStarted = false;
            isFiveMinutesRetry = false;
            NotificationHelper.changeTextOfBackupPolicyMenu = true;
        } else {
            if (backUpTimer != null) {
                logger.debug("backuptimer is not  null");
                backUpTimer.cancel();
            }
            BlusyncThreadHelper.initiateBackUpTimerAfterDelay();
        }
    }

    public static void cancelSyncTimer() {
        syncTimer.cancel();
    }

    public static void cancelBackupTimer() {
        backUpTimer.cancel();
    }

    public static void cancelBackupWatchTimer() {
        backUpWatchTimer.cancel();
    }

    public static void cancelCurrentSyncProcess() {
        if (syncJob != null && syncJob.isAlive()) {
            BlusyncThreadHelper.syncJob.shouldKillCrawl = true;
            syncJob.interrupt();
        }
    }

    public static void cancelCurrentBackupProcess(boolean isManualStop, boolean hardStop, boolean isActionFromPortal) {
        if (backUpJob != null && backUpJob.isAlive()) {
            logger.debug("Current Backup Process Cancelled" + isManualStop + hardStop);
            backUpJob.pauseBackup(isManualStop, hardStop, backUpJob, isActionFromPortal, false);
        }
    }

    public static synchronized void startSync(boolean manual) {
        if (syncJob != null && syncJob.isAlive() || !SettingHelper.isLicenseActive() || SettingHelper.isDeviceBlocked()) {
            logger.debug("syncJob: " + syncJob);
            logger.debug("SettingHelper.isLicenseActive(): " + SettingHelper.isLicenseActive());
            logger.debug("SettingHelper.isDeviceBlocked(): " + SettingHelper.isDeviceBlocked());
            logger.debug("sync job is not null and is alive or licenseExpired/deviceBlocked");
            return;
        }
        if (!SettingHelper.isEnableBlusync() && !manual) {
            logger.debug("Sync Enabled: " + SettingHelper.isEnableBlusync());
            return;
        }
        syncJob = new WindowsSyncJob();
        syncJob.setDaemon(true);
        syncJob.start();
        Runnable runnable = () -> {
            try {
                syncJob.join();
                if (BlusyncThreadHelper.syncJob.jobSucceded) {
                    return;
                }
                BlusyncThreadHelper.inspectError((BaseJob)syncJob);
            }
            catch (IllegalThreadStateException e) {
                logger.trace(ILLEGAL_THREAD_STATE_EXCEPTION + e);
                logger.debug(ILLEGAL_THREAD_STATE_EXCEPTION, (Object)e.getMessage());
            }
            catch (InterruptedException e) {
                logger.trace("" + e);
                logger.debug("InterruptedException", (Object)e.getMessage());
            }
        };
        new Thread(runnable).start();
    }

    protected static synchronized void inspectError(BaseJob baseJob) {
        if (baseJob.jobStatusCode == 2304 || baseJob.jobStatusCode == 909 || baseJob.jobStatusCode == 913 || baseJob.jobStatusCode == 1996) {
            BlusyncThreadHelper.startBackupAfterFiveMinutes();
        }
        if (baseJob.licenseExpired) {
            BlusyncThreadHelper.deactivateAccount();
            NotificationHelper.setCurrentStatus((int)13, (int)100);
            return;
        }
        if (baseJob.deviceBlocked) {
            NotificationHelper.setCurrentStatus((int)11, (int)100);
            BlusyncThreadHelper.blockDevice();
            return;
        }
        if (baseJob.sessionExpired) {
            NotificationHelper.setCurrentStatus((int)14, (int)100);
            BlusyncThreadHelper.disconnectFromParacloud(14);
            return;
        }
    }

    private static synchronized void startBackupAfterFiveMinutes() {
        logger.debug("##########inside starting backup after 5 mins##########");
        NotificationHelper.policyRefreshStarted = true;
        NotificationHelper.changeTextOfBackupPolicyMenu = false;
        WindowsPolicyRefreshHelper.cancelBackupPolicyTimer();
        isFiveMinutesRetry = true;
        if (backUpTimer != null) {
            backUpTimer.cancel();
        }
        backUpTimer = new Timer();
        backUpTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                BlusyncThreadHelper.startBackUp(false, false);
                WindowsPolicyRefreshHelper.resetBackupPolicyTimer();
                NotificationHelper.policyRefreshStarted = false;
                isFiveMinutesRetry = false;
                NotificationHelper.changeTextOfBackupPolicyMenu = true;
                logger.debug("##########inside starting backup after 1 mins##########");
            }
        }, 5L * timeInMillisecondsConvertionFactorFromMinutes);
    }

    private static void deactivateAccount() {
        UIHelper.deactivateAccount();
    }

    private static void disconnectFromParacloud(int statusBlusyncSessionexpired) {
        UIHelper.disconnectFromParacloud(statusBlusyncSessionexpired);
    }

    private static void blockDevice() {
        UIHelper.blockDevice();
    }

    private static synchronized long getNextScheduledMinute() {
        try {
            List<ScheduleTO> list = BlusyncThreadHelper.getSchedulesList();
            if (list == null || list.isEmpty()) {
                logger.debug("Schedule List is null or empty after retry so set default 12 mins");
                return 12L;
            }
            TreeSet<Date> dates = new TreeSet<Date>();
            if ((list = BlusyncThreadHelper.getAppropriateDatesForSchedules(list, dates, 0)) == null || list.isEmpty()) {
                logger.debug("Schedule List is null or empty after retry so set default 12 mins");
                return 12L;
            }
            Date highestDateUpUntilNow = dates.higher(Calendar.getInstance().getTime());
            TreeSet<Date> datesToCheckPreviousSchedule = new TreeSet<Date>();
            BlusyncThreadHelper.getAppropriateDatesForSchedules(list, datesToCheckPreviousSchedule, 1);
            Date currentDate = Calendar.getInstance().getTime();
            currentDate.setSeconds(0);
            Date previousSchedule = datesToCheckPreviousSchedule.lower(currentDate);
            if (previousSchedule == null) {
                previousSchedule = Collections.max(datesToCheckPreviousSchedule);
            }
            logger.debug("Previous schedule time " + previousSchedule);
            boolean isPreviousBackupOccured = BlusyncThreadHelper.comparePreviousBackupWithSchedule(previousSchedule);
            if (!isPreviousBackupOccured || isAdhocBackup) {
                logger.debug("Previous schedule didnt happen so return 14 min");
                logger.debug("AdhocBackup Enabled  : " + isAdhocBackup);
                isAdhocBackup = false;
                long nextScheduleMinute = 14L;
                logger.debug("scheduledBackupType...." + scheduledBackupTypeMap.get(previousSchedule).getBackupType());
                if (scheduledBackupTypeMap.get(previousSchedule).getBackupType().toLowerCase().equalsIgnoreCase("full")) {
                    NotificationHelper.setFullBackupOnly((boolean)true);
                } else {
                    NotificationHelper.setFullBackupOnly((boolean)false);
                }
                return nextScheduleMinute;
            }
            Date nextScheduleDate = highestDateUpUntilNow == null ? Collections.min(dates) : highestDateUpUntilNow;
            logger.debug("Next scheduled Date:" + nextScheduleDate);
            if (SettingHelper.getServerBackupLicensed().equals("true")) {
                NotificationHelper.setScheduledContainerNames((String)scheduledBackupTypeMap.get(nextScheduleDate).getContainerName());
            }
            logger.debug("scheduledBackupType...." + scheduledBackupTypeMap.get(nextScheduleDate).getBackupType() + nextScheduleDate);
            if (scheduledBackupTypeMap.get(nextScheduleDate).getBackupType().toLowerCase().equalsIgnoreCase("full")) {
                NotificationHelper.setFullBackupOnly((boolean)true);
            } else {
                NotificationHelper.setFullBackupOnly((boolean)false);
            }
            Calendar currentTime = Calendar.getInstance();
            currentTime.set(13, 0);
            long timeDiff = nextScheduleDate.getTime() - currentTime.getTime().getTime();
            long nextScheduleMinute = timeDiff <= 0L ? 1440L - TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff)) : TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff));
            if (nextScheduleMinute == 0L) {
                logger.debug("Next schedule minute is zero");
                nextScheduleMinute = BlusyncThreadHelper.getNextScheduledMinute();
            }
            logger.debug("NEXT SCHEDULE TIME IN MINUTES:" + nextScheduleMinute);
            return nextScheduleMinute;
        }
        catch (Exception e) {
            logger.error("Exception while getting next schedule ", (Throwable)e);
            return 12L;
        }
    }

    private static List<ScheduleTO> getSchedulesList() {
        List list = null;
        boolean retry = false;
        int retryCount = 0;
        do {
            try {
                logger.debug("Inside get schedules...");
                list = HashChecker.getScheduleList();
                if (list != null && !list.isEmpty()) continue;
                logger.debug("Inside schedules are empty so retry");
                retry = true;
                WindowsCheckBackupPolicy.checkGroupPolicy();
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                logger.error("Exception while retrying to get schedules" + e);
            }
        } while (retry && ++retryCount < 3);
        return list;
    }

    private static List<ScheduleTO> getAppropriateDatesForSchedules(List<ScheduleTO> list, NavigableSet<Date> dates, int checkPrevSchedule) {
        for (ScheduleTO scheduleTO : list) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            try {
                Date date1 = sdf.parse(scheduleTO.getStartTime());
                Calendar calendar = Calendar.getInstance();
                int dayOfWeek = calendar.get(7);
                int[] daysArray = BlusyncThreadHelper.toIntArray(scheduleTO.getDayArray());
                for (int i = 0; i < daysArray.length; ++i) {
                    Calendar calendar1 = Calendar.getInstance();
                    int currentSeconds = Calendar.getInstance().getTime().getSeconds();
                    if (daysArray[i] > dayOfWeek) {
                        if (checkPrevSchedule == 0) {
                            calendar1.add(5, daysArray[i] - dayOfWeek);
                            calendar1.set(11, date1.getHours());
                            calendar1.set(12, date1.getMinutes());
                            calendar1.set(13, date1.getSeconds());
                            dates.add(calendar1.getTime());
                            scheduledBackupTypeMap.put(calendar1.getTime(), scheduleTO);
                            continue;
                        }
                        if (checkPrevSchedule != 1) continue;
                        calendar1.add(5, daysArray[i] - dayOfWeek - 7);
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        calendar1.set(13, date1.getSeconds());
                        dates.add(calendar1.getTime());
                        scheduledBackupTypeMap.put(calendar1.getTime(), scheduleTO);
                        continue;
                    }
                    if (daysArray[i] < dayOfWeek) {
                        if (checkPrevSchedule == 0) {
                            calendar1.add(5, 7 - (dayOfWeek - daysArray[i]));
                            calendar1.set(11, date1.getHours());
                            calendar1.set(12, date1.getMinutes());
                            calendar1.set(13, date1.getSeconds());
                            dates.add(calendar1.getTime());
                            scheduledBackupTypeMap.put(calendar1.getTime(), scheduleTO);
                            continue;
                        }
                        if (checkPrevSchedule != 1) continue;
                        calendar1.add(5, daysArray[i] - dayOfWeek);
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        calendar1.set(13, date1.getSeconds());
                        dates.add(calendar1.getTime());
                        scheduledBackupTypeMap.put(calendar1.getTime(), scheduleTO);
                        continue;
                    }
                    if (daysArray[i] != dayOfWeek) continue;
                    calendar1.set(11, date1.getHours());
                    calendar1.set(12, date1.getMinutes());
                    calendar1.set(13, currentSeconds);
                    if (checkPrevSchedule == 0 && Calendar.getInstance().getTime().getTime() > calendar1.getTime().getTime()) {
                        calendar1.add(5, 7);
                    } else if (checkPrevSchedule == 1 && Calendar.getInstance().getTime().getTime() < calendar1.getTime().getTime()) {
                        calendar1.add(5, -7);
                    }
                    dates.add(calendar1.getTime());
                    scheduledBackupTypeMap.put(calendar1.getTime(), scheduleTO);
                }
            }
            catch (ParseException e) {
                list = null;
                logger.trace("" + e);
                logger.error("Exception getting schedules " + e.getMessage());
            }
        }
        return list;
    }

    private static boolean comparePreviousBackupWithSchedule(Date previousSchedule) {
        if (previousSchedule == null) {
            logger.debug("Previous Schedule is null");
            return true;
        }
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        if (backupActivityTO == null) {
            logger.debug("no backups run previously so initiating the backup in one minute");
            return false;
        }
        String timeStamp = backupActivityTO.getBackupActivityTimeStamp();
        long backupTimeStamp = 0L;
        if (timeStamp != null) {
            backupTimeStamp = Long.valueOf(timeStamp);
        }
        if (backupTimeStamp != 0L) {
            Date date = new Date(backupTimeStamp);
            logger.debug("Last sucessful backup:" + date + "  Previoud Schedule:" + previousSchedule);
            long previousScheduleTimestamp = previousSchedule.getTime();
            if (previousScheduleTimestamp < backupTimeStamp) {
                logger.debug("Previous Schedule backup occured successfully");
                return true;
            }
            if (backupTimeStamp + 60000L > System.currentTimeMillis()) {
                logger.debug("previous time>>>>>" + (backupTimeStamp + 60000L));
                logger.debug("current time>>>>>" + System.currentTimeMillis());
                logger.debug("Previous Schedule backup occured one minute ago successfully");
                return true;
            }
        }
        return false;
    }

    public static int[] toIntArray(String input) {
        String beforeSplit = input.replaceAll("\\[|\\]|\\s", "");
        String[] split = beforeSplit.split("\\,");
        int[] result = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            result[i] = Integer.parseInt(split[i]);
        }
        return result;
    }

    public static void startServerBackup(final boolean isManual) {
        if (backUpJob != null && backUpJob.isAlive() || !SettingHelper.isLicenseActive() || SettingHelper.isDeviceBlocked()) {
            logger.debug("backup job is not null and is alive");
            return;
        }
        if (!SettingHelper.isEnableAutomaticBackUp() && !isManual) {
            logger.debug("isEnableAutomaticBackUp: " + SettingHelper.isEnableAutomaticBackUp());
            return;
        }
        if (NotificationHelper.isRestoreStarted()) {
            logger.debug("Restore is happening so stop backup");
            return;
        }
        logger.debug("Schedule returned container " + NotificationHelper.getScheduledContainerNames());
        final String[] containeNames = NotificationHelper.getScheduledContainerNames().split("\\|");
        new Thread(){

            @Override
            public void run() {
                for (String containerName : containeNames) {
                    logger.debug("cont Name : " + containerName);
                    NotificationHelper.setCurrentContainerName((String)containerName);
                    NotificationHelper.setCurrentPolicyName((String)VolumeShadowService.getPolicyForContainer(containerName));
                    logger.debug("Policy name : " + NotificationHelper.getCurrentPolicyName());
                    backUpJob = new WindowsBackupJob(isManual, false);
                    backUpJob.setDaemon(true);
                    backUpJob.start();
                    logger.debug("The boolean manual is:" + isManual);
                    try {
                        backUpJob.join();
                        if (backUpJob.jobSucceded) continue;
                        BlusyncThreadHelper.inspectError((BaseJob)backUpJob);
                    }
                    catch (IllegalThreadStateException e) {
                        logger.trace(BlusyncThreadHelper.ILLEGAL_THREAD_STATE_EXCEPTION + e);
                        logger.debug(BlusyncThreadHelper.ILLEGAL_THREAD_STATE_EXCEPTION, (Object)e.getMessage());
                    }
                    catch (InterruptedException e) {
                        logger.trace("" + e);
                        logger.debug(BlusyncThreadHelper.ILLEGAL_THREAD_STATE_EXCEPTION, (Object)e.getMessage());
                    }
                }
            }
        }.start();
    }

    public static void validateDomainCheck() {
        try {
            ListnerAdapter listnerAdapter = new ListnerAdapter();
            BackupPolicyTO backupPolicyTO = SettingHelper.getCurrentBackupPolicy();
            if (backupPolicyTO != null) {
                logger.debug("Domain check enabled:" + backupPolicyTO.isDoaminCheckEnabled());
                if (backupPolicyTO.isDoaminCheckEnabled()) {
                    if (backupPolicyTO.getAllowedDomains() == null) {
                        BlusyncThreadHelper.validateDomain();
                    }
                    String domainName = new String(backupPolicyTO.getAllowedDomains().trim());
                    if (listnerAdapter.checkForService()) {
                        logger.debug("service is running so validate conected domain.." + domainName);
                        if (!listnerAdapter.validateConnectedDomain(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getCloudName(), SettingHelper.getDeviceUUId(), SettingHelper.getUserHome(), domainName)) {
                            BlusyncThreadHelper.validateDomain();
                        }
                    } else {
                        logger.debug("service is not running .. so failed to validate domain check....");
                        BlusyncThreadHelper.validateDomain();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error" + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void validateDomain() {
        logger.debug("inside validateDomain ");
        UIHelper.updateSystrayToolTipNotification("EndPoint not authorized", "This EndPoint is not authorized, check with your administrator.");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.debug("Valid domain nahi haiii...");
        System.exit(0);
    }

    public static void updateRestoreBatch() {
        logger.debug("inside updateRestoreBatch..");
        restoreUpdateTimer = new Timer();
        restoreUpdateTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                boolean getLastRecord = true;
                if (NotificationHelper.isRestoreStarted()) {
                    getLastRecord = false;
                }
                restoreBackup.validatePreviousBatchStatus(restoreActivityHistoryDAOImpl, getLastRecord);
            }
        }, 60000L);
    }

    static {
        restoreBackup = new RestoreBackup();
        restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
    }
}

