/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.SyncPolicyDAO;
import com.parablu.epa.core.to.InclusionTO;
import com.parablu.epa.core.to.ShareDetailsTo;
import com.parablu.epa.core.to.SyncPolicyTo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncPolicyDAOImpl
extends BaseDAO
implements SyncPolicyDAO {
    private Logger logger = LoggerFactory.getLogger(SyncPolicyDAOImpl.class);
    private static final String SQLEXCEPTON_WHILE_CREATING_SYNC_POLICYTABLE = "sql exception creating sync policy table";
    private static final String SQLEXCEPTON_WHILE_CLOSING_RESULTSET = "sql exception while closing result set";
    private static final String SQLEXCEPTON_WHILE_INSERTING_SYNC_POLICYDETAILS = "Sql excceptionn while inserting sync policy";
    private static final String SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER = "SQLException while inserting sync filter";
    private static final String WHERE = " where ";

    public SyncPolicyDAOImpl(String uRL) {
        super(uRL);
    }

    public boolean alterTable() {
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.alterInclusionsTable(this.conn);
                this.alterSyncPolicyTable(this.conn);
            }
            catch (Exception e) {
                this.logger.debug("Exception in Alter inclusion teble" + e);
            }
            finally {
                this.closeConnection();
            }
        }
        return false;
    }

    private void alterSyncPolicyTable(Connection conn) {
        try {
            this.statement = conn.prepareStatement("ALTER table SYNC_POLICY ADD COLUMN nwThrottleSpeed INTEGER;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table SYNC_POLICY ADD COLUMN nwThrottleSpeed INTEGER;" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearTable() {
        this.statement = null;
        String syncPolicyStatement = "delete from SYNC_POLICY;";
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(syncPolicyStatement);
                this.statement.executeUpdate();
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("sql exception while trying to deleting group policy and child elements:" + e.getMessage());
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createInclusionsTable() {
        String query = BluSyncSQLConstants.CREATE_INCLUSIONS_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("sql exception while creating sync inclusions table", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSyncPolicyTable() {
        String query = BluSyncSQLConstants.CREATE_SYNC_POLICY_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTON_WHILE_CREATING_SYNC_POLICYTABLE, (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSyncPolicyAndChildDetails() {
        this.logger.debug(" Inside deleteSyncPolicyAndChildDetails ");
        this.statement = null;
        String policyDeleteStatement = "delete from SYNC_POLICY;";
        String inclusionsDeleteStatement = "delete from INCLUSIONS;";
        String shareDeleteStatement = "delete from SHARE;";
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(policyDeleteStatement);
                this.logger.debug("statement   " + this.statement);
                this.statement.executeUpdate();
                this.statement.close();
                this.statement = this.conn.prepareStatement(inclusionsDeleteStatement);
                this.logger.debug("statement   " + this.statement);
                this.statement.executeUpdate();
                this.statement.close();
                this.statement = this.conn.prepareStatement(shareDeleteStatement);
                this.statement.executeUpdate();
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("sql exception while trying to deleting group policy and child elements:" + e.getMessage());
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSyncPolicyAndChildDetailsFromBackupdb() {
        this.logger.debug("Inside delete gatewaylist and EBMS ");
        this.statement = null;
        StringBuffer gatewayDeleteStatement = new StringBuffer().append("delete from ").append("GATEWAYLIST").append(WHERE).append("ProductType").append(" =?;");
        StringBuffer ebmsTableDeleteStatement = new StringBuffer().append("delete from ").append("EBMS").append(WHERE).append("ProductType").append(" =?;");
        String backupdbURL = SettingHelper.getBackUpDbUrl();
        String ProductType = "SYNC";
        boolean gotConnection = this.getConnection(backupdbURL);
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(gatewayDeleteStatement.toString());
                this.statement.setString(1, ProductType);
                this.statement.executeUpdate();
                this.statement.close();
                this.logger.debug("exception");
                this.statement = this.conn.prepareStatement(ebmsTableDeleteStatement.toString());
                this.statement.setString(1, ProductType);
                this.statement.executeUpdate();
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("sql exception while trying to deleting group policy and child elements:" + e.getMessage());
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SyncPolicyTo> getSyncPolicyDetails() {
        String query = " select * from SYNC_POLICY";
        ResultSet selectSyncPolicyTableResult = null;
        ArrayList<SyncPolicyTo> syncPolicyTos = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(" select * from SYNC_POLICY");
                selectSyncPolicyTableResult = this.statement.executeQuery();
                syncPolicyTos = new ArrayList<SyncPolicyTo>();
                while (selectSyncPolicyTableResult != null && selectSyncPolicyTableResult.next()) {
                    SyncPolicyTo syncPolicyTo = new SyncPolicyTo();
                    syncPolicyTo.setPolicyGroupName(selectSyncPolicyTableResult.getString("policyGroupName"));
                    syncPolicyTo.setMaxVersions(selectSyncPolicyTableResult.getInt("maxVersions"));
                    syncPolicyTo.setMaxFileSize(selectSyncPolicyTableResult.getInt("maxFileSize"));
                    syncPolicyTo.setPftEnabled(selectSyncPolicyTableResult.getString("PFTenabled"));
                    syncPolicyTo.setPftSize(selectSyncPolicyTableResult.getInt("PFTsize"));
                    syncPolicyTo.setCpuUtilization(selectSyncPolicyTableResult.getInt("cpuutil"));
                    syncPolicyTo.setPolicyRefreshInterval(selectSyncPolicyTableResult.getInt("refreshinterval"));
                    syncPolicyTo.setLastModifiedTime(selectSyncPolicyTableResult.getString("lastModifiedTime"));
                    syncPolicyTo.setChunkSize(selectSyncPolicyTableResult.getInt("chunkSize"));
                    syncPolicyTo.setCompressionEnabled(Boolean.valueOf(selectSyncPolicyTableResult.getString("compressionEnabled")).booleanValue());
                    syncPolicyTo.setMemoryUtilization(selectSyncPolicyTableResult.getInt("memoryutil"));
                    syncPolicyTo.setAutomaticSync(selectSyncPolicyTableResult.getString("automaticsync"));
                    syncPolicyTo.setSyncInterval(selectSyncPolicyTableResult.getInt("syncinterval"));
                    syncPolicyTo.setNetworkThrottleSpeed(selectSyncPolicyTableResult.getFloat("nwThrottleSpeed"));
                    syncPolicyTos.add(syncPolicyTo);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("sqlexception while reading from ploicy table", (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                if (selectSyncPolicyTableResult != null) {
                    try {
                        selectSyncPolicyTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTON_WHILE_CLOSING_RESULTSET + e);
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Runtime Exception...", (Object)e.getMessage());
                    }
                }
                this.closeConnection();
            }
        }
        return syncPolicyTos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertSyncPolicyDetailsToTable(SyncPolicyTo syncPolicyTo) {
        String query = "insert into SYNC_POLICY(policyGroupName,maxVersions,maxFileSize,PFTenabled,PFTsize,cpuutil,refreshinterval,lastModifiedTime,chunkSize,compressionEnabled,memoryutil,automaticsync,syncinterval,nwThrottleSpeed) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into SYNC_POLICY(policyGroupName,maxVersions,maxFileSize,PFTenabled,PFTsize,cpuutil,refreshinterval,lastModifiedTime,chunkSize,compressionEnabled,memoryutil,automaticsync,syncinterval,nwThrottleSpeed) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?);");
                this.statement.setString(1, syncPolicyTo.getPolicyGroupName());
                this.statement.setInt(2, syncPolicyTo.getMaxVersions());
                this.statement.setLong(3, syncPolicyTo.getMaxFileSize());
                this.statement.setString(4, syncPolicyTo.getPftEnabled());
                this.statement.setLong(5, syncPolicyTo.getPftSize());
                this.statement.setInt(6, syncPolicyTo.getCpuUtilization());
                this.statement.setInt(7, syncPolicyTo.getPolicyRefreshInterval());
                this.statement.setString(8, syncPolicyTo.getLastModifiedTime());
                this.statement.setInt(9, syncPolicyTo.getChunkSize());
                this.statement.setString(10, String.valueOf(syncPolicyTo.isCompressionEnabled()));
                this.statement.setInt(11, syncPolicyTo.getMemoryUtilization());
                this.statement.setString(12, syncPolicyTo.getAutomaticSync());
                this.statement.setInt(13, syncPolicyTo.getSyncInterval());
                this.statement.setString(14, String.valueOf(syncPolicyTo.getNetworkThrottleSpeed()));
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTON_WHILE_INSERTING_SYNC_POLICYDETAILS, (Object)exception.getMessage());
                this.logger.trace("" + exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertInclusions(InclusionTO inclusionTO) {
        String query = "insert into INCLUSIONS(filterName,extensionName,policyGroupName,filterType) values(?,?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into INCLUSIONS(filterName,extensionName,policyGroupName,filterType) values(?,?,?,?);");
                this.statement.setString(1, inclusionTO.getFilterName());
                this.statement.setString(2, inclusionTO.getExtensionName());
                this.statement.setString(4, inclusionTO.getFilterType());
                this.statement.setString(3, inclusionTO.getPolicyName());
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER, (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createShareTable() {
        String query = BluSyncSQLConstants.CREATE_SHARE_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTON_WHILE_CREATING_SYNC_POLICYTABLE, (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertShareDetails(ShareDetailsTo shareDetailsTo) {
        String query = "insert into SHARE(policyGroupName,complexpassword,expiryperiod,highsecure,shareenabled) values(?,?,?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into SHARE(policyGroupName,complexpassword,expiryperiod,highsecure,shareenabled) values(?,?,?,?,?);");
                this.statement.setString(1, shareDetailsTo.getPolicyName());
                this.statement.setString(2, shareDetailsTo.getIsComplexPassword());
                this.statement.setString(3, shareDetailsTo.getExpiryPeriod());
                this.statement.setString(4, shareDetailsTo.getIsHighSecure());
                this.statement.setString(5, shareDetailsTo.getShareEnabled());
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_INSERTING_PARENTFOLDER, (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareDetailsTo getShareDetails() {
        String query = "select * from SHARE";
        ShareDetailsTo shareDetailsTO = null;
        this.statement = null;
        ResultSet resultSet = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("select * from SHARE");
                resultSet = this.statement.executeQuery();
                if (resultSet != null) {
                    shareDetailsTO = new ShareDetailsTo();
                    while (resultSet.next()) {
                        shareDetailsTO.setPolicyName(resultSet.getString("policyGroupName"));
                        shareDetailsTO.setExpiryPeriod(resultSet.getString("expiryperiod"));
                        shareDetailsTO.setIsComplexPassword(resultSet.getString("complexpassword"));
                        shareDetailsTO.setIsHighSecure(resultSet.getString("highsecure"));
                        shareDetailsTO.setShareEnabled(resultSet.getString("shareenabled"));
                    }
                }
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while selecting from share table ", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set of share table:" + e);
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Runtime Exception...", (Object)e.getMessage());
                    }
                }
                this.closeConnection();
            }
        }
        return shareDetailsTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getInclusionExtensions() {
        String query = "select * from INCLUSIONS";
        HashMap<String, String> exclusionMap = null;
        this.statement = null;
        ResultSet resultSet = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("select * from INCLUSIONS");
                resultSet = this.statement.executeQuery();
                if (resultSet != null) {
                    exclusionMap = new HashMap<String, String>();
                    while (resultSet.next()) {
                        exclusionMap.put("extensionName", String.valueOf(resultSet.getString("extensionName")));
                        exclusionMap.put("filterType", resultSet.getString("filterType"));
                    }
                }
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while selecting from Inclusions ", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set for geting Previous Image Table Name" + e);
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Runtime Exception...", (Object)e.getMessage());
                    }
                }
                this.closeConnection();
            }
        }
        return exclusionMap;
    }

    private void alterInclusionsTable(Connection conn) throws Exception {
        try {
            this.statement = conn.prepareStatement("ALTER table INCLUSIONS ADD COLUMN filterType TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table TABLE_NAME_INCLUSIONS ADD COLUMN sync filter type :" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
    }
}

