/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.MediaImageTableDAO;
import com.parablu.epa.core.to.MediaTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaImageDAOImpl
extends BaseDAO
implements MediaImageTableDAO {
    private Logger logger = LoggerFactory.getLogger(MediaImageDAOImpl.class);

    public MediaImageDAOImpl(String uRL) {
        super(uRL);
    }

    public void createTable() {
        String query = BluSyncSQLConstants.CREATE_MEDIA_IMAGE_TABLE_QUERY;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while creating media image table:", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListIntoTable(List<MediaTO> fileTOs) {
        String query = "insert into MKIT values(?,?,?,?,?,?,?,?);";
        boolean success = false;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into MKIT values(?,?,?,?,?,?,?,?);");
                int listsize = fileTOs.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    MediaTO currentFilesTO = fileTOs.get(recordCount);
                    String tempValueFolder = String.valueOf(currentFilesTO.isFolder());
                    this.statement.setString(1, currentFilesTO.getFileName());
                    this.statement.setString(2, currentFilesTO.getAbstractFilePath());
                    this.statement.setString(3, currentFilesTO.getMd5checksum());
                    this.statement.setString(4, currentFilesTO.getMetaData());
                    this.statement.setString(5, String.valueOf(currentFilesTO.getLastModifiedTimestamp()));
                    this.statement.setString(6, tempValueFolder);
                    this.statement.setString(7, currentFilesTO.getMediaType());
                    this.statement.setString(8, currentFilesTO.getExtension());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while inserting", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaTO> readAllEntriesFromTable() {
        String query = "select * from MKIT";
        ResultSet selectImageTableResult = null;
        ArrayList<MediaTO> fileTOList = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("select * from MKIT");
                selectImageTableResult = this.statement.executeQuery();
                fileTOList = new ArrayList<MediaTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    MediaTO tempFile = new MediaTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(Boolean.valueOf(selectImageTableResult.getString("folder")).booleanValue());
                    tempFile.setMediaType(selectImageTableResult.getString("mediaType"));
                    tempFile.setExtension(selectImageTableResult.getString("extension"));
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while reading All Entries From Table", (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set" + e);
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Runtime Exception...", (Object)e.getMessage());
                    }
                }
                this.closeConnection();
            }
        }
        return fileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListFromTable(List<MediaTO> fileTOs) {
        String query = "delete from MKIT where filename=? And filepath=?;";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from MKIT where filename=? And filepath=?;");
                int listsize = fileTOs.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, fileTOs.get(recordCount).getFileName());
                    this.statement.setString(2, fileTOs.get(recordCount).getAbstractFilePath());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while removing List From Table", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }
}

