/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.BackupPolicyDAO;
import com.parablu.epa.core.helper.ParabluStringUtils;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BluVaultTO;
import com.parablu.epa.core.to.ContainerDetailsTo;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.ScheduleTO;
import com.parablu.epa.helper.utils.MD5Generator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupPolicyDAOImpl
extends BaseDAO
implements BackupPolicyDAO {
    private Logger logger = LoggerFactory.getLogger(BackupPolicyDAOImpl.class);
    private static final String SQLEXCEPTON_WHILE_INSERTING_BACKUP_POLICYDETAILS = "SQLEXCEPTON_WHILE_INSERTING_BACKUP_POLICYDETAILS";
    private static final String SQLEXCEPTON_WHILE_READING_FROM_SCHEDULES_TABLE = "sql exception while reading from schedules table";
    private static final String ALTER_TABLE_BACKUP_POLICY_ADDCOLUMN = "ALTER table BACKUP_POLICY ADD COLUMN ";
    private static final String SQLEXCEPTON_WHILE_CLOSING_RESULTSET = "sql exception while closing result set";
    private static final String SQLEXCEPTON_WHILE_CREATING_BACKUP_POLICYTABLE = "sql exception creating backup policy table";
    private static final String VALUES = ") values(?);";
    private static final String VALUES_TWO_INPUTS = ") values(?,?);";
    private static final String WHERE = " WHERE ";

    public BackupPolicyDAOImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createBackupPolicyTable() {
        String query = BluSyncSQLConstants.CREATE_BACKUP_POLICY_FOLDER_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTON_WHILE_CREATING_BACKUP_POLICYTABLE, (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createDeviceBackupLicenseTable() {
        String query = BluSyncSQLConstants.CREATE_BACKUP_POLICY_LICENSE_ELEMENT_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("sqlexception creating backup policy license table", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNetworkThrottlingTable() {
        String query = BluSyncSQLConstants.CREATE_NETWORK_THROTTLING_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("sql exception creating backup network throttling table", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSchedulesTable() {
        String query = BluSyncSQLConstants.CREATE_SCHEDULES_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("sql exception while creating backup schedules table", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createInclusionsTable() {
        String query = BluSyncSQLConstants.CREATE_INCLUSIONS_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("sql exception while creating backup inclusions table", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createPrivacyGatewayTable() {
        String query = BluSyncSQLConstants.CREATE_PRIVACY_GATEWAY_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("sql exception while creating backup privacy gateway table", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    public boolean clearTable() {
        this.logger.debug("deleted table");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertBackupPolicyDetailsToTable(BackupPolicyTO backupPolicy) {
        String query = "insert into BACKUP_POLICY(policyGroupName,destination,maxVersions,osType,maxFileSize,PFTenabled,PFTsize,cpuutil,refreshinterval,lastModifiedTime,statisticsrefreshinterval,isStatisticsCollectorEnabled,crawlLimit,legalholdenabled,backupsystemfiles,chunkSize,vssenabled,compressionEnabled,memoryutil,nwThrottleSpeed,pgSelectionAlgorithm,skipHiddenfile,threadPriorityCputhrottle,domainCheckEnabled,domainNames,MaxFileSizeinMBBkpbatch,ClientDedup,SqlBackupEnabled,PreScanCommand,PreBackupCommand,PostBackupCommand,continueOnPreScan,continueOnPreBackup,continueOnPostBackup,PreScanCommandEnabled,PreBackupCommandEnabled,PostBackupCommandEnabled) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
        boolean success = false;
        this.statement = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into BACKUP_POLICY(policyGroupName,destination,maxVersions,osType,maxFileSize,PFTenabled,PFTsize,cpuutil,refreshinterval,lastModifiedTime,statisticsrefreshinterval,isStatisticsCollectorEnabled,crawlLimit,legalholdenabled,backupsystemfiles,chunkSize,vssenabled,compressionEnabled,memoryutil,nwThrottleSpeed,pgSelectionAlgorithm,skipHiddenfile,threadPriorityCputhrottle,domainCheckEnabled,domainNames,MaxFileSizeinMBBkpbatch,ClientDedup,SqlBackupEnabled,PreScanCommand,PreBackupCommand,PostBackupCommand,continueOnPreScan,continueOnPreBackup,continueOnPostBackup,PreScanCommandEnabled,PreBackupCommandEnabled,PostBackupCommandEnabled) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);");
                this.statement.setString(1, backupPolicy.getPolicyGroupName());
                this.statement.setString(2, "azure");
                this.statement.setInt(3, backupPolicy.getMaxVersions());
                this.statement.setString(4, backupPolicy.getOsType());
                this.statement.setLong(5, backupPolicy.getMaxFileSize());
                this.statement.setString(6, backupPolicy.getPftEnabled());
                this.statement.setLong(7, backupPolicy.getPftSize());
                this.statement.setInt(8, backupPolicy.getCpuUtilization());
                this.statement.setInt(9, backupPolicy.getPolicyRefreshInterval());
                this.statement.setString(10, backupPolicy.getLastModifiedTime());
                this.statement.setInt(11, backupPolicy.getStatisticsRefreshInterval());
                this.statement.setString(12, backupPolicy.getIsStatisticsCollectorEnabled());
                this.statement.setString(13, backupPolicy.getCrawlLimit());
                this.statement.setString(14, backupPolicy.getLegalHoldEnabled());
                this.statement.setString(15, backupPolicy.getBackupSystemFilesEnabled());
                this.statement.setInt(16, backupPolicy.getChunkSize());
                this.statement.setString(17, backupPolicy.getVssEnabled());
                this.statement.setString(18, String.valueOf(backupPolicy.isCompressionEnabled()));
                this.statement.setInt(19, backupPolicy.getMemoryUtilization());
                this.statement.setString(20, String.valueOf(backupPolicy.getNetworkThrottleSpeed()));
                this.statement.setString(21, String.valueOf(backupPolicy.getBlukryptSelectionAlgorithm()));
                this.statement.setString(22, String.valueOf(backupPolicy.isSkipHiddenFile()));
                this.statement.setInt(23, backupPolicy.getThreadPriorityForcpuThrottle());
                this.statement.setString(24, String.valueOf(backupPolicy.isDoaminCheckEnabled()));
                this.statement.setString(25, backupPolicy.getAllowedDomains());
                this.statement.setInt(26, backupPolicy.getMaxFileSizeinMBBkpbatch());
                this.statement.setString(27, String.valueOf(backupPolicy.isClientDedupEnabled()));
                this.statement.setString(28, String.valueOf(backupPolicy.isSqlBackupEnabled()));
                this.statement.setString(29, backupPolicy.getPreScanCommand());
                this.statement.setString(30, backupPolicy.getPreBackupCommand());
                this.statement.setString(31, backupPolicy.getPostBackupCommand());
                this.statement.setString(32, String.valueOf(backupPolicy.isContinueOnPreScan()));
                this.statement.setString(33, String.valueOf(backupPolicy.isContinueOnPreBkp()));
                this.statement.setString(34, String.valueOf(backupPolicy.isContinueOnPostBkp()));
                this.statement.setString(35, String.valueOf(backupPolicy.isPreScanCommandEnabled()));
                this.statement.setString(36, String.valueOf(backupPolicy.isPreBackupCommandEnabled()));
                this.statement.setString(37, String.valueOf(backupPolicy.isPostBackupCommandEnabled()));
                this.statement.execute();
                this.closeConnection();
                ParabluStringUtils.createCommaSeparatedStringForPolicyTO((StringBuilder)stringBuilder, (BackupPolicyTO)backupPolicy);
                this.setTableId(stringBuilder, "BACKUP_POLICY");
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTON_WHILE_INSERTING_BACKUP_POLICYDETAILS, (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setTableId(StringBuilder stringBuilder, String tableName) throws SQLException {
        boolean success;
        block9: {
            String stringToEncrypt = SettingHelper.getDeviceUUId() + "," + stringBuilder.toString();
            String shaValue = MD5Generator.getSHA1hash((String)stringToEncrypt);
            this.logger.debug("String of hash to create:" + stringToEncrypt + "\nsha value:" + shaValue);
            success = false;
            try {
                String query = "insert or replace into TableIDs(TableName,tableId) values(?,?);";
                this.statement = null;
                if (!this.getConnection()) break block9;
                try {
                    this.statement = this.conn.prepareStatement("insert or replace into TableIDs(TableName,tableId) values(?,?);");
                    this.statement.setString(1, tableName);
                    this.statement.setString(2, shaValue);
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.error("SQLException while Detaching Image Table", (Throwable)e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            catch (Exception e) {
                this.logger.error("Error in getting the  connection ", (Throwable)e);
            }
        }
        return success;
    }

    public boolean insertDeviceBackupLicenseToTable(BackupPolicyTO completeBackupPolicyElement) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ScheduleTO> getSchedules() {
        String query = " select * from SCHEDULES";
        ResultSet selectImageTableResult = null;
        ArrayList<ScheduleTO> scheduleTOList = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(" select * from SCHEDULES");
                selectImageTableResult = this.statement.executeQuery();
                scheduleTOList = new ArrayList<ScheduleTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    ScheduleTO tempFile = new ScheduleTO();
                    tempFile.setScheduleName(selectImageTableResult.getString("scheduleName"));
                    tempFile.setStartTime(selectImageTableResult.getString("startTime"));
                    tempFile.setDayArray(selectImageTableResult.getString("dayArray"));
                    tempFile.setBackupType(selectImageTableResult.getString("backupType"));
                    tempFile.setContainerName(selectImageTableResult.getString("containerName"));
                    scheduleTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error(SQLEXCEPTON_WHILE_READING_FROM_SCHEDULES_TABLE, (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTON_WHILE_CLOSING_RESULTSET + e);
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Runtime Exception...", (Object)e.getMessage());
                    }
                }
                this.closeConnection();
            }
        }
        return scheduleTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupPolicyTO> getBackupPolicyDetails() {
        String query = " select * from BACKUP_POLICY";
        ResultSet selectImageTableResult = null;
        BackupPolicyDAOImpl backupPolicyDAOImpl = this;
        synchronized (backupPolicyDAOImpl) {
            ArrayList<BackupPolicyTO> backupPolicyTOList = null;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement(" select * from BACKUP_POLICY");
                    selectImageTableResult = this.statement.executeQuery();
                    backupPolicyTOList = new ArrayList<BackupPolicyTO>();
                    while (selectImageTableResult != null && selectImageTableResult.next()) {
                        BackupPolicyTO tempFile = new BackupPolicyTO();
                        tempFile.setPolicyGroupName(selectImageTableResult.getString("policyGroupName"));
                        tempFile.setLastModifiedTime(selectImageTableResult.getString("lastModifiedTime"));
                        tempFile.setMaxFileSize(selectImageTableResult.getInt("maxFileSize"));
                        tempFile.setPftEnabled(selectImageTableResult.getString("PFTenabled"));
                        tempFile.setPftSize(selectImageTableResult.getInt("PFTsize"));
                        tempFile.setCpuUtilization(selectImageTableResult.getInt("cpuutil"));
                        tempFile.setPolicyRefreshInterval(selectImageTableResult.getInt("refreshinterval"));
                        tempFile.setStatisticsRefreshInterval(selectImageTableResult.getInt("statisticsrefreshinterval"));
                        tempFile.setMaxVersions(selectImageTableResult.getInt("maxVersions"));
                        tempFile.setIsStatisticsCollectorEnabled(selectImageTableResult.getString("isStatisticsCollectorEnabled"));
                        tempFile.setCrawlLimit(selectImageTableResult.getString("crawlLimit"));
                        tempFile.setLegalHoldEnabled(selectImageTableResult.getString("legalholdenabled"));
                        tempFile.setVssEnabled(selectImageTableResult.getString("vssenabled"));
                        tempFile.setBackupSystemFilesEnabled(selectImageTableResult.getString("backupsystemfiles"));
                        tempFile.setChunkSize(selectImageTableResult.getInt("chunkSize"));
                        tempFile.setCompressionEnabled(Boolean.valueOf(selectImageTableResult.getString("compressionEnabled")).booleanValue());
                        tempFile.setMemoryUtilization(selectImageTableResult.getInt("memoryutil"));
                        tempFile.setNetworkThrottleSpeed(selectImageTableResult.getFloat("nwThrottleSpeed"));
                        tempFile.setBlukryptSelectionAlgorithm(selectImageTableResult.getString("pgSelectionAlgorithm"));
                        tempFile.setOsType(selectImageTableResult.getString("osType"));
                        tempFile.setSkipHiddenFile(Boolean.valueOf(selectImageTableResult.getString("skipHiddenfile")).booleanValue());
                        tempFile.setDoaminCheckEnabled(Boolean.valueOf(selectImageTableResult.getString("domainCheckEnabled") != null ? selectImageTableResult.getString("domainCheckEnabled") : "false").booleanValue());
                        tempFile.setAllowedDomains(selectImageTableResult.getString("domainNames"));
                        tempFile.setMaxFileSizeinMBBkpbatch(selectImageTableResult.getInt("MaxFileSizeinMBBkpbatch"));
                        tempFile.setClientDedupEnabled(Boolean.valueOf(selectImageTableResult.getString("ClientDedup")).booleanValue());
                        tempFile.setSqlBackupEnabled(Boolean.valueOf(selectImageTableResult.getString("SqlBackupEnabled")).booleanValue());
                        tempFile.setPreScanCommand(selectImageTableResult.getString("PreScanCommand"));
                        tempFile.setPreBackupCommand(selectImageTableResult.getString("PreBackupCommand"));
                        tempFile.setPostBackupCommand(selectImageTableResult.getString("PostBackupCommand"));
                        tempFile.setContinueOnPreScan(Boolean.valueOf(selectImageTableResult.getString("continueOnPreScan")).booleanValue());
                        tempFile.setContinueOnPreBkp(Boolean.valueOf(selectImageTableResult.getString("continueOnPreBackup")).booleanValue());
                        tempFile.setContinueOnPostBkp(Boolean.valueOf(selectImageTableResult.getString("continueOnPostBackup")).booleanValue());
                        tempFile.setPreScanCommandEnabled(Boolean.valueOf(selectImageTableResult.getString("PreScanCommandEnabled")).booleanValue());
                        tempFile.setPreBackupCommandEnabled(Boolean.valueOf(selectImageTableResult.getString("PreBackupCommandEnabled")).booleanValue());
                        tempFile.setPostBackupCommandEnabled(Boolean.valueOf(selectImageTableResult.getString("PostBackupCommandEnabled")).booleanValue());
                        backupPolicyTOList.add(tempFile);
                    }
                    this.statement.close();
                }
                catch (SQLException e) {
                    this.logger.error("sqlexception while reading from ploicy table", (Throwable)e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (selectImageTableResult != null) {
                        try {
                            selectImageTableResult.close();
                        }
                        catch (SQLException e) {
                            this.logger.error(SQLEXCEPTON_WHILE_CLOSING_RESULTSET + e);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return backupPolicyTOList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroupPolicyAndChildDetails() {
        this.statement = null;
        String schedulesDeleteStatement = "delete from SCHEDULES;";
        String throttlingDeleteStatement = "delete from NETWORKTHROTTLING;";
        String backupPolicyStatement = "delete from BACKUP_POLICY;";
        String backupFolderStatement = "delete from BKFT WHERE createdBy='IA';";
        String inclusionsDeleteStatement = "delete from INCLUSIONS;";
        StringBuffer gatewayDeleteStatement = new StringBuffer().append("delete from ").append("GATEWAYLIST").append(WHERE).append("ProductType").append(" =?;");
        String excludedFoldersDeleteStatement = "delete from policyExcludedFolders;";
        StringBuffer ebmsTableDeleteStatement = new StringBuffer().append("delete from ").append("EBMS").append(WHERE).append("ProductType").append(" =?;");
        String scriptsTableDeleteStatement = "delete from SCRIPTS;";
        String ProductType = "BACKUP";
        String exceptionsToExclusionDeleteStatement = "delete from exceptionsToExclusions;";
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(schedulesDeleteStatement);
                this.statement.executeUpdate();
                this.statement.close();
                this.statement = this.conn.prepareStatement(throttlingDeleteStatement);
                this.statement.executeUpdate();
                this.statement.close();
                this.statement = this.conn.prepareStatement(backupPolicyStatement);
                this.statement.executeUpdate();
                this.statement.close();
                this.statement = this.conn.prepareStatement(backupFolderStatement);
                this.statement.executeUpdate();
                this.statement.close();
                this.statement = this.conn.prepareStatement(inclusionsDeleteStatement);
                this.statement.executeUpdate();
                this.statement.close();
                this.statement = this.conn.prepareStatement(gatewayDeleteStatement.toString());
                this.statement.setString(1, ProductType);
                this.statement.executeUpdate();
                this.statement.close();
                this.statement = this.conn.prepareStatement(excludedFoldersDeleteStatement);
                this.statement.executeUpdate();
                this.statement.close();
                this.statement = this.conn.prepareStatement(ebmsTableDeleteStatement.toString());
                this.statement.setString(1, ProductType);
                this.statement.executeUpdate();
                this.statement.close();
                this.statement = this.conn.prepareStatement(scriptsTableDeleteStatement);
                this.statement.executeUpdate();
                this.statement.close();
                this.statement = this.conn.prepareStatement(exceptionsToExclusionDeleteStatement);
                this.statement.executeUpdate();
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("sql exception while trying to deleting group policy and child elements:" + e.getMessage());
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GatewayTO> getGatewayList(String policyName) {
        String query = !StringUtils.isEmpty((String)policyName) ? " select * from GATEWAYLIST WHERE policyGroupName LIKE '" + policyName + "'" : " select * from GATEWAYLIST";
        ResultSet selectImageTableResult = null;
        ArrayList<GatewayTO> gatewayTOs = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(query);
                selectImageTableResult = this.statement.executeQuery();
                gatewayTOs = new ArrayList<GatewayTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    GatewayTO gatewayTO = new GatewayTO();
                    gatewayTO.setGatewayName(selectImageTableResult.getString("GatewayName"));
                    gatewayTO.setType(selectImageTableResult.getString("Type"));
                    gatewayTOs.add(gatewayTO);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("sql exception reading From privacy gateway Table", (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTON_WHILE_CLOSING_RESULTSET + e);
                    }
                }
                this.closeConnection();
            }
        }
        return gatewayTOs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createBackupPolicyDefaultFoldersTable() {
        String query = BluSyncSQLConstants.CREATE_BACKUP_POLICY_DEFAULT_FOLDER_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("sqlexception while creating default backup folders", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertBackupPolicyFoldersToTable(String folderName) {
        String query = "insert into BP_DEFAULTFOLDERS(DefaultFolders) values(?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into BP_DEFAULTFOLDERS(DefaultFolders) values(?);");
                this.statement.setString(1, folderName);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTON_WHILE_INSERTING_BACKUP_POLICYDETAILS, (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        this.logger.debug("boolean after inserting backup policy folders table" + success);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDefaultFoldersList() {
        String query = " select * from BP_DEFAULTFOLDERS";
        ResultSet selectImageTableResult = null;
        ArrayList<String> folderNames = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(" select * from BP_DEFAULTFOLDERS");
                selectImageTableResult = this.statement.executeQuery();
                folderNames = new ArrayList<String>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    folderNames.add(selectImageTableResult.getString("DefaultFolders"));
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("sql exception reading All Entries From Default Folder Table", (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTON_WHILE_CLOSING_RESULTSET + e);
                    }
                }
                this.closeConnection();
            }
        }
        return folderNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDefaultFoldersTable() {
        this.statement = null;
        String defaultFoldersDeleteStatement = "delete from BP_DEFAULTFOLDERS;";
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(defaultFoldersDeleteStatement);
                this.statement.executeUpdate();
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("sql exeception trying to deleting group policy and child element ", (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alterTable() {
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.alterGatewaylistTable(this.conn);
                this.alterBackupPolicyTable(this.conn);
                this.alterInclusionsTable(this.conn);
                this.alterSchedulesTable(this.conn);
                this.alterEbmsTable(this.conn);
                success = true;
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("sqlExeception in CREATE_ACTIVITY_TABLE" + e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createPolicyExcludedFolderTable() {
        String query = BluSyncSQLConstants.CREATE_BKUP_POLICY_EXCLUDED_FOLDER_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("sql exception creating backup polocy excluded folders", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertPolicyExcludedFoldersToTable(List<String> folderNames) {
        String query = "insert into policyExcludedFolders(FolderPath) values(?);";
        boolean success = false;
        this.statement = null;
        StringBuilder strBuilder = new StringBuilder();
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into policyExcludedFolders(FolderPath) values(?);");
                int listsize = folderNames.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, folderNames.get(recordCount));
                    this.logger.debug("excluded folder path...." + folderNames.get(recordCount));
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.logger.debug("Inside recordCount reach 1000...");
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                this.closeConnection();
                ParabluStringUtils.createCommaSeparatedStringForStringList((StringBuilder)strBuilder, folderNames);
                this.setTableId(strBuilder, "policyExcludedFolders");
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTON_WHILE_INSERTING_BACKUP_POLICYDETAILS, (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getExcludedFoldersList() {
        String query = " select * from policyExcludedFolders";
        ResultSet selectImageTableResult = null;
        ArrayList<String> folderPaths = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(" select * from policyExcludedFolders");
                selectImageTableResult = this.statement.executeQuery();
                folderPaths = new ArrayList<String>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    folderPaths.add(selectImageTableResult.getString("FolderPath"));
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("sql exception reading All Entries From Excluded Table", (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTON_WHILE_CLOSING_RESULTSET + e);
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Runtime Exception...", (Object)e.getMessage());
                    }
                }
                this.closeConnection();
            }
        }
        return folderPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createEBMSTable() {
        String query = BluSyncSQLConstants.CREATE_EBMS_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("sqlexception creating ebms table", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertBluVaultNamesToTable(List<BluVaultTO> ebmstoList) {
        String query = "insert into EBMS(ebmsname,ProductType) values(?,?);";
        boolean success = false;
        this.statement = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into EBMS(ebmsname,ProductType) values(?,?);");
                int listsize = ebmstoList.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, ebmstoList.get(recordCount).getBluVaultName());
                    this.statement.setString(2, ebmstoList.get(recordCount).getProductType());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                this.closeConnection();
                ParabluStringUtils.createCommaSeparatedStringForBluVaultList((StringBuilder)stringBuilder, ebmstoList);
                this.setTableId(stringBuilder, "EBMS");
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("sql exception inserting ebms name details", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BluVaultTO> getBluVaultList() {
        String query = " select * from EBMS";
        ResultSet selectImageTableResult = null;
        ArrayList<BluVaultTO> ebmsNames = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(" select * from EBMS");
                selectImageTableResult = this.statement.executeQuery();
                ebmsNames = new ArrayList<BluVaultTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    BluVaultTO ebmsto = new BluVaultTO();
                    ebmsto.setBluVaultName(selectImageTableResult.getString("ebmsname"));
                    ebmsNames.add(ebmsto);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("sql exception reading All Entries From Bluvault Table" + e.getMessage());
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTON_WHILE_CLOSING_RESULTSET + e);
                    }
                }
                this.closeConnection();
            }
        }
        return ebmsNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullBackupSchedules() {
        String query = " select * from SCRIPTSCHEDULE";
        ResultSet selectImageTableResult = null;
        String fullBackupSchedule = "";
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(" select * from SCRIPTSCHEDULE");
                selectImageTableResult = this.statement.executeQuery();
                this.logger.debug("result set " + selectImageTableResult);
                if (selectImageTableResult != null && selectImageTableResult.next()) {
                    fullBackupSchedule = selectImageTableResult.getString("schedules");
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error(SQLEXCEPTON_WHILE_READING_FROM_SCHEDULES_TABLE, (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTON_WHILE_CLOSING_RESULTSET + e);
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Runtime Exception...", (Object)e.getMessage());
                    }
                }
                this.closeConnection();
            }
        }
        return fullBackupSchedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFullBackupTimestamp(String timestamp, String containerName) {
        String query = "UPDATE CONTAINERS SET timestamp ='" + timestamp + "' WHERE " + "containerName" + "='" + containerName + "';";
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("sqlexception  while updating script table", (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ScheduleTO> getSchedulesAccordingToType(String type) {
        String query = " select * from SCHEDULES WHERE backupType='" + type + "'";
        ResultSet selectImageTableResult = null;
        ArrayList<ScheduleTO> scheduleTOList = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.logger.debug("query for tyoe schedule : " + query);
                this.statement = this.conn.prepareStatement(query);
                selectImageTableResult = this.statement.executeQuery();
                scheduleTOList = new ArrayList<ScheduleTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    ScheduleTO tempFile = new ScheduleTO();
                    tempFile.setScheduleName(selectImageTableResult.getString("scheduleName"));
                    tempFile.setStartTime(selectImageTableResult.getString("startTime"));
                    tempFile.setDayArray(selectImageTableResult.getString("dayArray"));
                    tempFile.setBackupType(selectImageTableResult.getString("backupType"));
                    scheduleTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error(SQLEXCEPTON_WHILE_READING_FROM_SCHEDULES_TABLE, (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTON_WHILE_CLOSING_RESULTSET + e);
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Runtime Exception...", (Object)e.getMessage());
                    }
                }
                this.closeConnection();
            }
        }
        return scheduleTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVssEnabled() {
        String query = "select vssenabled from BACKUP_POLICY;";
        String vssEnabled = null;
        ResultSet vssEnabledResult = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("select vssenabled from BACKUP_POLICY;");
                vssEnabledResult = this.statement.executeQuery();
                while (vssEnabledResult != null && vssEnabledResult.next()) {
                    vssEnabled = vssEnabledResult.getString("vssenabled");
                    this.logger.debug(" vssEnabledd from db " + vssEnabled);
                }
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error(SQLEXCEPTON_WHILE_READING_FROM_SCHEDULES_TABLE + e.getMessage());
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                if (vssEnabledResult != null) {
                    try {
                        vssEnabledResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTON_WHILE_CLOSING_RESULTSET + e);
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Runtime Exception...", (Object)e.getMessage());
                    }
                }
                this.closeConnection();
            }
        }
        return vssEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean creatContainerTable() {
        String query = BluSyncSQLConstants.CREATE_CONTAINER_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTON_WHILE_CREATING_BACKUP_POLICYTABLE, (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertContainerDetailsToTable(ContainerDetailsTo containerDetailsTo) {
        String query = "insert into CONTAINERS(policyGroupName,containerLocation,containerName,containerType,groupName,containerPassword,containerPort,userName) values(?,?,?,?,?,?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into CONTAINERS(policyGroupName,containerLocation,containerName,containerType,groupName,containerPassword,containerPort,userName) values(?,?,?,?,?,?,?,?);");
                this.statement.setString(1, containerDetailsTo.getPolicyname());
                this.statement.setString(2, containerDetailsTo.getContainerLocation());
                this.statement.setString(3, containerDetailsTo.getContainerName());
                this.statement.setString(4, containerDetailsTo.getContainerType());
                this.statement.setString(5, containerDetailsTo.getGroupName());
                this.statement.setString(6, containerDetailsTo.getContainerPassword());
                this.statement.setString(7, containerDetailsTo.getContainerPort());
                this.statement.setString(8, containerDetailsTo.getContainerUserName());
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("Error while inserting backup container  details " + exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContainerDetailsTo> getCurrentContainerDetails(String key, boolean isContainer) {
        String query = isContainer ? " select * from CONTAINERS WHERE containerName=='" + key + "'" : " select * from CONTAINERS WHERE policyGroupName=='" + key + "'";
        ResultSet selectImageTableResult = null;
        ArrayList<ContainerDetailsTo> containerDetailsToList = null;
        ContainerDetailsTo containerDetailsTo = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(query);
                selectImageTableResult = this.statement.executeQuery();
                containerDetailsToList = new ArrayList<ContainerDetailsTo>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    containerDetailsTo = new ContainerDetailsTo();
                    containerDetailsTo.setPolicyname(selectImageTableResult.getString("policyGroupName"));
                    containerDetailsTo.setContainerLocation(selectImageTableResult.getString("containerLocation"));
                    containerDetailsTo.setContainerName(selectImageTableResult.getString("containerName"));
                    containerDetailsTo.setContainerType(selectImageTableResult.getString("containerType"));
                    containerDetailsTo.setGroupName(selectImageTableResult.getString("groupName"));
                    containerDetailsTo.setContainerUserName(selectImageTableResult.getString("userName"));
                    containerDetailsTo.setContainerPassword(selectImageTableResult.getString("containerPassword"));
                    containerDetailsTo.setContainerPort(selectImageTableResult.getString("containerPort"));
                    containerDetailsTo.setPrevTimesamp(selectImageTableResult.getString("timestamp"));
                    containerDetailsToList.add(containerDetailsTo);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error(SQLEXCEPTON_WHILE_READING_FROM_SCHEDULES_TABLE, (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTON_WHILE_CLOSING_RESULTSET + e);
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Runtime Exception...", (Object)e.getMessage());
                    }
                }
                this.closeConnection();
            }
        }
        return containerDetailsToList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContainerDetails() {
        this.statement = null;
        String containerTableDeleteStatement = "delete from CONTAINERS;";
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(containerTableDeleteStatement);
                this.statement.executeUpdate();
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("sql exception while trying to deleting group policy and child elements ", (Object)e.getMessage());
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
    }

    private void alterGatewaylistTable(Connection conn) throws Exception {
        try {
            this.statement = conn.prepareStatement("ALTER table GATEWAYLIST ADD COLUMN Type TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table GATEWAYLIST ADD COLUMN" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table GATEWAYLIST ADD COLUMN policyGroupName TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table GATEWAYLIST ADD COLUMN" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table GATEWAYLIST ADD COLUMN ProductType TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table GATEWAYLIST ADD COLUMN" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
    }

    private void alterBackupPolicyTable(Connection conn) throws Exception {
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN legalholdenabled TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN vssenabled TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_BACKUP_VSS_ENABLED" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN backupsystemfiles TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_BACKUP_SYSTEMFILES_ENABLED" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN chunkSize INTEGER;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_FILE_CHUNK_SIZE" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN crawlLimit TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_BACKUP_CRAWL_LIMIT" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN compressionEnabled TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_BACKUP_CRAWL_LIMIT" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN memoryutil TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_MEMORY_UTIL" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN nwThrottleSpeed TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_NETWORK_THROTTLE_SPEED" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN pgSelectionAlgorithm TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_PG_SELECTION_ALGORITHM" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN skipHiddenfile TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_SkIP_HIDDENFILE" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN threadPriorityCputhrottle INTEGER;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_THREAD_PRIORITY_CPU_BACKUP" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN domainCheckEnabled TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_THREAD_PRIORITY_CPU_BACKUP" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN domainNames TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_THREAD_PRIORITY_CPU_BACKUP" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN MaxFileSizeinMBBkpbatch INTEGER;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_MAXFILESIZE_INMBBKPBATCH" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN ClientDedup TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_CLIENT_DEDUP" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN SqlBackupEnabled TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_SQL_BACKUP_ENABLED" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN PreScanCommand TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_PRESCAN_COMMAND" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN PreBackupCommand TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_PREBACKUP_COMMAND" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN continueOnPreScan TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_CONTINUE_ONPRESCAN" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN continueOnPreBackup TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_CONTINUE_ONPREBKP" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN continueOnPostBackup TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_CONTINUE_ONPOSTBKP" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN PostBackupCommand TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_POSTBACKUP_COMMAND" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN PreScanCommandEnabled TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_PRESCAN_ENABLED" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN PreBackupCommandEnabled TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_PREBACKUP_ENABLED" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table BACKUP_POLICY ADD COLUMN PostBackupCommandEnabled TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table BACKUP_POLICY ADD COLUMN COLUMN_POSTBACKUP_ENABLED" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
    }

    private void alterInclusionsTable(Connection conn) throws Exception {
        try {
            this.statement = conn.prepareStatement("ALTER table INCLUSIONS ADD COLUMN policyGroupName TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table TABLE_NAME_INCLUSIONS ADD COLUMN COLUMN_BP_GROUP_NAME" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table INCLUSIONS ADD COLUMN filterType TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table TABLE_NAME_INCLUSIONS ADD COLUMN COLUMN_BP_GROUP_NAME" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
    }

    private void alterSchedulesTable(Connection conn) throws Exception {
        try {
            this.statement = conn.prepareStatement("ALTER table SCHEDULES ADD COLUMN containerName TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table TABLE_NAME_SCHEDULES ADD COLUMN COLUMN_CONTAINER_NAME" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table SCHEDULES ADD COLUMN backupType TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table TABLE_NAME_SCHEDULES ADD COLUMN COLUMN_SCHEDULE_BACKUP_TYPE" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
    }

    private void alterEbmsTable(Connection conn) throws Exception {
        try {
            this.statement = conn.prepareStatement("ALTER table EBMS ADD COLUMN ProductType TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table TABLE_NAME_SCHEDULES ADD COLUMN COLUMN_CONTAINER_NAME" + e.getMessage());
        }
        try {
            this.statement = conn.prepareStatement("ALTER table EBMS ADD COLUMN ebmsname TEXT;");
            this.statement.execute();
            this.statement.close();
        }
        catch (SQLException e) {
            this.logger.trace("" + e);
            this.logger.info("ALTER table TABLE_NAME_EBMS ADD COLUMN COLUMN_EBMS_NAME_PRODUCT_TYPE" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.logger.error("Runtime Exception...", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createPolicyExceptionsTOExclusionTable() {
        String query = BluSyncSQLConstants.CREATE_BKP_POLICY_EXCEPTIONS_TO_EXCLUSION_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("sql exception creating backup polocy excluded folders", (Throwable)exception);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }
}

