/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.service.network;

import com.parablu.epa.core.adapter.JMDNSAdapter;
import com.parablu.epa.core.adapter.api.ApiAdapter;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.helper.utils.MD5Generator;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudIPHelper {
    private static final int GAE_LOCAL_IP_INDEX = 0;
    private static final int GAE_PUBLIC_IP_INDEX = 1;
    private String cloudName = null;
    private Logger logger = LoggerFactory.getLogger(CloudIPHelper.class);
    private String cloudLocalIP = null;
    private String cloudPublicIP = null;
    private String gaeCloudLocalIP = null;
    private String httpPort = null;
    private String httpsPort = null;
    private ApiAdapter gae = null;

    public CloudIPHelper(String cloudName, String keyStore) {
        this.gae = new ApiAdapter(keyStore);
        this.cloudName = cloudName;
    }

    public CloudIPHelper(String cloudName, InputStream inputStream) {
        this.gae = new ApiAdapter(inputStream);
        this.cloudName = cloudName;
    }

    public boolean searchForLocalIpOfCloud() {
        boolean cloudFound = false;
        this.logger.debug("Entered CloudRegistrationService.searchForLocalIpOfCloud");
        this.logger.debug("About to create instance of JMDNSAdapter");
        JMDNSAdapter jc = new JMDNSAdapter();
        this.logger.debug("creating instance of JMDNSAdapter");
        try {
            this.cloudLocalIP = jc.getIpAddress(this.cloudName);
        }
        catch (Exception e) {
            this.logger.error("Exception in CloudRegistrationService :" + e.getMessage());
            this.logger.trace("" + e);
        }
        if (this.cloudLocalIP != null) {
            cloudFound = true;
        }
        this.logger.debug("Found cloud: " + cloudFound);
        this.logger.debug("The local Ip of cloud after jmdns :" + this.cloudLocalIP);
        return cloudFound;
    }

    public boolean searchForPublicIpOfCloud() {
        boolean cloudFound = false;
        this.logger.debug("Starting the public IP Search");
        String cloudNameHash = MD5Generator.generateMD5OfString((String)(this.cloudName + "-:-"));
        if (cloudNameHash == null) {
            return cloudFound;
        }
        String[] ipAddress = new String[3];
        String[] ports = new String[2];
        try {
            this.logger.debug("Making the call to GAE");
            this.gae.getCloudIPFromAmazon(this.cloudName, ipAddress, ports);
            this.cloudPublicIP = ipAddress[1];
            this.gaeCloudLocalIP = ipAddress[0];
            this.httpPort = ports[0];
            this.httpsPort = ports[1];
        }
        catch (CrawlAdapterException e) {
            this.logger.error("CrawlAdapterException in CloudRegistrationService :" + e.getMessage());
            this.logger.trace("" + (Object)((Object)e));
        }
        catch (Exception e) {
            this.logger.error("Exception in CloudRegistrationService :" + e.getMessage());
            this.logger.trace("" + e);
        }
        if (this.cloudPublicIP != null && !StringUtils.isEmpty((String)this.cloudPublicIP) || this.gaeCloudLocalIP != null && !StringUtils.isEmpty((String)this.gaeCloudLocalIP)) {
            cloudFound = true;
        }
        this.logger.debug("Found cloud: " + cloudFound);
        this.logger.debug("The local Ip of cloud after Gae request :" + this.cloudLocalIP);
        this.logger.debug("The public Ip of cloud after Gae request :" + this.cloudPublicIP);
        this.logger.debug("The gae Local Ip of cloud after Gae request :" + this.gaeCloudLocalIP);
        return cloudFound;
    }

    public String getCloudLocalIP() {
        return this.cloudLocalIP;
    }

    public String getCloudPublicIP() {
        return this.cloudPublicIP;
    }

    public String getGaeCloudLocalIP() {
        return this.gaeCloudLocalIP;
    }

    public void setCloudLocalIP(String cloudLocalIP) {
        this.cloudLocalIP = cloudLocalIP;
    }

    public void setCloudPublicIP(String cloudPublicIP) {
        this.cloudPublicIP = cloudPublicIP;
    }

    public void setGaeCloudLocalIP(String gaeCloudLocalIP) {
        this.gaeCloudLocalIP = gaeCloudLocalIP;
    }

    public String getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(String httpPort) {
        this.httpPort = httpPort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(String httpsPort) {
        this.httpsPort = httpsPort;
    }
}

