/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.bp.service.OfficeBackupPolicyService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.OfficeBackupPolicyElement;
import com.parablu.paracloud.element.PolicyResponse;
import com.parablu.paracloud.element.UserElement;
import com.parablu.paracloud.element.bp.EditUserBackupPolicyMappingElement;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class OfficeBackupPolicyController
extends BaseController {
    private static Logger logger = LogManager.getLogger(OfficeBackupPolicyController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private OfficeBackupPolicyService odbBackupPolicyService;
    @Autowired
    private UserManagementService userManagementService;
    private static final String ERROR_FAILED_TO_LOAD_BACKUPPOLICY = "Error failed to load BackupPolicy ...";

    @RequestMapping(value={"cloud/{cloudName}/odbPolicy/save"}, method={RequestMethod.POST})
    public void saveOdbBackupPolicy(@PathVariable(value="cloudName") String cloudName1, @RequestBody OfficeBackupPolicyElement backupPolicyElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(backupPolicyElement.getPolicyType() + " calling cloud/{cloudName}/odbPolicy/save ..filtertype..." + backupPolicyElement.getFilterType());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            String policyType = request.getHeader("policyType");
            logger.debug(backupPolicyElement.isCanAdminRestore() + "*******&&isCanAdminRestore*****" + policyType);
            logger.debug(backupPolicyElement.getOutlookFilters() + "*******&outlookfilter&*****" + backupPolicyElement.getMsAppBluKrypt());
            logger.debug("authorization token for user......" + authorizationTokens.getUser().getUserName());
            OfficeBackupPolicyElement bkpPolicyElement = this.odbBackupPolicyService.getBackupPolicy(cloudId, cloudName, backupPolicyElement.getPolicygroupName(), policyType);
            if (bkpPolicyElement != null && bkpPolicyElement.isBlocked()) {
                logger.debug("Backup policy blocked----" + bkpPolicyElement.isBlocked());
                response.setStatus(331);
                return;
            }
            this.odbBackupPolicyService.saveBackupPolicy(cloudId, cloudName, backupPolicyElement, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug("Error failed to save Schedule ..." + (Object)((Object)e));
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling cloud/{cloudName}/odbPolicy/save...");
    }

    @RequestMapping(value={"cloud/{cloudName}/odbPolicy/save"}, method={RequestMethod.PUT})
    public void createBackupPolicy(@PathVariable(value="cloudName") String cloudName1, @RequestBody OfficeBackupPolicyElement backupPolicyElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(backupPolicyElement.getPolicygroupName() + " calling save odbPolicy ..." + backupPolicyElement.getPolicyType());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug("....license check failed... ");
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                logger.debug(".... token check failed... ");
                return;
            }
            String policyType = request.getHeader("policyType");
            if (StringUtils.isEmpty((String)policyType)) {
                policyType = backupPolicyElement.getPolicyType();
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            logger.debug(policyType + ".... authorizationTokens check outlookfilter... " + backupPolicyElement.getOutlookFilters());
            OfficeBackupPolicyElement bkpPolicyElement = this.odbBackupPolicyService.getBackupPolicy(cloudId, cloudName, backupPolicyElement.getPolicygroupName(), policyType);
            if (bkpPolicyElement != null) {
                logger.debug("Backup policy Already exists----");
                response.setStatus(406);
                return;
            }
            this.odbBackupPolicyService.saveBackupPolicy(cloudId, cloudName, backupPolicyElement, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.debug("Error failed to save Schedule ..." + e);
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling /odbPolicy ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/odbPolicy/load/{policyName}/"}, method={RequestMethod.GET})
    public ModelAndView getBackupPolicys(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="policyName") String policyName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load BackupPolicy ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            String policyType = request.getHeader("policyType");
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return null;
            }
            OfficeBackupPolicyElement backupPolicyElement = this.odbBackupPolicyService.getBackupPolicy(cloudId, cloudName, policyName, policyType);
            if (backupPolicyElement == null) {
                response.setStatus(400);
                return null;
            }
            logger.debug("loading BackupPolicy ..." + backupPolicyElement.isCanAdminRestore());
            modelAndView.addObject((Object)backupPolicyElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of loading BackupPolicy ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/odbPolicy/load/all"}, method={RequestMethod.GET})
    public ModelAndView getAllBackupPolicy(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load all odbPolicy ..." + request.getHeader("userEditProfile"));
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            User currentUser;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), currentUser = new User(), response)) {
                return null;
            }
            boolean userEditProfile = false;
            String userEditProfileStr = request.getHeader("userEditProfile");
            String policyType = request.getHeader("policyType");
            if (!StringUtils.isEmpty((String)userEditProfileStr)) {
                userEditProfile = Boolean.parseBoolean(userEditProfileStr);
            }
            boolean validAdmin = false;
            if (currentUser != null && (currentUser.isReadOnlyAdmin() || currentUser.isAdmin() || userEditProfile)) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + currentUser.getUserName());
                response.setStatus(500);
                return null;
            }
            List<Object> backupPolicyElements = this.odbBackupPolicyService.loadAllOfficePoliciesBasedOnType(cloudId, policyType);
            if (backupPolicyElements.isEmpty()) {
                logger.debug("......no policies found ...");
                backupPolicyElements = new ArrayList<OfficeBackupPolicyElement>();
            }
            if (currentUser != null && currentUser.isReadOnlyAdmin() && !CollectionUtils.isEmpty((Collection)currentUser.getOdbPoliciesAdmin())) {
                logger.debug("....readonly admin..." + currentUser.getOdbPoliciesAdmin());
                backupPolicyElements = backupPolicyElements.stream().filter(policy -> Objects.nonNull(policy.getPolicygroupName()) && currentUser.getOdbPoliciesAdmin().contains(policy.getPolicygroupName())).collect(Collectors.toList());
            }
            logger.debug("...... policies found ..." + backupPolicyElements.size());
            modelAndView.addObject(backupPolicyElements);
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace("Error failed to load all backupPolicy  ..." + e);
            logger.error("Error failed to load all backupPolicy  ..." + e.getMessage());
        }
        logger.debug("end of load all odbPolicy ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/odbpolicy/load/userName"}, method={RequestMethod.GET})
    public ModelAndView getBackupPolicyForUser(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load odbpolicy/username ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            OfficeBackupPolicyElement backupPolicyElement;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            User currentUser = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return null;
            }
            String policyType = request.getHeader("policyType");
            UserElement user = this.userManagementService.getUserInfo(cloudId, cloudName, userName);
            if (user != null && !StringUtils.isEmpty((String)user.getOneDrivePolicyName())) {
                backupPolicyElement = this.odbBackupPolicyService.getBackupPolicy(cloudId, cloudName, user.getOneDrivePolicyName(), policyType);
                if (backupPolicyElement == null) {
                    response.setStatus(400);
                    return null;
                }
            } else {
                response.setStatus(400);
                return null;
            }
            modelAndView.addObject((Object)backupPolicyElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of loading odbpolicy/username ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/odbPolicy/loadAllPolicyNames/"}, method={RequestMethod.GET})
    public ModelAndView getAllBackupPolicyNames(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling getAllPolicyNames ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            User currentUser = authorizationTokens.getUser();
            boolean validAdmin = false;
            if (currentUser != null && currentUser.isReadOnlyAdmin() || currentUser.isAdmin()) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + currentUser.getUserName());
                response.setStatus(500);
                return null;
            }
            List<Object> backupPolicyNamesList = new ArrayList();
            backupPolicyNamesList = currentUser.isReadOnlyAdmin() && !CollectionUtils.isEmpty((Collection)currentUser.getBackupPoliciesAdmin()) ? currentUser.getBackupPoliciesAdmin() : this.odbBackupPolicyService.getAllBackupPolicyNames(cloudId, cloudName);
            modelAndView.addObject(backupPolicyNamesList);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of getAllPolicyNames...");
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/officeBackupPolicy/loadAll"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getAllOfficeSyncPolicyWithPagination(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNumber") Integer pageNumberInteger, @RequestParam(value="policyType") String policyType) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/officeBackupPolicy/loadAll ....." + policyType);
        try {
            User user;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return this.toJSON(1202);
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            int pageNumber = 0;
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, user = new User(), response)) {
                return this.toJSON(1201);
            }
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
            int skipValue = 0;
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            PolicyResponse elementResponse = new PolicyResponse();
            Map paramSet = request.getParameterMap();
            ArrayList<String> policyNames = new ArrayList<String>();
            if (user != null && user.isReadOnlyAdmin()) {
                logger.debug("...user is read only admin.....");
                if (!CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin())) {
                    policyNames.addAll(user.getOdbPoliciesAdmin());
                }
            }
            boolean validAdmin = false;
            if (user != null && user.isReadOnlyAdmin() || user.isAdmin()) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + user.getUserName());
                response.setStatus(500);
                return null;
            }
            List<Object> backupPolicyElements = new ArrayList();
            backupPolicyElements = user.isReadOnlyAdmin() ? this.odbBackupPolicyService.getAllOfficePoliciesWithPagination(cloudId, policyNames, skipValue, policyType) : this.odbBackupPolicyService.getAllOfficePoliciesWithPagination(cloudId, skipValue, policyType);
            long totalRecordsCount = this.odbBackupPolicyService.getOfficeBkpPoliciesCount(cloudId, policyNames, policyType);
            if (backupPolicyElements.isEmpty()) {
                logger.debug("......no policies found ...");
                backupPolicyElements = new ArrayList();
            }
            if (user != null && user.isReadOnlyAdmin() && !CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin())) {
                logger.debug("....readonly admin..." + user.getOdbPoliciesAdmin());
                backupPolicyElements = backupPolicyElements.stream().filter(policy -> Objects.nonNull(policy.getPolicygroupName()) && user.getOdbPoliciesAdmin().contains(policy.getPolicygroupName())).collect(Collectors.toList());
            }
            elementResponse.setOfficeBackupPolicyElements(backupPolicyElements);
            return this.toJSON(200, this.getMetadataElement(cloudPropertyElement.getReportRows(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), elementResponse);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load all officeBackupPolicy  ..." + (Object)((Object)e));
            logger.error("Error failed to load all officeBackupPolicy  ..." + e.getMessage());
            return null;
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/load/userOfficeBackupPolicy/users/"}, method={RequestMethod.GET})
    @ResponseBody
    public Object loadAllUsersBackupPolicyMapping(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load load/userOfficeBackupPolicy/users ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            String userNames = request.getHeader("userNames");
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(userNames.split(",")));
            HashSet<String> removeSet = new HashSet<String>();
            removeSet.addAll(list);
            list.clear();
            list.addAll(removeSet);
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            User user = authorizationTokens.getUser();
            EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = this.odbBackupPolicyService.getBackupPolicyElements(cloudId, list, user);
            modelAndView.addObject((Object)editUserBackupPolicyMappingElement);
            response.setStatus(200);
            logger.debug("end of loading load/userOfficeBackupPolicy/users ...");
            return this.toJSON(200, editUserBackupPolicyMappingElement);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.error("..failed during calling ...load/userOfficeBackupPolicy/users.." + e.getMessage());
            return this.toJSON(500);
        }
    }
}

