/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.itextpdf.text.Document;
import com.parablu.bluvault.backup.mem.MemoryStore;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bp.service.BackupPolicyService;
import com.parablu.bp.service.InclusionFilterService;
import com.parablu.bp.service.OfficeBackupPolicyService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BackupPolicyElement;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.PolicyResponse;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.impl.ReportServiceImpl;
import com.parablu.sp.service.SyncPolicyService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BackupPolicyController
extends BaseController {
    private static Logger logger = LogManager.getLogger(BackupPolicyController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private BackupPolicyService backupPolicyService;
    @Autowired
    private SyncPolicyService syncPolicyService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private InclusionFilterService inclusionFilterService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private OfficeBackupPolicyService odbBackupPolicyService;
    @Autowired
    private ReportServiceImpl reportServiceImpl;
    private static final String CRAWL_LIMIT = "crawlLimit";
    private static final String ERROR_FAILED_TO_LOAD_BACKUPPOLICY = "Error failed to load BackupPolicy ...";

    public DeviceManagementService getDeviceManagementService() {
        return this.deviceManagementService;
    }

    public void setDeviceManagementService(DeviceManagementService deviceManagementService) {
        this.deviceManagementService = deviceManagementService;
    }

    @RequestMapping(value={"cloud/{cloudName}/backupPolicy/save"}, method={RequestMethod.POST})
    public void saveBackupPolicy(@PathVariable(value="cloudName") String cloudName1, @RequestBody BackupPolicyElement backupPolicyElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(backupPolicyElement.getCloudCredential() + " calling save Policy ..." + backupPolicyElement.isDcmEnabled());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            logger.debug("************");
            logger.debug("cloudId..........." + cloudId);
            logger.debug("cloudname........" + cloudName);
            logger.debug("backuPolicyElement...maxfilesize....." + backupPolicyElement.getMaxFileSize());
            logger.debug("backuPolicyElement...cloud credentials ....." + backupPolicyElement.getCloudCredential());
            logger.debug("authorization token for user......" + authorizationTokens.getUser().getUserName());
            BackupPolicyElement bkpPolicyElement = this.backupPolicyService.getBackupPolicy(cloudId, cloudName, backupPolicyElement.getPolicygroupName());
            if (bkpPolicyElement != null && bkpPolicyElement.isBlocked()) {
                logger.debug("Backup policy blocked----" + bkpPolicyElement.isBlocked());
                response.setStatus(331);
                return;
            }
            boolean anycheckFailed = this.validateBackupPolicyValues(backupPolicyElement, response, cl);
            if (anycheckFailed) {
                response.setStatus(400);
                return;
            }
            this.backupPolicyService.saveBackupPolicy(cloudId, cloudName, backupPolicyElement, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug("Error failed to save Schedule ..." + (Object)((Object)e));
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling /authenticateOneDrive ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/backupPolicy/save"}, method={RequestMethod.PUT})
    public void createBackupPolicy(@PathVariable(value="cloudName") String cloudName1, @RequestBody BackupPolicyElement backupPolicyElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(backupPolicyElement.getCloudCredential() + " calling save Policy ..." + backupPolicyElement.isDcmEnabled());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            BackupPolicyElement bkpPolicyElement = this.backupPolicyService.getBackupPolicy(cloudId, cloudName, backupPolicyElement.getPolicygroupName());
            if (bkpPolicyElement != null) {
                if (bkpPolicyElement.isBlocked()) {
                    logger.debug("Backup policy Already exists---- and ist blocked....");
                    response.setStatus(331);
                    return;
                }
                logger.debug("Backup policy Already exists----");
                response.setStatus(406);
                return;
            }
            boolean anycheckFailed = this.validateBackupPolicyValues(backupPolicyElement, response, cl);
            if (anycheckFailed) {
                response.setStatus(400);
                return;
            }
            this.backupPolicyService.saveBackupPolicy(cloudId, cloudName, backupPolicyElement, authorizationTokens.getUser().getUserName());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug("Error failed to save Schedule ..." + (Object)((Object)e));
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling /authenticateOneDrive ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/backupPolicy/load/{policyName}/"}, method={RequestMethod.GET})
    public ModelAndView getBackupPolicys(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="policyName") String policyName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load BackupPolicy ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return null;
            }
            BackupPolicyElement backupPolicyElement = this.backupPolicyService.getBackupPolicy(cloudId, cloudName, policyName);
            if (backupPolicyElement == null) {
                response.setStatus(400);
                return null;
            }
            modelAndView.addObject((Object)backupPolicyElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of loading BackupPolicy ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/backupPolicy/load/userName"}, method={RequestMethod.GET})
    public ModelAndView getBackupPolicyForUser(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load backupPolicy ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            BackupPolicyElement backupPolicyElement;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return null;
            }
            User user = this.userDao.getUserByName(cloudId, userName);
            if (user != null && !StringUtils.isEmpty((String)user.getPolicyName())) {
                backupPolicyElement = this.backupPolicyService.getBackupPolicy(cloudId, cloudName, user.getPolicyName());
                if (backupPolicyElement == null) {
                    response.setStatus(400);
                    return null;
                }
            } else {
                response.setStatus(400);
                return null;
            }
            modelAndView.addObject((Object)backupPolicyElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of loading backupPolicy ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/backupPolicy/load/all"}, method={RequestMethod.GET})
    public ModelAndView getAllBackupPolicy(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load all backupPolicy prof..." + request.getHeader("userEditProfile"));
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            String loadOnlyBasic = request.getHeader("loadOnlyBasic");
            User currentUser = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return null;
            }
            List<Object> backupPolicyElements = this.backupPolicyService.loadAllBackupPolicies(cloudId);
            if (backupPolicyElements.isEmpty()) {
                backupPolicyElements = new ArrayList<BackupPolicyElement>();
            }
            if (currentUser != null && currentUser.isReadOnlyAdmin() && !CollectionUtils.isEmpty((Collection)currentUser.getBackupPoliciesAdmin())) {
                logger.debug("....readonly admin..." + currentUser.getBackupPoliciesAdmin());
                backupPolicyElements = backupPolicyElements.stream().filter(policy -> Objects.nonNull(policy.getPolicygroupName()) && currentUser.getBackupPoliciesAdmin().contains(policy.getPolicygroupName())).collect(Collectors.toList());
            }
            boolean userEditProfile = false;
            String userEditProfileStr = request.getHeader("userEditProfile");
            if (!StringUtils.isEmpty((String)userEditProfileStr)) {
                userEditProfile = Boolean.parseBoolean(userEditProfileStr);
            }
            boolean validAdmin = false;
            if (currentUser != null && (currentUser.isReadOnlyAdmin() || currentUser.isAdmin() || userEditProfile)) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + currentUser.getUserName());
                response.setStatus(500);
                return null;
            }
            List<Object> responseBackupPolicyElements = new ArrayList();
            if (!StringUtils.isEmpty((String)loadOnlyBasic) && loadOnlyBasic.equalsIgnoreCase("true") && !CollectionUtils.isEmpty(backupPolicyElements)) {
                for (BackupPolicyElement backupPolicyElement : backupPolicyElements) {
                    BackupPolicyElement tempBackupPolicyElement = new BackupPolicyElement();
                    tempBackupPolicyElement.setPolicygroupName(backupPolicyElement.getPolicygroupName());
                    tempBackupPolicyElement.setMaxVersions(backupPolicyElement.getMaxVersions());
                    tempBackupPolicyElement.setScheduleNames(backupPolicyElement.getScheduleNames());
                    tempBackupPolicyElement.setInclusionFilterElement(backupPolicyElement.getInclusionFilterElement());
                    tempBackupPolicyElement.setMappedUserCount(Long.toString(this.userDao.getBackupPolicyMappedUserCountbyPolicyName(cloudId, backupPolicyElement.getPolicygroupName())));
                    tempBackupPolicyElement.setFilterInclusionName(backupPolicyElement.getFilterInclusionName());
                    tempBackupPolicyElement.setSearchFilterInclusionName(backupPolicyElement.getSearchFilterInclusionName());
                    responseBackupPolicyElements.add(tempBackupPolicyElement);
                }
            } else {
                responseBackupPolicyElements = backupPolicyElements;
            }
            modelAndView.addObject(responseBackupPolicyElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load all backupPolicy  ..." + (Object)((Object)e));
            logger.error("Error failed to load all backupPolicy  ..." + e.getMessage());
        }
        logger.debug("end of load all backupPolicy ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/backupPolicy/load/device/{deviceUUID}/"}, method={RequestMethod.GET})
    public ModelAndView getBackupPolicyForDevice(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load BackupPolicy for device ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return null;
            }
            BackupPolicyElement backupPolicyElement = this.backupPolicyService.getBackupPolicyForDevice(cloudId, cloudName, deviceUUID);
            if (backupPolicyElement == null) {
                response.setStatus(400);
                return null;
            }
            modelAndView.addObject((Object)backupPolicyElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of loading BackupPolicy deviceuuid ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/backupPolicy/loadAllPolicyNames/"}, method={RequestMethod.GET})
    public ModelAndView getAllBackupPolicyNames(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        String isReportFlag = request.getHeader("isReport");
        String productType = request.getHeader("productType");
        logger.debug(request.getHeader("userEditProfile") + "....calling getAllPolicyNames report flag check ..." + request.getHeader("isReport") + "...productType..." + productType);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            User currentUser = authorizationTokens.getUser();
            boolean userEditProfile = false;
            String userEditProfileStr = request.getHeader("userEditProfile");
            if (!StringUtils.isEmpty((String)userEditProfileStr)) {
                userEditProfile = Boolean.parseBoolean(userEditProfileStr);
            }
            boolean validAdmin = false;
            if (currentUser != null && (currentUser.isReadOnlyAdmin() || currentUser.isAdmin() || userEditProfile)) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + currentUser.getUserName());
                response.setStatus(500);
                return null;
            }
            List<Object> backupPolicyNamesList = new ArrayList();
            if (BackupPolicyController.isBackupEnabled(cl.getCloud().getCloudCustomisableDetails())) {
                if (currentUser.isReadOnlyAdmin()) {
                    if (!CollectionUtils.isEmpty((Collection)currentUser.getBackupPoliciesAdmin())) {
                        backupPolicyNamesList = currentUser.getBackupPoliciesAdmin();
                    }
                } else {
                    backupPolicyNamesList = this.backupPolicyService.getAllBackupPolicyNames(cloudId, cloudName);
                }
            }
            if (!StringUtils.isEmpty((String)productType) && "office".equals(productType)) {
                backupPolicyNamesList = new ArrayList();
            }
            boolean isReport = false;
            if (!StringUtils.isEmpty((String)isReportFlag)) {
                isReport = Boolean.parseBoolean(isReportFlag);
            }
            if (isReport) {
                boolean isODBBackupEnabled = BackupPolicyController.isODBBackupEnabled(cl.getCloud().getCloudCustomisableDetails());
                boolean isExchangeBackupEnabled = BackupPolicyController.isExchangeBackupEnabled(cl.getCloud().getCloudCustomisableDetails());
                if (isODBBackupEnabled || isExchangeBackupEnabled) {
                    List<Object> odbBackupPolicyNamesList = new ArrayList();
                    odbBackupPolicyNamesList = currentUser.isReadOnlyAdmin() && !CollectionUtils.isEmpty((Collection)currentUser.getOdbPoliciesAdmin()) ? currentUser.getOdbPoliciesAdmin() : this.odbBackupPolicyService.getAllBackupPolicyNames(cloudId, cloudName);
                    if (!StringUtils.isEmpty((String)productType) && !"office".equals(productType)) {
                        odbBackupPolicyNamesList = new ArrayList();
                    }
                    backupPolicyNamesList.addAll(odbBackupPolicyNamesList);
                }
            }
            backupPolicyNamesList.stream().sorted();
            modelAndView.addObject(backupPolicyNamesList);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of getAllPolicyNames...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/backupPolicy/loadAllOfficePolicyNames/"}, method={RequestMethod.GET})
    public ModelAndView getAllOfficeBackupPolicyNames(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        String productType = request.getHeader("productType");
        logger.debug(request.getHeader("userEditProfile") + "....calling loadAllOfficePolicy .....productType..." + productType);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            User currentUser = authorizationTokens.getUser();
            boolean userEditProfile = false;
            String userEditProfileStr = request.getHeader("userEditProfile");
            if (!StringUtils.isEmpty((String)userEditProfileStr)) {
                userEditProfile = Boolean.parseBoolean(userEditProfileStr);
            }
            boolean validAdmin = false;
            if (currentUser != null && (currentUser.isReadOnlyAdmin() || currentUser.isAdmin() || userEditProfile)) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + currentUser.getUserName());
                response.setStatus(500);
                return null;
            }
            List<Object> backupPolicyNamesList = new ArrayList();
            backupPolicyNamesList = this.odbBackupPolicyService.getAllOfficePolicyNames(cloudId, productType);
            backupPolicyNamesList.stream().sorted();
            modelAndView.addObject(backupPolicyNamesList);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        logger.debug("end of getAllPolicyNames...");
        return modelAndView;
    }

    private static boolean isODBBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isODBUserLevelAcctEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"OneDrive Backup Enabled".equals(customisableDetails.getName())) continue;
            isODBUserLevelAcctEnabled = true;
            break;
        }
        return isODBUserLevelAcctEnabled;
    }

    private static boolean isBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isBackupEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"Backup Enabled".equals(customisableDetails.getName())) continue;
            isBackupEnabled = true;
            break;
        }
        return isBackupEnabled;
    }

    private static boolean isExchangeBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isExchangeBackupEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"Exchange Backup Enabled".equals(customisableDetails.getName())) continue;
            isExchangeBackupEnabled = true;
            break;
        }
        return isExchangeBackupEnabled;
    }

    @RequestMapping(value={"cloud/{cloudName}/check/backupPolicy/version"}, method={RequestMethod.GET})
    public void checkGpVersion(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load BackupPolicy for device ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            if (this.getCurrentCrawlLimit() > PCHelperConstant.getMaxCrawlHitCount()) {
                logger.debug("@@@CRAWL_COUNT has exceeded checkGpVersion the max limit of>>>: " + PCHelperConstant.getMaxCrawlHitCount());
                response.setStatus(400);
                return;
            }
            this.incrementCrawlLimit();
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                this.decrementCrawlLimit();
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String userName = request.getHeader("userName");
            String lastModifiedTime = request.getHeader("lastModifiedTime");
            String deviceUUID = request.getHeader("deviceUUID");
            String productVersion = request.getHeader("productVersion");
            String policyType = request.getHeader("syncPolicy");
            long lastModifiedTimeVal = 0L;
            if (!StringUtils.isEmpty((String)lastModifiedTime)) {
                lastModifiedTimeVal = Long.parseLong(lastModifiedTime);
            }
            Boolean isLatestVersion = null;
            if ("true".equalsIgnoreCase(policyType) && !StringUtils.isEmpty((String)policyType)) {
                isLatestVersion = this.syncPolicyService.isPolicyModified(cloudId, cloudName, userName, lastModifiedTimeVal);
            } else if (StringUtils.isEmpty((String)policyType) || "false".equalsIgnoreCase(policyType)) {
                isLatestVersion = this.backupPolicyService.isPolicyModified(cloudId, cloudName, userName, lastModifiedTimeVal);
            }
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                this.decrementCrawlLimit();
                return;
            }
            DeviceBackupOverView deviceBackupOverView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            if (deviceBackupOverView != null) {
                this.deviceManagementService.updateLastHeardTime(cloudId, deviceBackupOverView.getId());
            }
            try {
                if (!StringUtils.isEmpty((String)productVersion) && !StringUtils.isEmpty((String)deviceUUID)) {
                    String clientVersion = device.getClientVersion();
                    logger.debug("Device element product version..........." + clientVersion);
                    if (clientVersion != null) {
                        if (!clientVersion.contentEquals(productVersion)) {
                            this.deviceManagementService.updateClientVersion(cloudId, productVersion, deviceUUID, productVersion);
                        }
                    } else {
                        this.deviceManagementService.updateClientVersion(cloudId, productVersion, deviceUUID, productVersion);
                    }
                } else {
                    logger.debug("product version or uuid is empty.....");
                }
            }
            catch (Exception e) {
                logger.trace("check version and update is Failed..." + e);
                logger.error("check version and update is Failed..." + e.getMessage());
            }
            if (isLatestVersion != null) {
                response.setStatus(200);
                response.setHeader("isLatestVersion", isLatestVersion.toString());
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_BACKUPPOLICY + e.getMessage());
        }
        this.decrementCrawlLimit();
        logger.debug("end of loading BackupPolicy deviceuuid ...");
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/policy/block/"}, method={RequestMethod.PUT})
    public void blockBackupPolicy(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String policyName = request.getHeader("policyName");
            logger.debug("Start Blocking Policy" + policyName);
            String policyType = request.getHeader("policyType");
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            boolean isPolicyMappedToAnyUser = this.backupPolicyService.checkPolicyMappedToUsers(cloudId, policyName, policyType, response);
            if (!isPolicyMappedToAnyUser) {
                this.backupPolicyService.blockPolicy(cloudId, policyName, authorizationTokens.getUser().getUserName(), policyType);
                response.setStatus(200);
            }
        }
        catch (BaseException e) {
            logger.debug("Exception" + e.getMessage());
            response.setStatus(400);
        }
    }

    private synchronized void incrementCrawlLimit() {
        int crawlLimit = this.getCurrentCrawlLimit();
        MemoryStore.delete((String)CRAWL_LIMIT);
        MemoryStore.add((String)CRAWL_LIMIT, (Object)(++crawlLimit));
        logger.debug("@@@INCREMENT Crawl count ............. " + crawlLimit);
    }

    private synchronized void decrementCrawlLimit() {
        int crawlLimit = this.getCurrentCrawlLimit();
        if (crawlLimit > 0) {
            --crawlLimit;
        }
        MemoryStore.delete((String)CRAWL_LIMIT);
        MemoryStore.add((String)CRAWL_LIMIT, (Object)crawlLimit);
        logger.debug("@@@DECREMENT Crawl count ............. " + crawlLimit);
    }

    private synchronized int getCurrentCrawlLimit() {
        int crawlLimit = 0;
        if (MemoryStore.get((String)CRAWL_LIMIT) != null) {
            crawlLimit = (Integer)MemoryStore.get((String)CRAWL_LIMIT);
        }
        logger.debug("@@@CURRENT-Crawl count ............. " + crawlLimit);
        return crawlLimit;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/odbpolicy/block/{policyName}"}, method={RequestMethod.PUT})
    public void blockOdbBackupPolicy(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="policyName") String policyName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        String policyType = request.getHeader("policyType");
        logger.debug(policyType + "...Start Blocking odb Policy" + policyName);
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            boolean isPolicyMappedToAnyUser = this.backupPolicyService.checkODBPolicyMappedToUsers(cloudId, policyName, response, policyType);
            if (!isPolicyMappedToAnyUser) {
                this.backupPolicyService.blockODBPolicy(cloudId, policyName, authorizationTokens.getUser().getUserName(), policyType);
                response.setStatus(200);
            } else {
                response.setStatus(333);
            }
        }
        catch (BaseException e) {
            logger.debug("Exception" + e.getMessage());
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/backupPolicy/loadAll"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getAllBackupPolicyWithPagination(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNumber") Integer pageNumberInteger) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/backupPolicy/loadAll ...");
        try {
            User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return this.toJSON(1202);
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return this.toJSON(1201);
            }
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
            int pageNumber = 0;
            int skipValue = 0;
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            PolicyResponse elementResponse = new PolicyResponse();
            Map paramSet = request.getParameterMap();
            ArrayList<String> policyNames = new ArrayList<String>();
            if (user != null && user.isReadOnlyAdmin()) {
                logger.debug("...user is read only admin.....");
                if (!CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin())) {
                    policyNames.addAll(user.getBackupPoliciesAdmin());
                }
            }
            boolean validAdmin = false;
            if (user != null && user.isReadOnlyAdmin() || user.isAdmin()) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + user.getUserName());
                response.setStatus(500);
                return this.toJSON(400);
            }
            List<Object> backupPolicyElements = new ArrayList();
            backupPolicyElements = user.isReadOnlyAdmin() ? this.backupPolicyService.getAllBackupPoliciesByPagination(cloudId, policyNames, skipValue) : this.backupPolicyService.getAllBackupPoliciesByPagination(cloudId, skipValue);
            if (CollectionUtils.isEmpty(backupPolicyElements)) {
                backupPolicyElements = new ArrayList();
            }
            logger.debug(PCHelperConstant.getReportDisplayRecords() + "...policy list size... " + backupPolicyElements.size());
            long totalRecordsCount = this.backupPolicyService.loadAllBackupPoliciesCount(cloudId, policyNames);
            if (user != null && user.isReadOnlyAdmin()) {
                if (!CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin())) {
                    logger.debug("....readonly admin..." + user.getBackupPoliciesAdmin());
                    backupPolicyElements = backupPolicyElements.stream().filter(policy -> Objects.nonNull(policy.getPolicygroupName()) && user.getBackupPoliciesAdmin().contains(policy.getPolicygroupName())).collect(Collectors.toList());
                } else {
                    backupPolicyElements = new ArrayList();
                }
            }
            ArrayList<BackupPolicyElement> responseBackupPolicyElements = new ArrayList<BackupPolicyElement>();
            for (BackupPolicyElement backupPolicyElement : backupPolicyElements) {
                BackupPolicyElement tempBackupPolicyElement = new BackupPolicyElement();
                tempBackupPolicyElement.setPolicygroupName(backupPolicyElement.getPolicygroupName());
                tempBackupPolicyElement.setMaxVersions(backupPolicyElement.getMaxVersions());
                tempBackupPolicyElement.setScheduleNames(backupPolicyElement.getScheduleNames());
                tempBackupPolicyElement.setInclusionFilterElement(backupPolicyElement.getInclusionFilterElement());
                tempBackupPolicyElement.setMappedUserCount(Long.toString(this.userDao.getBackupPolicyMappedUserCountbyPolicyName(cloudId, backupPolicyElement.getPolicygroupName())));
                tempBackupPolicyElement.setFilterInclusionName(backupPolicyElement.getFilterInclusionName());
                tempBackupPolicyElement.setSearchFilterInclusionName(backupPolicyElement.getSearchFilterInclusionName());
                tempBackupPolicyElement.setActive(backupPolicyElement.isActive());
                logger.debug("policy Active" + backupPolicyElement.isActive());
                responseBackupPolicyElements.add(tempBackupPolicyElement);
            }
            elementResponse.setBackupPolicyElements(responseBackupPolicyElements);
            response.setStatus(200);
            logger.debug(backupPolicyElements.size() + "end of load all backupPolicy ..." + pageNumber + "/" + totalRecordsCount);
            return this.toJSON(200, this.getMetadataElement(cloudPropertyElement.getReportRows(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), elementResponse);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load all backupPolicy  ..." + (Object)((Object)e));
            logger.error("Error failed to load all backupPolicy  ..." + e.getMessage());
            return null;
        }
    }

    private boolean validateBackupPolicyValues(BackupPolicyElement backupPolicyElement, HttpServletResponse response, CloudLicenseTo cl) {
        Cloud cloud = cl.getCloud();
        boolean isMSPEnv = false;
        List cloudCustomisableDetails = cloud.getCloudCustomisableDetails();
        for (CloudCustomisableDetails customisableDetail : cloudCustomisableDetails) {
            if (!"MSP Environment Enabled".equalsIgnoreCase(customisableDetail.getName())) continue;
            isMSPEnv = true;
        }
        logger.debug("is MSP enabled={}", (Object)isMSPEnv);
        boolean anyCheckFailed = false;
        if (backupPolicyElement.getNoOfDevicesAllowed() <= 0 || backupPolicyElement.getNoOfDevicesAllowed() > cloud.getNoOfDevicesAllowed()) {
            logger.error("....bad input for device allowed..." + backupPolicyElement.getNoOfDevicesAllowed());
            response.setStatus(400);
            return true;
        }
        if (backupPolicyElement.getMemoryUtilization() < 128L || backupPolicyElement.getMemoryUtilization() > 1024L) {
            logger.error("....bad input for MemoryUtilization..." + backupPolicyElement.getMemoryUtilization());
            response.setStatus(400);
            return true;
        }
        if (backupPolicyElement.getCpuUtilization() < 20L || backupPolicyElement.getCpuUtilization() > 100L) {
            logger.error("....bad input for CpuUtilization..." + backupPolicyElement.getCpuUtilization());
            response.setStatus(400);
            return true;
        }
        if (backupPolicyElement.getNwFromClientToPGMB() <= 0.0 || backupPolicyElement.getNwFromClientToPGMB() > 10000.0) {
            logger.error("....bad input for NwFromClientToPGMB..." + backupPolicyElement.getNwFromClientToPGMB());
            response.setStatus(400);
            return true;
        }
        if (backupPolicyElement.getCpuThrottling() < 1 || backupPolicyElement.getCpuThrottling() > 10) {
            logger.error("....bad input for CpuThrottling..." + backupPolicyElement.getCpuThrottling());
            response.setStatus(400);
            return true;
        }
        if (backupPolicyElement.getNwFromPGToCloud() < 1L || backupPolicyElement.getNwFromPGToCloud() > 10L) {
            logger.error("....bad input for NwFromPGToCloud..." + backupPolicyElement.getNwFromPGToCloud());
            response.setStatus(400);
            return true;
        }
        if (backupPolicyElement.getCrawlLimit() < 1) {
            logger.error("....bad input for CrawlLimit..." + backupPolicyElement.getCrawlLimit());
            response.setStatus(400);
            return true;
        }
        if (isMSPEnv) {
            if (backupPolicyElement.getPolicyUsersAllowed() < 1L) {
                logger.error("....bad input for Policy users allowed..." + backupPolicyElement.getPolicyUsersAllowed());
                response.setStatus(400);
                return true;
            }
            if (backupPolicyElement.getPolicyStorageSizeAllowed() < 1L) {
                logger.error("....bad input for policy storage size allowed..." + backupPolicyElement.getPolicyStorageSizeAllowed());
                response.setStatus(400);
                return true;
            }
        }
        if (backupPolicyElement.getPftSize() < 1 || backupPolicyElement.getPftSize() > 250) {
            logger.error("....bad input for PftSize..." + backupPolicyElement.getPftSize());
            response.setStatus(400);
            return true;
        }
        if (backupPolicyElement.getFileChunkableSize() < 1 || backupPolicyElement.getFileChunkableSize() > 250) {
            logger.error("....bad input for FileChunkableSize..." + backupPolicyElement.getFileChunkableSize());
            response.setStatus(400);
            return true;
        }
        if (backupPolicyElement.getNumberOfThreadsAllowedForBackup() < 1 || backupPolicyElement.getNumberOfThreadsAllowedForBackup() > 5) {
            logger.error("....bad input for NumberOfThreadsAllowedForBackup..." + backupPolicyElement.getNumberOfThreadsAllowedForBackup());
            response.setStatus(400);
            return true;
        }
        if (!StringUtils.isEmpty((String)backupPolicyElement.getPolicyRefresh())) {
            String policyRefreshStr = backupPolicyElement.getPolicyRefresh();
            policyRefreshStr = policyRefreshStr.replaceAll(":00", "");
            logger.debug(backupPolicyElement.getPolicyRefresh() + "..formatted policy refresh ...." + policyRefreshStr);
            int policyRefresh = Integer.parseInt(policyRefreshStr);
            if (policyRefresh < 1 || policyRefresh > 23) {
                logger.error("....bad input for PolicyRefresh..." + backupPolicyElement.getPolicyRefresh());
                response.setStatus(400);
                return true;
            }
        }
        anyCheckFailed = this.checkSpecialCharactersForPolicy(backupPolicyElement, response);
        return anyCheckFailed;
    }

    private boolean checkSpecialCharactersForPolicy(BackupPolicyElement backupPolicyElement, HttpServletResponse response) {
        boolean anyCheckFailed = false;
        HashSet<String> errors = new HashSet<String>();
        logger.debug("inside special char check ....");
        ArrayList<String> specialFieldList = new ArrayList<String>();
        ArrayList<String> specialFieldListPath = new ArrayList<String>();
        specialFieldList.add("policygroupName");
        specialFieldList.add("description");
        specialFieldList.add("allowedDomains");
        specialFieldList.add("scheduleNames");
        specialFieldList.add("filterInclusionName");
        specialFieldList.add("shareDomainIncExclusions");
        specialFieldList.add("searchFilterInclusionName");
        specialFieldListPath.add("preScanCommand");
        specialFieldListPath.add("preBackupCommand");
        specialFieldListPath.add("postBackupCommand");
        List fields = FieldUtils.getAllFieldsList(backupPolicyElement.getClass());
        for (Field field : fields) {
            String val;
            Object value;
            field.setAccessible(true);
            logger.debug("....policy field names....." + field.getName());
            if (field.getName().equals("policyRefresh")) {
                String policyRefreshStr = backupPolicyElement.getPolicyRefresh();
                policyRefreshStr = policyRefreshStr.replaceAll(":00", "");
                logger.debug(backupPolicyElement.getPolicyRefresh() + "..formatted policy refresh ...." + policyRefreshStr);
                int policyRefresh = Integer.parseInt(policyRefreshStr);
                if (policyRefresh >= 1 && policyRefresh <= 23) continue;
                logger.error("....bad input for PolicyRefresh..." + backupPolicyElement.getPolicyRefresh());
                response.setStatus(400);
                return true;
            }
            if (field.getType().equals(String.class)) {
                try {
                    value = (String)field.get(backupPolicyElement);
                    if (!("agentPassword".equalsIgnoreCase(field.getName()) || "serverUserName".equalsIgnoreCase(field.getName()) || "serverPassword".equalsIgnoreCase(field.getName()))) {
                        if (specialFieldList.contains(field.getName())) {
                            if (BackupPolicyController.checkSpecialCharactersWithoutDot((String)value)) {
                                logger.debug(field.getName() + "...valuestest...." + (String)value);
                                errors.add(field.getName());
                            }
                        } else if (specialFieldListPath.contains(field.getName())) {
                            if (BackupPolicyController.checkSpecialCharactersForPath((String)value)) {
                                logger.debug(field.getName() + "...valuestest...." + (String)value);
                                errors.add(field.getName());
                            }
                        } else if (BackupPolicyController.checkSpecialCharacters((String)value)) {
                            logger.debug(field.getName() + "...values...." + (String)value);
                            errors.add(field.getName());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (field.getName().equals("backupFolderPaths") || field.getName().equals("excludedFolderpaths") || field.getName().equals("exceptionsToExclusions") || field.getName().equals("sqlBackupFolders")) {
                try {
                    value = (List)field.get(backupPolicyElement);
                    if (!CollectionUtils.isEmpty((Collection)value)) {
                        Iterator iterator = value.iterator();
                        while (iterator.hasNext()) {
                            val = (String)iterator.next();
                            if (!BackupPolicyController.checkSpecialCharactersForPath(val)) continue;
                            logger.debug(field.getName() + "...values...." + val);
                            errors.add(field.getName());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (field.getName().equals("backupFolderPaths") || field.getName().equals("excludedFolderpaths") || field.getName().equals("exceptionsToExclusions") || field.getName().equals("sqlBackupFolders") || !field.getType().equals(List.class)) continue;
            try {
                value = (List)field.get(backupPolicyElement);
                if (CollectionUtils.isEmpty((Collection)value)) continue;
                Iterator iterator = value.iterator();
                while (iterator.hasNext()) {
                    val = (String)iterator.next();
                    if ("agentPassword".equalsIgnoreCase(field.getName()) || "serverUserName".equalsIgnoreCase(field.getName()) || "serverPassword".equalsIgnoreCase(field.getName())) continue;
                    if (specialFieldList.contains(field.getName())) {
                        if (!BackupPolicyController.checkSpecialCharactersWithoutDot(val)) continue;
                        logger.debug(field.getName() + "...valuestest...." + value);
                        errors.add(field.getName());
                        continue;
                    }
                    if (specialFieldListPath.contains(field.getName())) {
                        if (!BackupPolicyController.checkSpecialCharactersForPath(val)) continue;
                        logger.debug(field.getName() + "...valuestest...." + value);
                        errors.add(field.getName());
                        continue;
                    }
                    if (!BackupPolicyController.checkSpecialCharacters(val)) continue;
                    logger.debug(field.getName() + "...values...." + value);
                    errors.add(field.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!CollectionUtils.isEmpty(errors)) {
            logger.error("....bad input for fields..." + errors);
            response.setStatus(400);
            return true;
        }
        return anyCheckFailed;
    }

    private static boolean checkSpecialCharactersWithoutDot(String checkStr) {
        boolean isSpecCharExists = false;
        if (StringUtils.isEmpty((String)checkStr)) {
            return false;
        }
        String specialCharactersString = "/([{}<>;:=]+)(*)/";
        for (int i = 0; i < checkStr.length(); ++i) {
            char ch = checkStr.charAt(i);
            if (specialCharactersString.contains(Character.toString(ch))) {
                return true;
            }
            if (i != checkStr.length() - 1) continue;
            isSpecCharExists = false;
        }
        return isSpecCharExists;
    }

    private static boolean checkSpecialCharacters(String checkStr) {
        boolean isSpecCharExists = false;
        if (StringUtils.isEmpty((String)checkStr)) {
            return false;
        }
        String specialCharactersString = "/([{}<>;:=]+)(.*)/";
        for (int i = 0; i < checkStr.length(); ++i) {
            char ch = checkStr.charAt(i);
            if (specialCharactersString.contains(Character.toString(ch))) {
                return true;
            }
            if (i != checkStr.length() - 1) continue;
            isSpecCharExists = false;
        }
        return isSpecCharExists;
    }

    private static boolean checkSpecialCharactersForPath(String checkStr) {
        boolean isSpecCharExists = false;
        if (StringUtils.isEmpty((String)checkStr)) {
            return false;
        }
        String specialCharactersString = "<>=";
        for (int i = 0; i < checkStr.length(); ++i) {
            char ch = checkStr.charAt(i);
            if (specialCharactersString.contains(Character.toString(ch))) {
                return true;
            }
            if (i != checkStr.length() - 1) continue;
            isSpecCharExists = false;
        }
        return isSpecCharExists;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/backupPolicy/export"}, method={RequestMethod.POST})
    public void exportBackupPolicy(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        User currentUser = new User();
        logger.debug(" calling cloud/{cloudName}/backupPolicy/export ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String policyName = request.getHeader("policyName");
            logger.debug("Start export Policy" + policyName);
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            logger.debug("************");
            logger.debug("cloudId..........." + cloudId);
            logger.debug("cloudname........" + cloudName);
            logger.debug("authorization token for user......" + authorizationTokens.getUser().getUserName());
            Document document = new Document();
            this.reportServiceImpl.createPdfForPolicy(cl.getCloud(), policyName, document, currentUser);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug("Error failed to save Schedule ..." + (Object)((Object)e));
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling /authenticateOneDrive ...");
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/syncPolicy/export"}, method={RequestMethod.POST})
    public void exportSyncPolicy(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(" calling cloud/{cloudName}/syncPolicy/export ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String policyName = request.getHeader("policyName");
            logger.debug("Start export Policy" + policyName);
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            logger.debug("************");
            logger.debug("cloudId..........." + cloudId);
            logger.debug("cloudname........" + cloudName);
            logger.debug("authorization token for user......" + authorizationTokens.getUser().getUserName());
            Document document = new Document();
            this.reportServiceImpl.createPdfForSyncPolicy(cl.getCloud(), policyName, document);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug("Error failed to save Schedule ..." + (Object)((Object)e));
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling /authenticateOneDrive ...");
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/officePolicy/export"}, method={RequestMethod.POST})
    public void exportOfficePolicy(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(" calling cloud/{cloudName}/syncPolicy/export ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String policyName = request.getHeader("policyName");
            String produtName = request.getHeader("productName");
            logger.debug("Start export Policy" + policyName);
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            logger.debug("************");
            logger.debug("cloudId..........." + cloudId);
            logger.debug("cloudname........" + cloudName);
            logger.debug("authorization token for user......" + authorizationTokens.getUser().getUserName());
            Document document = new Document();
            this.reportServiceImpl.createPdfForOfficePolicy(cl.getCloud(), policyName, document, produtName);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.debug("Error failed to save Schedule ..." + (Object)((Object)e));
            logger.error("Error failed to save Schedule ..." + e.getMessage());
        }
        logger.debug("end of calling /authenticateOneDrive ...");
    }
}

