/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.parablu.pcbd.dao.MSUtilDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.CMBackUpImage;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Components;
import com.parablu.pcbd.domain.DeltaPath;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.EWSToken;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.FolderFileInfo;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.MSAppBluKrypt;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OPWS;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.SiteDeltaPath;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserPolicy;
import com.parablu.pcbd.domain.UsersWOBackup;
import com.pg.domain.BackupAttempt;
import com.pg.domain.DriveFileInfo;
import com.pg.factory.BlukryptMongoFactoryUtils;
import com.pg.helper.constant.PCHelperConstant;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class MSUtilDaoImpl
implements MSUtilDao {
    private static Logger logger = LogManager.getLogger(MSUtilDaoImpl.class);
    public static final String IS_DEVICE_BOLCKED = "isDeviceBolcked";
    private static final String ACTION = "action";
    private static final String ACTION_TO_DEVICEUUID = "actionToDeviceUUID";
    private MongoOperations msgMongoTemplate;
    private MongoOperations mongoOps;
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;
    private static final String BATCH_START_TIME_STAMP = "batchStartTimestamp";
    private static final String DEVICE = "device";
    private static final String FILE_NAME = "fileName";
    private static final String DEVICE_PATH = "devicePath";
    private static final String LAST_SERVER_MODIFIED_TIME = "lastServerModifiedTime";
    private static final String PRESENT = "present";
    private static final String DEVICE_UUID = "deviceUUID";
    public static final String USER_NAME = "userName";
    private static final String STATUS_STARTED = "STARTED";
    private static final String STATUS_FAILED = "FAILED";
    private static final String JOB_TYPE = "jobType";
    private static final String BACK_UP = "BACKUP";
    private static final String STATUS = "status";
    private static final String BATCH_END_TIME_STAMP = "batchEndTimestamp";
    private static final String DEVICEUUID = "deviceUUID";
    private static final String RESTORE = "RESTORE";
    private static final String COMPLETED = "COMPLETED";
    private static final String COUNT = "count";
    private static final String BACKUP_BATCH = "BACKUP_BATCH";

    public MongoOperations getMongoTemplate() {
        return this.msgMongoTemplate;
    }

    public void setMsgMongoTemplate(MongoOperations msgMongoTemplate) {
        this.msgMongoTemplate = msgMongoTemplate;
    }

    public MongoOperations getMongoOps() {
        return this.mongoOps;
    }

    public void setMongoOps(MongoOperations mongoOps) {
        this.mongoOps = mongoOps;
    }

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public List<OfficeBackupPolicy> getAllOfficeBackupPolicies(int cloudId, String policyType) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        if (!"Sharepoint".equalsIgnoreCase(policyType)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false), Criteria.where((String)"policyType").is((Object)"Sharepoint")});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, OfficeBackupPolicy.class);
    }

    @Override
    public List<OfficeBackupPolicy> getAllOfficeBackupPoliciesForBluKrypt(int cloudId, String policyType) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        logger.debug(PCHelperConstant.getComponentName() + "....policyType....." + policyType);
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false), Criteria.where((String)"policyType").is((Object)policyType), Criteria.where((String)"msAppBluKrypt").is((Object)PCHelperConstant.getComponentName())});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = mongoTemplate.find(query, OfficeBackupPolicy.class);
        ArrayList<OfficeBackupPolicy> finalList = new ArrayList<OfficeBackupPolicy>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            finalList.addAll(list);
        }
        logger.debug(finalList.size() + "....policyType....." + policyType);
        return finalList;
    }

    @Override
    public boolean saveDriveItem(int cloudId, DriveFileInfo driveFileInfo) {
        boolean itemSaved = false;
        try {
            this.msgMongoTemplate.save((Object)driveFileInfo);
            itemSaved = true;
            logger.debug(itemSaved + "...file added...." + driveFileInfo.getDeviceUUID() + "..." + driveFileInfo.getItemPath() + "...." + driveFileInfo.getItemId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return itemSaved;
    }

    @Override
    public void saveDeletedDriveItem(int cloudId, String deletedItemId) {
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoList() {
        Query query = new Query().limit(PCHelperConstant.getQueryLimit());
        return this.msgMongoTemplate.find(query, DriveFileInfo.class);
    }

    @Override
    public void deleteDriveInfo(String driveFileInfoId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)driveFileInfoId));
        this.msgMongoTemplate.findAndRemove(query, DriveFileInfo.class);
    }

    @Override
    public String saveBatchDetails(int cloudId, ODBBackupBatch backupBatch, String policyName, long batchStartTime) {
        backupBatch.setBatchStartTimestamp(batchStartTime);
        ODBBackupBatch batch = (ODBBackupBatch)this.msgMongoTemplate.save((Object)backupBatch, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(batch + "...dao... " + backupBatch);
        logger.debug("...dao1... " + batch.getId());
        if (STATUS_STARTED.equalsIgnoreCase(backupBatch.getStatus())) {
            // empty if block
        }
        return batch.getId().toString();
    }

    @Override
    public void deleteBatchFromOdServer(ObjectId id, String policyName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        this.msgMongoTemplate.findAndRemove(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    public Components getComponents(String componentName, int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"gatewayName").is((Object)componentName);
        Query query = new Query((CriteriaDefinition)criteria);
        PrivacyGateway privacyGateway = (PrivacyGateway)mongoTemplate.findOne(query, PrivacyGateway.class);
        Components components = new Components();
        if (privacyGateway != null) {
            components.setComponentName(componentName);
            components.setComponentsProperties(privacyGateway.getComponentsProperties());
            components.setNoOfThreadsUsed(privacyGateway.getNoOfThreadsUsed());
        }
        return components;
    }

    @Override
    public List<ODBBackupBatch> getBatchList(String policyName) {
        List list;
        Criteria criteria;
        Query query2;
        Cloud cloud;
        boolean licenseActive;
        if (PCHelperConstant.getPGOverloadLimit() == 0) {
            Properties props = null;
            try {
                long threadSize;
                String threadstr;
                ClassPathResource resource = new ClassPathResource("privacygateway.properties");
                props = PropertiesLoaderUtils.loadProperties((Resource)resource);
                logger.debug(".....componentn name ..... " + props.getProperty("componentName"));
                Components components = this.getComponents(props.getProperty("componentName"), 1);
                logger.debug("getting components properties from db of" + components.getComponentName());
                Map<String, String> componentProperties = components.getComponentsProperties();
                if (componentProperties.containsKey("pgOverloadLimit") && !StringUtils.isEmpty((String)(threadstr = componentProperties.get("pgOverloadLimit")))) {
                    threadSize = Integer.parseInt(threadstr);
                    logger.debug("...threads from collection ...." + threadSize);
                    PCHelperConstant.setPGOverloadLimit((String)("" + threadSize));
                }
                if (componentProperties.containsKey("officeDownloadThreads")) {
                    threadstr = componentProperties.get("officeDownloadThreads");
                    if (!StringUtils.isEmpty((String)threadstr)) {
                        threadSize = Integer.parseInt(threadstr);
                        logger.debug("...threads from db for offfice ...." + threadSize);
                        PCHelperConstant.setOfficeThreadsValue((String)("" + threadSize));
                    }
                } else {
                    PCHelperConstant.setOfficeThreadsValue((String)"2");
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                logger.error("...error trying to get threads..." + ee.getMessage());
            }
        }
        Criteria criteria2 = Criteria.where((String)STATUS).is((Object)"DEFERRED");
        Query query = new Query((CriteriaDefinition)criteria2);
        Update updateObj = new Update();
        updateObj.set(STATUS, (Object)COMPLETED);
        UpdateResult updateFirstObj = this.msgMongoTemplate.updateMulti(query, updateObj, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        if (PCHelperConstant.getPGOverloadLimit() > 0 && (licenseActive = this.vaildatedLicensceStatus(cloud = (Cloud)this.mongoOps.findOne(query2 = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"cloudId").is((Object)1))), Cloud.class)))) {
            Criteria criteria1 = Criteria.where((String)STATUS).is((Object)"LICENSEEXPIRED");
            Query query1 = new Query((CriteriaDefinition)criteria1);
            Update update = new Update();
            update.set(STATUS, (Object)COMPLETED);
            UpdateResult updateResult = this.msgMongoTemplate.updateFirst(query1, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.msgMongoTemplate.find(query = new Query((CriteriaDefinition)Criteria.where((String)STATUS).is((Object)COMPLETED)), ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase())))) {
            logger.debug(".....iklist...." + list.size());
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private boolean vaildatedLicensceStatus(Cloud cloud) {
        return cloud.getValidityPeriod() >= System.currentTimeMillis() && cloud.getStatusCode().equals("ACTIVE");
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoFromListForBatchId(String batchId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"backupBatchId").is((Object)batchId));
        query.limit(50);
        List list = this.msgMongoTemplate.find(query, DriveFileInfo.class);
        logger.debug(".....getlist....");
        if (CollectionUtils.isEmpty((Collection)list)) {
            query = new Query((CriteriaDefinition)Criteria.where((String)"backupBatchId").is((Object)new ObjectId(batchId)));
            query.limit(50);
            list = this.msgMongoTemplate.find(query, DriveFileInfo.class);
            logger.debug(".....getlist1....");
        }
        return list;
    }

    @Override
    public void updateBatchDetails(int cloudId, ODBBackupBatch backupBatch, String policyName, long batchStartTime) {
        if (!StringUtils.isEmpty((String)backupBatch.getStatus()) && COMPLETED.equalsIgnoreCase(backupBatch.getStatus())) {
            List list = new ArrayList();
            Criteria criteria = null;
            Query query = null;
            long totalcount = this.getTotalCountInBatch(backupBatch);
            int totalupdated = 0;
            do {
                criteria = new Criteria();
                String batchId = backupBatch.getId().toString();
                criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)backupBatch.getDeviceUUID()), Criteria.where((String)"backupBatchId").ne((Object)batchId)});
                query = new Query((CriteriaDefinition)criteria);
                query.limit(1);
                list = this.msgMongoTemplate.find(query, DriveFileInfo.class);
                logger.debug(batchId + ".....update started...." + backupBatch.getUserName());
                if (CollectionUtils.isEmpty(list)) continue;
                logger.debug("....findprev list ... " + list.size());
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)backupBatch.getDeviceUUID()), Criteria.where((String)"backupBatchId").ne((Object)batchId)});
                query = new Query((CriteriaDefinition)criteria);
                Update update = new Update();
                update.set("backupBatchId", (Object)batchId);
                query.limit(500);
                UpdateResult updateRes = this.msgMongoTemplate.updateMulti(query, update, DriveFileInfo.class);
                totalcount = this.getTotalCountInBatch(backupBatch);
                logger.debug(updateRes.getModifiedCount() + "...updated successfully.... " + policyName + "..." + backupBatch.getId() + "...updated..." + totalupdated + "/" + totalcount);
            } while (!CollectionUtils.isEmpty(list));
            totalcount = this.getTotalCountInBatch(backupBatch);
            backupBatch.setNoOfFiles(totalcount);
        }
        logger.debug(".....update completed...." + backupBatch.getUserName());
        Criteria criteria = Criteria.where((String)"id").is((Object)backupBatch.getId());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(STATUS, (Object)backupBatch.getStatus());
        update.set("noOfFiles", (Object)backupBatch.getNoOfFiles());
        update.set(BATCH_START_TIME_STAMP, (Object)batchStartTime);
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getModifiedCount() + "...updated successfully.... " + policyName + "..." + backupBatch.getId());
    }

    private long getTotalCountInBatch(ODBBackupBatch backupBatch) {
        Criteria criteria = new Criteria();
        Query query = null;
        criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)backupBatch.getDeviceUUID())});
        query = new Query((CriteriaDefinition)criteria);
        long totalcount = this.msgMongoTemplate.count(query, DriveFileInfo.class);
        return totalcount;
    }

    @Override
    public List<EventHub> getStartBackupEventHubList(int cloudId) {
        logger.debug("...getStartBackupEventHubList...");
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"odStatus").is((Object)STATUS_STARTED), criteria});
        Query query = new Query((CriteriaDefinition)andCriteria);
        List list = mongoTemplate.find(query, EventHub.class);
        logger.debug("...after getStartBackupEventHubList...");
        return list;
    }

    @Override
    public void deleteActionBasedOnBackupBatchStatus(int cloudId, String deviceUUID, String action) {
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria devUUIDCriteria = Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)deviceUUID);
        andCriteria.andOperator(new Criteria[]{devUUIDCriteria, criteria});
        Query query = new Query((CriteriaDefinition)andCriteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DeleteResult remove = mongoTemplate.remove(query, EventHub.class);
        logger.debug("...removed eventhub.... " + action + "....." + deviceUUID + "......" + remove.getDeletedCount());
    }

    @Override
    public List<EventHub> getEventHubForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, EventHub.class);
    }

    @Override
    public BackUpImage getBackupImageForItemId(int cloudId, String itemId, String deviceDestCollection, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)"odItemId").is((Object)itemId), Criteria.where((String)STATUS).is((Object)"ADDED")});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
        BackUpImage backUpImage = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            if (list.size() > 1) {
                for (BackUpImage image : list) {
                    if (!image.getStatus().equals("DELETED")) continue;
                    return null;
                }
                if (((BackUpImage)list.get(0)).getStatus().equals("DELETED")) {
                    return null;
                }
                backUpImage = (BackUpImage)list.get(0);
            } else {
                backUpImage = (BackUpImage)list.get(0);
            }
        }
        return backUpImage;
    }

    @Override
    public BackUpImage getBackupImageForItemIdConversion(int cloudId, String itemId, String deviceDestCollection, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)"odItemId").is((Object)itemId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
        BackUpImage backUpImage = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Collections.sort(list, Comparator.comparingLong(BackUpImage::getLastClientModifiedTime).reversed());
            if (list.size() > 1) {
                for (BackUpImage image : list) {
                    if (!image.getStatus().equals("DELETED")) continue;
                    return null;
                }
                if (((BackUpImage)list.get(0)).getStatus().equals("DELETED")) {
                    return null;
                }
                backUpImage = (BackUpImage)list.get(0);
            } else {
                backUpImage = (BackUpImage)list.get(0);
            }
        }
        return backUpImage;
    }

    @Override
    public void saveDeletedBackupImage(int cloudId, BackUpImage deletedBkpImage, String deviceDestCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)deletedBkpImage, deviceDestCollection);
    }

    @Override
    public void updateEventHubOdStatus(int cloudId, ObjectId eventHubId) {
        Criteria criteria = Criteria.where((String)"id").is((Object)eventHubId);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List find = mongoTemplate.find(query, EventHub.class);
        if (find != null) {
            logger.debug("....find list ... " + find.size());
        }
        Update update = new Update();
        update.set("odStatus", (Object)EventHub.ODSTATUS.PROCESSED.toString());
        UpdateResult updateFirst = mongoTemplate.updateFirst(query, update, EventHub.class);
        logger.debug(updateFirst.getModifiedCount() + "...event hub updated successfully.... " + eventHubId);
    }

    @Override
    public void updateBatchStatusInOdServer(ObjectId id, String policyName) {
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(STATUS, (Object)"PAUSED");
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getModifiedCount() + "... paused successfully.... " + policyName + "..." + id);
    }

    @Override
    public boolean isPrevBkpPaused(String actionToDeviceUUID, String policyName) {
        Device device;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)actionToDeviceUUID), Criteria.where((String)STATUS).is((Object)"PAUSED")});
        Query query = new Query((CriteriaDefinition)criteria);
        ODBBackupBatch bkpBatch = (ODBBackupBatch)this.msgMongoTemplate.findOne(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        boolean isPrevBkpPaused = false;
        BackupBatch backupBatch = null;
        if (bkpBatch != null && "PAUSED".equalsIgnoreCase(bkpBatch.getStatus())) {
            isPrevBkpPaused = true;
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)bkpBatch.getId())});
            query = new Query((CriteriaDefinition)criteria);
            query.limit(1);
            List backupBatchList = mongoTemplate.find(query, BackupBatch.class);
            if (!CollectionUtils.isEmpty((Collection)backupBatchList)) {
                backupBatch = (BackupBatch)backupBatchList.get(0);
            }
            if (backupBatch != null && backupBatch.getStatus().equalsIgnoreCase("ABORTED")) {
                isPrevBkpPaused = false;
                this.msgMongoTemplate.remove((Object)bkpBatch, "BACKUP_BATCH_" + policyName.toUpperCase());
            }
        }
        if (isPrevBkpPaused && backupBatch == null && (device = this.getDeviceInfoByUUID(1, actionToDeviceUUID)) != null) {
            try {
                long deviceCreateDate = Long.parseLong(device.getDeviceCreatedDate());
                logger.debug(deviceCreateDate + ".....start233...." + bkpBatch.getBatchStartTimestamp());
                if (deviceCreateDate > bkpBatch.getBatchStartTimestamp()) {
                    isPrevBkpPaused = false;
                    logger.debug(actionToDeviceUUID + ".....start2556...." + policyName);
                    this.msgMongoTemplate.remove(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
                    this.deleteOldBatchAndFiles(actionToDeviceUUID, policyName, device.getUserName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isPrevBkpPaused;
    }

    @Override
    public void updatePauseBkp(String actionToDeviceUUID, String policyName) {
        Criteria criteria = Criteria.where((String)"deviceUUID").is((Object)actionToDeviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(STATUS, (Object)COMPLETED);
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getMatchedCount() + "... unpaused successfully.... " + policyName + "..." + actionToDeviceUUID);
    }

    @Override
    public long getThreadSize(int cloudId, String cloudName) {
        Query query;
        OPWS opws;
        String tableName = "opws_" + cloudName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        if ((opws = (OPWS)mongoTemplate.findOne(query = new Query(), OPWS.class, tableName)) != null) {
            return opws.getThreadSize();
        }
        return 0L;
    }

    @Override
    public List<BackUpImage> getChildrenByFolder(int cloudId, String folderPath, String deviceUUID, String destCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
        List<BackUpImage> backupImageList = new ArrayList<BackUpImage>();
        List list = mongoTemplate.find(query, BackUpImage.class, destCollection);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            backupImageList.addAll(list);
        }
        backupImageList = this.getFilteredBackupImageListByGrouping(backupImageList);
        return backupImageList;
    }

    private List<ObjectId> getAggregatedBackupIds(int cloudId, MongoTemplate mongoTemplate, String folderPath, String deviceUUID, String destCollection) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        ArrayList<String> bkpCollectionList = new ArrayList<String>();
        bkpCollectionList.add(destCollection);
        ArrayList stateStatsList = new ArrayList();
        for (String dest : bkpCollectionList) {
            AggregationResults result = mongoTemplate.aggregate(aggregation, dest, Document.class);
            List list = result.getMappedResults();
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            stateStatsList.addAll(list);
        }
        ArrayList<ObjectId> listOfObjectIds = new ArrayList<ObjectId>();
        for (Document dbObject : stateStatsList) {
            Long lastServerModifiedTime;
            String devicePath;
            String fileName = dbObject.get((Object)FILE_NAME).toString();
            BackUpImage backUpImage = this.getBackUpImageForFile(cloudId, deviceUUID, destCollection, mongoTemplate, fileName, devicePath = dbObject.get((Object)DEVICE_PATH).toString(), lastServerModifiedTime = (Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME));
            if (backUpImage == null) continue;
            listOfObjectIds.add(backUpImage.getId());
        }
        return listOfObjectIds;
    }

    private BackUpImage getBackUpImageForFile(int cloudId, String deviceUUID, String destCollection, MongoTemplate mongoTemplate, String fileName, String devicePath, Long serverModifiedTime) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).is((Object)serverModifiedTime)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        ArrayList backUpImageList = new ArrayList();
        ArrayList<String> bkpCollectionList = new ArrayList<String>();
        bkpCollectionList.add(destCollection);
        for (String dest : bkpCollectionList) {
            List list = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            backUpImageList.addAll(list);
        }
        if (!CollectionUtils.isEmpty(backUpImageList)) {
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    private List<BackUpImage> getFilteredBackupImageListByGrouping(List<BackUpImage> backUpImages) {
        logger.debug("Inside grouping backup images");
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getFileName)).entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    @Override
    public void saveOfficeBackupPolicy(int cloudId, OfficeBackupPolicy officeBackupPolicy) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)officeBackupPolicy.getId()));
        this.msgMongoTemplate.findAndRemove(query, OfficeBackupPolicy.class);
        this.msgMongoTemplate.save((Object)officeBackupPolicy);
        if (!CollectionUtils.isEmpty(officeBackupPolicy.getBackupFolders())) {
            officeBackupPolicy.getBackupFolders().forEach(folders -> {
                if (folders != null) {
                    logger.debug("... MailBackupFolders..... " + folders.getFolderPath());
                    try {
                        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)folders.getId()));
                        this.msgMongoTemplate.findAndRemove(query1, BackupFolders.class);
                        this.msgMongoTemplate.save(folders);
                    }
                    catch (MongoException mongoException) {
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(officeBackupPolicy.getSchedules())) {
            officeBackupPolicy.getSchedules().forEach(schedules -> {
                if (schedules != null) {
                    try {
                        logger.debug("... MailSchedules..... " + schedules.getTime());
                        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)schedules.getId()));
                        this.msgMongoTemplate.findAndRemove(query1, Schedule.class);
                        this.msgMongoTemplate.save(schedules);
                    }
                    catch (MongoException mongoException) {
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(officeBackupPolicy.getExcludedFolders())) {
            officeBackupPolicy.getExcludedFolders().forEach(excludedFolders -> {
                if (excludedFolders != null) {
                    try {
                        logger.debug("... MailExcludedFolders..... " + excludedFolders.getFolderPath());
                        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)excludedFolders.getId()));
                        this.msgMongoTemplate.findAndRemove(query1, ExcludedFolders.class);
                        this.msgMongoTemplate.save(excludedFolders);
                    }
                    catch (MongoException mongoException) {
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            });
        }
        if (officeBackupPolicy.getInclusionFilter() != null) {
            for (InclusionFilter inclusionFilter : officeBackupPolicy.getInclusionFilter()) {
                try {
                    Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)inclusionFilter.getId()));
                    this.msgMongoTemplate.findAndRemove(query1, InclusionFilter.class);
                    this.msgMongoTemplate.save((Object)inclusionFilter);
                }
                catch (MongoException mongoException) {
                }
                catch (DuplicateKeyException duplicateKeyException) {
                }
                catch (Exception exception) {
                }
                catch (Error error) {}
            }
        }
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyFromLocal(int cloudId, String policyName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"policyName").is((Object)policyName));
        return (OfficeBackupPolicy)this.msgMongoTemplate.findOne(query, OfficeBackupPolicy.class);
    }

    @Override
    public BackUpImage getBackupImageFolderForItemId(int cloudId, String itemId, String deviceDestCollection) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"odItemId").is((Object)itemId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
        logger.debug("..... for item id vla ..... " + itemId + "... " + deviceDestCollection);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            logger.debug("..... for list size ..... " + list.size());
        } else {
            logger.debug("... no files.... " + itemId);
        }
        BackUpImage backUpImage = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            if (list.size() > 1) {
                logger.debug(".... folder filter..... ");
                List bkpImageList = list.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).collect(Collectors.toList());
                backUpImage = (BackUpImage)bkpImageList.get(0);
                logger.debug(".... folder filter. after .... " + backUpImage.getDevicePath() + "/" + backUpImage.getFileName());
            } else {
                backUpImage = (BackUpImage)list.get(0);
                logger.debug("..... item to be deleted .... " + backUpImage.getOdItemId() + "...." + backUpImage.getId());
            }
        }
        return backUpImage;
    }

    @Override
    public void saveFolderItem(FolderFileInfo folderFileInfo) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"itemPath").is((Object)folderFileInfo.getItemPath()), Criteria.where((String)"deviceUUID").is((Object)folderFileInfo.getDeviceUUID())});
        Query query = new Query((CriteriaDefinition)criteria);
        this.msgMongoTemplate.findAndRemove(query, FolderFileInfo.class);
        this.msgMongoTemplate.save((Object)folderFileInfo);
    }

    @Override
    public String getFolderItemId(String path, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"itemPath").is((Object)path), Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        FolderFileInfo folderFileInfo = (FolderFileInfo)this.msgMongoTemplate.findOne(query, FolderFileInfo.class);
        String folderItemId = "";
        if (folderFileInfo != null) {
            folderItemId = folderFileInfo.getItemId();
        }
        logger.debug(".... item path .... " + path + "...id from table..." + folderItemId);
        return folderItemId;
    }

    @Override
    public List<ODBBackupBatch> getCurrentBatch(String policyName, String userName, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)STATUS).is((Object)COMPLETED), Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.msgMongoTemplate.find(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    public String getDatabaseName() {
        return "parablumsg";
    }

    public MongoClient mongoClient() {
        MongoCredential credential = MongoCredential.createCredential((String)"neil", (String)this.getDatabaseName(), (char[])"parablu".toCharArray());
        MongoClientOptions options = MongoClientOptions.builder().build();
        MongoClient client = new MongoClient(Arrays.asList(new ServerAddress(PCHelperConstant.getPropertyValueDBHost1().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort1().trim())), new ServerAddress(PCHelperConstant.getPropertyValueDBHost2().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort2().trim())), new ServerAddress(PCHelperConstant.getPropertyValueDBHost3().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort3().trim()))), credential, options);
        return client;
    }

    public MongoDbFactory mongoDbFactory() {
        return new SimpleMongoDbFactory(this.mongoClient(), this.getDatabaseName());
    }

    public MongoTemplate mongoTemplate() {
        return new MongoTemplate(this.mongoDbFactory());
    }

    public MSAppBluKrypt getMsAppBluKrypt() {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        List findAllOdPolicies = mongoTemplate.findAll(OfficeBackupPolicy.class);
        String msAppBluKrypt = this.getMsAppBlukrypt(findAllOdPolicies);
        logger.debug("...msapp blukrypt ... " + msAppBluKrypt);
        MSAppBluKrypt msBluKrypt = null;
        if (!StringUtils.isEmpty((String)msAppBluKrypt)) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"host").is((Object)msAppBluKrypt));
            msBluKrypt = (MSAppBluKrypt)mongoTemplate.findOne(query, MSAppBluKrypt.class);
        }
        return msBluKrypt;
    }

    private String getMsAppBlukrypt(List<OfficeBackupPolicy> findAllOdPolicies) {
        String msAppBluKrypt = "";
        for (OfficeBackupPolicy oneDriveBackupPolicy : findAllOdPolicies) {
            if (oneDriveBackupPolicy == null) continue;
            if (!StringUtils.isEmpty((String)oneDriveBackupPolicy.getMsAppBluKrypt()) && oneDriveBackupPolicy.getMsAppBluKrypt().equalsIgnoreCase(PCHelperConstant.getComponentName())) {
                msAppBluKrypt = oneDriveBackupPolicy.getMsAppBluKrypt();
                break;
            }
            if (StringUtils.isEmpty((String)oneDriveBackupPolicy.getMsAppBluKrypt()) || !oneDriveBackupPolicy.getMsAppBluKrypt().equalsIgnoreCase(PCHelperConstant.getComponentName())) continue;
            msAppBluKrypt = oneDriveBackupPolicy.getMsAppBluKrypt();
            break;
        }
        return msAppBluKrypt;
    }

    @Override
    public String getDeltaLinkForPathAndUser(String path, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"path").is((Object)path), Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        DeltaPath deltaPath = (DeltaPath)mongoTemplate.findOne(query, DeltaPath.class);
        if (deltaPath == null && (deltaPath = (DeltaPath)this.msgMongoTemplate.findOne(query, DeltaPath.class)) != null) {
            mongoTemplate.save((Object)deltaPath);
            this.msgMongoTemplate.remove((Object)deltaPath);
        }
        String delta = "";
        if (deltaPath != null) {
            delta = deltaPath.getDeltaLink();
        }
        return delta;
    }

    @Override
    public List<DeltaPath> getAllDeltaLinkUser(String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        List list = mongoTemplate.find(query, DeltaPath.class);
        if (CollectionUtils.isEmpty((Collection)list) && !CollectionUtils.isEmpty((Collection)(list = this.msgMongoTemplate.find(query, DeltaPath.class)))) {
            for (DeltaPath deltaPath : list) {
                if (deltaPath == null) continue;
                mongoTemplate.save((Object)deltaPath);
                this.msgMongoTemplate.remove((Object)deltaPath);
            }
        }
        return mongoTemplate.find(query, DeltaPath.class);
    }

    @Override
    public void updateDeltaForPathAndUser(String path, String userName, String messDeltaLink) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"path").is((Object)path), Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        DeltaPath existPath = (DeltaPath)mongoTemplate.findOne(query, DeltaPath.class);
        logger.debug("...deltapath .." + userName + ".." + path + "..." + messDeltaLink);
        if (existPath == null) {
            existPath = new DeltaPath();
            existPath.setPath(path);
            existPath.setUserName(userName);
            existPath.setDeltaLink(messDeltaLink);
            mongoTemplate.save((Object)existPath);
        } else {
            Update update = new Update();
            update.set("deltaLink", (Object)messDeltaLink);
            UpdateResult updateFirst = mongoTemplate.updateFirst(query, update, DeltaPath.class);
            logger.debug(updateFirst.getModifiedCount() + "...updated successfully.... " + path + "..." + userName);
        }
    }

    @Override
    public ObjectId saveEventHubAction(int cloudId, EventHub eventHub) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        EventHub save = (EventHub)mongoTemplate.save((Object)eventHub);
        return save.getId();
    }

    @Override
    public void saveStatisticToDatabase(int cloudId, AuditHistory auditHistory) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)auditHistory);
    }

    @Override
    public void saveEwsAppSetting(int cloudId, EWSAppSetting appSetting) {
        Query query;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MSAppSetting msAppSetting = (MSAppSetting)mongoTemplate.findOne(query = new Query(), MSAppSetting.class);
        if (msAppSetting != null) {
            appSetting.setTenantId(msAppSetting.getTenantId());
        }
        mongoTemplate.remove(EWSAppSetting.class);
        mongoTemplate.save((Object)appSetting);
    }

    @Override
    public EWSAppSetting getEwsAppSettingDetail(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query();
        return (EWSAppSetting)mongoTemplate.findOne(query, EWSAppSetting.class);
    }

    @Override
    public void deleteBackupImageForItemId(int cloudId, String itemId, String deviceDestCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"odItemId").is((Object)itemId)});
        Query query = new Query((CriteriaDefinition)andCriteria);
        mongoTemplate.findAndRemove(query, BackUpImage.class, deviceDestCollection);
    }

    @Override
    public long getTotalFilesCountByBatchId(String batchId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"backupBatchId").is((Object)batchId));
        return this.msgMongoTemplate.count(query, DriveFileInfo.class);
    }

    @Override
    public List<DriveFileInfo> getOneDriveFileInfoFromListForBatchId(int cloudId, String batchId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"backupBatchId").is((Object)batchId));
        query.limit(1);
        return this.msgMongoTemplate.find(query, DriveFileInfo.class);
    }

    @Override
    public void updateDeferedBatchStatusInOdServer(ObjectId id, String policyName) {
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        String oldTable = "BACKUP_BATCH_" + policyName.toUpperCase();
        ODBBackupBatch odbBackupBatch = (ODBBackupBatch)this.msgMongoTemplate.findOne(query, ODBBackupBatch.class, oldTable);
        this.msgMongoTemplate.remove((Object)odbBackupBatch, oldTable);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)odbBackupBatch.getDeviceUUID())});
        query = new Query((CriteriaDefinition)criteria);
        logger.debug(id + "....odbBackupBatch deviceuid...." + odbBackupBatch.getDeviceUUID());
        Device device = (Device)mongoTemplate.findOne(query, Device.class);
        criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)device.getUserName())});
        query = new Query((CriteriaDefinition)criteria);
        User user = (User)mongoTemplate.findOne(query, User.class);
        String newPolicyName = "";
        if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.toString())) {
            newPolicyName = user.getOneDrivePolicyName();
        }
        if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.toString())) {
            newPolicyName = user.getExchangePolicyName();
        }
        if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.toString())) {
            newPolicyName = user.getSpPolicyName();
        }
        odbBackupBatch.setStatus("DEFERRED");
        this.msgMongoTemplate.save((Object)odbBackupBatch, "BACKUP_BATCH_" + newPolicyName.toUpperCase());
        logger.debug("... DEFERRED successfully.... " + policyName + "..." + newPolicyName);
    }

    @Override
    public void updateLicenseExpiredBatchStatusInOdServer(ObjectId id, String policyName) {
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(STATUS, (Object)"LICENSEEXPIRED");
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getModifiedCount() + "... DEFERRED successfully.... " + policyName + "..." + id);
    }

    @Override
    public boolean isPrevBkpDeferred(String actionToDeviceUUID, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)actionToDeviceUUID), Criteria.where((String)STATUS).is((Object)"DEFERRED")});
        Query query = new Query((CriteriaDefinition)criteria);
        ODBBackupBatch bkpBatch = (ODBBackupBatch)this.msgMongoTemplate.findOne(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        boolean isPrevBkpPaused = false;
        if (bkpBatch != null && "DEFERRED".equalsIgnoreCase(bkpBatch.getStatus())) {
            isPrevBkpPaused = true;
        }
        return isPrevBkpPaused;
    }

    @Override
    public void updateDeferredBkp(String actionToDeviceUUID, String policyName) {
        Criteria criteria = Criteria.where((String)"deviceUUID").is((Object)actionToDeviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(STATUS, (Object)COMPLETED);
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getMatchedCount() + "... un deferred successfully.... " + policyName + "..." + actionToDeviceUUID);
    }

    @Override
    public long getTotaFailedlFilesFromPrevBackup(String deviceUUID) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"deviceUUID").is((Object)deviceUUID));
        query.limit(50);
        logger.debug("getTotaFailedlFilesFromPrevBackup count...");
        return this.msgMongoTemplate.count(query, DriveFileInfo.class, "RETRY_FAILED_FILES");
    }

    @Override
    public void removeFailedFile(String itemId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)itemId));
        this.msgMongoTemplate.findAndRemove(query, DriveFileInfo.class, "RETRY_FAILED_FILES");
    }

    @Override
    public List<ODBBackupBatch> getBatchList(String policyName, int limit) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)STATUS).is((Object)COMPLETED));
        query.limit(limit);
        return this.msgMongoTemplate.find(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    @Override
    public long getTotalSizeByBatchId(String batchId) {
        long totalSize = 0L;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"backupBatchId").is((Object)batchId)});
        TypedAggregation aggregation = Aggregation.newAggregation(DriveFileInfo.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"id"}).sum("size").as("size"), Aggregation.project((String[])new String[]{"size"})});
        AggregationResults result = this.msgMongoTemplate.aggregate(aggregation, Document.class);
        List overViewList = result.getMappedResults();
        for (Document dbObject : overViewList) {
            totalSize += ((Long)dbObject.get((Object)"size")).longValue();
        }
        return totalSize;
    }

    @Override
    public void saveDriveFileInfo(DriveFileInfo driveFileInfo) {
        this.msgMongoTemplate.save((Object)driveFileInfo);
        this.removeFailedFile(driveFileInfo.getId().toString());
    }

    @Override
    public List<DriveFileInfo> getPrevBatchFailedFiles(String deviceUUID) {
        Criteria criteria = new Criteria();
        logger.debug("......getPrevBatchFailedFiles....." + deviceUUID);
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.msgMongoTemplate.find(query, DriveFileInfo.class);
    }

    @Override
    public List<EventHub> getStartBackupEventHubListForBlukrypt(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria odStatusCriteria = new Criteria();
        odStatusCriteria.orOperator(new Criteria[]{Criteria.where((String)"odStatus").is((Object)STATUS_STARTED)});
        andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria});
        Query query = new Query((CriteriaDefinition)andCriteria);
        List list = mongoTemplate.find(query, EventHub.class);
        logger.debug("...empty events so try if any orphaned events lastUpdatedTime11...");
        andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria});
        query = new Query((CriteriaDefinition)andCriteria);
        List oldlist = mongoTemplate.find(query, EventHub.class);
        list.addAll(oldlist);
        if (!CollectionUtils.isEmpty((Collection)oldlist)) {
            logger.debug(list.size() + "....overall list ..lastUpdatedTime.." + oldlist.size());
        }
        return list;
    }

    @Override
    public void removeOldEventHub(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria odStatusCriteria = new Criteria();
        odStatusCriteria.orOperator(new Criteria[]{Criteria.where((String)"odStatus").is((Object)STATUS_STARTED), Criteria.where((String)"odStatus").is((Object)"PROCESSED")});
        andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria, Criteria.where((String)"blukryptName").is((Object)PCHelperConstant.getComponentName())});
        Query query = new Query((CriteriaDefinition)andCriteria);
        logger.debug("...remove all old eventhub..... ");
        mongoTemplate.findAllAndRemove(query, EventHub.class);
    }

    @Override
    public void deleteEventHub(int cloudId, ObjectId eventHubId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)eventHubId)});
        Query query = new Query((CriteriaDefinition)andCriteria);
        logger.debug("...remove eventhub..... " + eventHubId);
        mongoTemplate.findAllAndRemove(query, EventHub.class);
    }

    @Override
    public void updateEventHubTime(int cloudId, String eventHubId) {
        Criteria criteria = Criteria.where((String)"id").is((Object)eventHubId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("lastUpdatedTime", (Object)System.currentTimeMillis());
        update.set("blukryptName", (Object)PCHelperConstant.getComponentName());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UpdateResult updateFirst = mongoTemplate.updateFirst(query, update, EventHub.class);
    }

    @Override
    public BackUpImage getBackupImageFolder(int cloudId, String parentpath, String child, String deviceDestCollection, String deviceUUID) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)child)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)FILE_NAME).is((Object)parentpath), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)"folder").is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)parentpath), Criteria.where((String)FILE_NAME).is((Object)child), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)"folder").is((Object)true)});
        }
        Query query1 = new Query((CriteriaDefinition)criteria);
        BackUpImage backupImage = (BackUpImage)mongoTemplate.findOne(query1, BackUpImage.class, deviceDestCollection);
        return backupImage;
    }

    @Override
    public void saveDeletedBackupImageForMail(int cloudId, BackUpImage deletedBkpImage, String deviceDestCollection) {
        Query query;
        Criteria criteria;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = new ArrayList();
        if (deletedBkpImage.isFolder()) {
            criteria = new Criteria();
            if (!StringUtils.isEmpty((String)deletedBkpImage.getDevicePath())) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deletedBkpImage.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)deletedBkpImage.getDevicePath()), Criteria.where((String)FILE_NAME).is((Object)deletedBkpImage.getFileName()), Criteria.where((String)"folder").is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deletedBkpImage.getDeviceUUID()), Criteria.where((String)FILE_NAME).is((Object)deletedBkpImage.getFileName()), Criteria.where((String)"folder").is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
            }
            logger.debug(deletedBkpImage.getDevicePath() + "..deletechildcritelist.." + deletedBkpImage.getFileName());
            query = new Query((CriteriaDefinition)criteria);
            list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
            logger.debug("..deletechildlist.." + list.size());
        } else {
            logger.debug("..deletechild.." + deletedBkpImage.getOdItemId());
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deletedBkpImage.getDeviceUUID()), Criteria.where((String)"odItemId").is((Object)deletedBkpImage.getOdItemId()), Criteria.where((String)PRESENT).is((Object)true)});
            query = new Query((CriteriaDefinition)criteria);
            list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
            logger.debug("..deletechildlist file.." + list.size());
        }
        if (!CollectionUtils.isEmpty(list)) {
            for (BackUpImage backUpImage : list) {
                logger.debug("...updating to false...." + backUpImage.getId().toString());
                backUpImage.setPresent(false);
                mongoTemplate.save((Object)backUpImage, deviceDestCollection);
            }
        }
        mongoTemplate.save((Object)deletedBkpImage, deviceDestCollection);
    }

    @Override
    public void deleteMailsForPath(int cloudId, String newPathVal, String deviceUUID, String deviceDestCollection) {
        this.deleteMailsForPathNew(cloudId, newPathVal, deviceUUID, deviceDestCollection);
    }

    public void deleteMailsForPathNew(int cloudId, String newPathVal, String deviceUUID, String deviceDestCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        boolean filesExist = false;
        do {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)newPathVal), Criteria.where((String)PRESENT).is((Object)true)});
            Query query = new Query((CriteriaDefinition)criteria);
            query.limit(50);
            List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                logger.debug(newPathVal + "...still more mails to delete..." + list.size());
                for (BackUpImage backUpImage : list) {
                    if (backUpImage == null) continue;
                    BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImage);
                    this.saveDeletedBackupImageForMail(cloudId, deletedBkpImage, deviceDestCollection);
                    filesExist = true;
                }
            } else {
                filesExist = false;
                logger.debug(newPathVal + "...no more mails to delete...");
            }
        } while (filesExist);
    }

    private BackUpImage convertToBkpImage(String deviceUUID, BackUpImage backUpImageold) {
        BackUpImage backUpImageDeleted = new BackUpImage();
        BeanUtils.copyProperties((Object)backUpImageold, (Object)backUpImageDeleted);
        backUpImageDeleted.setId(null);
        long timeMilliSec = System.currentTimeMillis();
        backUpImageDeleted.setDevicePath(backUpImageold.getDevicePath());
        backUpImageDeleted.setFileName(backUpImageold.getFileName());
        backUpImageDeleted.setDeviceUUID(deviceUUID);
        backUpImageDeleted.setLastServerModifiedTime(timeMilliSec);
        backUpImageDeleted.setFolder(backUpImageold.isFolder());
        backUpImageDeleted.setMd5Checksum(backUpImageold.getMd5Checksum());
        backUpImageDeleted.setPresent(false);
        backUpImageDeleted.setfSPath(backUpImageold.getfSPath());
        backUpImageDeleted.setUserName(backUpImageold.getUserName());
        backUpImageDeleted.setStatus(PCHelperConstant.REVISION_STATUS.DELETED.toString());
        backUpImageDeleted.setLastClientModifiedTime(backUpImageold.getLastClientModifiedTime());
        backUpImageDeleted.setBaseBackup(false);
        backUpImageDeleted.setSize(backUpImageold.getSize());
        backUpImageDeleted.setOdItemId(backUpImageold.getOdItemId());
        backUpImageDeleted.setGatewayName(backUpImageold.getGatewayName());
        backUpImageDeleted.setSubject(backUpImageold.getSubject());
        backUpImageDeleted.setFrom(backUpImageold.getFrom());
        backUpImageDeleted.setBodyContent(backUpImageold.getBodyContent());
        backUpImageDeleted.setBccRecipients(backUpImageold.getBccRecipients());
        backUpImageDeleted.setCcRecipients(backUpImageold.getCcRecipients());
        backUpImageDeleted.setToRecipients(backUpImageold.getToRecipients());
        backUpImageDeleted.setHasAttachments(backUpImageold.isHasAttachments());
        backUpImageDeleted.setTaskSubject(backUpImageold.getTaskSubject());
        backUpImageDeleted.setTaskStartDate(backUpImageold.getTaskStartDate());
        backUpImageDeleted.setTaskReminderTime(backUpImageold.getTaskReminderTime());
        backUpImageDeleted.setTaskDueDate(backUpImageold.getTaskDueDate());
        backUpImageDeleted.setContactMobile(backUpImageold.getContactMobile());
        backUpImageDeleted.setContactAddrStreet(backUpImageold.getContactAddrStreet());
        backUpImageDeleted.setContactAddrCity(backUpImageold.getContactAddrCity());
        backUpImageDeleted.setContactAddrState(backUpImageold.getContactAddrState());
        backUpImageDeleted.setContactAddrCountry(backUpImageold.getContactAddrCountry());
        backUpImageDeleted.setContactAddrPostalCode(backUpImageold.getContactAddrPostalCode());
        backUpImageDeleted.setChunkFiles(backUpImageold.getChunkFiles());
        boolean isMail = false;
        if (backUpImageold.isMail()) {
            isMail = true;
            backUpImageDeleted.setEwsId(backUpImageold.getEwsId());
        }
        backUpImageDeleted.setMail(isMail);
        return backUpImageDeleted;
    }

    @Override
    public void updatePrevBatch(String deviceUUID, String batchId) {
        Criteria criteria2 = Criteria.where((String)"deviceUUID").is((Object)deviceUUID);
        Query query = new Query((CriteriaDefinition)criteria2);
        Update updateObj = new Update();
        updateObj.set("backupBatchId", (Object)batchId);
        UpdateResult updateMulti = this.msgMongoTemplate.updateMulti(query, updateObj, DriveFileInfo.class);
        logger.debug("...update records for device...." + updateMulti.getModifiedCount());
    }

    @Override
    public BackUpImage getDeletedBkpImageforPathandFile(int cloudId, String deviceUUID, String devicePath, String fileName, String deviceDestCollection) {
        BackUpImage backUpImageDeleted = null;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)STATUS).is((Object)"DELETED")});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            backUpImageDeleted = (BackUpImage)list.get(0);
        }
        return backUpImageDeleted;
    }

    @Override
    public void deleteBatchFromOdServer(String deviceUUID, long batchStartTime, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)BATCH_START_TIME_STAMP).is((Object)batchStartTime)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.msgMongoTemplate.findAndRemove(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    public List<BackUpImage> getBackupFolderForBasePath(int cloudId, String deviceUUID, String devicePath, String destCollection) {
        ArrayList<BackUpImage> backupImageList = new ArrayList();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"folder").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        backupImageList = mongoTemplate.find(query, BackUpImage.class, destCollection);
        return backupImageList;
    }

    public void getAllFolderChildrenByDevicePath(int cloudId, String deviceUUID, String filePath, String deviceDestCollection, List<BackUpImage> backupImages) {
        List<BackUpImage> backUpImagesTemp = this.getBackupFolderForBasePath(cloudId, deviceUUID, filePath, deviceDestCollection);
        backupImages.addAll(backUpImagesTemp);
        logger.debug("...folders for path ....." + filePath + "..." + backupImages.size());
        if (!CollectionUtils.isEmpty(backUpImagesTemp)) {
            Stream stream = backUpImagesTemp.parallelStream();
            stream.forEach(backUpImage -> {
                String devicePath = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                logger.debug("Inside loop after getting folders..bkpimages list size:" + backUpImagesTemp.size());
                if (StringUtils.isEmpty((String)backUpImage.getDevicePath())) {
                    devicePath = backUpImage.getFileName();
                }
                logger.debug("Inside loop to get immediate folders deevicePath:" + devicePath);
                this.getAllFolderChildrenByDevicePath(cloudId, deviceUUID, devicePath, deviceDestCollection, backupImages);
            });
        }
    }

    @Override
    public void deleteAllFilesUnderFolder(int cloudId, String newPathVal, String deviceUUID, String deviceDestCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        ArrayList<BackUpImage> backupImages = new ArrayList<BackUpImage>();
        this.getAllFolderChildrenByDevicePath(cloudId, deviceUUID, newPathVal, deviceDestCollection, backupImages);
        List<BackUpImage> list = this.getRestBackupFilesForGivenPathfromBackupImage(cloudId, newPathVal, deviceUUID, deviceDestCollection);
        int i = 0;
        logger.debug("....before adding parent file list..");
        ArrayList<BackUpImage> delList = new ArrayList<BackUpImage>();
        for (BackUpImage image : list) {
            ++i;
            BackUpImage deletedBkpImage = this.convertToBkpImage(image.getDeviceUUID(), image);
            delList.add(deletedBkpImage);
        }
        if (!CollectionUtils.isEmpty(delList)) {
            BulkOperations localbulkOps = mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, BackUpImage.class, deviceDestCollection);
            localbulkOps.insert(delList);
            localbulkOps.execute();
        }
        for (BackUpImage image : backupImages) {
            logger.debug("....folders to parse...." + image.getDevicePath() + "/" + image.getFileName());
        }
        for (BackUpImage folderimage : backupImages) {
            String newPath = folderimage.getDevicePath() + "/" + folderimage.getFileName();
            list = this.getRestBackupFilesForGivenPathfromBackupImage(cloudId, newPath, deviceUUID, deviceDestCollection);
            i = 0;
            delList = new ArrayList();
            logger.debug("....before adding sub folder parent file list.." + newPath);
            for (BackUpImage image : list) {
                ++i;
                BackUpImage deletedBkpImage = this.convertToBkpImage(image.getDeviceUUID(), image);
                delList.add(deletedBkpImage);
            }
            if (CollectionUtils.isEmpty(delList)) continue;
            BulkOperations localbulkOps = mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, BackUpImage.class, deviceDestCollection);
            localbulkOps.insert(delList);
            localbulkOps.execute();
        }
    }

    @Override
    public BackUpImage getBackupImageFolderForItemIdForModified(int cloudId, String itemId, String deviceDestCollection) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"odItemId").is((Object)itemId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
        logger.debug("..... for item id vla ..... " + itemId + "... " + deviceDestCollection);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            logger.debug("..... for list size ..... " + list.size());
        } else {
            logger.debug("... no files.... " + itemId);
        }
        BackUpImage backUpImage = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            if (list.size() > 1) {
                logger.debug(".... folder filter..... ");
                List bkpImageList = list.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).collect(Collectors.toList());
                backUpImage = (BackUpImage)bkpImageList.get(0);
                logger.debug(".... folder filter. after .... " + backUpImage.getDevicePath() + "/" + backUpImage.getFileName());
            } else {
                backUpImage = (BackUpImage)list.get(0);
                logger.debug("..... item to be deleted .... " + backUpImage.getOdItemId() + "...." + backUpImage.getId());
            }
        }
        return backUpImage;
    }

    public List<BackUpImage> getRestBackupFilesForGivenPathfromBackupImage(int cloudId, String folderPath, String deviceUUID, String dest) {
        List<Object> list = new ArrayList();
        ArrayList<BackUpImage> bkpImages = new ArrayList<BackUpImage>();
        try {
            logger.debug("RESTORE-QUERY ..getBackupFilesForGivenPathfromBackupImage..........");
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath)});
            Query query = new Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
            List results = mongoTemplate.find(query, BackUpImage.class, dest);
            if (!CollectionUtils.isEmpty((Collection)results)) {
                list.addAll(results);
            }
            bkpImages.addAll(list);
            logger.debug("....count of list..." + list.size());
            list = this.getFilteredLatestVersionBackupImageList(bkpImages, false);
            logger.debug("....count of list after ..." + list.size());
            logger.error("##End getBackupFilesForGivenPathfromBackupImage ..........");
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" Exception while getting filefrom backupimage:" + e.getMessage());
            return null;
        }
        return list;
    }

    private List<BackUpImage> getFilteredLatestVersionBackupImageList(List<BackUpImage> backUpImages, boolean restoreDeletedFiles) {
        logger.debug("Inside grouping backup images....");
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        ArrayList deltedBackUpImages = new ArrayList();
        ArrayList<BackUpImage> deletedBackUpImagesList = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        for (BackUpImage filteredBackUpImage : filteredBackUpImages) {
            if (filteredBackUpImage.isPresent()) {
                filteredBackUpImagesList.add(filteredBackUpImage);
                continue;
            }
            deletedBackUpImagesList.add(filteredBackUpImage);
        }
        if (restoreDeletedFiles) {
            for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
                entry.getValue().entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).filter(p1 -> p1.isPresent()).findFirst().get()));
            }
            for (BackUpImage bkpimage : deletedBackUpImagesList) {
                for (BackUpImage bkpimage1 : deltedBackUpImages) {
                    if (!bkpimage.getFileName().equals(bkpimage1.getFileName()) || !bkpimage.getDevicePath().equals(bkpimage1.getDevicePath())) continue;
                    bkpimage1.setPresent(false);
                    filteredBackUpImagesList.add(bkpimage1);
                }
            }
        }
        return filteredBackUpImagesList;
    }

    @Override
    public void deletedeltPathForUser(String path, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"path").is((Object)path), Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, DeltaPath.class);
        logger.debug("...deletedeltapath .." + userName + ".." + path);
    }

    @Override
    public void updateOverViewStatus(int cloudId, String actionToDeviceUUID, int errorCode) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)actionToDeviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("reason", (Object)("" + errorCode));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
    }

    @Override
    public SiteDeltaPath getDeltaTokenForSiteAndList(String siteId, String listId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"siteId").is((Object)siteId), Criteria.where((String)"listId").is((Object)listId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        SiteDeltaPath deltaPath = (SiteDeltaPath)mongoTemplate.findOne(query, SiteDeltaPath.class);
        return deltaPath;
    }

    @Override
    public void updateDeltaTokenForSiteAndList(String siteId, String listId, String deltaToken, String siteName) {
        Criteria criteria = new Criteria();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        criteria.andOperator(new Criteria[]{Criteria.where((String)"siteId").is((Object)siteId), Criteria.where((String)"listId").is((Object)listId)});
        Query query = new Query((CriteriaDefinition)criteria);
        SiteDeltaPath existPath = (SiteDeltaPath)mongoTemplate.findOne(query, SiteDeltaPath.class);
        logger.debug("...deltapath .." + siteId + ".." + listId + "..." + deltaToken);
        if (existPath == null) {
            existPath = new SiteDeltaPath();
            existPath.setSiteId(siteId);
            existPath.setListId(listId);
            existPath.setSiteName(siteName);
            existPath.setDeltaToken(deltaToken);
            mongoTemplate.save((Object)existPath);
        } else {
            Update update = new Update();
            update.set("deltaToken", (Object)deltaToken);
            UpdateResult updateFirst = mongoTemplate.updateFirst(query, update, SiteDeltaPath.class);
            logger.debug(updateFirst.getModifiedCount() + "...updated successfully.... " + siteId + "..." + listId);
        }
    }

    @Override
    public BackupBatch getLastBackupOnly(int cloudId, String userName, String deviceUUID) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)JOB_TYPE).is((Object)BACK_UP)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    @Override
    public void getPrevBatchFailedFilesAndUpdate(String deviceUUID, String batchId) {
        Criteria criteria = new Criteria();
        logger.debug("......getPrevBatchFailedFiles....." + deviceUUID);
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("backupBatchId", (Object)batchId);
        UpdateResult updateMulti = this.msgMongoTemplate.updateMulti(query, update, DriveFileInfo.class);
    }

    @Override
    public List<String> getListIdsForSiteId(String siteId) {
        ArrayList<String> listIds = new ArrayList<String>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"siteId").is((Object)siteId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        List deltaPathList = mongoTemplate.find(query, SiteDeltaPath.class);
        if (!CollectionUtils.isEmpty((Collection)deltaPathList)) {
            for (SiteDeltaPath deltaPath : deltaPathList) {
                listIds.add(deltaPath.getListId());
            }
        }
        return listIds;
    }

    @Override
    public void deleteDeltaTokenForSiteAndList(String siteId, String listId) {
        Criteria criteria = new Criteria();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        criteria.andOperator(new Criteria[]{Criteria.where((String)"siteId").is((Object)siteId), Criteria.where((String)"listId").is((Object)listId)});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, SiteDeltaPath.class);
    }

    @Override
    public List<BackUpImage> getALLSubChildrenByFolder(int cloudId, String newPathVal, String deviceUUID, String deviceDestCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).regex("^" + newPathVal + "/", "i")});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
        List<BackUpImage> backupImageList = new ArrayList<BackUpImage>();
        List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            backupImageList.addAll(list);
        }
        backupImageList = this.getFilteredBackupImageListByGrouping(backupImageList);
        return backupImageList;
    }

    @Override
    public Device getDeviceInfoByUUID(int cloudId, String deviceUUID) {
        logger.debug("$$$$ Before getting device Info by UUID $$$$");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"deviceUUID").is((Object)deviceUUID));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        logger.debug("$$$$ After getting device Info by UUID $$$$");
        query.limit(1);
        List list = mongoTemplate.find(query, Device.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (Device)list.get(0);
        }
        return null;
    }

    private Device getDeviceFormDisplayName(Device device) {
        if (device != null && StringUtils.isNotEmpty((String)device.getDisplayName())) {
            String dispalyName = device.getDisplayName();
            device.setDisplayName(device.getDeviceName());
            device.setDeviceName(dispalyName);
        }
        return device;
    }

    @Override
    public void blockUnblockDevice(int cloudId, Device device, boolean isBlocked) {
        device.setBlocked(isBlocked);
        device.setLastModifiedTimestamp(System.currentTimeMillis());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)device);
        this.updateDeviceStatusInOverview(cloudId, device.getDeviceUUID(), !device.isBlocked());
    }

    public Device getDeviceInfoByUUID(int cloudId, String cloudName, String deviceUUID) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"deviceUUID").is((Object)deviceUUID));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceFormDisplayName((Device)mongoTemplate.findOne(query, Device.class));
    }

    public void updateDeviceStatusInOverview(int cloudId, String deviceUUID, boolean isDeviceActive) {
        User user;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        Device device = this.getDeviceInfoByUUID(cloudId, "", deviceUUID);
        Update update = new Update();
        if (device != null && (user = this.getUserByName(cloudId, device.getUserName())).isActive() && !isDeviceActive) {
            update.set("isUserActive", (Object)(!isDeviceActive ? 1 : 0));
        }
        update.set(IS_DEVICE_BOLCKED, (Object)isDeviceActive);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateMulti(query, update, DeviceBackupOverView.class);
    }

    public static boolean validateRegex(String regex) {
        boolean validRegex = false;
        try {
            Pattern pattern = Pattern.compile(regex);
            validRegex = true;
        }
        catch (PatternSyntaxException e) {
            logger.debug("..invalid regex....");
        }
        return validRegex;
    }

    public User getUserByName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public void blockOrUnblockUser(int cloudId, String userName, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        if (!active) {
            update.set("backupEnabled", (Object)false);
            update.set("syncEnabled", (Object)false);
            update.set("onedriveBkpEnabled", (Object)false);
            update.set("exchangeBkpEnabled", (Object)false);
        }
        update.set("active", (Object)active);
        logger.debug("....user update...." + active);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<SiteDeltaPath> getDeltaTokenForSite(String siteId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"siteId").is((Object)siteId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        return mongoTemplate.find(query, SiteDeltaPath.class);
    }

    @Override
    public UserPolicy getUserPolicy(String userName, String type) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"productType").is((Object)type)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        return (UserPolicy)mongoTemplate.findOne(query, UserPolicy.class);
    }

    @Override
    public void saveUserPolicy(UserPolicy userPolicy) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        mongoTemplate.save((Object)userPolicy);
    }

    @Override
    public void deleteUserPolicy(String userName, String policyType) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"productType").is((Object)policyType)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        mongoTemplate.remove(query, UserPolicy.class);
    }

    @Override
    public DriveFileInfo getFileInfoForBatch(String batchId) {
        logger.debug(this.msgMongoTemplate + "..batchid-val...." + batchId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"backupBatchId").is((Object)batchId));
        query.limit(50);
        List list = this.msgMongoTemplate.find(query, DriveFileInfo.class);
        DriveFileInfo driveFileInfo = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            driveFileInfo = (DriveFileInfo)list.get(0);
            logger.debug("....listsize..." + list.size());
        } else {
            logger.debug(".....listempty.....");
        }
        return driveFileInfo;
    }

    @Override
    public void deleteUserAfterBackup(UsersWOBackup usersWOBackup) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)usersWOBackup.getPolicyName()), Criteria.where((String)"productType").is((Object)usersWOBackup.getProductType()), Criteria.where((String)USER_NAME).is((Object)usersWOBackup.getUserName())});
        Query query = new Query((CriteriaDefinition)criteria);
        this.msgMongoTemplate.remove(query, UsersWOBackup.class);
    }

    @Override
    public void saveUserBeforeBackup(UsersWOBackup usersWOBackup) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)usersWOBackup.getPolicyName()), Criteria.where((String)"productType").is((Object)usersWOBackup.getProductType()), Criteria.where((String)USER_NAME).is((Object)usersWOBackup.getUserName())});
        Query query = new Query((CriteriaDefinition)criteria);
        this.msgMongoTemplate.remove(query, UsersWOBackup.class);
        this.msgMongoTemplate.save((Object)usersWOBackup);
    }

    @Override
    public String getEWSToken(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query();
        EWSToken ewsToken = (EWSToken)mongoTemplate.findOne(query, EWSToken.class);
        String token = "";
        if (ewsToken != null) {
            token = ewsToken.getToken();
        }
        return token;
    }

    @Override
    public void deleteOldBatchAndFiles(String deviceUUID, String policyName, String userName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"deviceUUID").is((Object)deviceUUID));
        List list = this.msgMongoTemplate.find(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (ODBBackupBatch odbBackupBatch : list) {
                MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
                Criteria criteria = Criteria.where((String)"id").is((Object)odbBackupBatch.getId());
                query = new Query((CriteriaDefinition)criteria);
                mongoTemplate.findAndRemove(query, BackupBatch.class);
                this.msgMongoTemplate.findAndRemove(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
                criteria = Criteria.where((String)"batchId").is((Object)odbBackupBatch.getId().toString());
                query = new Query((CriteriaDefinition)criteria);
                mongoTemplate.findAndRemove(query, BackupAttempt.class);
            }
        }
    }

    @Override
    public BackUpImage getBackupImageForItemIdAndVersionId(int cloudId, String itemId, String versionId, String deviceDestCollection, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)"odItemId").is((Object)itemId), Criteria.where((String)"versionId").is((Object)versionId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
        BackUpImage backUpImage = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            logger.debug("....size list...." + list.size());
            if (list.size() > 1) {
                for (BackUpImage image : list) {
                    logger.debug(image.getId().toString() + "..." + itemId + "....image status..." + image.getStatus());
                    if (!image.getStatus().equals("DELETED")) continue;
                    logger.debug("...item id already deleted...." + image.getOdItemId());
                    return null;
                }
                logger.debug(((BackUpImage)list.get(0)).getId().toString() + "..." + itemId + "....image status11..." + ((BackUpImage)list.get(0)).getStatus());
                if (((BackUpImage)list.get(0)).getStatus().equals("DELETED")) {
                    logger.debug("...item id already deleted...." + ((BackUpImage)list.get(0)).getOdItemId());
                    return null;
                }
                backUpImage = (BackUpImage)list.get(0);
            } else {
                backUpImage = (BackUpImage)list.get(0);
                logger.debug(backUpImage.getUserName() + "..path..." + backUpImage.getDevicePath() + "..... item to be deleted .... " + backUpImage.getOdItemId() + "...." + backUpImage.getId());
            }
        }
        return backUpImage;
    }

    @Override
    public void saveBatch(int cloudId, String batchId, String orgPolicyName, String policyName, String eventHubId, String newBlukrypt) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)batchId));
        ODBBackupBatch odbBackupBatch = (ODBBackupBatch)this.msgMongoTemplate.findOne(query, ODBBackupBatch.class, "BACKUP_BATCH_" + orgPolicyName.toUpperCase());
        if (odbBackupBatch != null) {
            if (!policyName.equalsIgnoreCase(orgPolicyName)) {
                this.msgMongoTemplate.save((Object)odbBackupBatch, "BACKUP_BATCH_" + policyName.toUpperCase());
                this.msgMongoTemplate.findAndRemove(query, ODBBackupBatch.class, "BACKUP_BATCH_" + orgPolicyName.toUpperCase());
            }
            Criteria criteria = Criteria.where((String)"id").is((Object)eventHubId);
            query = new Query((CriteriaDefinition)criteria);
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            List find = mongoTemplate.find(query, EventHub.class);
            if (find != null) {
                logger.debug("....find list ... " + find.size());
            }
            Update update = new Update();
            update.set("blukryptName", (Object)newBlukrypt);
            UpdateResult updateFirst = mongoTemplate.updateFirst(query, update, EventHub.class);
            logger.debug(updateFirst.getModifiedCount() + "...event hub updated successfully.... " + eventHubId);
        }
    }

    @Override
    public void checkAndDeleteCPFile(int cloudId, String id, String deviceUUID, String productType, BackUpImage deletedBkpImage, String deviceDestCollection) {
        CMBackUpImage cmBackUpImage;
        String dbName = "";
        String faildbName = "";
        if (productType.equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_SP";
            faildbName = "FAILED_CAPACITY_MGMT_BACKUP_SP";
        } else if (productType.equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_ODB";
            faildbName = "FAILED_CAPACITY_MGMT_BACKUP_ODB";
        } else if (productType.equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_OUTLOOK";
            faildbName = "FAILED_CAPACITY_MGMT_BACKUP_OUTLOOK";
        }
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)"odItemId").is((Object)id)});
        Query queryNew = new Query((CriteriaDefinition)andCriteria);
        List find = mongoTemplate.find(queryNew, CMBackUpImage.class, dbName);
        if (!CollectionUtils.isEmpty((Collection)find) && (cmBackUpImage = (CMBackUpImage)find.get(0)) != null) {
            mongoTemplate.remove((Object)cmBackUpImage);
            mongoTemplate.save((Object)deletedBkpImage, deviceDestCollection);
        }
    }

    @Override
    public void updateBkpBatchDetails(int cloudId, BackupBatch backupBatch, long batchStartTime) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"id").is((Object)backupBatch.getId());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(STATUS, (Object)backupBatch.getStatus());
        update.set("noOfFiles", (Object)backupBatch.getNoOfFiles());
        update.set("totalNoOfFiles", (Object)backupBatch.getTotalNoOfFiles());
        update.set("uploadedFiles", (Object)"0/0");
        update.set(BATCH_START_TIME_STAMP, (Object)batchStartTime);
        update.set("scanCompleted", (Object)true);
        update.set("errorCode", (Object)backupBatch.getErrorCode());
        UpdateResult updateFirst = mongoTemplate.updateFirst(query, update, BackupBatch.class);
        logger.debug(updateFirst.getModifiedCount() + "...updated successfully.... " + backupBatch.getId());
        Criteria criteria1 = new Criteria();
        criteria1.andOperator(new Criteria[]{Criteria.where((String)"batchId").is((Object)backupBatch.getId().toString()), Criteria.where((String)STATUS).is((Object)backupBatch.getStatus())});
        query = new Query((CriteriaDefinition)criteria1);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"id"}));
        query.limit(1);
        BackupAttempt bkpAttempt = (BackupAttempt)mongoTemplate.findOne(query, BackupAttempt.class);
        logger.debug(bkpAttempt.getStatus() + ".........attempt vla........" + bkpAttempt.toString());
        if (bkpAttempt != null && bkpAttempt.getStatus().equalsIgnoreCase(BackupBatch.STATUS.QUEUED.toString()) && backupBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.SCANNING.toString())) {
            logger.debug("....SCAN_QUEUE STATUS.....");
        } else if (bkpAttempt != null) {
            bkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
            mongoTemplate.save((Object)bkpAttempt);
            logger.debug("......lastattempt.....");
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public BackupAttempt getLastBackupAttemptById(int cloudId, String batchId) {
        Criteria criteria1 = Criteria.where((String)"batchId").is((Object)batchId);
        Query query = new Query((CriteriaDefinition)criteria1);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"id"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupAttempt)mongoTemplate.findOne(query, BackupAttempt.class);
    }

    @Override
    public long getTotalFilesCountByDeviceUUID(String deviceUUID) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"deviceUUID").is((Object)deviceUUID));
        return this.msgMongoTemplate.count(query, DriveFileInfo.class);
    }

    @Override
    public ODBBackupBatch getQueuedBatch(String deviceUUID, String policyName, String status) {
        ODBBackupBatch odbBackupBatch = null;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        String batchTable = "BACKUP_BATCH_" + policyName.toUpperCase();
        List list = this.msgMongoTemplate.find(query, ODBBackupBatch.class, batchTable);
        logger.debug(".....existing batch...." + deviceUUID + "...." + status);
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            odbBackupBatch = (ODBBackupBatch)list.get(0);
            logger.debug("***listval...**" + list.size());
        }
        return odbBackupBatch;
    }

    @Override
    public void updateMsgBatchStatus(ObjectId id, String policyName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        Update update = new Update();
        update.set(STATUS, (Object)PCHelperConstant.BACKUP_STATUS.STARTED);
        UpdateResult updateFirst = this.msgMongoTemplate.updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        update = new Update();
        query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        update.set(STATUS, (Object)PCHelperConstant.BACKUP_STATUS.SCANNING);
        mongoTemplate.updateFirst(query, update, BackupBatch.class);
    }

    @Override
    public List<EventHub> getStartBackupEventHubList(int cloudId, String deviceType) {
        logger.debug("...getStartBackupEventHubList...");
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria odStatusCriteria = new Criteria();
        odStatusCriteria.orOperator(new Criteria[]{Criteria.where((String)"odStatus").is((Object)STATUS_STARTED), Criteria.where((String)"odStatus").is((Object)"PROCESSED")});
        andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria, Criteria.where((String)"blukryptName").is((Object)PCHelperConstant.getComponentName())});
        Query query = new Query((CriteriaDefinition)andCriteria);
        List list = mongoTemplate.find(query, EventHub.class);
        logger.debug("...after getStartBackupEventHubList...");
        logger.debug("...empty events so try if any orphaned events lastUpdatedTime111...");
        andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria, Criteria.where((String)"lastUpdatedTime").is((Object)0)});
        query = new Query((CriteriaDefinition)andCriteria);
        List oldlist = mongoTemplate.find(query, EventHub.class);
        list.addAll(oldlist);
        ArrayList<EventHub> finalList = new ArrayList<EventHub>();
        for (EventHub eventHub : list) {
            if (!StringUtils.isEmpty((String)eventHub.getDeviceType()) && !deviceType.equalsIgnoreCase(eventHub.getDeviceType())) continue;
            long currentTime = System.currentTimeMillis();
            long eventTime = eventHub.getLastUpdatedTime();
            logger.debug(eventHub.getId().toString() + ".....event time..... " + currentTime + "..." + eventTime);
            if (eventTime == 0L) {
                long convertToTimestampFrom = MSUtilDaoImpl.convertToTimestampFrom(eventHub.getId().toString());
                logger.debug(eventHub.getActionToUserName() + "..user.." + eventHub.getId().toString() + "*********************EVETHUB-DATE..........." + convertToTimestampFrom);
                long diffSec = (currentTime - convertToTimestampFrom) / 1000L;
                long min = diffSec / 60L;
                logger.debug("......diff in time...." + min);
                if (min > 45L) {
                    logger.debug(".....deleting event...." + eventHub.getId().toString());
                    finalList.add(eventHub);
                }
            }
            if (eventTime <= 0L || currentTime - eventTime <= 0L) continue;
            long diffSec = (currentTime - eventTime) / 1000L;
            long min = diffSec / 60L;
            logger.debug("......diff in time...." + min);
            if (min <= 45L) continue;
            logger.debug(".....deleting event...." + eventHub.getId().toString());
            finalList.add(eventHub);
        }
        return list;
    }

    public static long convertToTimestampFrom(String objectId) {
        return Long.parseLong(objectId.substring(0, 8), 16) * 1000L;
    }

    @Override
    public void updateOverViewStatusScan(int cloudId, String actionToDeviceUUID, String status) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)actionToDeviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("lastBkpStatus", (Object)status);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
    }

    @Override
    public List<EventHub> getFailedStartEventHubList(int cloudId, String deviceType) {
        logger.debug("...getFailedStartEventHubList...");
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria odStatusCriteria = new Criteria();
        odStatusCriteria.orOperator(new Criteria[]{Criteria.where((String)"odStatus").is((Object)STATUS_STARTED), Criteria.where((String)"odStatus").is((Object)"PROCESSED")});
        andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria, Criteria.where((String)"actionBy").is((Object)"Schedule"), Criteria.where((String)"deviceType").is((Object)deviceType)});
        Query query = new Query((CriteriaDefinition)andCriteria);
        List list = mongoTemplate.find(query, EventHub.class);
        logger.debug("...after getFailedStartEventHubList...");
        ArrayList<EventHub> finalList = new ArrayList<EventHub>();
        for (EventHub eventHub : list) {
            if (!StringUtils.isEmpty((String)eventHub.getDeviceType()) && !deviceType.equalsIgnoreCase(eventHub.getDeviceType())) continue;
            long currentTime = System.currentTimeMillis();
            long eventTime = eventHub.getLastUpdatedTime();
            logger.debug(eventHub.getId().toString() + ".....event time..... " + currentTime + "..." + eventTime);
            if (eventTime == 0L) {
                long convertToTimestampFrom = MSUtilDaoImpl.convertToTimestampFrom(eventHub.getId().toString());
                logger.debug(eventHub.getActionToUserName() + "..user.." + eventHub.getId().toString() + "*********************EVETHUB-DATE..........." + convertToTimestampFrom);
                long diffSec = (currentTime - convertToTimestampFrom) / 1000L;
                long min = diffSec / 60L;
                logger.debug("......diff in time...." + min);
                if (min > 45L) {
                    logger.debug(".....deleting event...." + eventHub.getId().toString());
                    finalList.add(eventHub);
                }
            }
            if (eventTime <= 0L || currentTime - eventTime <= 0L) continue;
            long diffSec = (currentTime - eventTime) / 1000L;
            long min = diffSec / 60L;
            logger.debug("......diff in time...." + min);
            if (min <= 45L) continue;
            logger.debug(".....deleting event...." + eventHub.getId().toString());
            finalList.add(eventHub);
        }
        return finalList;
    }

    public void sleep() {
        try {
            Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public List<BackupBatch> getAllIncompleteBatch(int cloudId, String deviceType) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        Instant now = Instant.now();
        Instant timestamp = now.minus(Duration.ofMinutes(30L));
        criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)STATUS).is((Object)BackupBatch.STATUS.QUEUED.toString()), Criteria.where((String)"deviceType").is((Object)deviceType), Criteria.where((String)"underProcessing").is((Object)true), Criteria.where((String)BATCH_START_TIME_STAMP).lt((Object)timestamp)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{BATCH_START_TIME_STAMP}));
        Update updateObj = new Update();
        updateObj.set("underProcessing", (Object)false);
        UpdateResult updateFirstObj = mongoTemplate.updateMulti(query, updateObj, BackupBatch.class);
        criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)STATUS).is((Object)BackupBatch.STATUS.QUEUED.toString()), Criteria.where((String)"deviceType").is((Object)deviceType), Criteria.where((String)"underProcessing").is((Object)false)});
        query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        List list = mongoTemplate.find(query, BackupBatch.class);
        criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)STATUS).is((Object)BackupBatch.STATUS.SCANNING.toString()), Criteria.where((String)"deviceType").is((Object)deviceType), Criteria.where((String)"scanCompleted").is((Object)false), Criteria.where((String)"underProcessing").is((Object)false)});
        query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        List scanList = mongoTemplate.find(query, BackupBatch.class);
        ArrayList overAllList = new ArrayList();
        overAllList.addAll(list);
        overAllList.addAll(scanList);
        ArrayList<BackupBatch> uniqueList = new ArrayList<BackupBatch>();
        for (BackupBatch backupBatch : overAllList) {
            if (uniqueList.contains(backupBatch)) continue;
            uniqueList.add(backupBatch);
        }
        logger.debug(list.size() + "....batch list..." + scanList.size() + "..." + uniqueList.size());
        return uniqueList;
    }

    public static boolean compareMyObjects(BackupBatch o1, BackupBatch o2) {
        return o1.getId() == o2.getId() && o1.getDeviceUUID().equals(o2.getDeviceUUID());
    }

    @Override
    public void updateBatchQueue(int cloudId, ObjectId batchId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)batchId)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update updateObj = new Update();
        updateObj.set("underProcessing", (Object)true);
        mongoTemplate.updateFirst(query, updateObj, BackupBatch.class);
    }

    @Override
    public void updateAllIncompleteBatchQueueStatus(int cloudId, String deviceType) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)STATUS).is((Object)BackupBatch.STATUS.SCANNING.toString()), Criteria.where((String)STATUS).is((Object)BackupBatch.STATUS.QUEUED.toString())});
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), criteria1, Criteria.where((String)"deviceType").is((Object)deviceType)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update updateObj = new Update();
        updateObj.set("underProcessing", (Object)false);
        UpdateResult updateFirstObj = mongoTemplate.updateMulti(query, updateObj, BackupBatch.class);
    }

    @Override
    public BackupBatch getIncompleteBatch(int cloudId, String deviceType) {
        BackupBatch backupBatch = null;
        List<BackupBatch> list = this.getAllIncompleteBatch(cloudId, deviceType);
        logger.debug("...batch to process..." + deviceType);
        if (!CollectionUtils.isEmpty(list)) {
            logger.debug("...batch to process1..." + list.size());
            list.sort(Comparator.comparing(BackupBatch::getStatus).reversed());
            for (BackupBatch batch : list) {
                Device device = this.getDeviceInfoByUUID(cloudId, batch.getDeviceUUID());
                User user = this.getUserByName(cloudId, device.getUserName());
                logger.debug(deviceType + "....device....userusername...." + device.getUserName());
                String policyName = "";
                if (deviceType.equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
                    policyName = user.getOneDrivePolicyName();
                }
                if (deviceType.equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                    policyName = user.getExchangePolicyName();
                }
                if (deviceType.equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
                    policyName = user.getSpPolicyName();
                }
                OfficeBackupPolicy officeBackupPolicy = this.getOfficeBackupPolicy(cloudId, policyName);
                logger.debug(PCHelperConstant.getComponentName() + "........device....policy...." + policyName);
                if (officeBackupPolicy != null && PCHelperConstant.getComponentName().equalsIgnoreCase(officeBackupPolicy.getMsAppBluKrypt())) {
                    backupBatch = batch;
                    this.updateBatchQueue(cloudId, backupBatch.getId());
                    backupBatch.setUnderProcessing(true);
                    logger.debug("...batch for user...." + backupBatch.getUserName());
                    continue;
                }
                logger.debug("...policy null...." + policyName + "...." + device.getUserName());
            }
        }
        return backupBatch;
    }

    private OfficeBackupPolicy getOfficeBackupPolicy(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (OfficeBackupPolicy)paracloudMongoTemplate.findOne(query, OfficeBackupPolicy.class);
    }

    @Override
    public void deleteEventHub(int cloudId, String userName, String status) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"actionToUserName").is((Object)userName), Criteria.where((String)"odStatus").is((Object)status)});
        Query query = new Query((CriteriaDefinition)andCriteria);
        mongoTemplate.findAllAndRemove(query, EventHub.class);
    }

    @Override
    public void updateQueueOrScanProcessing(int cloudId, String deviceUUID) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)STATUS).is((Object)BackupBatch.STATUS.SCANNING.toString()), Criteria.where((String)STATUS).is((Object)BackupBatch.STATUS.QUEUED.toString())});
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)"deviceUUID").is((Object)deviceUUID), criteria1});
        Query query = new Query((CriteriaDefinition)criteria);
        Update updateObj = new Update();
        updateObj.set("underProcessing", (Object)false);
        UpdateResult updateFirstObj = mongoTemplate.updateMulti(query, updateObj, BackupBatch.class);
    }

    @Override
    public ODBBackupBatch getODBBackupBatch(int cloudId, ObjectId id, String policyName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        return (ODBBackupBatch)this.msgMongoTemplate.findOne(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    @Override
    public void updateFullBkpforBatch(int cloudId, String batchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)new ObjectId(batchId))});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update updateObj = new Update();
        updateObj.set("isFullBackup", (Object)true);
        UpdateResult updateFirstObj = mongoTemplate.updateMulti(query, updateObj, BackupBatch.class);
    }

    @Override
    public BackUpImage getBackupImageForItemIdForCP(int cloudId, String odItemId, String destCollection, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)"odItemId").is((Object)odItemId), Criteria.where((String)STATUS).is((Object)"ADDED")});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class, destCollection);
        BackUpImage backUpImage = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            backUpImage = (BackUpImage)list.get(0);
        }
        return backUpImage;
    }
}

