/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.pcbd.dao.EncryptionKeyDao;
import com.parablu.pcbd.domain.EncryptionKey;
import com.pg.factory.BlukryptMongoFactoryUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class EncryptionKeyDaoImpl
implements EncryptionKeyDao {
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;
    private static final String ENDTIMESTAMP = "endTimestamp";
    private static final String PRODUCT_TYPE = "productType";

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public void saveEncryptionKey(int cloudId, EncryptionKey encryptionKey) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.updatePreviousKeyAndUpdateEndTimeStamp(cloudId, encryptionKey.getProductType());
        encryptionKey.setStartTimestamp(System.currentTimeMillis());
        mongoTemplate.save((Object)encryptionKey);
    }

    private void updatePreviousKeyAndUpdateEndTimeStamp(int cloudId, String productType) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ENDTIMESTAMP).is((Object)0), Criteria.where((String)PRODUCT_TYPE).is((Object)productType)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(ENDTIMESTAMP, (Object)System.currentTimeMillis());
        mongoTemplate.updateFirst(query, update, EncryptionKey.class);
    }

    @Override
    public List<EncryptionKey> getAllEncryptionKeys(int cloudId, String productType) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)PRODUCT_TYPE).is((Object)productType)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"startTimestamp"}));
        return mongoTemplate.find(query, EncryptionKey.class);
    }

    @Override
    public EncryptionKey getEncryptionKey(int cloudId, String productType) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ENDTIMESTAMP).is((Object)0), Criteria.where((String)PRODUCT_TYPE).is((Object)productType)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (EncryptionKey)mongoTemplate.findOne(query, EncryptionKey.class);
    }

    @Override
    public EncryptionKey getKeyForDecrypt(int cloudId, long timeStamp, String productType) {
        Criteria criteria = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addStartAndEndDateBetweenCriteria(timeStamp, list);
        list.add(Criteria.where((String)PRODUCT_TYPE).is((Object)productType));
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (EncryptionKey)mongoTemplate.findOne(query, EncryptionKey.class);
    }

    private void addStartAndEndDateBetweenCriteria(Long timeStamp, List<Criteria> list) {
        Criteria criteria2 = Criteria.where((String)"startTimestamp").lte((Object)timeStamp);
        Criteria criteria3 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)ENDTIMESTAMP).gte((Object)timeStamp), Criteria.where((String)ENDTIMESTAMP).is((Object)0)});
        list.add(criteria2);
        list.add(criteria3);
    }
}

