/*
 * Decompiled with CFR 0.152.
 */
package com.pg.encryption.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileEncryption {
    Logger logger = LoggerFactory.getLogger(FileEncryption.class);
    public static final int AES_KEY_SIZE = 256;
    private Cipher aesCipher = Cipher.getInstance("AES");
    private SecretKeySpec aeskeySpec;
    private static final String ALGO = "AES";

    public void makeKey(String saltKey, String userUniqueKey) throws Exception {
        this.aeskeySpec = FileEncryption.generateKey(String.valueOf(saltKey) + userUniqueKey);
    }

    public void encrypt(File in, File out) throws IOException, InvalidKeyException {
        this.aesCipher.init(1, this.aeskeySpec);
        this.logger.debug("ENCRYPTING the FILE....................");
        try {
            FileInputStream is = new FileInputStream(in);
            FileOutputStream fileOutputStream = new FileOutputStream(out);
            CipherOutputStream os = new CipherOutputStream(fileOutputStream, this.aesCipher);
            this.copy(is, os);
            os.close();
        }
        catch (Exception e) {
            this.logger.trace("Exception : " + e);
            this.logger.debug("File not found for encryption ....................");
        }
    }

    public void decrypt(File in, File out) throws IOException, InvalidKeyException {
        this.aesCipher.init(2, this.aeskeySpec);
        FileInputStream fileInputStream = new FileInputStream(in);
        CipherInputStream is = new CipherInputStream(fileInputStream, this.aesCipher);
        FileOutputStream os = new FileOutputStream(out);
        this.copy(is, os);
        is.close();
        os.close();
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        int i;
        byte[] b = new byte[1024];
        while ((i = is.read(b)) != -1) {
            os.write(b, 0, i);
        }
    }

    private static SecretKeySpec generateKey(String secretKey) throws Exception {
        String hashedKey = FileEncryption.generateMD5OfString(secretKey);
        return new SecretKeySpec(hashedKey.getBytes(), ALGO);
    }

    public void encrypt(File in) throws IOException, InvalidKeyException {
        this.aesCipher.init(1, this.aeskeySpec);
        FileInputStream is = new FileInputStream(in);
        CipherOutputStream os = new CipherOutputStream(new FileOutputStream(in), this.aesCipher);
        this.copy(is, os);
        os.close();
    }

    public void decrypt(InputStream in, File out) throws IOException, InvalidKeyException {
        this.aesCipher.init(2, this.aeskeySpec);
        CipherInputStream is = new CipherInputStream(in, this.aesCipher);
        FileOutputStream os = new FileOutputStream(out);
        this.copy(is, os);
        is.close();
        os.close();
    }

    public static String generateMD5OfString(String convertTo) {
        return new String(Hex.encodeHex(DigestUtils.md5(convertTo)));
    }
}

