/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.common.base.CaseFormat;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.microsoft.graph.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class FallbackTypeAdapterFactory
implements TypeAdapterFactory {
    private static final String NO_KNOWN_VALUE = "unexpectedValue";
    private final ILogger logger;
    private static final TypeAdapter<Void> voidAdapter = new TypeAdapter<Void>(){

        @Override
        public void write(JsonWriter out, Void value) throws IOException {
            out.nullValue();
        }

        @Override
        public Void read(JsonReader in) throws IOException {
            return null;
        }
    };

    public FallbackTypeAdapterFactory(ILogger logger) {
        this.logger = logger;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class<T> rawType = type.getRawType();
        if (rawType.isEnum()) {
            return new EnumTypeAdapter<T>(rawType, this.logger);
        }
        if (rawType == Void.class) {
            return voidAdapter;
        }
        return null;
    }

    private static final class EnumTypeAdapter<T>
    extends TypeAdapter<T> {
        private final Map<String, T> enumValues;
        private final ILogger logger;

        EnumTypeAdapter(Class<T> cls, ILogger logger) {
            this.logger = logger;
            HashMap<String, T> enumValues = new HashMap<String, T>();
            for (T constant : cls.getEnumConstants()) {
                enumValues.put(constant.toString(), constant);
            }
            this.enumValues = enumValues;
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, value.toString()));
            }
        }

        @Override
        public T read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            String value = reader.nextString();
            T incoming = this.enumValues.get(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            if (incoming == null) {
                this.logger.logDebug(String.format("The following value %s could not be recognized as a member of the enum", value));
                return this.enumValues.get(FallbackTypeAdapterFactory.NO_KNOWN_VALUE);
            }
            return incoming;
        }
    }
}

