/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WindowsInformationProtectionAppLockerFile;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWindowsInformationProtectionAppLockerFileCollectionPage;
import com.microsoft.graph.requests.extensions.IWindowsInformationProtectionAppLockerFileCollectionRequest;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionAppLockerFileCollectionPage;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionAppLockerFileCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionAppLockerFileCollectionResponse;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionAppLockerFileRequestBuilder;
import java.util.List;

public class WindowsInformationProtectionAppLockerFileCollectionRequest
extends BaseCollectionRequest<WindowsInformationProtectionAppLockerFileCollectionResponse, IWindowsInformationProtectionAppLockerFileCollectionPage>
implements IWindowsInformationProtectionAppLockerFileCollectionRequest {
    public WindowsInformationProtectionAppLockerFileCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsInformationProtectionAppLockerFileCollectionResponse.class, IWindowsInformationProtectionAppLockerFileCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWindowsInformationProtectionAppLockerFileCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WindowsInformationProtectionAppLockerFileCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWindowsInformationProtectionAppLockerFileCollectionPage get() throws ClientException {
        WindowsInformationProtectionAppLockerFileCollectionResponse response = (WindowsInformationProtectionAppLockerFileCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WindowsInformationProtectionAppLockerFile newWindowsInformationProtectionAppLockerFile, ICallback<WindowsInformationProtectionAppLockerFile> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WindowsInformationProtectionAppLockerFileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWindowsInformationProtectionAppLockerFile, callback);
    }

    @Override
    public WindowsInformationProtectionAppLockerFile post(WindowsInformationProtectionAppLockerFile newWindowsInformationProtectionAppLockerFile) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WindowsInformationProtectionAppLockerFileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWindowsInformationProtectionAppLockerFile);
    }

    @Override
    public IWindowsInformationProtectionAppLockerFileCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWindowsInformationProtectionAppLockerFileCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWindowsInformationProtectionAppLockerFileCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IWindowsInformationProtectionAppLockerFileCollectionPage buildFromResponse(WindowsInformationProtectionAppLockerFileCollectionResponse response) {
        WindowsInformationProtectionAppLockerFileCollectionRequestBuilder builder = response.nextLink != null ? new WindowsInformationProtectionAppLockerFileCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WindowsInformationProtectionAppLockerFileCollectionPage page = new WindowsInformationProtectionAppLockerFileCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

