/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Call;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ICallRequest;
import java.util.List;

public class CallRequest
extends BaseRequest
implements ICallRequest {
    public CallRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Call.class);
    }

    @Override
    public void get(ICallback<Call> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Call get() throws ClientException {
        return (Call)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Call> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Call sourceCall, ICallback<Call> callback) {
        this.send(HttpMethod.PATCH, callback, sourceCall);
    }

    @Override
    public Call patch(Call sourceCall) throws ClientException {
        return (Call)this.send(HttpMethod.PATCH, sourceCall);
    }

    @Override
    public void post(Call newCall, ICallback<Call> callback) {
        this.send(HttpMethod.POST, callback, newCall);
    }

    @Override
    public Call post(Call newCall) throws ClientException {
        return (Call)this.send(HttpMethod.POST, newCall);
    }

    @Override
    public ICallRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ICallRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

