/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.concurrency.IProgressCallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.DefaultConnectionConfig;
import com.microsoft.graph.core.IConnectionConfig;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpProvider;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.http.IStatefulResponseHandler;
import com.microsoft.graph.httpcore.HttpClients;
import com.microsoft.graph.httpcore.ICoreAuthenticationProvider;
import com.microsoft.graph.httpcore.middlewareoption.RedirectOptions;
import com.microsoft.graph.httpcore.middlewareoption.RetryOptions;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.logger.LoggerLevel;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.serializer.ISerializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;

public class CoreHttpProvider
implements IHttpProvider {
    private final ISerializer serializer;
    private final IAuthenticationProvider authenticationProvider;
    private final IExecutors executors;
    private final ILogger logger;
    private IConnectionConfig connectionConfig;
    private OkHttpClient corehttpClient;

    public CoreHttpProvider(ISerializer serializer, IAuthenticationProvider authenticationProvider, IExecutors executors, ILogger logger) {
        this.serializer = serializer;
        this.authenticationProvider = authenticationProvider;
        this.executors = executors;
        this.logger = logger;
    }

    @Override
    public ISerializer getSerializer() {
        return this.serializer;
    }

    public <Result, Body> void send(final IHttpRequest request, final ICallback<Result> callback, final Class<Result> resultClass, final Body serializable) {
        final IProgressCallback progressCallback = callback instanceof IProgressCallback ? (IProgressCallback)callback : null;
        this.executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    CoreHttpProvider.this.executors.performOnForeground(CoreHttpProvider.this.sendRequestInternal(request, resultClass, serializable, progressCallback, null), callback);
                }
                catch (ClientException e) {
                    CoreHttpProvider.this.executors.performOnForeground(e, callback);
                }
            }
        });
    }

    public <Result, Body> Result send(IHttpRequest request, Class<Result> resultClass, Body serializable) throws ClientException {
        return this.send(request, resultClass, serializable, (IStatefulResponseHandler<Result, DeserializeType>)null);
    }

    public <Result, Body, DeserializeType> Result send(IHttpRequest request, Class<Result> resultClass, Body serializable, IStatefulResponseHandler<Result, DeserializeType> handler) throws ClientException {
        return this.sendRequestInternal(request, resultClass, serializable, null, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <Result, Body, DeserializeType> Result sendRequestInternal(IHttpRequest request, Class<Result> resultClass, Body serializable, final IProgressCallback<Result> progress, IStatefulResponseHandler<Result, DeserializeType> handler) throws ClientException {
        int defaultBufferSize = 4096;
        try {
            if (this.authenticationProvider != null) {
                this.authenticationProvider.authenticateRequest(request);
            }
            InputStream in = null;
            boolean isBinaryStreamInput = false;
            URL requestUrl = request.getRequestUrl();
            this.logger.logDebug("Starting to send request, URL " + requestUrl.toString());
            if (this.connectionConfig == null) {
                this.connectionConfig = new DefaultConnectionConfig();
            }
            if (this.corehttpClient == null) {
                OkHttpClient.Builder okBuilder = HttpClients.createDefault(new ICoreAuthenticationProvider(){

                    @Override
                    public Request authenticateRequest(Request request) {
                        return request;
                    }
                }).newBuilder();
                okBuilder.connectTimeout(this.connectionConfig.getConnectTimeout(), TimeUnit.MILLISECONDS);
                okBuilder.readTimeout(this.connectionConfig.getReadTimeout(), TimeUnit.MILLISECONDS);
                okBuilder.followRedirects(false);
                okBuilder.retryOnConnectionFailure(false);
                this.corehttpClient = okBuilder.build();
            }
            RedirectOptions redirectOptions = new RedirectOptions(request.getMaxRedirects() > 0 ? request.getMaxRedirects() : this.connectionConfig.getMaxRedirects(), request.getShouldRedirect() != null ? request.getShouldRedirect() : this.connectionConfig.getShouldRedirect());
            RetryOptions retryOptions = new RetryOptions(request.getShouldRetry() != null ? request.getShouldRetry() : this.connectionConfig.getShouldRetry(), request.getMaxRetries() > 0 ? request.getMaxRetries() : this.connectionConfig.getMaxRetries(), request.getDelay() > 0L ? request.getDelay() : this.connectionConfig.getDelay());
            Request coreHttpRequest = this.convertIHttpRequestToOkHttpRequest(request);
            Request.Builder corehttpRequestBuilder = coreHttpRequest.newBuilder().tag(RedirectOptions.class, redirectOptions).tag(RetryOptions.class, retryOptions);
            String contenttype = null;
            try {
                byte[] bytesToWrite;
                this.logger.logDebug("Request Method " + request.getHttpMethod().toString());
                List<HeaderOption> requestHeaders = request.getHeaders();
                for (HeaderOption headerOption : requestHeaders) {
                    if (!headerOption.getName().equalsIgnoreCase("Content-Type")) continue;
                    contenttype = headerOption.getValue().toString();
                    break;
                }
                corehttpRequestBuilder.addHeader("Accept", "*/*");
                if (serializable == null) {
                    if (request.getHttpMethod() == HttpMethod.POST) {
                        bytesToWrite = new byte[]{};
                        contenttype = "application/octet-stream";
                    } else {
                        bytesToWrite = null;
                    }
                } else if (serializable instanceof byte[]) {
                    this.logger.logDebug("Sending byte[] as request body");
                    bytesToWrite = (byte[])serializable;
                    if (!CoreHttpProvider.hasHeader(requestHeaders, "Content-Type")) {
                        corehttpRequestBuilder.addHeader("Content-Type", "application/octet-stream");
                        contenttype = "application/octet-stream";
                    }
                } else {
                    this.logger.logDebug("Sending " + serializable.getClass().getName() + " as request body");
                    String serializeObject = this.serializer.serializeObject(serializable);
                    bytesToWrite = serializeObject.getBytes("UTF-8");
                    if (!CoreHttpProvider.hasHeader(requestHeaders, "Content-Type")) {
                        corehttpRequestBuilder.addHeader("Content-Type", "application/json");
                        contenttype = "application/json";
                    }
                }
                RequestBody requestBody = null;
                if (bytesToWrite != null) {
                    final String mediaContentType = contenttype;
                    requestBody = new RequestBody(){

                        @Override
                        public long contentLength() throws IOException {
                            return bytesToWrite.length;
                        }

                        @Override
                        public void writeTo(BufferedSink sink) throws IOException {
                            int toWrite;
                            OutputStream out = sink.outputStream();
                            int writtenSoFar = 0;
                            BufferedOutputStream bos = new BufferedOutputStream(out);
                            do {
                                toWrite = Math.min(4096, bytesToWrite.length - writtenSoFar);
                                bos.write(bytesToWrite, writtenSoFar, toWrite);
                                writtenSoFar += toWrite;
                                if (progress == null) continue;
                                CoreHttpProvider.this.executors.performOnForeground(writtenSoFar, bytesToWrite.length, progress);
                            } while (toWrite > 0);
                            bos.close();
                            out.close();
                        }

                        @Override
                        public MediaType contentType() {
                            return MediaType.parse(mediaContentType);
                        }
                    };
                }
                corehttpRequestBuilder.method(request.getHttpMethod().toString(), requestBody);
                coreHttpRequest = corehttpRequestBuilder.build();
                Response response = this.corehttpClient.newCall(coreHttpRequest).execute();
                if (handler != null) {
                    handler.configConnection(response);
                }
                this.logger.logDebug(String.format("Response code %d, %s", response.code(), response.message()));
                if (handler != null) {
                    this.logger.logDebug("StatefulResponse is handling the HTTP response.");
                    Result Result2 = handler.generateResult(request, response, this.getSerializer(), this.logger);
                    return Result2;
                }
                if (response.code() >= 400) {
                    this.logger.logDebug("Handling error response");
                    in = response.body().byteStream();
                    this.handleErrorResponse(request, serializable, response);
                }
                if (response.code() == 204 || response.code() == 304) {
                    this.logger.logDebug("Handling response with no body");
                    Result Result3 = this.handleEmptyResponse(CoreHttpProvider.getResponseHeadersAsMapOfStringList(response), resultClass);
                    return Result3;
                }
                if (response.code() == 202) {
                    this.logger.logDebug("Handling accepted response");
                    Result Result4 = this.handleEmptyResponse(CoreHttpProvider.getResponseHeadersAsMapOfStringList(response), resultClass);
                    return Result4;
                }
                in = new BufferedInputStream(response.body().byteStream());
                Map<String, String> headers = CoreHttpProvider.getResponseHeadersAsMapStringString(response);
                String contentType = headers.get("Content-Type");
                if (contentType != null && contentType.contains("application/json")) {
                    this.logger.logDebug("Response json");
                    Result Result5 = this.handleJsonResponse(in, CoreHttpProvider.getResponseHeadersAsMapOfStringList(response), resultClass);
                    return Result5;
                }
                this.logger.logDebug("Response binary");
                isBinaryStreamInput = true;
                InputStream inputStream = this.handleBinaryStream(in);
                return (Result)inputStream;
            }
            finally {
                if (!isBinaryStreamInput && in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.logger.logError(e.getMessage(), e);
                    }
                }
            }
        }
        catch (GraphServiceException ex) {
            boolean shouldLogVerbosely = this.logger.getLoggingLevel() == LoggerLevel.DEBUG;
            this.logger.logError("Graph service exception " + ex.getMessage(shouldLogVerbosely), ex);
            throw ex;
        }
        catch (UnsupportedEncodingException ex) {
            ClientException clientException = new ClientException("Unsupported encoding problem: ", ex);
            this.logger.logError("Unsupported encoding problem: " + ex.getMessage(), ex);
            throw clientException;
        }
        catch (Exception ex) {
            ClientException clientException = new ClientException("Error during http request", ex);
            this.logger.logError("Error during http request", clientException);
            throw clientException;
        }
    }

    static Map<String, String> getResponseHeadersAsMapStringString(Response response) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Headers responseHeaders = response.headers();
        for (int index = 0; index < responseHeaders.size(); ++index) {
            String headerName = responseHeaders.name(index);
            String headerValue = responseHeaders.value(index);
            if (headerName == null && headerValue == null) break;
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    static Map<String, List<String>> getResponseHeadersAsMapOfStringList(Response response) {
        Map<String, List<String>> headerFields = response.headers().toMultimap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.format("%d", response.code()));
        headerFields.put("responseCode", list);
        return headerFields;
    }

    private Request convertIHttpRequestToOkHttpRequest(IHttpRequest request) {
        if (request != null) {
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(request.getRequestUrl());
            for (HeaderOption header : request.getHeaders()) {
                requestBuilder.addHeader(header.getName(), header.getValue().toString());
            }
            return requestBuilder.build();
        }
        return null;
    }

    private <Body> void handleErrorResponse(IHttpRequest request, Body serializable, Response response) throws IOException {
        throw GraphServiceException.createFromConnection(request, serializable, this.serializer, response, this.logger);
    }

    private InputStream handleBinaryStream(InputStream in) {
        return in;
    }

    private <Result> Result handleJsonResponse(InputStream in, Map<String, List<String>> responseHeaders, Class<Result> clazz) {
        if (clazz == null) {
            return null;
        }
        String rawJson = CoreHttpProvider.streamToString(in);
        return this.getSerializer().deserializeObject(rawJson, clazz, responseHeaders);
    }

    private <Result> Result handleEmptyResponse(Map<String, List<String>> responseHeaders, Class<Result> clazz) throws UnsupportedEncodingException {
        ByteArrayInputStream in = new ByteArrayInputStream("{}".getBytes("UTF-8"));
        return this.handleJsonResponse(in, responseHeaders, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String streamToString(InputStream input) {
        String httpStreamEncoding = "UTF-8";
        String endOfFile = "\\A";
        String scannerString = "";
        try (Scanner scanner = new Scanner(input, "UTF-8");){
            scanner.useDelimiter("\\A");
            scannerString = scanner.next();
        }
        return scannerString;
    }

    @VisibleForTesting
    static boolean hasHeader(List<HeaderOption> headers, String header) {
        for (HeaderOption option : headers) {
            if (!option.getName().equalsIgnoreCase(header)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public ILogger getLogger() {
        return this.logger;
    }

    @VisibleForTesting
    public IExecutors getExecutors() {
        return this.executors;
    }

    @VisibleForTesting
    public IAuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    @Override
    public IConnectionConfig getConnectionConfig() {
        if (this.connectionConfig == null) {
            this.connectionConfig = new DefaultConnectionConfig();
        }
        return this.connectionConfig;
    }

    @Override
    public void setConnectionConfig(IConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }
}

