/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.content;

import com.microsoft.graph.content.MSBatchRequestStep;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MSBatchRequestContent {
    private Map<String, MSBatchRequestStep> batchRequestStepsHashMap;
    public static final int MAX_NUMBER_OF_REQUESTS = 20;

    public MSBatchRequestContent(List<MSBatchRequestStep> batchRequestStepsArray) {
        if (batchRequestStepsArray.size() > 20) {
            throw new IllegalArgumentException("Number of batch request steps cannot exceed 20");
        }
        this.batchRequestStepsHashMap = new HashMap<String, MSBatchRequestStep>();
        for (MSBatchRequestStep requestStep : batchRequestStepsArray) {
            this.addBatchRequestStep(requestStep);
        }
    }

    public MSBatchRequestContent() {
        this.batchRequestStepsHashMap = new HashMap<String, MSBatchRequestStep>();
    }

    public boolean addBatchRequestStep(MSBatchRequestStep batchRequestStep) {
        if (this.batchRequestStepsHashMap.containsKey(batchRequestStep.getRequestId())) {
            return false;
        }
        this.batchRequestStepsHashMap.put(batchRequestStep.getRequestId(), batchRequestStep);
        return true;
    }

    public boolean removeBatchRequestStepWithId(String requestId) {
        boolean removed = false;
        if (this.batchRequestStepsHashMap.containsKey(requestId)) {
            this.batchRequestStepsHashMap.remove(requestId);
            removed = true;
            for (Map.Entry<String, MSBatchRequestStep> steps : this.batchRequestStepsHashMap.entrySet()) {
                if (steps.getValue() == null || steps.getValue().getArrayOfDependsOnIds() == null) continue;
                while (steps.getValue().getArrayOfDependsOnIds().remove(requestId)) {
                }
            }
        }
        return removed;
    }

    public String getBatchRequestContent() {
        JSONObject batchRequestContentMap = new JSONObject();
        JSONArray batchContentArray = new JSONArray();
        for (Map.Entry<String, MSBatchRequestStep> requestStep : this.batchRequestStepsHashMap.entrySet()) {
            batchContentArray.add(this.getBatchRequestObjectFromRequestStep(requestStep.getValue()));
        }
        batchRequestContentMap.put("requests", batchContentArray);
        String content = batchRequestContentMap.toString();
        return content;
    }

    private JSONObject getBatchRequestObjectFromRequestStep(MSBatchRequestStep batchRequestStep) {
        RequestBody body;
        List<String> arrayOfDependsOnIds;
        JSONObject contentmap = new JSONObject();
        contentmap.put("id", batchRequestStep.getRequestId());
        String url = batchRequestStep.getRequest().url().toString();
        url = url.replaceAll("https://graph.microsoft.com/v1.0/", "");
        url = url.replaceAll("http://graph.microsoft.com/v1.0/", "");
        url = url.replaceAll("https://graph.microsoft.com/beta/", "");
        url = url.replaceAll("http://graph.microsoft.com/beta/", "");
        contentmap.put("url", url);
        contentmap.put("method", batchRequestStep.getRequest().method().toString());
        Headers headers = batchRequestStep.getRequest().headers();
        if (headers != null && headers.size() != 0) {
            JSONObject headerMap = new JSONObject();
            for (Map.Entry<String, List<String>> entry : headers.toMultimap().entrySet()) {
                headerMap.put(entry.getKey(), this.getHeaderValuesAsString(entry.getValue()));
            }
            contentmap.put("headers", headerMap);
        }
        if ((arrayOfDependsOnIds = batchRequestStep.getArrayOfDependsOnIds()) != null) {
            JSONArray array = new JSONArray();
            for (String dependsOnId : arrayOfDependsOnIds) {
                array.add(dependsOnId);
            }
            contentmap.put("dependsOn", array);
        }
        if ((body = batchRequestStep.getRequest().body()) != null) {
            try {
                contentmap.put("body", this.requestBodyToJSONObject(batchRequestStep.getRequest()));
            }
            catch (IOException | ParseException exception) {
                exception.printStackTrace();
            }
        }
        return contentmap;
    }

    private String getHeaderValuesAsString(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            builder.append(";");
            builder.append(list.get(i));
        }
        return builder.toString();
    }

    private JSONObject requestBodyToJSONObject(Request request) throws IOException, ParseException {
        if (request == null || request.body() == null) {
            return null;
        }
        Request copy = request.newBuilder().build();
        Buffer buffer = new Buffer();
        copy.body().writeTo(buffer);
        String requestBody = buffer.readUtf8();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(requestBody);
        return jsonObject;
    }
}

