/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.FileInputStream;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.bson.Document;

public class UpdateODbIDinBulk {
    public static void main(String[] args) throws Exception {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String csvFile = config.getProperty("inputFile").toString();
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort) || StringUtils.isEmpty(csvFile)) {
            System.out.println("mongoIP, mongoPort or inputFile cannot be empty in config file...Please configure and run again");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> userCollection = db.getCollection("USER");
        System.out.println("cloudName :" + mongoIP);
        System.out.println("ip :" + mongoPort);
        System.out.println(" csvFile :" + csvFile);
        Throwable throwable = null;
        Object var10_11 = null;
        try (FileInputStream inp = new FileInputStream(csvFile);){
            Workbook wb = WorkbookFactory.create(inp);
            Sheet sheet = wb.getSheetAt(0);
            int rowCount = sheet.getLastRowNum();
            System.out.println(sheet.getLastRowNum());
            int i = 1;
            while (i <= rowCount) {
                Row row = sheet.getRow(i);
                Cell cell0 = row.getCell(0);
                Cell cell1 = row.getCell(1);
                if (cell0 == null || cell1 == null) {
                    System.out.println("...userName or odbid is null........");
                } else {
                    String userName = cell0.toString().trim();
                    String odbId = cell1.toString().trim();
                    Document user = (Document)userCollection.find(new Document("userName", userName)).first();
                    if (user != null) {
                        System.out.println("....inside update user ...." + user.get("userName"));
                        BasicDBObject userSearchQuery = new BasicDBObject();
                        userSearchQuery.append("_id", user.get("_id"));
                        BasicDBObject updateFields = new BasicDBObject();
                        BasicDBObject updateQuery = new BasicDBObject();
                        updateFields.append("odbLoginId", odbId);
                        updateQuery.append("$set", updateFields);
                        userCollection.updateOne(userSearchQuery, updateQuery);
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

