/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class UpdateBackupOverviewReport {
    public static void main(String[] args) throws Exception {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String cloudName = config.getProperty("cloudName").toString();
        if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
            System.out.println("mongoIP, mongoPort, cloudName cannot be empty in config file...Please configure and run again");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        System.out.println("mongoIP :" + mongoIP);
        System.out.println("ip :" + mongoPort);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> userCollection = db.getCollection("USER");
        MongoCollection<Document> deviceBkpOverviewCollection = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        try {
            FindIterable<Document> bkpoverviewReports = deviceBkpOverviewCollection.find();
            for (Document doc : bkpoverviewReports) {
                System.out.println(String.valueOf(doc.getString("userName")) + " UserName" + "duuid" + doc.getObjectId("_id"));
                Document user = (Document)userCollection.find(new Document("userName", doc.getString("userName"))).first();
                if (user != null) {
                    boolean active = user.getBoolean("active");
                    if (String.valueOf(active).equalsIgnoreCase(String.valueOf(doc.getBoolean("isUserActive")))) continue;
                    System.out.println("duuid" + doc.getObjectId("_id"));
                    System.out.println("userName....  " + doc.getString("userName") + "deviceName....  " + doc.getString("deviceName"));
                    System.out.println("existing value from user table...." + active + "  existing value from device backup overview table...." + doc.getBoolean("isUserActive"));
                    BasicDBObject bkpSearchQuery = new BasicDBObject();
                    bkpSearchQuery.append("_id", doc.getObjectId("_id"));
                    BasicDBObject updateFields = new BasicDBObject();
                    updateFields.append("isUserActive", active);
                    BasicDBObject updateDeviceQuery = new BasicDBObject();
                    updateDeviceQuery.append("$set", updateFields);
                    deviceBkpOverviewCollection.updateOne(bkpSearchQuery, updateDeviceQuery);
                    continue;
                }
                System.out.println("NO user found in users collection...." + doc.getString("userName"));
            }
            System.out.println(".........END...............");
        }
        catch (Exception e) {
            System.out.println("..........Failed............");
            e.printStackTrace();
        }
    }
}

