/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class RefCountCal {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        boolean startOver = Boolean.parseBoolean(config.getProperty("startOver").toString());
        int refCountLimit = Integer.parseInt(config.getProperty("refCountLimit").toString());
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        if (startOver) {
            System.out.println("input indicates to be start over");
            db.getCollection("FINSIHED_CHUNK_DETAILS").drop();
        }
        MongoIterable<String> collections = db.listCollectionNames();
        db.createCollection("FINSIHED_CHUNK_DETAILS");
        MongoCollection<Document> finishedChunkDetailCollections = db.getCollection("FINSIHED_CHUNK_DETAILS");
        Stream collStream = StreamSupport.stream(collections.spliterator(), true);
        System.out.println("print all collections.....");
        ((Stream)collStream.parallel()).forEach(collectionName -> {
            System.out.println("operation on collection ....." + collectionName);
            if (collectionName.startsWith("CHUNK_DETAIL")) {
                System.out.println("collction name starts with chunk detail ....." + collectionName);
                int skip = 0;
                MongoCollection<Document> chunkDetailCollection = db.getCollection((String)collectionName);
                while (true) {
                    FindIterable<Document> docs = chunkDetailCollection.find().skip(skip * 500).limit(500);
                    System.out.println("docs size ....." + docs);
                    if (docs.first() == null) {
                        Document chunkDetail = new Document();
                        chunkDetail.put("collName", collectionName);
                        chunkDetail.put("finishedTimeStamp", (Object)System.currentTimeMillis());
                        finishedChunkDetailCollections.insertOne(chunkDetail);
                        break;
                    }
                    Stream docStream = StreamSupport.stream(docs.spliterator(), true);
                    System.out.println("docStream ....." + docStream);
                    ((Stream)docStream.parallel()).forEach(document -> {
                        int refCount = document.getInteger("refCount");
                        if (refCount > refCountLimit) {
                            System.out.println("@PVN@ collectionName:" + collectionName + "|" + "md5:" + document.getString("md5") + "|" + "refCount:" + refCount);
                        }
                    });
                    ++skip;
                }
            }
        });
        System.out.println(".................THE END................");
        client.close();
    }
}

