/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.types.ObjectId;

public class RebackupFromDeviceVersion {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase mainPB001DB = client.getDatabase(uri.getDatabase());
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        MongoCollection<Document> reBkpCollection = mainPB001DB.getCollection("RE_BACKUP");
        MongoCollection<Document> deviceReBkpTmpColl = db.getCollection("DEVICE_RE_BACKUP_TEMP");
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deleted", false));
        whereQuery.add(new BasicDBObject("blocked", false));
        andQuery.put("$and", whereQuery);
        FindIterable<Document> devices = deviceColl.find(andQuery);
        FindIterable<Document> completedDevices = deviceReBkpTmpColl.find();
        System.out.println(deviceColl.count(andQuery));
        ArrayList<Document> filteredDevice = new ArrayList<Document>();
        HashSet<String> completedUUIDS = new HashSet<String>();
        try {
            for (Document dev : completedDevices) {
                if (dev == null || StringUtils.isEmpty(dev.getString("deviceUUID"))) continue;
                completedUUIDS.add(dev.getString("deviceUUID"));
            }
        }
        catch (Exception var19) {
            var19.printStackTrace();
        }
        System.out.println(completedUUIDS.size());
        for (Document dev : devices) {
            if (dev == null || StringUtils.isEmpty(dev.getString("clientVersion"))) continue;
            if (!completedUUIDS.contains(dev.getString("deviceUUID"))) {
                System.out.println(dev.getString("clientVersion"));
                if (RebackupFromDeviceVersion.isInstalledversionLatest("2.5.2.13", dev.getString("clientVersion"))) {
                    filteredDevice.add(dev);
                    continue;
                }
                System.out.println(".......");
                continue;
            }
            System.out.println(String.valueOf(dev.getString("clientVersion")) + " already done so continue");
        }
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " filter device count : " + filteredDevice.size());
        filteredDevice.parallelStream().forEach(devx -> {
            BasicDBObject folderQuery = new BasicDBObject();
            ArrayList<BasicDBObject> folderWhereQuery = new ArrayList<BasicDBObject>();
            folderWhereQuery.add(new BasicDBObject("deviceUUID", devx.getString("deviceUUID")));
            folderWhereQuery.add(new BasicDBObject("folder", true));
            folderWhereQuery.add(new BasicDBObject("present", true));
            folderQuery.put("$and", folderWhereQuery);
            MongoCollection<Document> bkpColl = db.getCollection(devx.getString("destCollection"));
            ArrayList<Document> allFoldersList = new ArrayList<Document>();
            int skip = 0;
            while (true) {
                FindIterable<Document> folders;
                if ((folders = bkpColl.find(folderQuery).skip(skip * 500).limit(500)).first() == null) {
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + " folder is done deviceUUID :" + devx.getString("deviceUUID") + " folders size :" + allFoldersList.size());
                    HashMap filesSet = new HashMap();
                    try {
                        allFoldersList.parallelStream().forEach(devicePath -> {
                            BasicDBObject filesQuery = new BasicDBObject();
                            String folderName = "";
                            folderName = StringUtils.isEmpty(devicePath.getString("devicePath")) ? devicePath.getString("fileName") : String.valueOf(devicePath.getString("devicePath")) + "/" + devicePath.getString("fileName");
                            System.out.println(folderName);
                            ArrayList<BasicDBObject> filesWhereQuery = new ArrayList<BasicDBObject>();
                            filesWhereQuery.add(new BasicDBObject("deviceUUID", devx.getString("deviceUUID")));
                            filesWhereQuery.add(new BasicDBObject("folder", false));
                            filesWhereQuery.add(new BasicDBObject("present", true));
                            filesWhereQuery.add(new BasicDBObject("devicePath", folderName));
                            Pattern pattern = Pattern.compile(String.valueOf(Pattern.quote("pst")) + "$", 2);
                            filesWhereQuery.add(new BasicDBObject("fileName", pattern));
                            filesQuery.put("$and", filesWhereQuery);
                            int fileSkip = 0;
                            while (true) {
                                FindIterable files;
                                if ((files = bkpColl.find(filesQuery).skip(fileSkip * 500).limit(500)).first() == null) {
                                    System.out.println("........");
                                    filesSet.size();
                                    for (Map.Entry entry : filesSet.entrySet()) {
                                        try {
                                            Document rebkpFile = new Document();
                                            Document bkpFile = (Document)bkpColl.find(new BasicDBObject("_id", new ObjectId((String)entry.getValue()))).first();
                                            if (bkpFile == null) continue;
                                            String folderPath = "";
                                            if (StringUtils.isEmpty(devicePath.getString("devicePath"))) {
                                                folderPath = devicePath.getString("fileName");
                                            } else {
                                                String cfr_ignored_0 = String.valueOf(devicePath.getString("devicePath")) + "/" + devicePath.getString("fileName");
                                            }
                                            rebkpFile.put("_id", (Object)new ObjectId((String)entry.getValue()));
                                            rebkpFile.put("userName", (Object)bkpFile.getString("userName"));
                                            rebkpFile.put("fileName", (Object)bkpFile.getString("fileName"));
                                            rebkpFile.put("devicePath", (Object)bkpFile.getString("devicePath"));
                                            rebkpFile.put("deviceId", (Object)devx.getObjectId("_id").toString());
                                            reBkpCollection.insertOne(rebkpFile);
                                            System.out.println("inserted");
                                        }
                                        catch (Exception var15) {
                                            System.out.println("Exception:" + var15.getLocalizedMessage());
                                        }
                                    }
                                    return;
                                }
                                for (Document document2 : files) {
                                    filesSet.put(document2.getString("fileName"), document2.getObjectId("_id").toString());
                                }
                                ++fileSkip;
                            }
                        });
                    }
                    catch (Exception var13) {
                        var13.printStackTrace();
                    }
                    try {
                        Document deviceReBkpTmp = new Document();
                        deviceReBkpTmp.put("deviceUUID", (Object)devx.getString("deviceUUID"));
                        deviceReBkpTmpColl.insertOne(deviceReBkpTmp);
                    }
                    catch (Exception var12) {
                        var12.printStackTrace();
                    }
                    return;
                }
                for (Document deviceReBkpTmp : folders) {
                    allFoldersList.add(deviceReBkpTmp);
                }
                ++skip;
            }
        });
        if (client != null) {
            client.close();
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, List<BackUpImage>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getFileName));
        for (Map.Entry<String, List<BackUpImage>> entry : map.entrySet()) {
            List files = entry.getValue().stream().filter(file -> !file.getStatus().equalsIgnoreCase("DELETED")).collect(Collectors.toList());
            filteredBackUpImages.add(files.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get());
        }
        return filteredBackUpImages;
    }

    public static int VersionCompare(String versionFromServer, String installedVersion) {
        int v2Len;
        int v1Len = StringUtils.countMatches(versionFromServer, ".");
        if (v1Len != (v2Len = StringUtils.countMatches(installedVersion, "."))) {
            int i;
            int count = Math.abs(v1Len - v2Len);
            if (v1Len > v2Len) {
                i = 1;
                while (i <= count) {
                    installedVersion = String.valueOf(installedVersion) + ".0";
                    ++i;
                }
            } else {
                i = 1;
                while (i <= count) {
                    versionFromServer = String.valueOf(versionFromServer) + ".0";
                    ++i;
                }
            }
        }
        if (versionFromServer.equals(installedVersion)) {
            return 0;
        }
        String[] v1Str = StringUtils.split(versionFromServer, ".");
        String[] v2Str = StringUtils.split(installedVersion, ".");
        int i = 0;
        while (i < v1Str.length) {
            int num2;
            int num1 = Integer.parseInt(v1Str[i]);
            if (num1 != (num2 = Integer.parseInt(v2Str[i]))) {
                if (num1 > num2) {
                    return 1;
                }
                return 2;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isInstalledversionLatest(String versionFromServer, String installedVersion) {
        boolean result = false;
        int resu = RebackupFromDeviceVersion.VersionCompare(versionFromServer, installedVersion);
        if (resu == 1) {
            result = false;
        } else if (resu == 2) {
            result = true;
        }
        return result;
    }
}

