/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class MigrationStatusUpdate {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        try {
            MongoCollection<Document> userDBCollection = db.getCollection("USER");
            MongoCollection<Document> migrationsStatusDBCollection = db.getCollection("MIGRATION_STATUS");
            FindIterable<Document> users = userDBCollection.find(new Document("localUser", false));
            for (Document user : users) {
                Document migrationStatus = new Document();
                migrationStatus.put("userName", (Object)user.getString("userName"));
                if (user.get("emailId") != null) {
                    migrationStatus.put("emailId", (Object)user.getString("emailId"));
                }
                if (user.get("createdTimestamp") != null) {
                    long createdTimeStamp = Long.parseLong(user.getString("createdTimestamp"));
                    migrationStatus.put("migratededTimestamp", (Object)createdTimeStamp);
                } else {
                    migrationStatus.put("migratededTimestamp", (Object)System.currentTimeMillis());
                }
                migrationStatus.put("migratedBy", (Object)user.getString("migratedBy"));
                migrationStatus.put("isMigrated", (Object)true);
                migrationsStatusDBCollection.insertOne(migrationStatus);
                System.out.println("Successfuly updated for :" + user.getString("userName"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

