/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.types.ObjectId;

public class GlobalExclusionToBKPPoliciesFix {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> excludedFoldersDBCollection = db.getCollection("EXCLUDED_FOLDERS");
        MongoCollection<Document> bkpPolicyDBCollection = db.getCollection("BACKUP_POLICY");
        FindIterable<Document> policyList = bkpPolicyDBCollection.find();
        FindIterable<Document> excludedFolderList = excludedFoldersDBCollection.find();
        ArrayList<String> excludedFolderPathList = new ArrayList<String>();
        excludedFolderPathList.add("{OneDrive}");
        excludedFolderPathList.add("{user.home}\\Documents\\My Pictures");
        excludedFolderPathList.add("{user.home}\\Documents\\My Videos");
        excludedFolderPathList.add("{user.home}\\Documents\\My Music");
        excludedFolderPathList.add("{user.home}\\Templates");
        excludedFolderPathList.add("{user.home}\\Local Settings");
        excludedFolderPathList.add("{user.home}\\Cookies");
        excludedFolderPathList.add("{user.home}\\NetHood");
        excludedFolderPathList.add("{user.home}\\PrintHood");
        excludedFolderPathList.add("{user.home}\\Application Data");
        excludedFolderPathList.add("{user.home}\\My Documents");
        excludedFolderPathList.add("{user.home}\\Start Menu");
        excludedFolderPathList.add("{user.home}\\SendTo");
        for (Document policy : policyList) {
            ArrayList<DBRef> userExcludedFoldersList = (ArrayList<DBRef>)policy.get("excludedFolders");
            System.out.println(String.valueOf(policy.getString("policyName")) + ":excluded folder list:" + userExcludedFoldersList);
            if (userExcludedFoldersList == null) {
                userExcludedFoldersList = new ArrayList<DBRef>();
            }
            for (Document userExcludedFolder : excludedFolderList) {
                String folderPath = userExcludedFolder.getString("folderPath");
                System.out.println("folderPath from db:" + folderPath);
                if (!excludedFolderPathList.contains(folderPath)) continue;
                ObjectId id = userExcludedFolder.getObjectId("_id");
                DBRef dbRef = new DBRef("EXCLUDED_FOLDERS", id);
                boolean pathAlreadyExist = false;
                for (DBRef dbRef2 : userExcludedFoldersList) {
                    if (!dbRef2.getId().toString().equalsIgnoreCase(id.toString())) continue;
                    pathAlreadyExist = true;
                    break;
                }
                if (pathAlreadyExist) continue;
                userExcludedFoldersList.add(dbRef);
            }
            BasicDBObject bkpPolicySearchQuery = new BasicDBObject();
            bkpPolicySearchQuery.append("_id", policy.get("_id"));
            BasicDBObject bkpPolicydUpdateFields = new BasicDBObject();
            bkpPolicydUpdateFields.append("excludedFolders", userExcludedFoldersList);
            BasicDBObject updatebkpPolicyQuery = new BasicDBObject();
            updatebkpPolicyQuery.append("$set", bkpPolicydUpdateFields);
            bkpPolicyDBCollection.updateOne(bkpPolicySearchQuery, updatebkpPolicyQuery);
        }
        client.close();
    }
}

