/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.types.ObjectId;

public class DeleteMultipleBkpOverview {
    static MongoCollection deviceBkpOverviewCollection;

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
            System.out.println("mongoIP, port or inputFile cannot be empty in config file...Please configure and run again");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        deviceBkpOverviewCollection = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        System.out.println("connectivity success ");
        try {
            FindIterable bkpoverviewReports = deviceBkpOverviewCollection.find();
            ArrayList<DeviceBackupOverView> deviceBackupOverViews = new ArrayList<DeviceBackupOverView>();
            for (Document doc : bkpoverviewReports) {
                DeviceBackupOverView deviceBackupOverView = new DeviceBackupOverView();
                deviceBackupOverView.setId(doc.getObjectId("_id"));
                deviceBackupOverView.setDeviceUUID(doc.getString("deviceUUID"));
                long timeStamp = deviceBackupOverView.getId().getTimestamp();
                deviceBackupOverView.setLastHeardTime(timeStamp);
                deviceBackupOverView.setUserName(doc.getString("userName"));
                deviceBackupOverView.setDeviceName(doc.getString("deviceName"));
                deviceBackupOverViews.add(deviceBackupOverView);
            }
            DeleteMultipleBkpOverview.getFilteredDeviceBackupOverViewList(deviceBackupOverViews);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getFilteredDeviceBackupOverViewList(List<DeviceBackupOverView> deviceBackupOverViews) {
        System.out.println("Inside grouping backup images");
        Map<String, List<DeviceBackupOverView>> map = deviceBackupOverViews.stream().collect(Collectors.groupingBy(DeviceBackupOverView::getDeviceUUID));
        for (Map.Entry<String, List<DeviceBackupOverView>> entry : map.entrySet()) {
            ArrayList<DeviceBackupOverView> filteredDeviceBackupOverViews = new ArrayList();
            filteredDeviceBackupOverViews = entry.getValue();
            DeviceBackupOverView oldDeviceBackupOverView = DeleteMultipleBkpOverview.getOldDeviceBackupOverView(filteredDeviceBackupOverViews);
            ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
            for (DeviceBackupOverView report : filteredDeviceBackupOverViews) {
                if (report.getId() == oldDeviceBackupOverView.getId()) continue;
                ids.add(report.getId());
            }
            System.out.println("device uuid to delete backup overview report: " + oldDeviceBackupOverView.getDeviceUUID() + " count: " + ids.size() + " Keep report id" + oldDeviceBackupOverView.getId());
            BasicDBObject inQuery = new BasicDBObject();
            inQuery.append("_id", new BasicDBObject("$in", ids));
            inQuery.append("deviceUUID", oldDeviceBackupOverView.getDeviceUUID());
            inQuery.append("userName", oldDeviceBackupOverView.getUserName());
            inQuery.append("deviceName", oldDeviceBackupOverView.getDeviceName());
            deviceBkpOverviewCollection.deleteMany(inQuery);
        }
    }

    private static DeviceBackupOverView getOldDeviceBackupOverView(List<DeviceBackupOverView> filteredDeviceBackupOverViews) {
        DeviceBackupOverView filteredDeviceBackupOver = filteredDeviceBackupOverViews.stream().sorted(Comparator.comparing(DeviceBackupOverView::getLastHeardTime)).findFirst().get();
        return filteredDeviceBackupOver;
    }
}

