/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.Device;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.bson.Document;

public class DeleteFilesForDeletedUsers {
    public static void main(String[] args) throws Exception {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String csvFile = config.getProperty("inputFile").toString();
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String cloudName = config.getProperty("cloudName").toString();
        if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort) || StringUtils.isEmpty(csvFile) || StringUtils.isEmpty(cloudName)) {
            System.out.println("mongoIP, mongoPort, cloudName or inputFile cannot be empty in config file...Please configure and run again");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> userCollection = db.getCollection("USER");
        MongoCollection<Document> deviceCollection = db.getCollection("DEVICE");
        System.out.println("cloudName :" + cloudName);
        System.out.println("mongoIP :" + mongoIP);
        System.out.println("ip :" + mongoPort);
        System.out.println(" csvFile :" + csvFile);
        Throwable throwable = null;
        Object var12_13 = null;
        try (FileInputStream inp = new FileInputStream(csvFile);){
            Workbook wb = WorkbookFactory.create(inp);
            Sheet sheet = wb.getSheetAt(0);
            int rowCount = sheet.getLastRowNum();
            System.out.println(sheet.getLastRowNum());
            Row row0 = sheet.getRow(0);
            String header = row0.getCell(0).toString();
            int i = 1;
            while (i <= rowCount) {
                Row row = sheet.getRow(i);
                Cell cell0 = row.getCell(0);
                if (cell0 == null) {
                    System.out.println("...userName is null........");
                } else {
                    String userName = cell0.toString().trim();
                    if (header.equalsIgnoreCase("UserName")) {
                        System.out.println("....inside get users for device.......");
                        List<Device> allDevicesForUser = DeleteFilesForDeletedUsers.getAllDevicesforUser(deviceCollection, userName);
                        for (Device device : allDevicesForUser) {
                            if (device == null) continue;
                            System.out.println("....inside delete files ...." + device.getDeviceUUID());
                            DeleteFilesForDeletedUsers.deleteFoldersandSubFolders(cloudName, device.getDeviceUUID());
                        }
                    } else if (header.equalsIgnoreCase("DeviceUUID")) {
                        System.out.println("....inside deviceUUID.......");
                        DeleteFilesForDeletedUsers.deleteFoldersandSubFolders(cloudName, userName);
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void deleteFoldersandSubFolders(String cloudName, String deviceUUID) {
        String filePath = "//parablu//" + cloudName + "//upload//" + deviceUUID;
        File f = new File(filePath);
        System.out.println(".......start........" + f.exists());
        DeleteFilesForDeletedUsers.deleteFilesFolders(filePath);
        System.out.println(".......end........" + f.exists());
    }

    private static void deleteFilesFolders(String filePath) {
        try {
            File f = new File(filePath);
            if (f.exists()) {
                File[] listofFiles;
                System.out.println(String.valueOf(f.list().length) + "....DeviceUUID path...." + filePath);
                File[] fileArray = listofFiles = f.listFiles();
                int n = listofFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File fname = fileArray[n2];
                    if (fname.isFile()) {
                        System.out.println("before  delete" + fname.exists() + fname.getAbsolutePath());
                        fname.delete();
                        System.out.println("after delete" + fname.exists() + fname.getAbsolutePath());
                    } else if (fname.isDirectory()) {
                        File[] listofFilesinSub;
                        File[] fileArray2 = listofFilesinSub = fname.listFiles();
                        int n3 = listofFilesinSub.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File subFile = fileArray2[n4];
                            if (subFile.isDirectory()) {
                                DeleteFilesForDeletedUsers.deleteFilesFolders(subFile.getAbsolutePath());
                            } else {
                                System.out.println("before  delete" + fname.exists() + fname.getAbsolutePath());
                                subFile.delete();
                                System.out.println("after delete" + fname.exists() + fname.getAbsolutePath());
                            }
                            ++n4;
                        }
                        fname.delete();
                    }
                    ++n2;
                }
                f.delete();
            }
        }
        catch (Exception e) {
            System.out.println("error to delete files/folders..." + e);
            e.printStackTrace();
        }
    }

    private static List<Device> getAllDevicesforUser(MongoCollection deviceCollection, String useName) {
        ArrayList<String> useNames = new ArrayList<String>();
        useNames.add(useName);
        FindIterable devices = null;
        BasicDBObject inQuery = new BasicDBObject();
        inQuery.append("userName", new BasicDBObject("$in", useNames));
        devices = deviceCollection.find(inQuery);
        ArrayList<String> devListForUser = new ArrayList<String>();
        ArrayList<Device> devicesList = new ArrayList<Device>();
        ArrayList<Device> filteredDevices = new ArrayList();
        for (Document dev : devices) {
            Device device = new Device();
            device.setDeviceUUID(dev.getString("deviceUUID"));
            device.setDeviceName(dev.getString("deviceName"));
            device.setDeviceCreatedDate(dev.getString("deviceCreatedDate"));
            device.setDeviceCreatedDateLong(Long.parseLong(device.getDeviceCreatedDate()));
            device.setId(dev.getObjectId("_id"));
            devicesList.add(device);
            String aa = dev.getString("deviceName");
            devListForUser.add(aa);
        }
        filteredDevices = devicesList.stream().sorted(Comparator.comparing(Device::getDeviceCreatedDateLong).reversed()).collect(Collectors.toList());
        return filteredDevices;
    }
}

