/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import Utility.com.parablu.HttpClientUtil;
import Utility.com.parablu.MD5Generator;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.Device;
import com.pg.encryption.util.FileEncryption;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.LogManager;
import java.util.zip.GZIPInputStream;
import javax.crypto.BadPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.bson.Document;
import org.json.JSONObject;

public class ChunkSizeCheck {
    private static final String MERGE = "merge";
    private static final String DECRYPTED = "decrypted";
    private static final String COPY = "-copy";
    private static final String PERSONAL_URL = "/personal/";
    static long kilo = 1024L;
    static long mega = kilo * kilo;
    static long giga = mega * kilo;
    static long tera = giga * kilo;

    private static String getEmailId(String emailId) {
        String replacedEmailId = emailId.replace(".", "_");
        replacedEmailId = replacedEmailId.replace("@", "_");
        return replacedEmailId;
    }

    public static String getLibraryDownloadUrl(String office365baseUrl, String fileName, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(office365baseUrl) + personalUrl + ChunkSizeCheck.getEmailId(accountId) + "/_api/web/GetFolderByServerRelativeUrl('" + personalUrl + ChunkSizeCheck.getEmailId(accountId) + "/" + pbFolderName + "/" + userName + "/" + suffixFolderPath + "')" + "/Files('" + fileName + "')/$value";
    }

    private static String getMd5FromFileName(String fileName, int occurance) {
        String md5 = "";
        if (occurance == 1 && !fileName.startsWith("part")) {
            md5 = fileName.substring(0, fileName.lastIndexOf(46));
        } else if (occurance == 1 && fileName.startsWith("part")) {
            md5 = fileName.substring(fileName.lastIndexOf(46) + 1);
        } else if (occurance == 0) {
            md5 = fileName;
        } else if (occurance > 1) {
            md5 = fileName.substring(fileName.indexOf(46) + 1, fileName.lastIndexOf(46));
        }
        if (StringUtils.isNotEmpty(md5) && md5.contains("_")) {
            md5 = md5.substring(0, md5.lastIndexOf("_"));
        }
        return md5;
    }

    private static String getChunkNewCollectionName(String md5) {
        int hashCode = Arrays.hashCode(md5.getBytes());
        int chunkDetailDest = Math.abs(hashCode % 101);
        return "CHUNK_DETAIL_" + chunkDetailDest;
    }

    public static void main(String[] args) throws Exception {
        LogManager.getLogManager().reset();
        System.out.println(".... ");
        Properties p = System.getProperties();
        AbstractFileConfiguration config = null;
        String filePath = "/home/inba/Desktop/fileList";
        File file = new File(filePath);
        Scanner sc = new Scanner(file);
        ArrayList<String> pathList = new ArrayList<String>();
        while (sc.hasNextLine()) {
            String fileName = sc.nextLine();
            int occurance = StringUtils.countMatches(fileName, ".");
            String md5 = ChunkSizeCheck.getMd5FromFileName(fileName, occurance);
            pathList.add(md5);
        }
        sc.close();
        String mongoIP = "trent-restore-koti.parablu.com";
        String mongoPort = "27017";
        if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        FindIterable<Document> devices = null;
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("userName", "TRE19642"));
        andQuery.put("$and", whereQuery);
        devices = deviceColl.find(andQuery);
        ArrayList<Device> devList = new ArrayList<Device>();
        for (Document dev : devices) {
            Device device = new Device();
            device.setDeviceUUID(dev.getString("deviceUUID"));
            device.setDestCollection(dev.getString("destCollection"));
            device.setUserName(dev.getString("userName"));
            devList.add(device);
        }
        System.out.println("....device...." + devList.size());
        pathList = new ArrayList();
        pathList.add("4a5fae60b964294a8f8e2cd1be0364a3");
        for (String md5 : pathList) {
            String collection = ChunkSizeCheck.getChunkNewCollectionName(md5);
            System.out.println("....name and collection .... " + md5 + "..." + collection);
            MongoCollection<Document> chunkCollection = db.getCollection(collection);
            andQuery = new BasicDBObject();
            whereQuery = new ArrayList();
            whereQuery.add(new BasicDBObject("md5", md5));
            andQuery.put("$and", whereQuery);
            FindIterable<Document> chunkdetaillist = chunkCollection.find(andQuery);
            for (Document chunk : chunkdetaillist) {
                System.out.println(String.valueOf(md5) + "...." + chunk.toJson());
            }
            String userNameInPath = "";
            String deviceUUID = "d47e8c70a1aa99f2e379fadb2a0f45d2";
            if (!StringUtils.isEmpty(deviceUUID)) {
                userNameInPath = ChunkSizeCheck.getUniqueODUserFolder(deviceUUID);
            }
            userNameInPath = "qe4csybanrz8";
            String sharepointURL = "https://trentlimited-my.sharepoint.com/";
            String accountId = "Pradeep_Chauhan_trent-tata_com";
            MongoCollection<Document> pcitokenCollection = db.getCollection("PCI_AUTHORIZATION_TOKENS");
            FindIterable<Document> pciTokenist = pcitokenCollection.find();
            String accessToken = "";
            for (Document chunk : pciTokenist) {
                accessToken = chunk.getString("accessToken");
            }
            for (Document chunk : chunkdetaillist) {
                System.out.println(String.valueOf(md5) + "...." + chunk.toJson());
                String cloudStoragePath = chunk.getString("cloudStoragePath");
                String containerName = chunk.getString("containerName");
                String cloudChunkName = chunk.getString("cloudChunkName");
                String fileNameToDownload = "";
                if (chunk.getString("encodedName") != null) {
                    fileNameToDownload = chunk.getString("encodedName").replaceAll("/", "_");
                } else {
                    fileNameToDownload = ChunkSizeCheck.convertStringTOBase64(cloudChunkName);
                    fileNameToDownload = fileNameToDownload.replaceAll("/", "_");
                }
                String downloadurl = ChunkSizeCheck.getLibraryDownloadUrl(sharepointURL, fileNameToDownload, accountId, userNameInPath, cloudStoragePath, "PB");
                System.out.println("...url..." + downloadurl);
                HttpResponse result = ChunkSizeCheck.executeDownload(downloadurl, accessToken);
                InputStream inputStream = result.getEntity().getContent();
                String saltKey = "";
                String fileName = "abc";
                String userName = "TRE19642";
                String restorePath = "/home/inba/Desktop/decrypt";
                File decryptedFile = ChunkSizeCheck.getDecryptedFile(saltKey, fileName, new BufferedInputStream(inputStream), userName, restorePath);
                byte[] array = Files.readAllBytes(Paths.get(decryptedFile.getAbsolutePath(), new String[0]));
                InputStream compressedStream = new ByteArrayInputStream(array);
                boolean isCompressed = true;
                if (isCompressed) {
                    compressedStream = new GZIPInputStream(compressedStream);
                    System.out.println("... after compression ...");
                }
                byte[] buffer = new byte[1024];
                boolean len = false;
                System.out.println("... after compression111 ...");
            }
        }
        System.exit(0);
        MongoCollection<Document> deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        String deviceUUIDList = config.getProperty("deviceUUID").toString();
        if (StringUtils.isEmpty(deviceUUIDList)) {
            devices = deviceColl.find();
        } else {
            String[] deviceUUIDs = deviceUUIDList.split(",");
            ArrayList uuids = new ArrayList();
            String[] stringArray = deviceUUIDs;
            int n = deviceUUIDs.length;
            int userNameInPath = 0;
            while (userNameInPath < n) {
                String uuid = stringArray[userNameInPath];
                uuid = uuid.replace("[", "");
                uuid = uuid.replace("]", "");
                uuid = uuid.trim();
                uuids.add(uuid);
                ++userNameInPath;
            }
            System.out.println("uuids ..." + uuids);
            BasicDBObject inQuery = new BasicDBObject();
            inQuery.append("deviceUUID", new BasicDBObject("$in", uuids));
            devices = deviceColl.find(inQuery);
        }
        System.out.println("Converting device Db object to list of  device ...");
        devList = new ArrayList();
        for (Document dev : devices) {
            Device device = new Device();
            device.setDeviceUUID(dev.getString("deviceUUID"));
            device.setDestCollection(dev.getString("destCollection"));
            device.setUserName(dev.getString("userName"));
            devList.add(device);
        }
        MongoCollection<Document> userColl = db.getCollection("USER");
        String userName = "";
        FindIterable<Document> users = userColl.find();
        for (Document document : users) {
            System.out.println("....user.... " + document.getString("userName"));
            boolean bl = true;
        }
    }

    private static String convertStringTOBase64(String name) {
        String base64EncodeString = null;
        if (name != null) {
            byte[] bytes = DigestUtils.md5(name);
            byte[] bytesEncoded = Base64.encodeBase64(bytes);
            base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            System.out.println("ecncoded value for given string is " + base64EncodeString);
        }
        return base64EncodeString;
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty(deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString(deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    public static String getSize(long size) {
        String s = "";
        double kb = (double)size / (double)kilo;
        double mb = kb / (double)kilo;
        double gb = mb / (double)kilo;
        double tb = gb / (double)kilo;
        if (size < kilo) {
            s = String.valueOf(size) + " Bytes";
        } else if (size >= kilo && size < mega) {
            s = String.valueOf(String.format("%.2f", kb)) + " KB";
        } else if (size >= mega && size < giga) {
            s = String.valueOf(String.format("%.2f", mb)) + " MB";
        } else if (size >= giga && size < tera) {
            s = String.valueOf(String.format("%.2f", gb)) + " GB";
        } else if (size >= tera) {
            s = String.valueOf(String.format("%.2f", tb)) + " TB";
        }
        return s;
    }

    private static boolean isPBDrive(String json) {
        boolean pbDrive = false;
        String webUrl = "";
        try {
            JSONObject jsonObject = new JSONObject(json);
            webUrl = (String)jsonObject.get("webUrl");
            String docLibraryName = webUrl.substring(webUrl.lastIndexOf("/") + 1);
            System.out.println(".....doclib....." + docLibraryName);
            if (!StringUtils.isEmpty(docLibraryName) && docLibraryName.equalsIgnoreCase("PB")) {
                pbDrive = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            pbDrive = false;
        }
        return pbDrive;
    }

    public static HttpResponse executeDownload(String downloadUrl, String accessToken) throws ClientProtocolException, IOException {
        System.out.println(" ............new path................." + downloadUrl);
        HttpGet httpGet = new HttpGet(downloadUrl);
        httpGet.addHeader("Authorization", "Bearer " + accessToken);
        httpGet.addHeader("Accept", "application/json;odata=verbose");
        httpGet.addHeader("Content-Type", "*/*");
        HttpClient httpclient = HttpClientUtil.getSSlConnection();
        HttpResponse result = httpclient.execute(httpGet);
        System.out.println(String.valueOf(result.getStatusLine().getReasonPhrase()) + "...Inside execute..." + result.getStatusLine().getStatusCode());
        System.out.println(" filename and size...." + result.getEntity().getContentLength());
        return result;
    }

    private static File getDecryptedFile(String saltKey, String fileName, BufferedInputStream inputStream, String userName, String restorePath) {
        BufferedInputStream inputStreamTemp = inputStream;
        File decryptedDir = ChunkSizeCheck.createDecryptedDirs(restorePath);
        if (inputStreamTemp == null) {
            return null;
        }
        String copyPath = decryptedDir + "/" + fileName + COPY;
        try {
            FileUtils.copyInputStreamToFile(inputStreamTemp, new File(copyPath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File decryptedFile = new File(decryptedDir + "/" + fileName);
        System.out.println("Before trying with userName normal copy file case>>>>>>" + userName + "inputstreamlength>>>>");
        File copyFile = new File(decryptedDir + "/" + fileName + COPY);
        try {
            inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        decryptedFile = ChunkSizeCheck.decrypt(saltKey, userName, inputStreamTemp, decryptedFile);
        System.out.println("END OF trying with userName normal case>>>>>>");
        if (decryptedFile == null) {
            String userLowerCase = null;
            try {
                userLowerCase = userName.toLowerCase();
                System.out.println("Decryptfile is null so try with user lowercase...." + userLowerCase);
                decryptedFile = new File(decryptedDir + "/" + fileName);
                inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            decryptedFile = ChunkSizeCheck.decrypt(saltKey, userLowerCase, inputStreamTemp, decryptedFile);
            System.out.println("END Of try with user lowercase..");
            if (decryptedFile == null) {
                String userUpperCase = null;
                try {
                    userUpperCase = userName.toUpperCase();
                    System.out.println("Decryptfile is null so try with user uppercase.." + userUpperCase);
                    decryptedFile = new File(decryptedDir + "/" + fileName);
                    inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                decryptedFile = ChunkSizeCheck.decrypt(saltKey, userUpperCase, inputStreamTemp, decryptedFile);
                System.out.println("END Of try with user uppercase...\t");
            }
            if (decryptedFile == null) {
                System.out.println("DEcrypted file is null>>>>> so create new file.....");
                decryptedFile = new File(decryptedDir + "/" + fileName);
                try {
                    inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                decryptedFile = null;
            }
        }
        if (copyFile.exists()) {
            copyFile.delete();
        }
        try {
            inputStreamTemp.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("....decryptedfile length...." + decryptedFile.length() + "|" + fileName);
        return decryptedFile;
    }

    private static File createDecryptedDirs(String restorePath) {
        File mergeDir;
        File decryptedDir = new File(String.valueOf(restorePath) + DECRYPTED);
        if (!decryptedDir.exists()) {
            decryptedDir.mkdir();
        }
        if (!(mergeDir = new File(String.valueOf(restorePath) + MERGE)).exists()) {
            mergeDir.mkdir();
        }
        return decryptedDir;
    }

    public static File decrypt(String saltKey, String userUniqueId, BufferedInputStream inputStream, File decryptedFile) {
        try {
            String md5ForUserUniqueId = MD5Generator.generateMD5OfString(userUniqueId);
            FileEncryption encryption = new FileEncryption();
            encryption.makeKey(saltKey, md5ForUserUniqueId);
            encryption.decrypt(inputStream, decryptedFile);
        }
        catch (BadPaddingException e1) {
            e1.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return decryptedFile;
    }
}

