/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import Utility.com.parablu.HttpClientUtil;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.EmailProps;
import com.parablu.pcbd.domain.EmailRecipent;
import java.util.ArrayList;
import org.apache.commons.configuration.ConfigurationException;
import org.bson.Document;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class CheckBackupSize {
    static String mongoIP = "";
    static String mongoPort = "";
    static long maxPercentage = 0L;
    static String paramailURL = "";

    public static void main(String[] args) throws ConfigurationException {
        if (args.length != 4) {
            System.out.println(" mongoIP/ mongoPort/ maxPercentage/ paramailURL/");
            System.exit(400);
        }
        mongoIP = args[0];
        mongoPort = args[1];
        maxPercentage = Long.parseLong(args[2]);
        paramailURL = args[3];
        if (!paramailURL.endsWith("/")) {
            paramailURL = String.valueOf(String.valueOf(String.valueOf(paramailURL))) + "/";
        }
        MongoDatabase db = null;
        MongoClient parabluClient = null;
        MongoClient client = null;
        long percent = 0L;
        try {
            long storageLimitInKb;
            System.out.println(".....starting checkbackupsize.........");
            MongoClientURI parabluURI = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu");
            parabluClient = new MongoClient(parabluURI);
            MongoDatabase parabluDB = parabluClient.getDatabase(parabluURI.getDatabase());
            MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
            client = new MongoClient(uri);
            db = client.getDatabase(uri.getDatabase());
            MongoCollection<Document> collection = parabluDB.getCollection("CLOUD_PROPERTIES");
            Document cloudProperties = (Document)collection.find().first();
            if (cloudProperties == null || cloudProperties.get("storageLimitInKb") == null) {
                System.out.println("In cloud property storageLimitInKb is empty...");
                System.exit(1);
            }
            if ((storageLimitInKb = cloudProperties.getLong("storageLimitInKb").longValue()) <= 0L) {
                System.out.println("In cloud property storageLimitInKb is empty...");
                System.exit(1);
            }
            System.out.println("storageLimitInKb in cloud properties..." + storageLimitInKb);
            MongoCollection<Document> deviceBkpOverview = db.getCollection("DEVICE_BACKUP_OVERVIEW");
            BasicDBObject andQuery = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("isDeviceDeleted", false));
            whereQuery.add(new BasicDBObject("isUserDeleted", false));
            andQuery.put("$and", whereQuery);
            FindIterable<Document> overviews = deviceBkpOverview.find(andQuery);
            long storageUtilized = 0L;
            for (Document overview : overviews) {
                if (overview == null) continue;
                long size = overview.getLong("storageUtilized");
                storageUtilized += size;
            }
            System.out.println("storageUtilized in backupOverview tables..." + storageUtilized);
            percent = storageUtilized * 100L / storageLimitInKb;
            System.out.println("percent=" + percent);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (percent > maxPercentage) {
            try {
                if (percent > 100L) {
                    percent = 100L;
                }
                MongoCollection<Document> usersDB = db.getCollection("USER");
                BasicDBObject andQuery = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                whereQuery.add(new BasicDBObject("admin", true));
                whereQuery.add(new BasicDBObject("active", true));
                andQuery.put("$and", whereQuery);
                FindIterable<Document> users = usersDB.find(andQuery);
                ArrayList<EmailRecipent> recipents = new ArrayList<EmailRecipent>();
                for (Document user : users) {
                    EmailRecipent emailRecipent = new EmailRecipent();
                    emailRecipent.setUserName(user.getString("userName"));
                    emailRecipent.setEmail(user.getString("emailId"));
                    recipents.add(emailRecipent);
                }
                HttpComponentsClientHttpRequestFactory requestFactory = HttpClientUtil.getHttpRequestFactory();
                RestTemplate restTemplate = new RestTemplate(requestFactory);
                ArrayList messageConverters = new ArrayList();
                messageConverters.add(new MappingJackson2HttpMessageConverter());
                restTemplate.setMessageConverters(messageConverters);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                EmailProps emailProps = new EmailProps();
                emailProps.setRecipents(recipents);
                HttpEntity<EmailProps> entity = new HttpEntity<EmailProps>(emailProps, headers);
                emailProps.setAction("overall-backup-limit-reached");
                emailProps.setFileName(String.valueOf(percent));
                emailProps.setToUser(true);
                String url = String.valueOf(String.valueOf(String.valueOf(paramailURL))) + "paramail/send/mail/";
                restTemplate.put(url, entity, new Object[0]);
                try {
                    requestFactory.destroy();
                }
                catch (Exception e) {
                    System.out.println("......closing mail connections......");
                }
            }
            catch (RestClientException e2) {
                e2.printStackTrace();
                CheckBackupSize.closeConnections(parabluClient, client);
                System.exit(0);
            }
        }
        CheckBackupSize.closeConnections(parabluClient, client);
        System.out.println(".....finishing checkbackupsize.........");
        System.exit(0);
    }

    private static void closeConnections(MongoClient parabluClient, MongoClient client) {
        if (client != null) {
            client.close();
        }
        if (parabluClient != null) {
            parabluClient.close();
        }
    }
}

