/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.X509Certificate;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.json.simple.JSONArray;

public class BulkBlockAndDelete {
    public static void main(String[] args) throws Exception {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String cloudName = config.getProperty("cloudName").toString();
        String ip = config.getProperty("ip").toString();
        String token = config.getProperty("token").toString();
        String csvFile = config.getProperty("inputFile").toString();
        String deletedByUserName = config.getProperty("deletedByUserName").toString();
        String actionType = config.getProperty("actionType").toString();
        if (StringUtils.isEmpty(cloudName) || StringUtils.isEmpty(ip) || StringUtils.isEmpty(csvFile) || StringUtils.isEmpty(token) || StringUtils.isEmpty(deletedByUserName) || StringUtils.isEmpty(actionType)) {
            System.out.println("ip, token, deletedByUserName or inputFile cannot be empty in config file...Please configure and run again");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("cloudName :" + cloudName);
        System.out.println("ip :" + ip);
        System.out.println(" token :" + token);
        System.out.println(" csvFile :" + csvFile);
        System.out.println(" deletedByUserName :" + deletedByUserName);
        ArrayList<String> userNames = new ArrayList<String>();
        Throwable throwable = null;
        Object var10_11 = null;
        try (FileInputStream inp = new FileInputStream(csvFile);){
            Workbook wb = WorkbookFactory.create(inp);
            Sheet sheet = wb.getSheetAt(0);
            int rowCount = sheet.getLastRowNum();
            System.out.println(sheet.getLastRowNum());
            int i = 1;
            while (i <= rowCount) {
                Row row = sheet.getRow(i);
                Cell cell1 = row.getCell(0);
                String useName = cell1.toString().trim();
                userNames.add(useName);
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (actionType.equalsIgnoreCase("delete")) {
            System.out.println(" actionType :" + actionType);
            BulkBlockAndDelete.multipleDelete(userNames, cloudName, deletedByUserName, ip, token, deletedByUserName);
        } else if (actionType.equalsIgnoreCase("block")) {
            System.out.println(" actionType :" + actionType);
            BulkBlockAndDelete.multipleBlock(userNames, cloudName, deletedByUserName, ip, token, deletedByUserName);
        } else if (actionType.equalsIgnoreCase("unblock")) {
            System.out.println(" actionType :" + actionType);
            BulkBlockAndDelete.multipleUnBlock(userNames, cloudName, deletedByUserName, ip, token, deletedByUserName);
        } else {
            System.out.println(" actionType is illegal:" + actionType);
        }
    }

    private static String createHttpsUrl(String ip, String cloudName, Integer port, String url) {
        String httpsUrl = "https://";
        String ipValue = port != null ? String.valueOf(ip) + ":" + port : ip;
        return String.valueOf(httpsUrl) + ipValue + "/paracloud" + "/versions/" + 2.2 + "/clouds" + "/" + cloudName + url;
    }

    public static boolean multipleDelete(List<String> userNames, String cloudName, String userName, String ip, String token, String deletedByUserName) {
        int responseStatusCode = 0;
        boolean logSent = false;
        try {
            BulkBlockAndDelete.createSSLFactory();
            String urlString = BulkBlockAndDelete.createHttpsUrl(ip, cloudName, null, "/users/delete/");
            URL url = new URL(urlString);
            System.out.println("Calling for multiple delete users URI:" + url.toString());
            HttpsURLConnection httpConn = (HttpsURLConnection)url.openConnection();
            httpConn.setRequestMethod("POST");
            httpConn.setRequestProperty("Content-Language", "en-US");
            httpConn.setRequestProperty("token", token);
            httpConn.setRequestProperty("deletedBy", deletedByUserName);
            httpConn.setRequestProperty("Accept", "application/json");
            httpConn.setRequestProperty("Content-Type", "application/json");
            httpConn.setUseCaches(false);
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            OutputStream os = httpConn.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
            JSONArray list = new JSONArray();
            for (String un : userNames) {
                list.add(un);
            }
            osw.write(list.toJSONString());
            osw.flush();
            osw.close();
            os.close();
            httpConn.connect();
            responseStatusCode = httpConn.getResponseCode();
            System.out.println("responsestatus code" + responseStatusCode);
        }
        catch (Exception e) {
            System.out.println("Exception " + e);
            e.printStackTrace();
        }
        return logSent;
    }

    public static boolean multipleBlock(List<String> userNames, String cloudName, String userName, String ip, String token, String deletedByUserName) {
        Object response = null;
        int responseStatusCode = 0;
        boolean logSent = false;
        try {
            BulkBlockAndDelete.createSSLFactory();
            String urlString = BulkBlockAndDelete.createHttpsUrl(ip, cloudName, null, "/users/block/");
            URL url = new URL(urlString);
            HttpsURLConnection httpConn = (HttpsURLConnection)url.openConnection();
            httpConn.setRequestMethod("POST");
            httpConn.setRequestProperty("Content-Language", "en-US");
            httpConn.setRequestProperty("token", token);
            httpConn.setRequestProperty("blockedBy", deletedByUserName);
            httpConn.setRequestProperty("active", "false");
            httpConn.setRequestProperty("Accept", "application/json");
            httpConn.setRequestProperty("Content-Type", "application/json");
            httpConn.setUseCaches(false);
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            OutputStream os = httpConn.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
            JSONArray list = new JSONArray();
            for (String un : userNames) {
                list.add(un);
            }
            osw.write(list.toJSONString());
            osw.flush();
            osw.close();
            os.close();
            System.out.println("Calling for multiple Users block URI:" + url.toString());
            httpConn.connect();
            responseStatusCode = httpConn.getResponseCode();
            System.out.println("responsestatus code" + responseStatusCode);
        }
        catch (Exception e) {
            System.out.println("Exception " + e);
            e.printStackTrace();
        }
        return logSent;
    }

    public static void multipleUnBlock(List<String> userNames, String cloudName, String userName, String ip, String token, String deletedByUserName) {
        try {
            int responseStatusCode = 0;
            BulkBlockAndDelete.createSSLFactory();
            String urlString = BulkBlockAndDelete.createHttpsUrl(ip, cloudName, null, "/users/block/");
            URL url = new URL(urlString);
            System.out.println("Calling for multiple Users unblock URI:" + url.toString());
            HttpsURLConnection httpConn = (HttpsURLConnection)url.openConnection();
            httpConn.setRequestMethod("POST");
            httpConn.setRequestProperty("Content-Language", "en-US");
            httpConn.setRequestProperty("token", token);
            httpConn.setRequestProperty("blockedBy", deletedByUserName);
            httpConn.setRequestProperty("active", "true");
            httpConn.setRequestProperty("Accept", "application/json");
            httpConn.setRequestProperty("Content-Type", "application/json");
            httpConn.setUseCaches(false);
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            OutputStream os = httpConn.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
            JSONArray list = new JSONArray();
            for (String un : userNames) {
                list.add(un);
            }
            osw.write(list.toJSONString());
            osw.flush();
            osw.close();
            os.close();
            System.out.println("Calling for multiple Users unblock URI:" + url.toString());
            httpConn.connect();
            responseStatusCode = httpConn.getResponseCode();
            System.out.println("responsestatus code" + responseStatusCode);
        }
        catch (Exception e) {
            System.out.println("Exception " + e);
            e.printStackTrace();
        }
    }

    private static void createSSLFactory() {
        final java.security.cert.X509Certificate[] xs = null;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                return xs;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            System.out.println("" + e);
            System.out.println("Exception in creating SSL Factory :" + e.getMessage());
        }
        if (sc != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = (hostname, session) -> true;
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
    }
}

