/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.operation.OrderBy;
import com.parablu.pcbd.domain.Device;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.bson.Document;

public class AdToAADConversionFix {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String csvFile = config.getProperty("inputFile").toString();
        if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort) || StringUtils.isEmpty(csvFile)) {
            System.out.println("mongoIP, port or inputFile cannot be empty in config file...Please configure and run again");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> userCollection = db.getCollection("USER");
        MongoCollection<Document> deviceCollection = db.getCollection("DEVICE");
        MongoCollection<Document> deviceBkpOverviewCollection = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        System.out.println("connectivity success ");
        try {
            int count = 0;
            Throwable throwable = null;
            Object var13_15 = null;
            try (FileInputStream inp = new FileInputStream(csvFile);){
                Workbook wb = WorkbookFactory.create(inp);
                Sheet sheet = wb.getSheetAt(0);
                int rowCount = sheet.getLastRowNum();
                int i = 0;
                while (i <= rowCount) {
                    System.out.println("===============================");
                    Row row = sheet.getRow(i);
                    Cell cell1 = row.getCell(0);
                    if (cell1 != null) {
                        String useName = cell1.toString().trim();
                        Object deviceBackupOverViewList = null;
                        List<Device> allDevicesForUser = AdToAADConversionFix.getAllDevicesforUser(deviceCollection, useName);
                        Set<String> uniqDevicesList = AdToAADConversionFix.getmultipledevicesforuser(allDevicesForUser);
                        for (String devicename : uniqDevicesList) {
                            FindIterable<Document> devices = AdToAADConversionFix.getDevices(deviceCollection, useName, devicename);
                            ArrayList<Device> devListForUserAnddevice = new ArrayList<Device>();
                            List<Object> filtereddevListForUserAnddevice = new ArrayList();
                            for (Document device1 : devices) {
                                Device device = new Device();
                                device.setDeviceUUID(device1.getString("deviceUUID"));
                                device.setDeviceName(device1.getString("deviceName"));
                                device.setDeviceCreatedDate(device1.getString("deviceCreatedDate"));
                                device.setDeviceCreatedDateLong(Long.parseLong(device.getDeviceCreatedDate()));
                                device.setId(device1.getObjectId("_id"));
                                devListForUserAnddevice.add(device);
                            }
                            filtereddevListForUserAnddevice = devListForUserAnddevice.stream().sorted(Comparator.comparing(Device::getDeviceCreatedDateLong).reversed()).collect(Collectors.toList());
                            System.out.println(".... devicess with user name and device name......" + useName + "  " + devicename + "  count is  " + filtereddevListForUserAnddevice.size());
                            if (filtereddevListForUserAnddevice.size() <= 1) continue;
                            Device latestDevice = (Device)filtereddevListForUserAnddevice.get(0);
                            Device oldDevice = (Device)filtereddevListForUserAnddevice.get(filtereddevListForUserAnddevice.size() - 1);
                            System.out.println("latest device uuid  from device table ..  " + latestDevice.getDeviceUUID() + "  Oldest device uuid ......" + oldDevice.getDeviceUUID());
                            for (Device device : filtereddevListForUserAnddevice) {
                                if (latestDevice.getId() == device.getId()) continue;
                                BasicDBObject deviceBlockQuery = new BasicDBObject();
                                deviceBlockQuery.append("_id", device.getId());
                                BasicDBObject updateFields = new BasicDBObject();
                                BasicDBObject updateQuery = new BasicDBObject();
                                String newdevicename = String.valueOf(device.getDeviceName()) + "-old";
                                updateFields.append("deviceName", newdevicename);
                                updateFields.append("displayName", newdevicename);
                                updateQuery.append("$set", updateFields);
                                deviceCollection.updateOne(deviceBlockQuery, updateQuery);
                                System.out.println("Block device uudi.." + device.getDeviceUUID());
                                FindIterable<Document> deviceBkpOverviewReports = AdToAADConversionFix.getDeviceBkpOverviewReport(deviceBkpOverviewCollection, useName, device.getDeviceUUID());
                                for (Document doc : deviceBkpOverviewReports) {
                                    BasicDBObject bkpOverviewSearchQuery = new BasicDBObject();
                                    bkpOverviewSearchQuery.append("_id", doc.getObjectId("_id"));
                                    String oldDisplayName = doc.getString("displayName");
                                    String oldDeviceDisplayName = doc.getString("deviceDisplayName");
                                    updateFields = new BasicDBObject();
                                    updateQuery = new BasicDBObject();
                                    updateFields.append("deviceName", newdevicename);
                                    if (StringUtils.isNotEmpty(oldDisplayName)) {
                                        System.out.println(".... display name is there so set..");
                                        updateFields.append("displayName", newdevicename);
                                    }
                                    if (StringUtils.isNotEmpty(oldDeviceDisplayName)) {
                                        System.out.println(".... device display name is there so set..");
                                        updateFields.append("deviceDisplayName", newdevicename);
                                    }
                                    updateQuery.append("$set", updateFields);
                                    deviceBkpOverviewCollection.updateOne(bkpOverviewSearchQuery, updateQuery);
                                }
                            }
                            ++count;
                        }
                    }
                    System.out.println("===============================");
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            System.out.println("Done successfully.devices count which has multiple devices with same name ....." + count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static long getBkpOverviewCount(MongoCollection deviceBkpOverviewCollection, String useName, String duplicateDeviceName) {
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery2 = new ArrayList<BasicDBObject>();
        whereQuery2.add(new BasicDBObject("userName", useName));
        whereQuery2.add(new BasicDBObject("deviceName", duplicateDeviceName));
        andQuery.put("$and", whereQuery2);
        long deviceBkpOverviewCount = deviceBkpOverviewCollection.count(andQuery);
        return deviceBkpOverviewCount;
    }

    private static FindIterable<Document> getDeviceBkpOverviewReport(MongoCollection deviceBkpOverviewCollection, String useName, String deviceUUID) {
        BasicDBObject andQuery1 = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
        whereQuery1.add(new BasicDBObject("deviceUUID", deviceUUID));
        andQuery1.put("$and", whereQuery1);
        FindIterable<Document> bkpoverview = deviceBkpOverviewCollection.find(andQuery1);
        return bkpoverview;
    }

    private static FindIterable<Document> getDevices(MongoCollection deviceCollection, String useName, String deviceName) {
        BasicDBObject andQuery1 = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
        whereQuery1.add(new BasicDBObject("deviceName", deviceName));
        whereQuery1.add(new BasicDBObject("userName", useName));
        andQuery1.put("$and", whereQuery1);
        FindIterable<Document> devices = deviceCollection.find(andQuery1);
        return devices;
    }

    private static Document getOldDeviceBkpOverviewReport(MongoCollection deviceBkpOverviewCollection, String useName, String duplicateDeviceName) {
        BasicDBObject andQuery1 = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
        whereQuery1.add(new BasicDBObject("deviceName", duplicateDeviceName));
        whereQuery1.add(new BasicDBObject("userName", useName));
        andQuery1.put("$and", whereQuery1);
        Document bkpoverview = (Document)deviceBkpOverviewCollection.find(andQuery1).sort(new BasicDBObject("epaInstallationDate", (Object)OrderBy.ASC.getIntRepresentation())).first();
        return bkpoverview;
    }

    private static List<Device> getAllDevicesforUser(MongoCollection deviceCollection, String useName) {
        ArrayList<String> useNames = new ArrayList<String>();
        useNames.add(useName);
        FindIterable devices = null;
        BasicDBObject inQuery = new BasicDBObject();
        inQuery.append("userName", new BasicDBObject("$in", useNames));
        devices = deviceCollection.find(inQuery);
        ArrayList<String> devListForUser = new ArrayList<String>();
        ArrayList<Device> devicesList = new ArrayList<Device>();
        ArrayList<Device> filteredDevices = new ArrayList();
        for (Document dev : devices) {
            Device device = new Device();
            device.setDeviceUUID(dev.getString("deviceUUID"));
            device.setDeviceName(dev.getString("deviceName"));
            device.setDeviceCreatedDate(dev.getString("deviceCreatedDate"));
            device.setDeviceCreatedDateLong(Long.parseLong(device.getDeviceCreatedDate()));
            device.setId(dev.getObjectId("_id"));
            devicesList.add(device);
            String aa = dev.getString("deviceName");
            devListForUser.add(aa);
        }
        filteredDevices = devicesList.stream().sorted(Comparator.comparing(Device::getDeviceCreatedDateLong).reversed()).collect(Collectors.toList());
        return filteredDevices;
    }

    private static Set<String> getmultipledevicesforuser(List<Device> devListForUser) {
        ArrayList<String> deviceForUser = new ArrayList<String>();
        for (Device dev : devListForUser) {
            deviceForUser.add(dev.getDeviceName());
        }
        HashSet<String> allDuplicateItems = new HashSet<String>();
        int j = 0;
        while (j < deviceForUser.size()) {
            int count = 0;
            int k = 0;
            while (k < deviceForUser.size()) {
                if (((String)deviceForUser.get(j)).toString().equals(((String)deviceForUser.get(k)).toString()) && ++count > 1) {
                    allDuplicateItems.add((String)deviceForUser.get(j));
                }
                ++k;
            }
            ++j;
        }
        return allDuplicateItems;
    }
}

