/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class Praveen {
    private static int skipValue;
    private static TimerTask backupTimerTask;
    private static Timer timer;
    private static int count;
    int deviceuuidCount;
    private static int threads;
    private static int limit;
    private static List<Device> devList;

    static {
        devList = new ArrayList<Device>();
    }

    public static void main(String[] args) throws ConfigurationException {
        try {
            File file = new File("serverOutput.txt");
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
                file.createNewFile();
            }
            PrintStream o = new PrintStream(file);
            System.setOut(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("This will be written to the text file");
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String thread = config.getProperty("thread").toString();
        String deviceUUID = config.getProperty("deviceUUID").toString();
        int threadCount = Integer.parseInt(thread);
        if (StringUtils.isEmpty((String)mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection deviceColl = db.getCollection("DEVICE");
        MongoCollection latestDeviceBkpInfoColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
        MongoCollection deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        Object devices = null;
        BasicDBObject andQuery2 = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery2 = new ArrayList<BasicDBObject>();
        whereQuery2.add(new BasicDBObject("deviceUUID", (Object)deviceUUID));
        andQuery2.put((Object)"$and", whereQuery2);
        Document latestDevice = (Document)deviceColl.find((Bson)andQuery2).first();
        Device device1 = new Device();
        device1.setDeviceUUID(latestDevice.getString((Object)"deviceUUID"));
        device1.setDestCollection(latestDevice.getString((Object)"destCollection"));
        device1.setDecoupled((Boolean)latestDevice.get((Object)"decoupled"));
        devList.add(device1);
        System.out.println("Converting device Db object to list of  device ...");
        System.out.println("total device size is...." + devList.size());
        int threadSizeVal = threadCount;
        ExecutorService executor = Executors.newFixedThreadPool(threadSizeVal);
        ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
        Praveen.checkThreadStatusAndStartUpdate(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool);
        int i = 0;
        while (i < threadSizeVal) {
            System.out.println("Creating thread for first time>>>>>>>>> i value::");
            Praveen.callUpdateDBEntries(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool);
            ++i;
        }
        Device device2 = Praveen.getDeviceFromList();
        if (device2 != null) {
            Praveen.updateLatestSize(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, device2);
        }
    }

    private static synchronized Device getDeviceFromList() {
        Device dev = null;
        try {
            if (!CollectionUtils.isEmpty(devList) && devList.get(0) != null) {
                dev = devList.get(0);
                System.out.println(".............." + dev.getDeviceUUID());
                devList.remove(dev);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dev;
    }

    private static void checkThreadStatusAndStartUpdate(MongoDatabase db, MongoCollection latestDeviceBkpInfoColl, MongoCollection deviceBkpOverviewColl, CompletionService<String> pool) {
        if (timer == null) {
            timer = new Timer();
        }
        if (backupTimerTask == null) {
            timer.schedule(backupTimerTask, 1000L, 1000L);
        }
    }

    private static void callUpdateDBEntries(MongoDatabase db, MongoCollection latestDeviceBkpInfoColl, MongoCollection deviceBkpOverviewColl, CompletionService<String> pool) {
        Device device = Praveen.getDeviceFromList();
        if (device != null) {
            Device device2 = null;
            Runnable uploadJob = () -> {
                try {
                    Praveen.updateLatestSize(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, device2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
            pool.submit(uploadJob, "");
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    private static void updateLatestSize(MongoDatabase db, MongoCollection latestDeviceBkpInfoColl, MongoCollection deviceBkpOverviewColl, Device device) {
        FindIterable folders;
        if (device == null) {
            System.out.println(String.valueOf(String.valueOf(Thread.currentThread().getName())) + ".......Device is empty so return");
            return;
        }
        System.out.println(String.valueOf(String.valueOf(Thread.currentThread().getName())) + "Satrted for device :" + device.getDeviceUUID() + " on " + System.currentTimeMillis());
        MongoCollection bkpColl = db.getCollection(device.getDestCollection());
        String deviceUUID = device.getDeviceUUID();
        Document deviceBkpOverview = (Document)deviceBkpOverviewColl.find((Bson)new BasicDBObject("deviceUUID", (Object)deviceUUID)).first();
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", (Object)deviceUUID));
        whereQuery.add(new BasicDBObject("folder", (Object)true));
        whereQuery.add(new BasicDBObject("present", (Object)true));
        andQuery.put((Object)"$and", whereQuery);
        ArrayList<Object> allFoldersList = new ArrayList<Document>();
        int skip = 0;
        System.out.println(String.valueOf(String.valueOf(Thread.currentThread().getName())) + " getting folders................");
        long latestFileSizes = 0L;
        while ((folders = bkpColl.find((Bson)andQuery).skip(skip * 200).limit(200)).first() != null) {
            for (Document document : folders) {
                allFoldersList.add(document);
            }
            ++skip;
        }
        System.out.println(String.valueOf(String.valueOf(Thread.currentThread().getName())) + " getting folders list................" + allFoldersList.size());
        latestFileSizes = Praveen.calacluateSizeForPaths(bkpColl, deviceUUID, allFoldersList, latestFileSizes);
        allFoldersList = new ArrayList();
        System.out.println(String.valueOf(String.valueOf(Thread.currentThread().getName())) + "Ended for device :" + device.getDeviceUUID() + " on " + System.currentTimeMillis());
    }

    private static long calacluateSizeForPaths(MongoCollection bkpColl, String deviceUUID, List<Document> allFoldersList, long latestFileSizes) {
        for (Document folder : allFoldersList) {
            FindIterable files;
            String folderName = "";
            folderName = StringUtils.isEmpty((String)folder.getString((Object)"devicePath")) ? folder.getString((Object)"fileName") : String.valueOf(String.valueOf(folder.getString((Object)"devicePath"))) + "/" + folder.getString((Object)"fileName");
            BasicDBObject andQuery1 = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("deviceUUID", (Object)deviceUUID));
            whereQuery.add(new BasicDBObject("devicePath", (Object)folderName));
            whereQuery.add(new BasicDBObject("folder", (Object)false));
            whereQuery.add(new BasicDBObject("present", (Object)true));
            andQuery1.put((Object)"$and", whereQuery);
            int skip1 = 0;
            int count = 0;
            while ((files = bkpColl.find((Bson)andQuery1).skip(skip1 * 200).limit(200)).first() != null) {
                ++skip1;
                ArrayList<BackUpImage> allFilesList = new ArrayList<BackUpImage>();
                int k = 0;
                for (Document document : files) {
                    ++k;
                    BackUpImage backUpImage = new BackUpImage();
                    backUpImage.setDevicePath(document.getString((Object)"devicePath"));
                    backUpImage.setFileName(document.getString((Object)"fileName"));
                    backUpImage.setLastServerModifiedTime(document.getLong((Object)"lastServerModifiedTime"));
                    if (StringUtils.isEmpty((String)backUpImage.getDevicePath()) || StringUtils.isEmpty((String)backUpImage.getFileName())) continue;
                    backUpImage.setSize(document.getLong((Object)"size"));
                    allFilesList.add(backUpImage);
                }
                List<BackUpImage> list = Praveen.getFilteredBackupImageList(allFilesList);
                for (BackUpImage image : list) {
                    ++count;
                    latestFileSizes += image.getSize();
                    System.out.println("@PVN@" + image.getDevicePath() + "\\" + image.getFileName() + "|" + image.getSize());
                }
            }
            System.out.println(String.valueOf(String.valueOf(folderName)) + "| " + count + "|" + latestFileSizes);
        }
        return latestFileSizes;
    }
}

