/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.parablu.pcbd.dao.RetryPolicyDao;
import com.parablu.pcbd.domain.OdbIdLookup;
import com.parablu.pcbd.domain.RetryPolicyTable;
import com.pg.service.RetryService;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import net.jodah.failsafe.RetryPolicy;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class RetryServiceImpl
implements RetryService {
    @Autowired
    private RetryPolicyDao retryPolicyDao;

    public RetryPolicyDao getRetryPolicyDao() {
        return this.retryPolicyDao;
    }

    public void setRetryPolicyDao(RetryPolicyDao retryPolicyDao) {
        this.retryPolicyDao = retryPolicyDao;
    }

    @Override
    public RetryPolicyTable getRetryPolicyTable(int cloudId, String policyName) {
        RetryPolicyTable retryPolicyTable = this.retryPolicyDao.getRetryPolicy(cloudId, policyName);
        if (retryPolicyTable == null) {
            retryPolicyTable = new RetryPolicyTable();
            if (retryPolicyTable.getDelayInSecs() == 0L) {
                retryPolicyTable.setDelayInSecs(5L);
            }
            if (StringUtils.isEmpty((String)retryPolicyTable.getBackoffType())) {
                retryPolicyTable.setBackoffType(BACKOFF_TYPES.FIXED.toString());
            }
            if (retryPolicyTable.getMaxDurationInSecs() == 0L) {
                retryPolicyTable.setMaxDurationInSecs(300L);
            }
            if (retryPolicyTable.getMaxRetries() == 0) {
                retryPolicyTable.setMaxRetries(5);
            }
        }
        return retryPolicyTable;
    }

    @Override
    public void saveRetryPolicy(int cloudId, RetryPolicyTable retryPolicy) {
    }

    public RetryPolicy<HttpResponse> valueOf(RetryPolicyTable policy) {
        RetryPolicy failSafePolicy = new RetryPolicy();
        switch (policy.getBackoffType()) {
            case "NONE": {
                break;
            }
            case "FIXED": {
                failSafePolicy.withDelay(Duration.ofSeconds(policy.getDelayInSecs()));
                break;
            }
            case "RANDOM": {
                failSafePolicy.withDelay(policy.getRandomMinValInSecs(), policy.getRandomMaxValInSecs(), ChronoUnit.SECONDS);
                break;
            }
            case "EXPONENTIAL": {
                failSafePolicy.withBackoff(policy.getDelayInSecs(), policy.getExponentialMaxSleepInSecs(), ChronoUnit.SECONDS, policy.getExponentialFactor());
                break;
            }
            default: {
                failSafePolicy.withDelay(policy.getDelayInSecs(), policy.getDelayInSecs(), ChronoUnit.SECONDS);
            }
        }
        if (policy.getMaxDurationInSecs() != 0L) {
            failSafePolicy.withMaxDuration(Duration.ofSeconds(policy.getMaxDurationInSecs()));
        }
        if (policy.getMaxRetries() != 0) {
            failSafePolicy.withMaxRetries(policy.getMaxRetries());
        }
        if (policy.getJitterInSecs() != 0 && policy.getBackoffType() != BACKOFF_TYPES.RANDOM.toString()) {
            failSafePolicy.withJitter(Duration.ofSeconds(policy.getJitterInSecs()));
        }
        failSafePolicy.handle(Exception.class);
        return failSafePolicy;
    }

    @Override
    public List<OdbIdLookup> getOdbIdsForLookup(int cloudId) {
        return this.retryPolicyDao.getOdbIdsForLookup(cloudId);
    }

    @Override
    public String getuserNameFromOdbFolderName(int cloudId, String fodlerName) {
        return this.retryPolicyDao.getuserNameForOdbFoldernName(cloudId, fodlerName);
    }

    static enum BACKOFF_TYPES {
        NONE,
        FIXED,
        RANDOM,
        EXPONENTIAL;

    }
}

