/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.ListInfo;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.DriveCollectionPage;
import com.microsoft.graph.requests.DriveCollectionRequest;
import com.microsoft.graph.requests.DriveCollectionRequestBuilder;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.ListCollectionRequest;
import com.microsoft.graph.requests.SiteCollectionPage;
import com.microsoft.graph.requests.SiteCollectionRequest;
import com.microsoft.graph.requests.SiteCollectionRequestBuilder;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserRequestBuilder;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EncryptionKey;
import com.parablu.pcbd.domain.OdbIdLookup;
import com.parablu.pcbd.domain.RetryPolicyTable;
import com.pg.dao.Office365Dao;
import com.pg.dao.UtilDao;
import com.pg.domain.ChunkFile;
import com.pg.element.FileDownloadElement;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.exception.BaseException;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.odb.util.OneDriveUtil;
import com.pg.service.GraphDownloadService;
import com.pg.service.RetryService;
import com.pg.service.impl.Office365DownloadServiceImplData;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.function.CheckedSupplier;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicStatusLine;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GraphDownloadServiceImpl
implements GraphDownloadService {
    private static Logger logger = LoggerFactory.getLogger(GraphDownloadServiceImpl.class);
    private static final int BUFFER_CHUNK_SIZE = 1024;
    @Autowired
    private Office365Dao office365Dao;
    @Autowired
    private UtilDao utilDao;
    @Autowired
    private DeviceDao deviceDao;
    @Autowired
    private RetryService retryService;
    private static final String BEARER = "Bearer ";

    public void setOffice365Dao(Office365Dao office365Dao) {
        this.office365Dao = office365Dao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public String getKeyForDecrypt(int cloudId, long timeStamp) {
        EncryptionKey encryptionKey = this.utilDao.getKeyForDecrypt(cloudId, timeStamp, "");
        String encryptionKeyVal = "";
        if (encryptionKey != null) {
            encryptionKeyVal = encryptionKey.getSaltKey();
            logger.debug("Recieved salt key  for file ..... " + encryptionKeyVal);
        }
        return encryptionKeyVal;
    }

    private GraphServiceClient<Request> getGraphClient() {
        String authorityHost = "https://login.microsoftonline.com";
        logger.debug("...helper constant ...." + PCHelperConstant.getMSClientId());
        GraphServiceClient graphClient = null;
        if (!StringUtils.isEmpty((String)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            logger.debug("....using proxy latest......");
            InetSocketAddress proxyInetAddress = new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort());
            logger.debug("....using proxy latest before createDefault 1bb......" + PCHelperConstant.getProxyHost() + "..pwd..." + PCHelperConstant.getProxyPort());
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            HttpClientOptions clientOptions = new HttpClientOptions();
            clientOptions.setProxyOptions(proxyOptions);
            logger.debug("....using proxy latest before createDefault 2a with host latest");
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            OkHttpClient httpClient = null;
            Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyInetAddress);
            logger.debug("....using proxy latest before createDefault 3a");
            httpClient = com.microsoft.graph.httpcore.HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(proxy).build();
            logger.debug("....using proxy latest before createDefault 4");
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).httpClient((Object)httpClient).buildClient();
            logger.debug("....using proxy latest before createDefault 5");
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).buildClient();
        }
        return graphClient;
    }

    private static boolean isPBDrive(String json) {
        boolean pbDrive = false;
        String webUrl = "";
        try {
            JSONObject jsonObject = new JSONObject(json);
            webUrl = (String)jsonObject.get("webUrl");
            String docLibraryName = webUrl.substring(webUrl.lastIndexOf("/") + 1);
            if (!StringUtils.isEmpty((String)docLibraryName) && docLibraryName.equalsIgnoreCase("PB")) {
                pbDrive = true;
            }
        }
        catch (Exception e) {
            logger.error(webUrl + "...unable to get drive .... " + e.getMessage());
            pbDrive = false;
        }
        return pbDrive;
    }

    public static String getPBFolderItemId(GraphServiceClient graphClient, String emailId) {
        String pbFolderItemId = "";
        try {
            UserRequestBuilder users = graphClient.users(emailId);
            DriveCollectionRequestBuilder drives = users.drives();
            DriveCollectionRequest buildRequests = (DriveCollectionRequest)drives.buildRequest(new Option[0]);
            DriveCollectionPage DriveCollectionPages = (DriveCollectionPage)buildRequests.get();
            for (Drive drive : DriveCollectionPages.getCurrentPage()) {
                if (!GraphDownloadServiceImpl.isPBDrive(drive.webUrl)) continue;
                pbFolderItemId = drive.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException", (Throwable)e);
        }
        return pbFolderItemId;
    }

    @Override
    public BufferedInputStream downloadFileFromOneDriveWithPriority1(PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID, String userName, String driveId, com.parablu.pcbd.domain.User user, FileStatusElement fileStatusElement, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) {
        String fileNameTemp = fileName;
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        BufferedInputStream bufferedInputStream = null;
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        Office365DownloadServiceImplData downloadServiceImplData = new Office365DownloadServiceImplData(proxyUserName, password, host, port);
        downloadServiceImplData.setGraphClient(graphClient);
        driveId = fileStatusElement.getDriveId();
        fileStatusElement.setEncodedFileName(chunkFile.getfSPath());
        logger.debug(fileStatusElement.isCalculateEncodedNameOldWay() + "--is old way encoded name....using new restore retries new....... driveId:::" + fileStatusElement.getDriveId());
        logger.debug("chunkFile cloud storahe" + chunkFile.getCloudStoragePath());
        try {
            boolean breakLoop = true;
            ArrayList<String> triedDeviceUUIDs = new ArrayList<String>();
            triedDeviceUUIDs.add(deviceUUID);
            ArrayList<String> triedOdbLookupIds = new ArrayList<String>();
            FileDownloadElement result = null;
            RetryPolicyTable policyTable = this.retryService.getRetryPolicyTable(1, "");
            RetryPolicy retryPolicy = this.retryService.valueOf(policyTable);
            RetryPolicy getDriveId = this.retryService.valueOf(policyTable);
            logger.debug("..beforesetting accountid ..." + downloadServiceImplData.getAccountId());
            this.setRetriesToGetDriveId((RetryPolicy<String>)getDriveId, downloadServiceImplData, user);
            logger.debug("..aftersetting accountid ..." + downloadServiceImplData.getAccountId());
            if (StringUtils.isEmpty((String)downloadServiceImplData.getAccountId())) {
                String emailId = user.getEmailId();
                if (!StringUtils.isEmpty((String)user.getOdbLoginId())) {
                    emailId = user.getOdbLoginId();
                }
                if (!StringUtils.isEmpty((String)user.getDestOdbLoginId())) {
                    emailId = user.getDestOdbLoginId();
                }
                downloadServiceImplData.setAccountId(emailId);
                downloadServiceImplData.setUserName(user.getUserName());
            }
            this.setRetriesToExecuteDownload(downloadServiceImplData, (RetryPolicy<FileDownloadElement>)retryPolicy, (RetryPolicy<String>)getDriveId, user, fileNameTemp, fileStatusElement);
            logger.debug("..aftersetting accountid2 ..." + downloadServiceImplData.getAccountId());
            String pbFolderName = this.office365Dao.getOdbFolderName(1);
            String userNameInPath = "";
            if (!StringUtils.isEmpty((String)deviceUUID)) {
                userNameInPath = GraphDownloadServiceImpl.getUniqueODUserFolder(deviceUUID);
                logger.debug(deviceUUID + "....device unique id ....... " + userNameInPath);
            }
            String downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)PCHelperConstant.getMSSharePointUrl(), (String)fileNameTemp, (String)downloadServiceImplData.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
            if (!StringUtils.isEmpty((String)user.getMigratedFolderName())) {
                userNameInPath = user.getMigratedFolderName() + "/" + userNameInPath;
                downloadServiceImplData.setAccountId(user.getDestOdbLoginId());
                downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)PCHelperConstant.getMSSharePointUrl(), (String)fileNameTemp, (String)downloadServiceImplData.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
                logger.debug("....migrated user.... " + userNameInPath);
            } else {
                downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)PCHelperConstant.getMSSharePointUrl(), (String)fileNameTemp, (String)downloadServiceImplData.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
                downloadurl = PCHelperConstant.getGraphClientDownloadUrl((String)driveId, (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)fileNameTemp);
            }
            downloadServiceImplData.setDeviceUUID(deviceUUID);
            if (StringUtils.isEmpty((String)fileStatusElement.getDriveId()) || "404".equalsIgnoreCase(driveId)) {
                driveId = user.getOdbDriveid();
                fileStatusElement.setDriveId(driveId);
                logger.debug(downloadServiceImplData.getAccountId() + "...driveid is empty so assigningb...:" + driveId);
                if (StringUtils.isEmpty((String)driveId) || "404".equalsIgnoreCase(driveId)) {
                    driveId = OneDriveUtil.getPBFolderItemIdWithErrorCode(downloadServiceImplData.getAccountId());
                    logger.debug("%%%%%%%%%%%%%%%%%%%%test%%%%%%%%%%%%%%%%%%" + driveId);
                    if (!StringUtils.isEmpty((String)driveId) || !"404".equals(driveId)) {
                        user.setOdbDriveid(driveId);
                        logger.debug(user.getOdbDriveid() + "%%%%%%%%%%%%%^^^%%%%%%%%%%%%%%%%%%%%%%%%%" + user.getAzureUniqueId());
                        this.utilDao.updateAzureProperties(1, user.getUserName(), driveId);
                    }
                }
            }
            this.setDriveId(fileStatusElement.getDriveId(), downloadServiceImplData);
            downloadurl = fileStatusElement.isCalculateEncodedNameOldWay() ? PCHelperConstant.getGraphClientDownloadUrl((String)driveId, (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)fileStatusElement.getEncodedFileName()) : PCHelperConstant.getGraphClientDownloadUrl((String)driveId, (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)fileNameTemp);
            logger.debug("...download under .... " + downloadurl);
            downloadServiceImplData.setDownloadUrl(downloadurl);
            do {
                driveId = downloadServiceImplData.getDriveId();
                breakLoop = true;
                downloadServiceImplData.setGraphClient(graphClient);
                this.executeDownloadWithFailSafe(downloadServiceImplData, (RetryPolicy<FileDownloadElement>)retryPolicy);
                result = downloadServiceImplData.getFileDownloadElement();
                int responseCode = result.getDownloadStatuscode();
                logger.debug("Retry Response status code: " + responseCode);
                if (responseCode == 200) {
                    InputStream inputStream = result.getInputStream();
                    bufferedInputStream = new BufferedInputStream(inputStream, 1024);
                    continue;
                }
                if (responseCode != 404) continue;
                List<OdbIdLookup> odbIdstoLookup = this.retryService.getOdbIdsForLookup(1);
                logger.debug("odb od look up done.." + odbIdstoLookup.size());
                for (OdbIdLookup odbIdLookup : odbIdstoLookup) {
                    if (triedOdbLookupIds.contains(odbIdLookup.getOdbLoginId())) continue;
                    logger.debug("odb id look up...." + odbIdLookup.getOdbLoginId());
                    triedOdbLookupIds.add(odbIdLookup.getOdbLoginId());
                    downloadServiceImplData.getToken().setAccountId(odbIdLookup.getOdbLoginId());
                    this.getDriveIdWithFailSafe(downloadServiceImplData, (RetryPolicy<String>)getDriveId);
                    this.setToken(downloadServiceImplData.getToken(), downloadServiceImplData);
                    fileStatusElement.setFileOwner(odbIdLookup.getUserName());
                    logger.debug(fileStatusElement.getFileOwner() + "file owner after odb look up new email drive id.." + downloadServiceImplData.getDriveId());
                    breakLoop = false;
                }
            } while (!breakLoop);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Downloading File From One Drive :", (Throwable)e);
            throw new BaseException("exception retrycount reaches max try");
        }
        return bufferedInputStream;
    }

    private void setRetriesToExecuteDownload(Office365DownloadServiceImplData downloadServiceImplData, RetryPolicy<FileDownloadElement> retryPolicy, RetryPolicy<String> getDriveId, com.parablu.pcbd.domain.User user, String fileNameToSearch, FileStatusElement fileStatusElement) {
        retryPolicy.onRetry(e -> {
            ExecutionAttemptedEvent event = e;
            Throwable failure = event.getLastFailure();
            logger.debug("Connection error encountered {}", (Object)failure.getMessage(), (Object)failure);
            logger.debug("Retrying Count:", (Object)event.getAttemptCount());
        });
        retryPolicy.handleResultIf(res -> {
            logger.debug("inside retry handleResultIf...........");
            if (res == null) {
                logger.debug("Result is null so retry...........");
                return true;
            }
            if (res instanceof FileDownloadElement) {
                FileDownloadElement response = res;
                int statusCode = response.getDownloadStatuscode();
                if (statusCode == 401) {
                    this.sleepForGivenTime(60000L);
                    if (user != null) {
                        if (StringUtils.isEmpty((String)user.getOdbLoginId())) {
                            downloadServiceImplData.setAccountId(user.getEmailId());
                        } else {
                            downloadServiceImplData.setAccountId(user.getOdbLoginId());
                        }
                        downloadServiceImplData.setUserName(user.getUserName());
                    }
                    return true;
                }
                if (statusCode == 429 || statusCode == 503) {
                    String value = "3";
                    logger.debug("inside retry.... response code:" + statusCode);
                    logger.debug("After getting the sleep value:" + value);
                    long waitTime = Long.parseLong(value);
                    long millis = waitTime * 1000L;
                    this.sleepForGivenTime(millis);
                    return true;
                }
                if (statusCode == 404) {
                    logger.debug("...404 in graph so sleep for 1 min...");
                    if (StringUtils.isEmpty((String)downloadServiceImplData.getFileItemId())) {
                        String driveId = user.getOdbDriveid();
                        logger.debug("...user unique id and driveid...." + driveId + "..val..." + user.getAzureUniqueId());
                        String userMail = user.getEmailId();
                        if (!StringUtils.isEmpty((String)user.getOdbLoginId())) {
                            userMail = user.getOdbLoginId();
                        }
                        if (StringUtils.isEmpty((String)driveId)) {
                            logger.debug(user.getUserName() + "%%%%%%%%%%%%%%%%%%%%get drive for user mail%%%%%%%%%%%%%%%%%%" + userMail);
                            driveId = OneDriveUtil.getPBFolderItemIdWithErrorCode(userMail.toLowerCase());
                            logger.debug("%%%%%%%%%%%%%%%%%%%%test%%%%%%%%%%%%%%%%%%" + driveId);
                            if (!StringUtils.isEmpty((String)driveId) || !"404".equals(driveId)) {
                                user.setOdbDriveid(driveId);
                            }
                            logger.debug(user.getOdbDriveid() + "%%%%%%%%%%%%%^^^%%%%%%%%%%%%%%%%%%%%%%%%%" + user.getAzureUniqueId());
                            this.utilDao.updateAzureProperties(1, user.getUserName(), driveId);
                        }
                        if (StringUtils.isEmpty((String)user.getAzureUniqueId())) {
                            String azureUniqueId = OneDriveUtil.getUserIdFromAzure(userMail);
                            user.setAzureUniqueId(azureUniqueId);
                        }
                        downloadServiceImplData.setDriveId(driveId);
                        downloadServiceImplData.setAccountId(user.getAzureUniqueId());
                        if (StringUtils.isNotEmpty((String)fileStatusElement.getEncodedFileName()) && !fileStatusElement.isCalculateEncodedNameOldWay()) {
                            this.getFileItemIdWithFailSafe(downloadServiceImplData, getDriveId, fileStatusElement.getEncodedFileName(), driveId);
                            if (StringUtils.isNotEmpty((String)downloadServiceImplData.getFileItemId())) {
                                fileStatusElement.setCalculateEncodedNameOldWay(true);
                            }
                        }
                        if (StringUtils.isEmpty((String)downloadServiceImplData.getFileItemId())) {
                            this.getFileItemIdWithFailSafe(downloadServiceImplData, getDriveId, fileNameToSearch, driveId);
                            if (StringUtils.isNotEmpty((String)downloadServiceImplData.getFileItemId())) {
                                fileStatusElement.setCalculateEncodedNameOldWay(false);
                            }
                        }
                        logger.debug("...after searchfileitemid....." + downloadServiceImplData.getFileItemId());
                        if (StringUtils.isNotEmpty((String)downloadServiceImplData.getFileItemId())) {
                            downloadServiceImplData.setDownloadUrl(PCHelperConstant.getGraphLibraryDownloadUrlWithItemId((String)downloadServiceImplData.getDriveId(), (String)downloadServiceImplData.getFileItemId()));
                            fileStatusElement.setFileOwner(this.retryService.getuserNameFromOdbFolderName(1, downloadServiceImplData.getOneDriveUniqueFolderName()));
                            logger.debug("Search for file successfull so change the download url with item id:" + downloadServiceImplData.getDownloadUrl() + " &fileOwner:" + fileStatusElement.getFileOwner());
                        }
                    }
                    return true;
                }
                if (statusCode != 200) {
                    logger.debug("the status code is neither 200 nor 404 nor 429 401 503 so retry : " + statusCode);
                    return true;
                }
            }
            return false;
        });
    }

    private void setRetriesToGetDriveId(RetryPolicy<String> getDriveId, Office365DownloadServiceImplData downloadServiceImplData, com.parablu.pcbd.domain.User user) {
        getDriveId.onRetry(e -> {
            ExecutionAttemptedEvent event = e;
            Throwable failure = event.getLastFailure();
            logger.debug("Connection error encountered {}", (Object)failure.getMessage(), (Object)failure);
            logger.debug("Retrying Count:", (Object)event.getAttemptCount());
        });
        getDriveId.handleResultIf(res -> {
            logger.debug("inside retry handleResultIf...........");
            if (res == null) {
                logger.debug("Result is null so retry...........");
                return true;
            }
            if (res instanceof String) {
                if (StringUtils.isEmpty((String)res) || res.equalsIgnoreCase("404")) {
                    logger.error("get drive id String is empty so retry true");
                    return true;
                }
                if (res.equalsIgnoreCase("401")) {
                    logger.debug("401 case drive id inside fail safe:" + res);
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e1) {
                        logger.error("InterruptedException:" + e1);
                    }
                    PciAuthorizationTokenElement element1 = this.office365Dao.getMSGTokenElement(1, downloadServiceImplData.getToken().getAccountId());
                    if (user != null) {
                        String emailId = user.getEmailId();
                        if (!StringUtils.isEmpty((String)user.getOdbLoginId())) {
                            emailId = user.getOdbLoginId();
                        }
                        if (!StringUtils.isEmpty((String)user.getDestOdbLoginId())) {
                            emailId = user.getDestOdbLoginId();
                        }
                        element1.setAccountId(emailId);
                        element1.setUserName(user.getUserName());
                    }
                    this.setToken(element1, downloadServiceImplData);
                    return true;
                }
            }
            return false;
        });
    }

    private void executeDownloadWithFailSafe(final Office365DownloadServiceImplData downloadServiceImplData, RetryPolicy<FileDownloadElement> retryPolicy) {
        CheckedSupplier<FileDownloadElement> checkedSupplier = new CheckedSupplier<FileDownloadElement>(){

            public FileDownloadElement get() throws Throwable {
                return downloadServiceImplData.executeDownloadUsingGraphClient();
            }
        };
        Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).get((CheckedSupplier)checkedSupplier);
    }

    public void getDriveIdWithFailSafe(final Office365DownloadServiceImplData downloadServiceImplData, RetryPolicy<String> retryPolicy) {
        CheckedSupplier<String> checkedSupplier = new CheckedSupplier<String>(){

            public String get() throws Throwable {
                return downloadServiceImplData.getPBFolderItemId();
            }
        };
        Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).get((CheckedSupplier)checkedSupplier);
    }

    private void getFileItemIdWithFailSafe(final Office365DownloadServiceImplData downloadServiceImplData, RetryPolicy<String> retryPolicy, final String fileNameToSearch, final String driveId) {
        CheckedSupplier<String> checkedSupplier = new CheckedSupplier<String>(){

            public String get() throws Throwable {
                return downloadServiceImplData.searchFileItemInOneDrive(fileNameToSearch, driveId);
            }
        };
        Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).get((CheckedSupplier)checkedSupplier);
    }

    private void setToken(PciAuthorizationTokenElement authorizationTokenElementTemp, Office365DownloadServiceImplData downloadServiceImplData) {
        logger.debug("Setting the msg auth token...");
        downloadServiceImplData.setToken(authorizationTokenElementTemp);
    }

    private void setDriveId(String driveId, Office365DownloadServiceImplData downloadServiceImplData) {
        logger.debug("Setting the drive id......" + driveId);
        downloadServiceImplData.setDriveId(driveId);
    }

    @Override
    public BufferedInputStream downloadFileFromOneDrive(PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID, String userName, String driveId, com.parablu.pcbd.domain.User user, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) {
        String fileNameTemp = fileName;
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        String pbFolderName = this.office365Dao.getOdbFolderName(1);
        String userNameInPath = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            userNameInPath = GraphDownloadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameInPath);
        }
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        Object stream = null;
        HttpResponse result = null;
        String downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileNameTemp, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
        if (!StringUtils.isEmpty((String)user.getMigratedFolderName())) {
            userNameInPath = user.getMigratedFolderName() + "/" + userNameInPath;
            authorizationTokenElementTemp.setAccountId(user.getDestOdbLoginId());
            downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileNameTemp, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
            logger.debug("....migrated user.... " + userNameInPath);
        } else {
            downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileNameTemp, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
        }
        logger.debug(chunkFile.getFileName() + " .........old style...new path................." + downloadurl);
        BufferedInputStream bufferedInputStream = null;
        try {
            if (StringUtils.isEmpty((String)driveId)) {
                driveId = GraphDownloadServiceImpl.getPBFolderItemId(graphClient, authorizationTokenElementTemp.getAccountId());
                logger.debug("...driveid is empty so assigning...");
            }
            downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)fileNameTemp);
            logger.debug(" .........graph api new download url from helper................." + downloadurl);
            result = this.executeDownload(proxyUserName, password, host, port, downloadurl, authorizationTokenElementTemp);
            String tokenUserName = authorizationTokenElementTemp.getUserName();
            int responseCode = result.getStatusLine().getStatusCode();
            logger.debug(" Response status code: " + responseCode);
            if (responseCode == 401) {
                logger.debug("inside 401...");
                logger.error(" ... token expired so try after 1 min ... ");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                authorizationTokenElementTemp = this.office365Dao.getMSGTokenElement(1, authorizationTokenElement.getUserName());
                if (authorizationTokenElementTemp != null) {
                    result = this.executeDownload(proxyUserName, password, host, port, downloadurl, authorizationTokenElementTemp);
                    responseCode = result.getStatusLine().getStatusCode();
                }
            }
            if (responseCode == 200) {
                InputStream inputStream = result.getEntity().getContent();
                result.getEntity().getContentLength();
                bufferedInputStream = new BufferedInputStream(inputStream, 1024);
                logger.debug(tokenUserName + "download url : " + downloadurl);
            } else if (responseCode == 404) {
                logger.debug("Response code is 404");
                List allDeviceByUserName = this.deviceDao.getAllDeviceByUserName(1, userName);
                for (Device device : allDeviceByUserName) {
                    if (device == null || StringUtils.isEmpty((String)deviceUUID) || device.getDeviceUUID().equalsIgnoreCase(deviceUUID)) continue;
                    logger.debug("Retry with other deviceUUID " + device.getDeviceUUID());
                    bufferedInputStream = this.downloadFileFromOneDriveWithFailedCase(1, authorizationTokenElement, fileName, chunkFile, device.getDeviceUUID(), graphClient, okHttpClient);
                    if (bufferedInputStream == null) continue;
                    break;
                }
                if (bufferedInputStream == null) {
                    logger.debug("After checking in all devices for user stream is null so check without deviceUUID");
                    bufferedInputStream = this.downloadFileFromOneDriveWithFailedCase(1, authorizationTokenElement, fileName, chunkFile, "", graphClient, okHttpClient);
                    if (bufferedInputStream == null) {
                        logger.debug("After checking without deviceUUID stream is empty so call retryDownloadFileFromOneDrive");
                        bufferedInputStream = this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID);
                    }
                }
            } else {
                bufferedInputStream = this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Downloading File From One Drive :" + e.getMessage());
            bufferedInputStream = this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID);
        }
        return bufferedInputStream;
    }

    private InputStream graphapi(ChunkFile chunkFile, String deviceUUID, String fileNameTemp, PciAuthorizationTokenElement authorizationTokenElementTemp, String userNameInPath, String proxyUserName, String password, String host, int port, InputStream stream, HttpResponse result, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) throws IOException {
        int responseCode;
        block15: {
            try {
                String downloadurl = "/me/drive/root:/{item-path}:/content";
                try {
                    result = this.executeDownload(proxyUserName, password, host, port, downloadurl, authorizationTokenElementTemp);
                }
                catch (ClientProtocolException e) {
                    logger.error(".... exception......" + e.getMessage());
                }
                catch (IOException e) {
                    logger.error(".... exception......" + e.getMessage());
                }
                responseCode = result.getStatusLine().getStatusCode();
                if (responseCode == 200) {
                    InputStream inputStream = result.getEntity().getContent();
                    result.getEntity().getContentLength();
                }
            }
            catch (GraphServiceException e) {
                responseCode = e.getResponseCode();
                logger.error(" ... error trying to download file ..." + e.getResponseCode());
                if (responseCode != 401) break block15;
                logger.error(" ... token expired so try after 1 min ... ");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException inputStream) {
                    // empty catch block
                }
                try {
                    stream = this.downloadFile(chunkFile, fileNameTemp, authorizationTokenElementTemp, userNameInPath);
                }
                catch (GraphServiceException ee) {
                    logger.error("... unable to download file after token expiry... " + ee.getResponseCode());
                }
            }
        }
        if (responseCode == 404) {
            stream = this.downloadFileFromOneDriveWithFailedCase(1, authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID, graphClient, okHttpClient);
        } else if (stream == null) {
            logger.debug(".. last attempt ... for download .." + responseCode);
            try {
                stream = this.downloadFile(chunkFile, fileNameTemp, authorizationTokenElementTemp, userNameInPath);
            }
            catch (GraphServiceException ee) {
                logger.error("... unable to download file after token expiry... " + ee.getResponseCode());
            }
        }
        return stream;
    }

    private InputStream downloadFile(ChunkFile chunkFile, String fileNameTemp, PciAuthorizationTokenElement authorizationTokenElementTemp, String userNameInPath) {
        InputStream stream;
        GraphServiceClient<Request> graphClient = this.getGraphClient();
        String driveId = GraphDownloadServiceImpl.getPBFolderItemId(graphClient, authorizationTokenElementTemp.getAccountId());
        String itemId = "";
        if (StringUtils.isEmpty((String)itemId)) {
            String path = "/drives/" + driveId + "/root:/" + userNameInPath + "/" + chunkFile.getCloudStoragePath() + "/" + fileNameTemp;
            logger.debug("....empty id... " + path);
            DriveItem item = (DriveItem)graphClient.customRequest(path, DriveItem.class).buildRequest(new Option[0]).get();
            stream = graphClient.drives(driveId).items(item.id).content().buildRequest(new Option[0]).get();
        } else {
            stream = graphClient.drives(driveId).items(itemId).content().buildRequest(new Option[0]).get();
            System.out.println("...." + stream);
        }
        return stream;
    }

    private HttpResponse executeDownload(String proxyUserName, String password, String host, int port, String downloadurl, PciAuthorizationTokenElement authorizationTokenElement) throws IOException, ClientProtocolException {
        HttpResponse result;
        try {
            HttpGet httpGet = new HttpGet(downloadurl);
            httpGet.addHeader("Authorization", BEARER + authorizationTokenElement.getAccessToken());
            httpGet.addHeader("Accept", "application/json;odata=verbose");
            httpGet.addHeader("Content-Type", "*/*");
            if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
            }
            if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                logger.debug(" without proxy ....");
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                result = httpclient.execute((HttpUriRequest)httpGet);
            } else {
                logger.debug(" using proxy ....");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                HttpHost proxy = new HttpHost(host, port);
                RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                httpGet.setConfig(config);
                result = httpclient.execute((HttpUriRequest)httpGet);
            }
            logger.debug("...Inside execute..." + result.getStatusLine().getStatusCode());
        }
        catch (GraphServiceException e) {
            logger.error("... failed graph exception ... " + e.getResponseCode());
            DefaultHttpResponseFactory factory = new DefaultHttpResponseFactory();
            result = factory.newHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, e.getResponseCode(), null), null);
        }
        return result;
    }

    private BufferedInputStream downloadFileFromOneDriveWithFailedCase(int cloudId, PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) {
        BufferedInputStream bufferedInputStream;
        block9: {
            String fileNameTemp = fileName;
            PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
            String pbFolderName = this.office365Dao.getOdbFolderName(1);
            String userNameInPath = "";
            if (!StringUtils.isEmpty((String)deviceUUID)) {
                userNameInPath = GraphDownloadServiceImpl.getUniqueODUserFolder(deviceUUID);
                logger.debug("....device unique id ....... " + userNameInPath);
            }
            String downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileNameTemp, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
            String driveId = GraphDownloadServiceImpl.getPBFolderItemIdWithErrorCode(graphClient, authorizationTokenElementTemp.getAccountId());
            downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)fileNameTemp);
            logger.debug(chunkFile.getFileName() + " ............new path................." + downloadurl);
            bufferedInputStream = null;
            String proxyUserName = PCHelperConstant.getProxyUserName();
            String password = PCHelperConstant.getProxyPassword();
            String host = PCHelperConstant.getProxyHost();
            int port = PCHelperConstant.getProxyPort();
            HttpResponse result = null;
            try {
                result = this.executeDownload(proxyUserName, password, host, port, downloadurl, authorizationTokenElementTemp);
                String tokenUserName = authorizationTokenElementTemp.getUserName();
                int responseCode = result.getStatusLine().getStatusCode();
                logger.debug("Retry Response status code: " + responseCode);
                if (responseCode == 200) {
                    InputStream inputStream = result.getEntity().getContent();
                    result.getEntity().getContentLength();
                    bufferedInputStream = new BufferedInputStream(inputStream, 1024);
                    logger.debug(tokenUserName + "download url : " + downloadurl);
                    break block9;
                }
                if (responseCode == 401) {
                    logger.debug("inside 401...");
                    logger.error(" ... token expired so try after 1 min ... ");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    authorizationTokenElementTemp = this.office365Dao.getMSGTokenElement(1, authorizationTokenElement.getUserName());
                    if (authorizationTokenElementTemp != null) {
                        bufferedInputStream = this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID);
                    }
                    break block9;
                }
                if (responseCode == 404) {
                    logger.debug("404 in downloadFileFromOneDriveWithFailedCase for deviceUUID " + deviceUUID + " so return null");
                    return null;
                }
                bufferedInputStream = this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception While Downloading File From One Drive :" + e.getMessage());
                bufferedInputStream = this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID);
            }
        }
        return bufferedInputStream;
    }

    public static String getPBFolderItemIdWithErrorCode(GraphServiceClient<Request> graphClient, String emailId) {
        String pbFolderItemId = "";
        try {
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            logger.debug("..userid is not there..." + userId);
            if (StringUtils.isEmpty((String)userId)) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + emailId + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            UserRequestBuilder users = graphClient.users(userId);
            DriveCollectionRequestBuilder drives = users.drives();
            DriveCollectionRequest buildRequests = (DriveCollectionRequest)drives.buildRequest(new Option[0]);
            DriveCollectionPage DriveCollectionPages = (DriveCollectionPage)buildRequests.get();
            for (Drive drive : DriveCollectionPages.getCurrentPage()) {
                if (!GraphDownloadServiceImpl.isPBDrive(drive.webUrl)) continue;
                pbFolderItemId = drive.id;
            }
            if (StringUtils.isEmpty((String)pbFolderItemId)) {
                logger.debug(".....trytocreate pb for email...." + emailId);
                GraphDownloadServiceImpl.createDriveInsideList(graphClient, emailId);
                return GraphDownloadServiceImpl.getPBFolderItemIdWithErrorCode(graphClient, emailId);
            }
        }
        catch (GraphServiceException e) {
            logger.debug(".....driveid error code ...." + e.getResponseCode());
            pbFolderItemId = "" + e.getResponseCode();
            logger.error("error getting drive id for one drive upload", (Throwable)e);
        }
        return pbFolderItemId;
    }

    private static void createDriveInsideList(GraphServiceClient<Request> graphClient, String emailId) {
        SiteCollectionPage siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)graphClient.sites().buildRequest(new Option[0])).get();
        String siteId = "";
        List currentPageVal = null;
        SiteCollectionRequestBuilder nextPage = (SiteCollectionRequestBuilder)siteCollectionPage.getNextPage();
        String url = PCHelperConstant.getPersonalSite((String)PCHelperConstant.getMSSharePointUrl(), (String)emailId);
        block0: do {
            currentPageVal = siteCollectionPage.getCurrentPage();
            for (Site site : siteCollectionPage.getCurrentPage()) {
                logger.debug("....insidennn..." + site.webUrl);
                if (StringUtils.isEmpty((String)site.webUrl) || !site.webUrl.equalsIgnoreCase(url)) continue;
                siteId = site.id;
                logger.debug(site.webUrl + "..foundsite..." + siteId);
                continue block0;
            }
        } while (currentPageVal.size() > 0 && nextPage != null && (siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)((SiteCollectionRequestBuilder)siteCollectionPage.getNextPage()).buildRequest(new Option[0])).get()) != null && nextPage != null);
        Site site = graphClient.sites(siteId).buildRequest(new Option[0]).get();
        logger.debug("..before creating.." + site.name + "...." + site.webUrl);
        com.microsoft.graph.models.List list = new com.microsoft.graph.models.List();
        list.displayName = "PB";
        list.description = "MY Description";
        ListInfo listInfo = new ListInfo();
        listInfo.template = "documentLibrary";
        list.list = listInfo;
        ((ListCollectionRequest)graphClient.sites(siteId).lists().buildRequest(new Option[0])).post(list);
    }

    public BufferedInputStream retryDownloadFileFromOneDrive(PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID) {
        boolean retry;
        logger.debug("Retrying file download form ODB");
        String pbFolderName = this.office365Dao.getOdbFolderName(1);
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        String userNameInPath = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            userNameInPath = GraphDownloadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameInPath);
        }
        String downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
        GraphServiceClient<Request> graphClient = this.getGraphClient();
        String driveId = GraphDownloadServiceImpl.getPBFolderItemId(graphClient, authorizationTokenElementTemp.getAccountId());
        String initialDownloadUrl = downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)fileName);
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        BufferedInputStream bufferedInputStream = null;
        String originalPath = chunkFile.getCloudStoragePath();
        boolean incrementPath = false;
        boolean decrementPath = false;
        boolean newPathCheck = false;
        boolean newRetryPathCheck = false;
        boolean oldStylePath = false;
        boolean customOldStylePath = false;
        boolean increOldStylePath = false;
        boolean decreOldStylePath = false;
        boolean newPathCheckOnly = false;
        int retryCount = 0;
        int newRetryPath = 1;
        int maxRetryCount = 9;
        int sleepMultiplier = 1;
        long sleepTime = 5000L * (long)sleepMultiplier;
        do {
            retry = false;
            HttpGet httpGet = null;
            String modifiedPath = chunkFile.getCloudStoragePath();
            try {
                String cloudPath;
                HttpResponse result;
                logger.debug(downloadurl + "......download path........." + retryCount);
                httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Authorization", BEARER + authorizationTokenElementTemp.getAccessToken());
                httpGet.addHeader("Accept", "application/json;odata=verbose");
                httpGet.addHeader("Content-Type", "*/*");
                if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                    httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                    logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
                }
                if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                    logger.debug(" without proxy ...");
                    HttpClient httpclient = HttpClientUtil.getSSlConnection();
                    result = httpclient.execute((HttpUriRequest)httpGet);
                } else {
                    logger.debug(" using proxy ...");
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                    CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                    HttpHost proxy = new HttpHost(host, port);
                    RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                    httpGet.setConfig(config);
                    result = httpclient.execute((HttpUriRequest)httpGet);
                }
                int responseCode = result.getStatusLine().getStatusCode();
                logger.debug("Retry Response status code: " + responseCode);
                if (responseCode == 200) {
                    InputStream inputStream = result.getEntity().getContent();
                    bufferedInputStream = new BufferedInputStream(inputStream, 1024);
                    logger.debug(originalPath + "...Retry download url : " + downloadurl);
                    if (originalPath.equals(modifiedPath)) continue;
                    logger.debug("....path modified......");
                    continue;
                }
                if (responseCode == 401) {
                    retry = true;
                    ++retryCount;
                    sleepTime = this.sleepForGivenTime(sleepTime);
                    logger.debug("inside 401...");
                    logger.error(" ... token expired so try after 1 min ... ");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException inputStream) {
                        // empty catch block
                    }
                    authorizationTokenElementTemp = this.office365Dao.getMSGTokenElement(1, authorizationTokenElement.getUserName());
                    continue;
                }
                if (responseCode == 200) continue;
                retry = true;
                sleepTime = responseCode != 404 ? this.sleepForGivenTime(sleepTime) : 0L;
                logger.debug("..retry attempt for response code ...." + responseCode + "...." + ++retryCount + "....." + authorizationTokenElementTemp.getEmailId());
                logger.debug("..retry url ...." + downloadurl);
                if (responseCode != 404) continue;
                logger.debug("response code is 404 so sleep for 2 sec..");
                this.sleepForGivenTime(2000L);
                logger.debug("sleep for 2 sec completed..");
                if (!increOldStylePath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)cloudPath, (String)pbFolderName);
                    graphClient = this.getGraphClient();
                    driveId = GraphDownloadServiceImpl.getPBFolderItemId(graphClient, authorizationTokenElementTemp.getAccountId());
                    downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)"", (String)cloudPath, (String)fileName);
                    modifiedPath = cloudPath;
                    logger.debug("...increOldStylePath..." + modifiedPath);
                    increOldStylePath = true;
                    continue;
                }
                if (!newPathCheckOnly && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    cloudPath = "" + PCHelperConstant.getRetryOdbFolderValue();
                    downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)userNameInPath, (String)cloudPath, (String)fileName);
                    newPathCheckOnly = true;
                    modifiedPath = cloudPath;
                    logger.debug("...newPathCheck ..." + modifiedPath);
                    continue;
                }
                if (!newPathCheck && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                    }
                    downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)userNameInPath, (String)cloudPath, (String)fileName);
                    newPathCheck = true;
                    modifiedPath = cloudPath;
                    logger.debug("...newPathCheck ..." + modifiedPath);
                    continue;
                }
                if (!newRetryPathCheck && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    logger.debug("...Inside new logic...");
                    int retryPath = PCHelperConstant.getRetryOdbFolderValue() + newRetryPath;
                    String cloudPath2 = "" + retryPath;
                    logger.debug("...retryPath..." + retryPath);
                    logger.debug("...downloadurl..." + downloadurl);
                    String folderExistsPath = userNameInPath + "/" + retryPath;
                    boolean isFolderExists = this.isFolderExists(folderExistsPath, authorizationTokenElementTemp);
                    logger.debug(isFolderExists + "...isFolderExists..." + folderExistsPath);
                    if (isFolderExists) {
                        downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)userNameInPath, (String)cloudPath2, (String)fileName);
                        modifiedPath = cloudPath2;
                        ++newRetryPath;
                        ++maxRetryCount;
                    } else {
                        newRetryPathCheck = true;
                        logger.debug("...Folder not exists....");
                    }
                    logger.debug("...newPathCheck ..." + modifiedPath);
                    continue;
                }
                if (!decrementPath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path - 1);
                    }
                    downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)userNameInPath, (String)cloudPath, (String)fileName);
                    decrementPath = true;
                    modifiedPath = cloudPath;
                    logger.debug("...decre new path..." + modifiedPath);
                    continue;
                }
                if (!incrementPath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)userNameInPath, (String)cloudPath, (String)fileName);
                    modifiedPath = cloudPath;
                    logger.debug("...incre new path..." + modifiedPath);
                    incrementPath = true;
                    continue;
                }
                if (!oldStylePath) {
                    downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)"", (String)chunkFile.getCloudStoragePath(), (String)fileName);
                    oldStylePath = true;
                    logger.debug("...oldStylePath restore ...");
                    continue;
                }
                if (!customOldStylePath && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                    }
                    downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)"", (String)cloudPath, (String)fileName);
                    customOldStylePath = true;
                    modifiedPath = cloudPath;
                    logger.debug("...customOldStylePath retryodbValue ..." + modifiedPath);
                    continue;
                }
                if (!decreOldStylePath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path - 1);
                    }
                    downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)"", (String)cloudPath, (String)fileName);
                    decreOldStylePath = true;
                    modifiedPath = cloudPath;
                    logger.debug("...decreOldStylePath..." + modifiedPath);
                    continue;
                }
                logger.debug("file find in any where so attempt once in initial path");
                downloadurl = initialDownloadUrl;
                logger.debug("...initialDownloadUrl..." + initialDownloadUrl);
            }
            catch (Exception e) {
                retry = true;
                ++retryCount;
                sleepTime = this.sleepForGivenTime(sleepTime);
                logger.trace("" + e);
                logger.error("Exception While Retying Download File From One Drive :" + e.getMessage());
            }
        } while (retry && retryCount < maxRetryCount);
        return bufferedInputStream;
    }

    private boolean isFolderExists(String folderExistsPath, PciAuthorizationTokenElement authorizationTokenElementTemp) {
        boolean isFolderExists = false;
        try {
            GraphServiceClient<Request> graphClient = this.getGraphClient();
            String driveId = GraphDownloadServiceImpl.getPBFolderItemId(graphClient, authorizationTokenElementTemp.getAccountId());
            DriveItem driveItem = (DriveItem)graphClient.customRequest("/drives/" + driveId + "/root:/" + folderExistsPath, DriveItem.class).buildRequest(new Option[0]).get();
            if (driveItem != null && driveItem.folder != null) {
                isFolderExists = true;
            }
        }
        catch (GraphServiceException e) {
            logger.error("..unable to check if folder exists ..." + e.getMessage());
        }
        return isFolderExists;
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString((String)deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    private long sleepForGivenTime(long sleepTime) {
        long sleepTimeTemp = sleepTime;
        try {
            logger.debug("SleepTime is" + sleepTimeTemp);
            Thread.sleep(sleepTimeTemp);
            int sleepMultiplier = 2;
            sleepTimeTemp *= (long)sleepMultiplier;
        }
        catch (InterruptedException e1) {
            logger.error("Thread interupted error");
        }
        return sleepTimeTemp;
    }
}

