/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.parablu.pcbd.domain.BluKryptStorageMapping;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCredentials;
import com.pg.controller.DownloadController;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class BluKryptController {
    private static Logger logger = LoggerFactory.getLogger(DownloadController.class);
    public static final String LOCAL_STORAGE = "localStorage";
    @Autowired
    private UtilService utilService;

    @RequestMapping(value={"/save/bluKryptStorageMapping/"}, method={RequestMethod.POST})
    public void updateRestartID(HttpServletRequest request, HttpServletResponse httpResponse) {
        String blukryptName = PCHelperConstant.getComponentName();
        boolean isGDEnabled = Boolean.valueOf(request.getHeader("isGDEnabled"));
        boolean isODBEnabled = Boolean.valueOf(request.getHeader("isODBEnabled"));
        String cloudType = request.getHeader("cloudType");
        logger.debug(blukryptName + "..comp and productype..." + cloudType);
        BluKryptStorageMapping bluKryptStorageMapping = new BluKryptStorageMapping();
        Cloud cloud = this.utilService.getCloud(1);
        List cloudCredentialsList = cloud.getCloudCredentials();
        CloudCredentials cloudCredentials = null;
        if (!StringUtils.isEmpty((String)cloudType) && "local".equalsIgnoreCase(cloudType) && !CollectionUtils.isEmpty((Collection)cloudCredentialsList)) {
            for (CloudCredentials cc : cloudCredentialsList) {
                if (cc == null || !LOCAL_STORAGE.equalsIgnoreCase(cc.getCloudName())) continue;
                logger.debug(" local storage flag ..... ");
                cloudCredentials = cc;
                break;
            }
        }
        bluKryptStorageMapping.setBlukrytName(blukryptName);
        bluKryptStorageMapping.setGDEnabled(isGDEnabled);
        bluKryptStorageMapping.setODBEnabled(isODBEnabled);
        if (cloudCredentials != null) {
            ArrayList<String> ccList = new ArrayList<String>();
            if (LOCAL_STORAGE.equalsIgnoreCase(cloudCredentials.getCloudName())) {
                ccList.add(LOCAL_STORAGE);
            }
            bluKryptStorageMapping.setCloudCredentials(ccList);
        }
        logger.debug(" Before updating blukrypt storage...........");
        this.utilService.saveBlukryptStorage(1, bluKryptStorageMapping);
        logger.debug(" After updating blukrypt storage...........");
        httpResponse.setStatus(200);
    }
}

