/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.container.initialization;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.configuration.PlexusComponentDescriptorMerger;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.container.initialization.AbstractContainerInitializationPhase;
import org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import org.codehaus.plexus.container.initialization.ContainerInitializationException;

public class ComponentDiscoveryPhase
extends AbstractContainerInitializationPhase {
    public void execute(ContainerInitializationContext context) throws ContainerInitializationException {
        try {
            ComponentDiscoveryPhase.discoverComponents(context.getContainer(), context.getContainer().getContainerRealm(), false);
        }
        catch (PlexusConfigurationException e) {
            throw new ContainerInitializationException("Error discovering components.", e);
        }
        catch (ComponentRepositoryException e) {
            throw new ContainerInitializationException("Error discovering components.", e);
        }
    }

    public static List discoverComponents(DefaultPlexusContainer container, ClassRealm realm) throws PlexusConfigurationException, ComponentRepositoryException {
        return ComponentDiscoveryPhase.discoverComponents(container, realm, false);
    }

    public static List discoverComponents(DefaultPlexusContainer container, ClassRealm realm, boolean override) throws PlexusConfigurationException, ComponentRepositoryException {
        ArrayList discoveredComponentDescriptors = new ArrayList();
        Iterator i = container.getComponentDiscovererManager().getComponentDiscoverers().iterator();
        while (i.hasNext()) {
            ComponentDiscoverer componentDiscoverer = (ComponentDiscoverer)i.next();
            List componentSetDescriptors = componentDiscoverer.findComponents(container.getContext(), realm);
            Iterator j = componentSetDescriptors.iterator();
            while (j.hasNext()) {
                ComponentSetDescriptor componentSet = (ComponentSetDescriptor)j.next();
                List<ComponentDescriptor<?>> componentDescriptors = componentSet.getComponents();
                if (componentDescriptors == null) continue;
                Iterator<ComponentDescriptor<?>> k = componentDescriptors.iterator();
                while (k.hasNext()) {
                    ComponentDescriptor<?> componentDescriptor = k.next();
                    componentDescriptor.setComponentSetDescriptor(componentSet);
                    ComponentDescriptor orig = container.getComponentDescriptor(componentDescriptor.getRole(), componentDescriptor.getRoleHint(), realm);
                    if (orig == null) {
                        container.addComponentDescriptor(componentDescriptor);
                        discoveredComponentDescriptors.add(componentDescriptor);
                        continue;
                    }
                    if (!override) continue;
                    if (orig.getRealmId() != null && !orig.getRealmId().equals(componentDescriptor.getRealmId())) {
                        if (container.getLogger().isDebugEnabled()) {
                            container.getLogger().debug("Duplicate component found, merging:\n  Original: " + orig.getRealmId() + ": " + orig.getRole() + " [" + orig.getRoleHint() + "] impl=" + orig.getImplementation() + "\n  Config: " + orig.getConfiguration() + "\n  New:      " + componentDescriptor.getRealmId() + ": " + componentDescriptor.getRole() + " [" + orig.getRoleHint() + "] impl=" + componentDescriptor.getImplementation() + "\n  Config: " + orig.getConfiguration());
                        }
                        PlexusComponentDescriptorMerger.merge(componentDescriptor, orig);
                        continue;
                    }
                    if (orig.getRealmId() == null || !orig.getRealmId().equals(componentDescriptor.getRealmId()) || !container.getLogger().isDebugEnabled()) continue;
                    container.getLogger().debug("Duplicate component found, not replacing:\n  Original: " + orig.getRealmId() + ": " + orig.getRole() + " [" + orig.getRoleHint() + "] impl=" + orig.getImplementation() + "\n  Config: " + orig.getConfiguration() + "\n  New:      " + componentDescriptor.getRealmId() + ": " + componentDescriptor.getRole() + " [" + orig.getRoleHint() + "] impl=" + componentDescriptor.getImplementation() + "\n  Config: " + orig.getConfiguration());
                }
            }
        }
        return discoveredComponentDescriptors;
    }
}

