/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility;

import com.mongodb.client.MongoCollection;
import com.parablu.domin.HttpClientUtil;
import com.parablu.domin.Office365;
import com.parablu.domin.PciAuthorizationTokenElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.bson.Document;
import org.json.JSONObject;

public class SearchFile {
    private static final String PERSONAL_URL = "/personal/";
    private static final String BEARER = "Bearer ";
    public static final String HEADER_KEY_ACCEPT = "Accept";
    public static final String HEADER_VALUE_APPLICATION_JSON = "application/json;odata=verbose";
    public static final String HEADER_KEY_CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT = "Accept";
    private static final String APPLICATION_JSON_ODATA_VERBOSE = "application/json;odata=verbose";
    public static final String AUTHORIZATION = "Authorization";

    public static void main(String[] args) throws ConfigurationException, IOException {
        String mongoIP = "192.168.7.182";
        String mongoPort = "27017";
        String userNames = "admin,ramram";
        String filePath = "/home/druva/Desktop/input1.xls";
        String countString = "10";
        String delayString = "2";
        int count = Integer.parseInt(countString);
        int delay = Integer.parseInt(delayString);
        PciAuthorizationTokenElement authorizationTokenElement = SearchFile.convertDocToPCIObj();
        String paraBluFolderPath = SearchFile.getParabluLibraryExistsUrl(authorizationTokenElement.getSharePointUrl(), "druva@parablu.com", "");
        System.out.println(paraBluFolderPath);
        int folderExists = SearchFile.isFolderExists(paraBluFolderPath, authorizationTokenElement, 0);
        ArrayList<String> userNameList = new ArrayList<String>();
        ArrayList userList = new ArrayList();
        try {
            FileInputStream file = new FileInputStream(new File(filePath));
            Workbook workbook = WorkbookFactory.create(file);
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                Iterator<Cell> cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = cellIterator.next();
                    switch (cell.getCellType()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            userNameList.add(cell.getStringCellValue());
                        }
                    }
                }
            }
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        userNameList.remove("userName");
        System.out.println("userNameList..." + userNameList.size());
        Object users = null;
        System.out.println("Success...");
    }

    private static void sleepForGivenTime(long sleepTime) {
        long sleepTimeTemp = sleepTime;
        try {
            System.out.println("SleepTime is " + sleepTimeTemp);
            Thread.sleep(sleepTimeTemp * 1000L);
            System.out.println("SleepTime is completed " + sleepTimeTemp);
        }
        catch (InterruptedException e1) {
            System.out.println("Thread interupted error");
        }
    }

    public static String getParabluLibraryExistsUrl(String office365baseUrl, String accountId, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        pbFolderName = "";
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = SearchFile.getPersonalSite(office365baseUrl, "karthick@parablu.com");
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        String downloadurl = SearchFile.getLibraryDownloadUrl(office365baseUrl, "_2buVBmfZjVmEp_PiflN*", "druva@parablu.com", "", "/1hv8s8v9wisma/1", pbFolderName);
        System.out.println("Download :" + downloadurl);
        return downloadurl;
    }

    public static String getLibraryDownloadUrl(String office365baseUrl, String fileName, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(office365baseUrl) + personalUrl + SearchFile.getEmailId(accountId) + "/_api/web/GetFolderByServerRelativeUrl('" + personalUrl + SearchFile.getEmailId(accountId) + "/" + pbFolderName + "/" + userName + "/" + suffixFolderPath + "')" + "/Files('" + fileName + "')/$value";
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        System.out.println(t);
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t >= 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    public static int isFolderExists(String url, PciAuthorizationTokenElement authorizationTokenElement, int retryCount) {
        int result = 0;
        try {
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty(AUTHORIZATION, BEARER + authorizationTokenElement.getAccessToken());
            con.setRequestProperty("Accept", "application/json;odata=verbose");
            int responseCode = con.getResponseCode();
            System.out.println(responseCode);
            if (responseCode == 401) {
                authorizationTokenElement = Office365.getAccessToken(authorizationTokenElement);
                return SearchFile.isFolderExists(url, authorizationTokenElement, ++retryCount);
            }
            System.out.println("Status code :" + responseCode);
            if (responseCode == 200) {
                return responseCode;
            }
            result = responseCode;
        }
        catch (Exception e) {
            System.out.println("" + e);
            System.out.println("Exception while checking folder exists:" + e.getMessage());
            return 505;
        }
        return result;
    }

    public static Object[] getSizes(String url, PciAuthorizationTokenElement authorizationTokenElement, int retryCount, String userName) {
        long sizeInKB;
        int statusCode;
        Object[] resultObj;
        block8: {
            HttpResponse result = null;
            resultObj = new Object[2];
            statusCode = 0;
            long size = 0L;
            sizeInKB = 0L;
            try {
                if (retryCount == 2) {
                    System.out.println("Retry reached max so return ");
                }
                URL obj = new URL(url);
                HttpGet httpGet = new HttpGet(url);
                httpGet.addHeader(AUTHORIZATION, BEARER + authorizationTokenElement.getAccessToken());
                httpGet.addHeader("Accept", "application/json;odata=verbose");
                httpGet.addHeader(HEADER_KEY_CONTENT_TYPE, "*/*");
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                result = httpclient.execute(httpGet);
                statusCode = result.getStatusLine().getStatusCode();
                System.out.println(statusCode);
                if (statusCode == 401) {
                    authorizationTokenElement = Office365.getAccessToken(authorizationTokenElement);
                    return SearchFile.getSizes(url, authorizationTokenElement, ++retryCount, userName);
                }
                if (statusCode == 200) {
                    String json = EntityUtils.toString(result.getEntity());
                    System.out.println(json);
                    JSONObject jsonObject = new JSONObject(json);
                    String itemCount = jsonObject.optString("d");
                    if (itemCount != null) {
                        jsonObject = new JSONObject(new String(itemCount));
                        String StorageMetrics = jsonObject.optString("StorageMetrics");
                        jsonObject = new JSONObject(new String(StorageMetrics));
                        size = Long.parseLong(jsonObject.optString("TotalFileStreamSize"));
                        sizeInKB = size / 1024L;
                    }
                }
                if (statusCode != 429) break block8;
                String value = result.getFirstHeader("Retry-After").getValue();
                System.out.println("429 retrt time " + value);
                long waitTime = Long.parseLong(value);
                long millis = waitTime * 1000L;
                System.out.println("...Sleeping for " + waitTime + "..milli..." + millis + "....for userName..." + userName);
                try {
                    Thread.sleep(millis);
                }
                catch (InterruptedException e1) {
                    System.out.println("Thread interupted error");
                }
                System.out.println("...sleep completed........for userName..." + userName);
            }
            catch (Exception e) {
                System.out.println("" + e);
                System.out.println("Exception while checking folder exists:" + e.getMessage());
            }
        }
        resultObj[0] = statusCode;
        resultObj[1] = sizeInKB;
        return resultObj;
    }

    public static String getParabluLibrarySizeUrl(String office365baseUrl, String accountId, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        pbFolderName = "";
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = SearchFile.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(personalSite) + "/_api/web/getFolderByServerRelativeUrl('" + personalUrl + SearchFile.getEmailId(accountId) + "/" + pbFolderName1 + "/')?$select=StorageMetrics&$expand=StorageMetrics";
    }

    private static String getEmailId(String emailId) {
        String replacedEmailId = emailId.replace(".", "_");
        replacedEmailId = replacedEmailId.replace("@", "_");
        return replacedEmailId;
    }

    public static String getPersonalSite(String office365baseUrl, String accountId) {
        if (accountId.contains("sites/")) {
            return String.valueOf(office365baseUrl) + "/" + SearchFile.getEmailId(accountId);
        }
        return String.valueOf(office365baseUrl) + PERSONAL_URL + SearchFile.getEmailId(accountId);
    }

    private static PciAuthorizationTokenElement convertDocToPCIObj(MongoCollection tokenCollection) {
        Document tokenDoc = (Document)tokenCollection.find().first();
        PciAuthorizationTokenElement pciAuthorizationTokenElement = new PciAuthorizationTokenElement();
        pciAuthorizationTokenElement.setAccessToken(tokenDoc.getString("accessToken"));
        pciAuthorizationTokenElement.setAuthenticationToken(tokenDoc.getString("authenticationToken"));
        pciAuthorizationTokenElement.setClientId(tokenDoc.getString("clientId"));
        pciAuthorizationTokenElement.setSharePointUrl(tokenDoc.getString("sharePointUrl"));
        pciAuthorizationTokenElement.setClientSecret(tokenDoc.getString("clientSecret"));
        pciAuthorizationTokenElement.setCloudName(tokenDoc.getString("cloudName"));
        pciAuthorizationTokenElement.setRefreshToken(tokenDoc.getString("refreshToken"));
        return pciAuthorizationTokenElement;
    }

    private static PciAuthorizationTokenElement convertDocToPCIObj() {
        PciAuthorizationTokenElement pciAuthorizationTokenElement = new PciAuthorizationTokenElement();
        pciAuthorizationTokenElement.setAccessToken("eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsIng1dCI6ImFQY3R3X29kdlJPb0VOZzNWb09sSWgydGlFcyIsImtpZCI6ImFQY3R3X29kdlJPb0VOZzNWb09sSWgydGlFcyJ9.eyJhdWQiOiJodHRwczovL3BhcmFibHVzeXMtbXkuc2hhcmVwb2ludC5jb20iLCJpc3MiOiJodHRwczovL3N0cy53aW5kb3dzLm5ldC9hNTMzMjljNi01ODJmLTQ4ZTUtYjI4Ni0xNWU2YmNjNjU4YjAvIiwiaWF0IjoxNTcxMjI2MTQ5LCJuYmYiOjE1NzEyMjYxNDksImV4cCI6MTU3MTIzMDA0OSwiYWNyIjoiMSIsImFpbyI6IkFTUUEyLzhOQUFBQTNMYUdpMUJyMXJDWkFRM0NWMkJRdlNlQ0RPaHFxbWZKKzBTK2hkZXFSTFU9IiwiYW1yIjpbInB3ZCJdLCJhcHBfZGlzcGxheW5hbWUiOiJ0ZXN0ZHJ1dmEiLCJhcHBpZCI6IjU0MWU4YjdkLWY5ZDUtNDkwYS05Y2E1LWNiNjFhZjU1NmYxOCIsImFwcGlkYWNyIjoiMSIsImdpdmVuX25hbWUiOiJub3JlcGx5IiwiaXBhZGRyIjoiMTE5LjgyLjEwMy4yNDIiLCJuYW1lIjoibm9yZXBseSIsIm9pZCI6IjM0MmE3YjcwLTFmZDAtNDIyZC1iZmYxLTM2ZGFmNGI5ZTg2MCIsInB1aWQiOiIxMDAzQkZGREFBMzY1MkI4Iiwic2NwIjoiQW5hbHl0aWNzLlJlYWQgRGlyZWN0b3J5LlJlYWQuQWxsIFJlcG9ydHMuUmVhZC5BbGwgU2l0ZXMuRnVsbENvbnRyb2wuQWxsIFNpdGVzLk1hbmFnZS5BbGwgU2l0ZXMuUmVhZC5BbGwgU2l0ZXMuUmVhZFdyaXRlLkFsbCBVc2VyLlJlYWQiLCJzaWQiOiIzYmE0NTAxMy0zN2ExLTRkMDYtOWI4ZS04NTU3MWRjNGRkYTciLCJzaWduaW5fc3RhdGUiOlsia21zaSJdLCJzdWIiOiJjczhweUlvUTdLbTJZRVVXd2gxcS1zbFR4NDhabENDWnVaSkNrdlBQOTJ3IiwidGlkIjoiYTUzMzI5YzYtNTgyZi00OGU1LWIyODYtMTVlNmJjYzY1OGIwIiwidW5pcXVlX25hbWUiOiJub3JlcGx5QHBhcmFibHUuY29tIiwidXBuIjoibm9yZXBseUBwYXJhYmx1LmNvbSIsInV0aSI6Ik4yUzRxazg0QkVxbUxuUE96UkF1QUEiLCJ2ZXIiOiIxLjAifQ.TpKU1ibyuSl4vegqRgecSUcRU8J7k2XJzkvcYTVr3-V2A6nJLEYUvl5hNBETnCBG1vlKfKyeQNlXtkPklOwEKkjvZwzxwTuVvHo4XS1VrwLW9R_OYEJFWQ0jFSMbR5AtOWSfEOgZ5dpTBMc5MCLMfjxE79Ef_mJRg3ES5Lv8_p5hL1-99pZRUrlfxKRJswKco5hOivrRDIyhgAUJ1L3R1KXRUVfiQlGdJsSszt9wEXot2ES9EZmkho9RqQRdGEv9phNXBNw20nvlbBxJfPSfy50chYhWanq-aIQ8xivsarbNYeu_8UzAX_h7cdGX3eJiyspP-t0EFOey2E7wb5LJcQ");
        pciAuthorizationTokenElement.setAuthenticationToken("eyJ0eXAiOiJKV1QiLCJhbGciOiJub25lIn0.eyJhdWQiOiI1NDFlOGI3ZC1mOWQ1LTQ5MGEtOWNhNS1jYjYxYWY1NTZmMTgiLCJpc3MiOiJodHRwczovL3N0cy53aW5kb3dzLm5ldC9hNTMzMjljNi01ODJmLTQ4ZTUtYjI4Ni0xNWU2YmNjNjU4YjAvIiwiaWF0IjoxNTcxMjIzODk4LCJuYmYiOjE1NzEyMjM4OTgsImV4cCI6MTU3MTIyNzc5OCwiYW1yIjpbInB3ZCJdLCJmYW1pbHlfbmFtZSI6Ikt1bWFyIiwiZ2l2ZW5fbmFtZSI6IkRydXZhIiwiaXBhZGRyIjoiMTE5LjgyLjEwMy4yNDIiLCJuYW1lIjoiZHJ1dmEiLCJvaWQiOiJmZDg5Nzg3OS1jOTIxLTQyNDEtYTBkMi1lYWUyZTFiOTU4ODkiLCJwd2RfZXhwIjoiMTEzMDMzMiIsInB3ZF91cmwiOiJodHRwczovL3BvcnRhbC5taWNyb3NvZnRvbmxpbmUuY29tL0NoYW5nZVBhc3N3b3JkLmFzcHgiLCJzdWIiOiI2Smc1Y1dEZDdJRndhNXRvdGk4OGR4WWtQVzJyUDlCWC1NeU5QY2FLdXpnIiwidGlkIjoiYTUzMzI5YzYtNTgyZi00OGU1LWIyODYtMTVlNmJjYzY1OGIwIiwidW5pcXVlX25hbWUiOiJkcnV2YUBwYXJhYmx1LmNvbSIsInVwbiI6ImRydXZhQHBhcmFibHUuY29tIiwidmVyIjoiMS4wIn0.");
        pciAuthorizationTokenElement.setClientId("541e8b7d-f9d5-490a-9ca5-cb61af556f18");
        pciAuthorizationTokenElement.setSharePointUrl("https://parablusys-my.sharepoint.com");
        pciAuthorizationTokenElement.setClientSecret("o_B16VVsJ0v=eSvi6SdP?uUVF:@5pbAc");
        pciAuthorizationTokenElement.setRefreshToken("AQABAAAAAACQN9QBRU3jT6bcBQLZNUj7d7yRziaIasTxD8F5GcLFfQxewyo3rALY6_RCuGMjLwkrNqWUDRScQvSvt53Y6GAhby4Y0O_krRlzYSmZtkabyPkOzfMHZ4jijg3EPoG3i3qOgpTO_FsPzerqtIvGI7C4Z8ER7aS8_3FmAU_fWuCcRsCYGvLasB3NMpKBN8jCSnDjNQdq6buzdfkr_V8JqksbXqAW0K8cec22qXyienPUtBag9lFCOkZbBgCdoGqkNd0TOuPnwG7q-Rg6Fu2AVDIBGFi3oheSJOUiYzzjsG9R04rKbjzU-ldsu_Rf_6Y95wTtDfi2DFWAGx0v2IGVdrvf_j_6k3ZYDMsZYbO3Oa60_OZbjtkgpJ7Ub2oj5yHvdFyb_L4PQDc-khQpZxPWDpMOQBpuQbfq5xDuXytZWY_z0Dm0cV_PFUt6lGWplUG0-2WFKPv9GW_Z2WHNyPBbPF5Ncp7Kk6qXm-VMLslsUo9fTJK-i8PIGJF1Usoa7DubIybEVfMbvkTATxrtSRzYIRzMEY4a5jWHIokO-MKHIqBNGHHsBRn5pSYHlLkU_dg1pc4GmmBqhEw3T6yHVOGuGxB7qCNk6eXkjY3LWOZwOm5tzIThElsAng07cEXZqxxgu9NczW7MtXWT-nOpf_L7j9T6_pqm5bmxJncp5XTwD6TVoHvV2TtiwY1j6YJaV-whwJfP_w00vfoZipR7WH4_w3Az2pIVIb2PRS57ozQZweLTMz3yXuXQMh3EjN3KE2OQ0TsUv6AbfdlkEWut7O3_TrXtJzh9UiUIin7XaUDyBLwhV0yraHylZfRO5vB8M3aMOiUgAA");
        return pciAuthorizationTokenElement;
    }

    private static Object[] getStorage(String emailId, String baseurl, PciAuthorizationTokenElement authorizationTokenElement) {
        Object[] resultObj = new Object[3];
        double StoragePercentageUsed = 0.0;
        long Storage = 0L;
        long l = 0L;
        String url = String.valueOf(SearchFile.getPersonalSite(baseurl, emailId)) + "/_api/site/usage";
        try {
            URL obj = new URL(url);
            HttpGet httpGet = new HttpGet(url);
            httpGet.addHeader(AUTHORIZATION, BEARER + authorizationTokenElement.getAccessToken());
            httpGet.addHeader("Accept", "application/json;odata=verbose");
            httpGet.addHeader(HEADER_KEY_CONTENT_TYPE, "*/*");
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpResponse result = httpclient.execute(httpGet);
            int statusCode = result.getStatusLine().getStatusCode();
            System.out.println("....status code ....." + statusCode);
            if (statusCode == 401) {
                authorizationTokenElement = Office365.getAccessToken(authorizationTokenElement);
                SearchFile.getStorage(emailId, baseurl, authorizationTokenElement);
            }
            if (statusCode == 200) {
                String json = EntityUtils.toString(result.getEntity());
                System.out.println("..." + json);
                JSONObject jsonObject = new JSONObject(json);
                String itemCount = jsonObject.optString("d");
                if (itemCount != null) {
                    jsonObject = new JSONObject(new String(itemCount));
                    String StorageMetrics = jsonObject.optString("Usage");
                    jsonObject = new JSONObject(new String(StorageMetrics));
                    StoragePercentageUsed = Double.parseDouble(jsonObject.optString("StoragePercentageUsed"));
                    Storage = Long.parseLong(jsonObject.optString("Storage"));
                    System.out.println("...StoragePercentageUsed.." + StoragePercentageUsed);
                    System.out.println("...Storage.." + Storage);
                    l = (long)((double)Storage / StoragePercentageUsed);
                    System.out.println(l);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        resultObj[0] = StoragePercentageUsed * 100.0;
        resultObj[1] = Storage;
        resultObj[2] = l;
        return resultObj;
    }
}

