/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.File;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class GetAllDeviceFileExists {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String cloudName = config.getProperty("cloudName").toString();
        if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> deviceCollection = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        String filePath = "/parablu/" + cloudName + "/upload/";
        System.out.println("upload file path :" + filePath);
        File uploadFolder = new File(filePath);
        File[] listFiles = uploadFolder.listFiles();
        System.out.println("UserName,DeviceName,isUserActive,isDeviceBlacked,deviceUUID,folderSize");
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            try {
                Document device;
                if (folder.isDirectory() && folder.canRead() && (device = (Document)deviceCollection.find(new BasicDBObject("deviceUUID", folder.getName())).first()) != null && !StringUtils.isEmpty(device.getString("userName")) && !StringUtils.isEmpty(device.getString("deviceName")) && device.get("isDeviceBolcked") != null && device.get("isUserActive") != null) {
                    System.out.println(String.valueOf(device.getString("userName")) + "," + device.getString("deviceName") + "," + device.getBoolean("isUserActive") + "," + device.getBoolean("isDeviceBolcked") + "," + folder.getName() + "," + FileUtils.byteCountToDisplaySize(FileUtils.sizeOfDirectory(folder)));
                }
            }
            catch (Exception e) {
                System.out.println("Exception :" + e.getMessage());
            }
            ++n2;
        }
    }
}

