/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.domin.Office365;
import com.parablu.domin.PciAuthorizationTokenElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.bson.Document;

public class CheckPBFolderExistsWithDelay {
    private static final String PERSONAL_URL = "/personal/";
    private static final String BEARER = "Bearer ";
    public static final String HEADER_KEY_ACCEPT = "Accept";
    public static final String HEADER_VALUE_APPLICATION_JSON = "application/json;odata=verbose";
    public static final String HEADER_KEY_CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT = "Accept";
    private static final String APPLICATION_JSON_ODATA_VERBOSE = "application/json;odata=verbose";
    public static final String AUTHORIZATION = "Authorization";

    public static void main(String[] args) throws ConfigurationException, IOException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String countString = config.getProperty("count").toString();
        String delayString = config.getProperty("delay").toString();
        String filePath = config.getProperty("filePath").toString();
        if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        int count = Integer.parseInt(countString);
        int delay = Integer.parseInt(delayString);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> tokenCollection = db.getCollection("PCI_AUTHORIZATION_TOKENS");
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        PciAuthorizationTokenElement authorizationTokenElement = CheckPBFolderExistsWithDelay.convertDocToPCIObj(tokenCollection);
        ArrayList<String> userNameList = new ArrayList<String>();
        ArrayList<Document> userList = new ArrayList<Document>();
        try {
            FileInputStream file = new FileInputStream(new File(filePath));
            Workbook workbook = WorkbookFactory.create(file);
            Iterator sheet = workbook.getSheetAt(0);
            Iterator rowIterator = sheet.iterator();
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                Iterator<Cell> cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = cellIterator.next();
                    switch (cell.getCellType()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            userNameList.add(cell.getStringCellValue());
                        }
                    }
                }
            }
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("userNameList..." + userNameList.size());
        FindIterable<Document> users = null;
        if (CollectionUtils.isEmpty(userNameList)) {
            users = userDBCollection.find(new BasicDBObject("deleted", false));
            for (Document user : users) {
                try {
                    if (user == null) continue;
                    userList.add(user);
                }
                catch (Exception e) {
                    System.out.println("Exception :" + e.getMessage());
                }
            }
        } else {
            for (String userName : userNameList) {
                BasicDBObject andQuery = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                whereQuery.add(new BasicDBObject("userNameLowerCase", userName.toLowerCase()));
                whereQuery.add(new BasicDBObject("deleted", false));
                andQuery.put("$and", whereQuery);
                Document userFromDB = (Document)userDBCollection.find(andQuery).first();
                try {
                    if (userFromDB == null) continue;
                    userList.add(userFromDB);
                }
                catch (Exception e) {
                    System.out.println("Exception :" + e.getMessage());
                }
            }
        }
        System.out.println("User list count new :" + userList.size());
        int k = 0;
        for (Document user : userList) {
            try {
                String paraBluFolderPath;
                int folderExists;
                if (k >= count) {
                    CheckPBFolderExistsWithDelay.sleepForGivenTime(delay);
                    k = 0;
                }
                String odbId = user.getString("emailId");
                if (!StringUtils.isEmpty(user.getString("odbLoginId"))) {
                    odbId = user.getString("odbLoginId");
                }
                if ((folderExists = CheckPBFolderExistsWithDelay.isFolderExists(paraBluFolderPath = CheckPBFolderExistsWithDelay.getParabluLibrarySizeUrl(authorizationTokenElement.getSharePointUrl(), odbId, ""), authorizationTokenElement, 0)) == 200) {
                    System.out.println(String.valueOf(user.getString("userName")) + " PB folder exists");
                } else {
                    System.out.println(String.valueOf(user.getString("userName")) + " PB folder not exists response code " + folderExists);
                }
            }
            catch (Exception e) {
                System.out.println("Exception :" + e.getMessage());
            }
            ++k;
        }
    }

    private static void sleepForGivenTime(long sleepTime) {
        long sleepTimeTemp = sleepTime;
        try {
            System.out.println("SleepTime is " + sleepTimeTemp);
            Thread.sleep(sleepTimeTemp * 1000L);
            System.out.println("SleepTime is completed " + sleepTimeTemp);
        }
        catch (InterruptedException e1) {
            System.out.println("Thread interupted error");
        }
    }

    public static int isFolderExists(String url, PciAuthorizationTokenElement authorizationTokenElement, int retryCount) {
        int result = 0;
        try {
            if (retryCount == 2) {
                System.out.println("Retry reached max so return ");
                return result;
            }
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty(AUTHORIZATION, BEARER + authorizationTokenElement.getAccessToken());
            con.setRequestProperty("Accept", "application/json;odata=verbose");
            int responseCode = con.getResponseCode();
            if (responseCode == 401) {
                authorizationTokenElement = Office365.getAccessToken(authorizationTokenElement);
                return CheckPBFolderExistsWithDelay.isFolderExists(url, authorizationTokenElement, ++retryCount);
            }
            if (responseCode == 200) {
                return responseCode;
            }
            result = responseCode;
        }
        catch (Exception e) {
            System.out.println("" + e);
            System.out.println("Exception while checking folder exists:" + e.getMessage());
            return 505;
        }
        return result;
    }

    public static String getParabluLibrarySizeUrl(String office365baseUrl, String accountId, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        pbFolderName = "";
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = CheckPBFolderExistsWithDelay.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(personalSite) + "/_api/web/getFolderByServerRelativeUrl('" + personalUrl + CheckPBFolderExistsWithDelay.getEmailId(accountId) + "/" + pbFolderName1 + "/')";
    }

    private static String getEmailId(String emailId) {
        String replacedEmailId = emailId.replace(".", "_");
        replacedEmailId = replacedEmailId.replace("@", "_");
        return replacedEmailId;
    }

    public static String getPersonalSite(String office365baseUrl, String accountId) {
        if (accountId.contains("sites/")) {
            return String.valueOf(office365baseUrl) + "/" + CheckPBFolderExistsWithDelay.getEmailId(accountId);
        }
        return String.valueOf(office365baseUrl) + PERSONAL_URL + CheckPBFolderExistsWithDelay.getEmailId(accountId);
    }

    private static PciAuthorizationTokenElement convertDocToPCIObj(MongoCollection tokenCollection) {
        Document tokenDoc = (Document)tokenCollection.find().first();
        PciAuthorizationTokenElement pciAuthorizationTokenElement = new PciAuthorizationTokenElement();
        pciAuthorizationTokenElement.setAccessToken(tokenDoc.getString("accessToken"));
        pciAuthorizationTokenElement.setAuthenticationToken(tokenDoc.getString("authenticationToken"));
        pciAuthorizationTokenElement.setClientId(tokenDoc.getString("clientId"));
        pciAuthorizationTokenElement.setSharePointUrl(tokenDoc.getString("sharePointUrl"));
        pciAuthorizationTokenElement.setClientSecret(tokenDoc.getString("clientSecret"));
        pciAuthorizationTokenElement.setCloudName(tokenDoc.getString("cloudName"));
        pciAuthorizationTokenElement.setRefreshToken(tokenDoc.getString("refreshToken"));
        return pciAuthorizationTokenElement;
    }
}

