/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class CheckDataMissing {
    public static void main(String[] args) throws ConfigurationException, IOException {
        String[] split;
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mainMongoIP").toString();
        String mongoPort = config.getProperty("mainMongoPort").toString();
        String cloudName = config.getProperty("cloudName").toString();
        String deviceUUIDs = config.getProperty("deviceUUIDs").toString();
        String blukryptIP = config.getProperty("blukryptIP").toString();
        String localDBName = config.getProperty("localDBName").toString();
        boolean conInsert = Boolean.parseBoolean(config.getProperty("conInsert").toString());
        if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort) || StringUtils.isEmpty(cloudName) || StringUtils.isEmpty(blukryptIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("Main mongo connectivity success  ");
        MongoClientURI uriLocal = new MongoClientURI("mongodb://neil:parablu@localhost:27017/blukrypt");
        MongoClient clientLocal = new MongoClient(uriLocal);
        MongoDatabase dbLocal = clientLocal.getDatabase(uriLocal.getDatabase());
        System.out.println("Local mongo connectivity success  ");
        ArrayList<String> deviceUUIDList = new ArrayList<String>();
        String[] stringArray = split = deviceUUIDs.split(",");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String u = stringArray[n2];
            u = u.replace("[", "");
            u = u.replace("]", "");
            u = u.trim();
            deviceUUIDList.add(u.toLowerCase());
            ++n2;
        }
        MongoCollection<Document> bkpPGCollection = db.getCollection("BACKUP_PG");
        MongoCollection<Document> deviceCollection = db.getCollection("DEVICE");
        MongoCollection<Document> localCollection = dbLocal.getCollection(localDBName.toUpperCase());
        for (String deviceUUID : deviceUUIDList) {
            Document device = (Document)deviceCollection.find(new BasicDBObject("deviceUUID", deviceUUID)).first();
            if (device == null) continue;
            MongoCollection<Document> bkpColl = db.getCollection(device.getString("destCollection"));
            BasicDBObject andQuery = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("gatewayName", blukryptIP));
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            andQuery.put("$and", whereQuery);
            FindIterable<Document> pgFiles = bkpPGCollection.find(andQuery);
            for (Document pgFile : pgFiles) {
                Document bkpFile = (Document)bkpColl.find(new BasicDBObject("_id", pgFile.getObjectId("_id"))).first();
                Document localFile = (Document)localCollection.find(new BasicDBObject("_id", pgFile.getObjectId("_id"))).first();
                if (bkpFile == null) {
                    System.out.println(pgFile.getObjectId("_id") + "," + "bkpFile is null");
                    continue;
                }
                if (localFile == null) {
                    System.out.println(pgFile.getObjectId("_id") + "local file is empty");
                    if (StringUtils.isNotEmpty(bkpFile.getString("storagePlace")) && bkpFile.getString("storagePlace").equalsIgnoreCase("CLOUD")) {
                        System.out.println("file alredy move to cloud");
                        continue;
                    }
                    if (conInsert) {
                        localCollection.insertOne(pgFile);
                        System.out.println("file is added to loacl db");
                        continue;
                    }
                    System.out.println("file is reday to add in loacl db but flag is false");
                    continue;
                }
                System.out.println(pgFile.getObjectId("_id") + "local file is exists");
            }
        }
    }
}

