/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.domin;

import com.parablu.domin.PciAuthorizationTokenElement;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class Office365 {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT = "Accept";
    public static final String BEARER = "Bearer ";
    public static final String AUTHORIZATION = "Authorization";
    private static final String TOKEN_URL = "https://login.windows.net/common/oauth2/token";
    private static final String UTF_8 = "UTF-8";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String APPLICATION_JSON_ODATA_VERBOSE = "application/json;odata=verbose";

    public static boolean createLibraryIfNotExists(String office365baseUrl, String token, String emailId, String libraryName, String folderPath) {
        System.out.println(" URL for  createLibraryIfNotExists ........... ");
        boolean isLibraryExists = Office365.isLibraryExists(office365baseUrl, token, libraryName, emailId);
        System.out.println(String.valueOf(isLibraryExists) + "  .....isLibraryExists URL ........... ");
        if (!isLibraryExists) {
            isLibraryExists = Office365.createLibrary(office365baseUrl, token, libraryName, emailId);
            if (isLibraryExists) {
                return Office365.createFolderInsideLibrary(office365baseUrl, token, libraryName, folderPath, emailId);
            }
            return false;
        }
        return Office365.createFolderInsideLibrary(office365baseUrl, token, libraryName, folderPath, emailId);
    }

    private static boolean createLibrary(String baseurl, String token, String libraryName, String emailId) {
        boolean success;
        block9: {
            String url = String.valueOf(Office365.getPersonalSite(baseurl, emailId)) + "/_api/web/lists";
            success = true;
            URL obj = null;
            HttpURLConnection con = null;
            try {
                try {
                    String line;
                    System.out.println("  proxy createLibrary.....HttpURLConnection....................................");
                    obj = new URL(url);
                    con = (HttpURLConnection)obj.openConnection();
                    con.setUseCaches(false);
                    con.setDoInput(true);
                    con.setDoOutput(true);
                    con.setRequestMethod("POST");
                    String folderNameBody = "{ '__metadata': { 'type': 'SP.List' }, 'AllowContentTypes': true, 'BaseTemplate': 101,'ContentTypesEnabled': true, 'Description': 'My Documents Library', 'Title': '" + libraryName + "' }";
                    con.setRequestProperty(AUTHORIZATION, BEARER + token);
                    con.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON_ODATA_VERBOSE);
                    con.setRequestProperty(ACCEPT, APPLICATION_JSON_ODATA_VERBOSE);
                    con.connect();
                    OutputStream os = con.getOutputStream();
                    OutputStreamWriter osw = new OutputStreamWriter(os, UTF_8);
                    osw.write(folderNameBody);
                    osw.flush();
                    osw.close();
                    StringBuilder sb = new StringBuilder();
                    BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), UTF_8));
                    while ((line = br.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                    br.close();
                }
                catch (Exception e) {
                    success = false;
                    e.printStackTrace();
                    if (con != null) {
                        con.disconnect();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (con != null) {
                    con.disconnect();
                }
                throw throwable;
            }
            if (con != null) {
                con.disconnect();
            }
        }
        System.out.println("**********************createLibrary****************" + success);
        return success;
    }

    public static boolean createFolderInsideLibrary(String baseurl, String token, String libraryName, String pbFolderPath, String emailId) {
        String url = String.valueOf(Office365.getPersonalSite(baseurl, emailId)) + "/_api/web/folders";
        boolean success = true;
        Path p = Paths.get(pbFolderPath, new String[0]);
        String path = "";
        for (Path element : p) {
            path = StringUtils.isEmpty(path) ? "" + element : String.valueOf(path) + "/" + element;
            URL obj = null;
            HttpURLConnection con = null;
            try {
                try {
                    System.out.println("  proxy createFolder.....HttpURLConnection...................................." + url + "...." + path);
                    obj = new URL(url);
                    con = (HttpURLConnection)obj.openConnection();
                    con.setUseCaches(false);
                    con.setDoInput(true);
                    con.setDoOutput(true);
                    con.setRequestMethod("POST");
                    String folderNameVal = "{\"__metadata\": {\"type\": \"SP.Folder\"}, \"ServerRelativeUrl\"  : \"" + libraryName + "/" + path + "\"}";
                    con.setRequestProperty(AUTHORIZATION, BEARER + token);
                    con.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON_ODATA_VERBOSE);
                    con.setRequestProperty(ACCEPT, APPLICATION_JSON_ODATA_VERBOSE);
                    con.connect();
                    OutputStream os = con.getOutputStream();
                    OutputStreamWriter osw = new OutputStreamWriter(os, UTF_8);
                    osw.write(folderNameVal);
                    osw.flush();
                    osw.close();
                    StringBuilder sb = new StringBuilder();
                    BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), UTF_8));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                    br.close();
                }
                catch (Exception e) {
                    success = false;
                    e.printStackTrace();
                    if (con == null) continue;
                    con.disconnect();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (con != null) {
                    con.disconnect();
                }
                throw throwable;
            }
            if (con == null) continue;
            con.disconnect();
        }
        return success;
    }

    public static String getPersonalSite(String office365baseUrl, String accountId) {
        return String.valueOf(office365baseUrl) + "/personal/" + Office365.getEmailId(accountId);
    }

    public static String getSite(String office365baseUrl, String accountId) {
        return String.valueOf(office365baseUrl) + "/" + Office365.getEmailId(accountId);
    }

    private static String getEmailId(String emailId) {
        String replacedEmailId = emailId.replace(".", "_");
        replacedEmailId = replacedEmailId.replace("@", "_");
        return replacedEmailId;
    }

    private static boolean isLibraryExists(String baseurl, String token, String libraryName, String emailId) {
        boolean success = false;
        String url = String.valueOf(Office365.getPersonalSite(baseurl, emailId)) + "/_api/web/lists/GetByTitle('" + libraryName + "')";
        try {
            URL obj = new URL(url);
            System.out.println("  ......proxy isLibraryExists.........." + url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty(AUTHORIZATION, BEARER + token);
            con.setRequestProperty(ACCEPT, APPLICATION_JSON_ODATA_VERBOSE);
            int responseCode = con.getResponseCode();
            String value = con.getHeaderField("Retry-After");
            System.out.println(String.valueOf(value) + "....status code  for isLibraryExists....." + responseCode);
            if (responseCode == 200) {
                success = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    public static PciAuthorizationTokenElement getAccessToken(PciAuthorizationTokenElement elementParam) {
        OutputStreamWriter wr;
        URLConnection conn;
        String refreshToken;
        String accessToken;
        block4: {
            accessToken = "";
            refreshToken = "";
            URL url = null;
            conn = null;
            String data = null;
            data = String.valueOf(URLEncoder.encode("grant_type", UTF_8)) + "=" + URLEncoder.encode(REFRESH_TOKEN, UTF_8);
            data = String.valueOf(data) + "&" + URLEncoder.encode(REFRESH_TOKEN, UTF_8) + "=" + URLEncoder.encode(elementParam.getRefreshToken(), UTF_8);
            data = String.valueOf(data) + "&" + URLEncoder.encode("client_id", UTF_8) + "=" + URLEncoder.encode(elementParam.getClientId(), UTF_8);
            data = String.valueOf(data) + "&" + URLEncoder.encode("client_secret", UTF_8) + "=" + URLEncoder.encode(elementParam.getClientSecret(), UTF_8);
            url = new URL(TOKEN_URL);
            conn = url.openConnection();
            conn.setDoOutput(true);
            conn.setConnectTimeout(1800000);
            wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            HttpURLConnection connection = (HttpURLConnection)conn;
            if (connection.getResponseCode() != 400) break block4;
            System.out.println("TOKEN has expired for user ...... " + elementParam.getAccountId());
            return null;
        }
        try {
            String line;
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder("");
            while ((line = rd.readLine()) != null) {
                response.append(line);
            }
            wr.close();
            rd.close();
            JSONObject jsonObject = new JSONObject(response.toString());
            accessToken = jsonObject.optString("access_token");
            refreshToken = jsonObject.optString(REFRESH_TOKEN);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        elementParam.setAccessToken(accessToken);
        return elementParam;
    }

    public static void main(String[] args) {
        String emailId = "karthick@parablu.com";
        emailId = "inbaraj@parablu.com";
        String baseurl = "https://parablusys-my.sharepoint.com";
        String token1 = "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsIng1dCI6IjdfWnVmMXR2a3dMeFlhSFMzcTZsVWpVWUlHdyIsImtpZCI6IjdfWnVmMXR2a3dMeFlhSFMzcTZsVWpVWUlHdyJ9.eyJhdWQiOiJodHRwczovL3BhcmFibHVzeXMtbXkuc2hhcmVwb2ludC5jb20iLCJpc3MiOiJodHRwczovL3N0cy53aW5kb3dzLm5ldC9hNTMzMjljNi01ODJmLTQ4ZTUtYjI4Ni0xNWU2YmNjNjU4YjAvIiwiaWF0IjoxNTM2MjIyNjY2LCJuYmYiOjE1MzYyMjI2NjYsImV4cCI6MTUzNjIyNjU2NiwiYWNyIjoiMSIsImFpbyI6IkFTUUEyLzhJQUFBQUVoRGt4NnVkZE5kSzJSbkRUWko0b0VDcG1FbGk5L0x0aU9sQlE3S2VDWGc9IiwiYW1yIjpbInB3ZCJdLCJhcHBfZGlzcGxheW5hbWUiOiJQYXJhQmx1IEluYy4gQXBwIiwiYXBwaWQiOiIxMGJlZDM2Ny04NmI4LTRiODAtODE2NS0yMTc4MWYwMGI1MDAiLCJhcHBpZGFjciI6IjEiLCJmYW1pbHlfbmFtZSI6IlAiLCJnaXZlbl9uYW1lIjoiS2FydGhpY2siLCJpcGFkZHIiOiIxMTkuODIuMTAzLjI0MiIsIm5hbWUiOiJLYXJ0aGljayIsIm9pZCI6IjkzOGVkZTZkLWQ0YWMtNGRiMi04MjBiLWZjMTRhMjQwNDMxMyIsInB1aWQiOiIxMDAzQkZGRDlGQTY0RUZCIiwic2NwIjoiQWxsU2l0ZXMuTWFuYWdlIEFsbFNpdGVzLldyaXRlIE15RmlsZXMuUmVhZCBNeUZpbGVzLldyaXRlIiwic3ViIjoiUzdJSlFyWmFrcnNOZU8yUnQxZ0JXN0FoWjhNYnhYMTFjVUp1bktRbjVIUSIsInRpZCI6ImE1MzMyOWM2LTU4MmYtNDhlNS1iMjg2LTE1ZTZiY2M2NThiMCIsInVuaXF1ZV9uYW1lIjoia2FydGhpY2tAcGFyYWJsdS5jb20iLCJ1cG4iOiJrYXJ0aGlja0BwYXJhYmx1LmNvbSIsInV0aSI6IktQRWp6N21YZFVHOGlOaThxd1FWQUEiLCJ2ZXIiOiIxLjAifQ.RwfCJz-tvjwdo0I3OAU8_pCO6Ld24CXB3ylq9HLmPRM6OB5vlZNamy4CNZ2tq9BMo6HNJZIagTjdNDbxwW61mfjkdcyWXaG2SUKERirtry4ElvRZ6EHidfyo-j_yuPrhCT_5qeBMWsGp3wYD8ziyCog2V56IJIP4aAtBkEkCP4qNY-GATD6gp749AONdSiEjSiruKd6SIJ7FfHQkrXbkhM3RbJJ19Z4NWYs_MxH2yBxbi4DNlDVsdtvaYncgPiriQ1RvC0UJ4CyKbuITtieGIWGFc3_LvQNkziBoUEbnIZVYKpdC_S2x95-aO7w7JCuHmxapoJysRXbloMOwl-Ogfg";
        String libraryName = "PB";
        PciAuthorizationTokenElement elementParam = new PciAuthorizationTokenElement();
        elementParam.setClientId("10bed367-86b8-4b80-8165-21781f00b500");
        elementParam.setClientSecret("i89uIMFkQaVxBsue20atMIS7v52SajTZtE8h4vtt040=");
        String refreshToken = "AQABAAAAAADXzZ3ifr-GRbDT45zNSEFEsN-AmO7sTQGDWBQwuftguUqgQ6DmRSFHADvEOETXW4IYYwrhtixlnjS4wkaBq_SQfk9PfwgphrPlJ-P-ix1iG2P5lhK6tmmhI8WP229kF0MLl1Me90viEy1sXUiCLi9DLMFPeRufgj1v3Lrjju3pi0aCDXnZlriXtbFwIpktQ8ZCyFO9mJ8SAfFBNajmgW-z7TwlBI1nKEG1ryVrnjoRk7wY-C8vUUPYXPaCAW1krxQeRynm1YYDdxI2KpuPV_5cwaPsM-bdcKmmSEgK0giz-5mFAl8gHHZk_ldCBd_FY9mcNP0gQIocWePp2VG8hpqJMzvOBrMdzZAo9EqWxC4KznhSo9QgTY0Jcin4i5-PC9_4amKcXcA7fwZkcTagfyurGN8MQUAKVRXUCjNpZ0LhhIPXLr8mmfT8lm3pZjeULTC4Od8vQCdLhE73fWzsmlbCIuldqufpAQ--3G85u4qw25Ap3qKN6Ts9ooQ0lx1wfzPhf5PKq7GtU6eNAda-Ea3caBcPmA5nImOHFykX3D5KoJpT05XSaxL-EGMOS1f1ZvkWXpwyXfT6DeNKboRMiNuQiAxmqZeskNy1A31KQbbwxFmWIInQNi-i6t73Ms7PqMgyXb2kb8_SUQzMKtHQOcizoAhxD9-kyvdBHcDSmoUbBlJmUy_43cCmm9PKSmyRjjOBE-2usIQfhK6lFvEizrTk5c8eGYSqish5qpAyxMdpefZzxN_AYVr_bkemEF0lPUIdID6C3y51XWy5ToTyeoDaLUL4-vHwxsAnbTdF82qWCiAA";
        elementParam.setRefreshToken(refreshToken);
    }
}

