/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.tools;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;

public class Jdk9ReflectionHelper {
    private static final Jdk9ReflectionHelper instance = Jdk9ReflectionHelper.createAccessibleMaker();
    private final Unsafe unsafe;
    private final long overrideFieldOffset;

    public static void makeAccessible(AccessibleObject object) {
        instance.makeObjectAccessible(object);
    }

    private Jdk9ReflectionHelper(Unsafe unsafe) {
        this.unsafe = unsafe;
        this.overrideFieldOffset = Jdk9ReflectionHelper.getOverrideFieldOffset(unsafe);
    }

    private void makeObjectAccessible(AccessibleObject object) {
        this.unsafe.putBoolean(object, this.overrideFieldOffset, true);
    }

    private static long getOverrideFieldOffset(Unsafe unsafe) {
        try {
            Field overrideField = AccessibleObject.class.getDeclaredField("override");
            return unsafe.objectFieldOffset(overrideField);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to get override field in accessible object.", e);
        }
    }

    private static Unsafe acquireUnsafe() {
        try {
            if (Jdk9ReflectionHelper.class.getClassLoader() == null) {
                return Unsafe.getUnsafe();
            }
            for (Field field : Unsafe.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Unsafe.class) continue;
                field.setAccessible(true);
                Object result = field.get(null);
                if (result == null) continue;
                return (Unsafe)Unsafe.class.cast(result);
            }
            throw new RuntimeException("No Unsafe instance found.");
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to load unsafe.", e);
        }
    }

    private static Jdk9ReflectionHelper createAccessibleMaker() {
        return new Jdk9ReflectionHelper(Jdk9ReflectionHelper.acquireUnsafe());
    }
}

