/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.tools;

import eu.plumbr.wrapper.deps.org.slf4j.Logger;
import eu.plumbr.wrapper.deps.org.slf4j.LoggerFactory;
import eu.plumbr.wrapper.tools.Jdk9ReflectionHelper;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;

public class Jdk9ClassPathTools {
    private static final Logger log = LoggerFactory.getLogger(Jdk9ClassPathTools.class);

    public static void addToClassPath(File jarLocation) {
        try {
            Class<?> klass = Class.forName("jdk.internal.loader.ClassLoaders");
            Method bootLoaderMethod = null;
            for (Method method : klass.getDeclaredMethods()) {
                if (!"bootLoader".equals(method.getName())) continue;
                bootLoaderMethod = method;
                break;
            }
            if (bootLoaderMethod == null) {
                log.error("No bootloader classloader found.");
                return;
            }
            Jdk9ReflectionHelper.makeAccessible(bootLoaderMethod);
            Object bootClassLoader = bootLoaderMethod.invoke(null, new Object[0]);
            Field classpathField = Jdk9ClassPathTools.findFieldByName(bootClassLoader.getClass(), "ucp");
            if (classpathField == null) {
                log.error("No URL classpath found in bootloader classloader.");
                return;
            }
            Jdk9ReflectionHelper.makeAccessible(classpathField);
            Object classPath = classpathField.get(bootClassLoader);
            Method addPathMethod = classPath.getClass().getMethod("addURL", URL.class);
            Jdk9ReflectionHelper.makeAccessible(addPathMethod);
            addPathMethod.invoke(classPath, jarLocation.toURI().toURL());
            log.info("Injected agent JAR to bootloader classloader resource classpath.");
        }
        catch (Throwable e) {
            log.error("Cannot add {} to bootstrap classpath.", (Object)jarLocation, (Object)e);
        }
    }

    private static Field findFieldByName(Class<?> klass, String fieldName) {
        while (klass != Object.class) {
            for (Field field : klass.getDeclaredFields()) {
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
            klass = klass.getSuperclass();
        }
        return null;
    }
}

