/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.tools;

import eu.plumbr.wrapper.deps.org.slf4j.Logger;
import eu.plumbr.wrapper.deps.org.slf4j.LoggerFactory;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import sun.misc.Launcher;
import sun.misc.URLClassPath;

public class Jdk6ClassPathTools {
    private static final Logger log = LoggerFactory.getLogger(Jdk6ClassPathTools.class);

    public static void addToClassPath(File jarLocation) throws MalformedURLException {
        URLClassPath bootstrapClassPath = Jdk6ClassPathTools.getBootstrapClassPath();
        if (bootstrapClassPath != null) {
            bootstrapClassPath.addURL(jarLocation.toURI().toURL());
            log.debug("Added agent JAR to launcher boot class path.");
        } else {
            log.warn("Agent JAR is NOT added to an existing instance of the boot class path.");
        }
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        log.debug("System classloader is {} (an instance of {})", (Object)systemClassLoader, (Object)(systemClassLoader != null ? systemClassLoader.getClass() : null));
    }

    private static URLClassPath getBootstrapClassPath() {
        try {
            Method method = ClassLoader.class.getDeclaredMethod("getBootstrapClassPath", new Class[0]);
            method.setAccessible(true);
            return (URLClassPath)URLClassPath.class.cast(method.invoke(null, new Object[0]));
        }
        catch (Throwable cause) {
            log.debug("Failed to obtain bootstrap classpath via getBootstrapClassPath() ({}), trying via Launcher.", (Object)cause.getMessage());
            try {
                return Launcher.getBootstrapClassPath();
            }
            catch (Throwable cause2) {
                log.warn("Also failed to obtain bootstrap classpath via Launcher.", cause2);
                return null;
            }
        }
    }
}

