/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Properties;

public class FileTools {
    private static final Charset CHARSET = Charset.forName("UTF-8");

    public static String readToString(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            String string = FileTools.readToString(inputStream);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readToProperties(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            inputStream.close();
        }
    }

    public static String readToString(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        FileTools.copy(inputStream, outputStream);
        return outputStream.toString(CHARSET.name());
    }

    public static void writeToFile(String text, File file) throws IOException {
        FileTools.writeToFile(text.getBytes(CHARSET), file);
    }

    public static void writeToFile(byte[] buffer, File file) throws IOException {
        FileTools.writeToFile(new ByteArrayInputStream(buffer), file);
    }

    public static void writeToFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            FileTools.copy(inputStream, outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    public static void writeToFile(Properties properties, File file) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            properties.store(outputStream, null);
        }
        finally {
            outputStream.close();
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int length;
        byte[] buffer = new byte[4096];
        while ((length = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, length);
        }
    }
}

