/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;

public class DigestTools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long checksumFile(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            long l = DigestTools.checksumStream(inputStream);
            return l;
        }
        finally {
            inputStream.close();
        }
    }

    private static long checksumStream(InputStream inputStream) throws IOException {
        int length;
        CRC32 crc32 = new CRC32();
        byte[] buffer = new byte[4096];
        while ((length = inputStream.read(buffer)) >= 0) {
            crc32.update(buffer, 0, length);
        }
        return crc32.getValue();
    }

    public static String digestToHex(String algorithm, File file) throws IOException {
        return DigestTools.bytesToHex(DigestTools.digestFile(algorithm, file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] digestFile(String algorithm, File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            byte[] byArray = DigestTools.digestStream(algorithm, inputStream);
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    private static byte[] digestStream(String algorithm, InputStream inputStream) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        DigestTools.updateDigest(digest, inputStream);
        return digest.digest();
    }

    private static void updateDigest(MessageDigest digest, InputStream inputStream) throws IOException {
        int length;
        byte[] buffer = new byte[4096];
        while ((length = inputStream.read(buffer)) >= 0) {
            digest.update(buffer, 0, length);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        int length = bytes.length;
        char[] characters = new char[bytes.length * 2];
        for (int i = 0; i < length; ++i) {
            int value = bytes[i] & 0xFF;
            characters[i * 2] = DigestTools.halfByteToHex(value >> 4);
            characters[i * 2 + 1] = DigestTools.halfByteToHex(value & 0xF);
        }
        return new String(characters);
    }

    private static char halfByteToHex(int value) {
        return value < 10 ? (char)(48 + value) : (char)(97 + (value - 10));
    }
}

