/*
 * Decompiled with CFR 0.152.
 */
package eu.plumbr.wrapper.distribution.extracted;

import eu.plumbr.wrapper.configuration.WrapperConfiguration;
import eu.plumbr.wrapper.deps.org.slf4j.Logger;
import eu.plumbr.wrapper.deps.org.slf4j.LoggerFactory;
import eu.plumbr.wrapper.distribution.AgentVersion;
import eu.plumbr.wrapper.distribution.DistributionRegistry;
import eu.plumbr.wrapper.distribution.DistributionScanner;
import eu.plumbr.wrapper.distribution.extracted.ExtractedDistribution;
import eu.plumbr.wrapper.tools.FileTools;
import java.io.File;
import java.io.IOException;

public class ExtractedDistributionScanner
implements DistributionScanner {
    private static final Logger log = LoggerFactory.getLogger(ExtractedDistributionScanner.class);

    @Override
    public void scan(WrapperConfiguration configuration, DistributionRegistry registry) {
        File[] children;
        File directory = configuration.getAgentWrapperDirectory();
        if (directory != null && (children = directory.listFiles()) != null) {
            for (File file : children) {
                if (!file.isDirectory() || !file.getName().startsWith("version-")) continue;
                try {
                    this.check(registry, file);
                }
                catch (Exception e) {
                    log.error("Failed to read agent distribution from {}", (Object)file);
                }
            }
        }
    }

    private void check(DistributionRegistry registry, File directory) {
        AgentVersion version = AgentVersion.fromVersionInSuffix(directory.getName());
        if (version != null) {
            File jarFile = new File(directory, "plumbr-agent.jar");
            File hashFile = new File(directory, "plumbr-agent.hash");
            if (hashFile.exists() && jarFile.exists()) {
                try {
                    String hash = FileTools.readToString(hashFile);
                    registry.builderFor(version).setDistribution(new ExtractedDistribution(version, jarFile, hash));
                }
                catch (IOException e) {
                    log.error("Failed to read hash from: {}", (Object)hashFile.getAbsolutePath(), (Object)e);
                }
            } else {
                log.error("Version directory has missing files: {}", (Object)directory);
            }
        } else {
            log.warn("Version directory with invalid name: {}", (Object)directory.getName());
        }
    }
}

